package jp.ill.photon.module.session;

import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;

import javax.servlet.http.HttpSession;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.annotation.ModuleVersion;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;

/**
 * 全てのセッションを削除するモジュール
 *
 * @author j_nakai
 *
 */
@ModuleVersion("1.0.0")
public class SessionAllRemoveModule implements PhotonModule {

	@ModuleParam(required = true)
	private String tenantId;

	@ModuleParam(required = true)
	private String appId;

	@ModuleParam(required = false)
	private List<String> exceptList;

	/**
	 * 全てのセッションを削除するメソッド
	 *
	 * @param context コンテキスト
	 * @return モジュール結果クラス
	 *
	 */
	@SuppressWarnings("rawtypes")
	@Override
	public ModuleResult execute(ModuleContext context) {

		ModuleResult result = new ModuleResult();
		HttpSession session = context.getDto().getSession();

		// 全てのセッションキーを取得
		Enumeration attributeNames = session.getAttributeNames();
		String sessionKey;

		List<String> tenantExceptList = null;
		if (exceptList != null) {
			tenantExceptList = exceptList.stream()
					.map(s -> s + "-" + getTenantId() + "-" + getAppId())
					.collect(Collectors.toList());
		}

		// セッションキー数ループ
		while (attributeNames.hasMoreElements()) {
			sessionKey = (String) attributeNames.nextElement();
			if (tenantExceptList != null
					&& tenantExceptList.indexOf(sessionKey.toString()) >= 0) {
				// 除外リストに格納されているので、何もしない
			} else {
				// セッションの破棄
				if (sessionKey
						.endsWith("-" + getTenantId() + "-" + getAppId())) {
					session.removeAttribute(sessionKey);
				}
			}
		}

		result.setResultCode("clear");

		return result;
	}

	/**
	 * exceptListを取得します。
	 * 
	 * @return exceptList
	 */
	public List<String> getExceptList() {
		return exceptList;
	}

	/**
	 * exceptListを設定します。
	 * 
	 * @param exceptList
	 */
	public void setExceptList(List<String> exceptList) {
		this.exceptList = exceptList;
	}

	public String getTenantId() {
		return tenantId;
	}

	public void setTenantId(String tenantId) {
		this.tenantId = tenantId;
	}

	public String getAppId() {
		return appId;
	}

	public void setAppId(String appId) {
		this.appId = appId;
	}

}
