package jp.ill.photon.module.pdf.mapper;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.ill.photon.model.User;
import jp.ill.photon.struts.thymeleaf.PhotonFormatUtility;
import jp.ill.photon.util.AoUtil;
import jp.ill.photon.util.DateUtil;
import jp.ill.photon.util.StringUtil;

import org.apache.commons.lang3.StringUtils;

public class PdfEstimateMapper extends AbstractPdfDefaultMapper {

    /** メッセージID（SMBC通信結果エラー） */
    public static final String TAX_MSG_ID = "estimatePrintNoTaxMss";

	public PdfEstimateMapper(Map<String, Object> common) {
		super(common);
	}

	@Override
	@SuppressWarnings("unchecked")
	public List<Map<String, Object>> setupData(User user, Map<String, Object> params) throws Exception {

		List<Map<String, Object>> data = new ArrayList<>();

		Map<String, Object> estimate = (Map<String, Object>) params.get("estimate");
		List<Map<String, Object>> estimateDetail = (List<Map<String, Object>>) params.get("estimate_detail");
		List<Map<String, Object>> estimateHeaderExfieldColName = (List<Map<String, Object>>) params.get("estimate_header_exfield_col_name");
		List<Map<String, Object>> estimateDetailExfieldColName = (List<Map<String, Object>>) params.get("estimate_detail_exfield_col_name");
		List<Map<String, Object>> itemExfieldColName = (List<Map<String, Object>>) params.get("item_exfield_col_name");

		Map<String, Object> estimateHeader = this.setupEstimateHeader(user, estimate);

		Map<String, Object> unitLabel = (Map<String, Object>) label.get("unit_label");
		Map<String, Object> caseLabel = (Map<String, Object>) label.get("case_label");
		// 項目名の取得
		estimateHeader.put("unit_label", unitLabel.get("note"));
		estimateHeader.put("case_label", caseLabel.get("note"));

		// システム設定のケース数設定により表示を切り替え
		if (CASE_NUM_DIV_ON.equals(systemSetting.get("caseNumDiv"))) {
			estimateHeader.put("is_case_enabled", true);
		} else {
			estimateHeader.put("is_case_enabled", false);
		}

		// 見積見出拡張項目名
		for (int i = 0; i < EXTENDED_ITEM_CNT; i++) {
			int j = i +1;
			Map<String, Object> ehecn = estimateHeaderExfieldColName.get(i);
			if ("1".equals(ehecn.get("valid_flg")) && "1".equals(ehecn.get("item_estimate_print_flg"))) {
				estimateHeader.put("estimate_header_exfield_col_name"+j, ehecn.get("name"));
			} else {
				estimateHeader.put("estimate_header_exfield_col_name"+j, "");
			}
		}

		// 見積明細拡張項目名
		for (int i = 0; i < EXTENDED_ITEM_CNT; i++) {
			int j = i +1;
			Map<String, Object> edecn = estimateDetailExfieldColName.get(i);
			if ("1".equals(edecn.get("valid_flg")) && "1".equals(edecn.get("item_estimate_print_flg"))) {
				estimateHeader.put("estimate_detail_exfield_col_name"+j, edecn.get("name"));
			} else {
				estimateHeader.put("estimate_detail_exfield_col_name"+j, "");
			}
		}

		// 商品拡張項目名
		for (int i = 0; i < EXTENDED_ITEM_CNT; i++) {
			int j = i +1;
			Map<String, Object> iecn = itemExfieldColName.get(i);
			if ("1".equals(iecn.get("valid_flg")) && "1".equals(iecn.get("item_estimate_print_flg"))) {
				estimateHeader.put("item_exfield_col_name"+j, iecn.get("name"));
			} else {
				estimateHeader.put("item_exfield_col_name"+j, "");
			}
		}

		// 税抜メッセージ
		if (TAX_DIV_EXCLUDING.equals(StringUtil.defaultString(user.getTaxDiv(), "")) && StringUtils.isNotEmpty(message.get(TAX_MSG_ID))) {
			estimateHeader.put("estimate_no_tax_mss", message.get(TAX_MSG_ID));
		} else {
			estimateHeader.put("estimate_no_tax_mss", "");
		}

		for (Map<String, Object> detail : estimateDetail) {
			data.add(setupEstimateDetail(estimateHeader, detail));
		}
		return data;
	}

	/**
	 * 見積見出データを出力する
	 *
	 * @param myCompanyForm 自社情報フォーム
	 * @param estimateForm 見積見出フォーム
	 * @param user 得意先
	 * @param logoImage 自社ロゴイメージ
	 * @param pageNo ページ番号
	 * @param maxPageNo 最大ページ番号
	 * @throws Exception
	 */
	private Map<String, Object> setupEstimateHeader(User user, Map<String, Object> estimate)
			throws Exception {

		Map<String, Object> header = new HashMap<>();

		header.put("estimate_no", estimate.get("estimate_no"));

		// 自社情報取得
		String logoImgPath = null;
		String sysLogoImgDir = systemSetting.get("myCompanyLogoImgDir");
		String sysLogoImgPath = systemSetting.get("myCompanyLogoImgPath");
		if (sysLogoImgDir != null && sysLogoImgPath != null) {
			String imgPath = Paths.get(sysLogoImgDir, sysLogoImgPath).toString();
			if (isValidImgPath(imgPath)) {
				logoImgPath = imgPath;
			}
		}else{
			logoImgPath = null;
		}

		header.put("MY_COMPANY_NAME1", systemSetting.get(MY_COMPANY_NAME1));
		header.put("MY_COMPANY_NAME2", systemSetting.get(MY_COMPANY_NAME2));
		header.put("MY_COMPANY_ZIP", systemSetting.get(MY_COMPANY_ZIP));
		header.put("MY_COMPANY_ADDRESS1", systemSetting.get(MY_COMPANY_ADDRESS1));
		header.put("MY_COMPANY_ADDRESS2", systemSetting.get(MY_COMPANY_ADDRESS2));
		header.put("MY_COMPANY_ADDRESS3", systemSetting.get(MY_COMPANY_ADDRESS3));
		header.put("MY_COMPANY_TEL", systemSetting.get(MY_COMPANY_TEL));
		header.put("MY_COMPANY_FAX", systemSetting.get(MY_COMPANY_FAX));
		header.put("MY_COMPANY_LOGO_IMG_PATH", logoImgPath);

		// ---------------------------------------------
		// 見積日
		// ---------------------------------------------
		header.put("estimate_date", DateUtil.formatString(StringUtil.defaultString(estimate.get("estimate_date"))));

		// ---------------------------------------------
		// 見積有効期限
		// ---------------------------------------------
		header.put("estimate_end_time", DateUtil.formatString(StringUtil.defaultString(estimate.get("estimate_end_time"))));

		// ---------------------------------------------
		// 得意先名
		// ---------------------------------------------
		// 得意先名1
		header.put("user_name1", user.getUserName1());
		// 得意先名2
		header.put("user_name2", StringUtil.defaultString(user.getUserName2(), ""));

		// ---------------------------------------------
		// 得意先郵便番号
		// ---------------------------------------------
		header.put("user_zip", StringUtil.defaultString(user.getZip(), ""));

		// ---------------------------------------------
		// 得意先住所1
		// ---------------------------------------------
		header.put("user_city_name1",
				StringUtil.defaultString(user.getCityName1(), ""));

		// ---------------------------------------------
		// 得意先住所2
		// ---------------------------------------------
		header.put("user_city_name2",
				StringUtil.defaultString(user.getCityName2(), ""));

		// ---------------------------------------------
		// 得意先住所3
		// ---------------------------------------------
		header.put("user_city_name3",
				StringUtil.defaultString(user.getCityName3(), ""));

		// ---------------------------------------------
		// 得意先電話番号
		// ---------------------------------------------
		String userTel = StringUtil.defaultString(user.getTel(), "");
		header.put("user_tel", userTel);

		// ---------------------------------------------
		// 得意先FAX番号
		// ---------------------------------------------
		String userFax = StringUtil.defaultString(user.getFax(), "");
		header.put("user_fax", userFax);

		// ---------------------------------------------
		// 届け先名1
		// ---------------------------------------------
		header.put("user_delivery_name1", StringUtil.defaultString(estimate.get("user_delivery_name1"), ""));

		// ---------------------------------------------
		// 届け先名2
		// ---------------------------------------------
		header.put("user_delivery_name2", StringUtil.defaultString(estimate.get("user_delivery_name2"), ""));

		// ---------------------------------------------
		// 見積見出拡張項目
		// ---------------------------------------------
		for (int i = 1; i <= EXTENDED_ITEM_CNT; i++) {
			if (StringUtils.isNotEmpty((CharSequence) estimate.get("_ex_field_order" + i))) {
				header.put("_ex_field_order" + i, StringUtil.defaultString(estimate.get("_ex_field_order" + i)));
			} else {
				header.put("_ex_field_order" + i, "");
			}
		}

		// ---------------------------------------------
		// 注文時コメント
		// ---------------------------------------------
		header.put("remarks", StringUtil.defaultString(estimate.get("remarks"), ""));

		// ---------------------------------------------
		// 御見積金額合計
		// ---------------------------------------------
		// データ
		String estimateSum = (String) estimate.get("wholesale_price");
		estimateSum = AoUtil.convAoRoundingSalesPrice(
				estimateSum, aladdinSetting.get("売上金額整数桁"), aladdinSetting.get("売上金額端数処理区分"));
		header.put("estimate_sum", "￥ " + estimateSum);

		return header;
	}

	/**
	 * 見積明細データをPDF出力する.
	 *
	 * @param contentStream PDPageContentStream
	 * @param estimateDetailForm 見積明細
	 * @param dataIndexY データ書き込み開始Y座標
	 * @throws IOException
	 */
	private Map<String, Object> setupEstimateDetail(Map<String, Object> estimateHeader,
													Map<String, Object> detail)
			throws Exception {

		detail.putAll(estimateHeader);

		// ケース数
		String caseNumDiv = systemSetting.get("caseNumDiv");

		// 商品コード
		String itemCd = StringUtil.defaultString(detail.get("item_cd"), "");
		// 得意先商品コード
		String userItemCd = StringUtil.defaultString(detail.get("user_item_cd"), "");
		if (!"".equals(userItemCd)) {
			itemCd = itemCd + " " + userItemCd;
		}
		detail.put("item_cd", itemCd);

		// JANコード
		detail.put("jan_cd", StringUtil.defaultString(detail.get("jan_cd"), ""));

		// システム設定のケース数設定により表示を切り替え
		// ケース数
		if (caseNumDiv.equals(CASE_NUM_DIV_ON)) {
			// ケース数表示あり
			String caseQuantity = StringUtil.defaultString(detail.get("order_case_quantity"), "");
			// ケース数が0の場合は何も表示しない
			if ("0".equals(caseQuantity)) {
				caseQuantity = "";
			}
			if (!"".equals(caseQuantity)) {
			    caseQuantity = AoUtil.convAoRoundingCaseQuantity(caseQuantity, aladdinSetting.get("ケース数整数桁"), aladdinSetting.get("ケース数小数点桁"), aladdinSetting.get("ケース数端数処理区分"));
			}

			detail.put("case_quantity", caseQuantity);
		} else {
			detail.put("case_quantity", "");
		}

		// 商品名1
		String itemName1 = StringUtil.defaultString(detail.get("item_name1"), "");
		detail.put("item_name1", itemName1);

		// 商品名2
		String itemName2 = StringUtil.defaultString(detail.get("item_name2"), "");
		detail.put("item_name2", itemName2);

		// 単価の桁数が大きい場合は分割して表示します
		String wholesalePrice = StringUtil.defaultString(detail.get("wholesale_price"), "");
		if (!"".equals(wholesalePrice)) {
		    wholesalePrice = AoUtil.convAoRoundingSalesUnitPrice(wholesalePrice, aladdinSetting.get("売上単価整数桁"), aladdinSetting.get("売上単価小数点桁"), aladdinSetting.get("売上単価端数処理区分"));
		}
		if (wholesalePrice.length() > 15) {
			// 単価前半
			String price1 = wholesalePrice.substring(0, 15);
			String p = price1.replace(",", "");
			detail.put("price1", "￥ " + PhotonFormatUtility.num(p));
		}
		// 合計の桁数が大きい場合は分割して表示します
		String subTotal = StringUtil.defaultString(detail.get("sub_total"), "");
		if (!"".equals(subTotal)) {
		    subTotal = AoUtil.convAoRoundingSalesPrice(subTotal, aladdinSetting.get("売上金額整数桁"), aladdinSetting.get("売上金額端数処理区分"));
		}

		if (subTotal.length() > 15) {
			// 合計前半
			String totalPrice1 = subTotal.substring(0, 15);
			detail.put("total_price1", totalPrice1);
		}

		// 得意先商品名1
		String userItemName1 = StringUtil.defaultString(detail.get("user_item_name1"), "");
		detail.put("user_item_name1", userItemName1);

		// 得意先商品名2
		String userItemName2 = StringUtil.defaultString(detail.get("user_item_name2"), "");
		detail.put("user_item_name2", userItemName2);

		// 拡張項目
		for (int i = 1; i <= EXTENDED_ITEM_CNT; i++) {
			if (StringUtils.isNotEmpty((CharSequence) detail.get("_ex_field_orderdetail" + i))) {
				detail.put("_ex_field_orderdetail" + i, StringUtil.defaultString(detail.get("_ex_field_orderdetail" + i)));
			} else {
				detail.put("_ex_field_orderdetail" + i, "");
			}
		}
		for (int i = 1; i <= EXTENDED_ITEM_CNT; i++) {
			if (StringUtils.isNotEmpty((CharSequence) detail.get("_ex_field_item" + i))) {
				detail.put("_ex_field_item" + i, StringUtil.defaultString(detail.get("_ex_field_item" + i)));
			} else {
				detail.put("_ex_field_item" + i, "");
			}
		}

		// システム設定のケース数設定により表示を切り替え
		// 入数
		if (caseNumDiv.equals(CASE_NUM_DIV_ON)) {
			// ケース数表示あり
			String quantityPerCase = (String) detail.get("quantity_per_case");
			// 入数が0の場合は何も表示しない
			if ("0".equals(quantityPerCase)) {
				quantityPerCase = "";
			}else{
				quantityPerCase = AoUtil.convAoRoundingUnitQuantity(quantityPerCase, aladdinSetting.get("入数整数桁"), aladdinSetting.get("入数小数点桁"), "0");
			}

			detail.put("quantity_per_case", quantityPerCase);
		} else {
			detail.put("quantity_per_case", "");
		}

		// 数量
		String quantity = StringUtil.defaultString(detail.get("order_quantity"), "0");
		if (!"".equals(quantity)) {
		    quantity = AoUtil.convAoRoundingSalesQuantity(quantity, aladdinSetting.get("売上数量整数桁"), aladdinSetting.get("売上数量小数点桁"), aladdinSetting.get("売上数量端数処理区分"));
		}
		detail.put("quantity", quantity);

		// 単位
		String unit = StringUtil.defaultString(detail.get("unit"), "");
		detail.put("unit", unit);

		// 単価
		// 単価の桁数が大きい場合は分割して表示します
		String price = StringUtil.defaultString(detail.get("wholesale_price"), "0");
		if (!"".equals(price)) {
            price = AoUtil.convAoRoundingSalesUnitPrice(price, aladdinSetting.get("売上単価整数桁"), aladdinSetting.get("売上単価小数点桁"), aladdinSetting.get("売上単価端数処理区分"));
        }
		if (price.length() > 15) {
			price = price.substring(15);
		}
		String p = price.replace(",", "");
		detail.put("price", "￥ " + PhotonFormatUtility.num(p));

		// 合計
		// 合計の桁数が大きい場合は分割して表示します
		String totalPrice = StringUtil.defaultString(detail.get("sub_total"), "0");
		if (!"".equals(totalPrice)) {
		    totalPrice = AoUtil.convAoRoundingSalesPrice(totalPrice, aladdinSetting.get("売上金額整数桁"), aladdinSetting.get("売上金額端数処理区分"));
        }
		if (totalPrice.length() > 15) {
			totalPrice = totalPrice.substring(15);
		}
		detail.put("total_price", "￥ " + totalPrice);

		return detail;
	}

	private boolean isValidImgPath(String imgPath) {
		File file = new File(imgPath);
		if (!file.exists()) {
			return false;
		}

		String lowerRealFilePath = imgPath.toLowerCase();
		if (lowerRealFilePath.endsWith(IMAGE_EXT_JPG)
				|| lowerRealFilePath.endsWith(IMAGE_EXT_JPEG)) {
			// JPG
			return true;
		} else if (lowerRealFilePath.endsWith(IMAGE_EXT_PNG)) {
			// PNG
			return true;
		} else if (lowerRealFilePath.endsWith(IMAGE_EXT_GIF)) {
			// GIF
			return true;
		}

		return false;
	}
}
