package jp.ill.photon.module.pdf.mapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.stream.Collectors;

import org.apache.commons.collections.MapUtils;

import jp.ill.photon.model.User;
import jp.ill.photon.module.pdf.PdfDefaultMapper;
import jp.ill.photon.util.StringUtil;

public class AbstractPdfDefaultMapper implements PdfDefaultMapper {

	public static final String CASE_NUM_DIV_ON = "1";
	/** 自社名1 */
	public static final String MY_COMPANY_NAME1 = "myCompanyName1";
	/** 自社名2 */
	public static final String MY_COMPANY_NAME2 = "myCompanyName2";
	/** 自社郵便番号 */
	public static final String MY_COMPANY_ZIP = "myCompanyZip";
	/** 自社住所1 */
	public static final String MY_COMPANY_ADDRESS1 = "myCompanyAddress1";
	/** 自社住所2 */
	public static final String MY_COMPANY_ADDRESS2 = "myCompanyAddress2";
	/** 自社住所3 */
	public static final String MY_COMPANY_ADDRESS3 = "myCompanyAddress3";
	/** 自社電話番号 */
	public static final String MY_COMPANY_TEL = "myCompanyTel";
	/** 自社FAX */
	public static final String MY_COMPANY_FAX = "myCompanyFax";
	/** 自社ロゴ画像パス */
	public static final String MY_COMPANY_LOGO_IMG_PATH = "myCompanyLogoImgPath";
	/** 自社ロゴ画像保存ディレクトリ */
	public static final String MY_COMPANY_LOGO_IMG_DIR = "myCompanyLogoImgDir";
	/** 自社ロゴ画像参照URL */
	public static final String MY_COMPANY_LOGO_IMG_URL = "myCompanyLogoImgUrl";
	/** 拡張項目数 */
	public static final int EXTENDED_ITEM_CNT = 20;
	/** 税抜 */
	public static final String TAX_DIV_EXCLUDING = "1";
	/** 画像拡張子 JPG */
	public static final String IMAGE_EXT_JPG = ".jpg";
	/** 画像拡張子 JPEG */
	public static final String IMAGE_EXT_JPEG = ".jpeg";
	/** 画像拡張子 PNG */
	public static final String IMAGE_EXT_PNG = ".png";

	/** 画像拡張子 GIF */
	public static final String IMAGE_EXT_GIF = ".gif";

	protected Map<String, Object> label;
	protected Map<String, String> systemSetting;
	protected Map<String, String> aladdinSetting;
	protected Map<String, String> message;
	//protected Map<String, Object> errormessage;

	@SuppressWarnings("unchecked")
	public AbstractPdfDefaultMapper(Map<String, Object> common) {
		if (!MapUtils.isEmpty(common)) {
			this.label = (Map<String, Object>) common.get("label");
			//this.message = (Map<String, Object>) common.get("message");
			//this.errormessage = (Map<String, Object>) common.get("errormessage");

			this.systemSetting = new  HashMap<String, String>();
			for (Entry<String, Object> obj : ((Map<String, Object>) common.get("systemsetting")).entrySet()) {
				this.systemSetting.put(obj.getKey(), StringUtil.defaultString(((Map<String, Object>)obj.getValue()).get("note"), ""));
			}

			this.aladdinSetting = new  HashMap<String, String>();
			Map<String, Object> aladdinData = (Map<String, Object>) common.get("aladdinsetting");
			for (Entry<String, Object> obj : aladdinData.entrySet()) {
				this.aladdinSetting.put(obj.getKey(), StringUtil.defaultString(((Map<String, Object>)obj.getValue()).get("value"), ""));
			}

			this.message = new HashMap<String, String>();
			Map<String, Object> mesgData = (Map<String, Object>) common.get("mesg");
            for (Entry<String, Object> obj : mesgData.entrySet()) {
                this.message.put(obj.getKey(), StringUtil.defaultString(((Map<String, Object>)obj.getValue()).get("format"), ""));
            }
		}
	}

	public List<Map<String, Object>> setupData(User user, Map<String, Object> params) throws Exception {
		return setupData(null, user, params);
	}

	@SuppressWarnings("unchecked")
	public List<Map<String, Object>> setupData(Map<String, Object> subtpl, User user, Map<String, Object> params) {
		List<Map<String, Object>> data = new ArrayList<>();

		if (params != null) {
			if (subtpl != null) {
				Entry<String, Object> detail = params.entrySet().stream().filter(
						e -> e.getValue() instanceof java.util.ArrayList).findFirst().get();

				String listkey = detail.getKey();
				List<Map<String, Object>> tmpList = (ArrayList<Map<String, Object>>) detail.getValue();
				for (Map<String, Object> entity : tmpList) {
					for (Entry<String, Object> header : params.entrySet()) {
						if (!header.getKey().equals(listkey)) {

							if (header.getValue() instanceof Map) {
								Map<String, Object> ch = (Map<String, Object>) header.getValue();
								for (Entry<String, Object> h : ch.entrySet()) {
									entity.put(h.getKey(), StringUtil.defaultString(h.getValue(), "{" + h.getKey() + "}"));
								}
							} else {
								entity.put(header.getKey(), StringUtil.defaultString(header.getValue(), "{" + header.getKey() + "}"));
							}
						}
					}
					data.add(entity);
				}
			} else {
				List<Entry<String, Object>> detailList = params.entrySet().stream().filter(
						e -> e.getValue() instanceof java.util.ArrayList).collect(Collectors.toList());
				for (Entry<String, Object> detail : detailList) {
					String listkey = detail.getKey();

					List<Map<String, Object>> tmpList = (ArrayList<Map<String, Object>>) detail.getValue();
					for (Map<String, Object> entity : tmpList) {
						for (Entry<String, Object> header : params.entrySet()) {
							if (!header.getKey().equals(listkey)) {

								if (header.getValue() instanceof Map) {
									Map<String, Object> ch = (Map<String, Object>) header.getValue();
									for (Entry<String, Object> h : ch.entrySet()) {
										entity.put(h.getKey(), StringUtil.defaultString(h.getValue(), "{" + h.getKey() + "}"));
									}
								} else {
									entity.put(header.getKey(), StringUtil.defaultString(header.getValue(), "{" + header.getKey() + "}"));
								}
							}
						}
						data.add(entity);
					}
				}
			}
		}

		return data;
	}
}
