package jp.ill.photon.module.pdf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.struts2.ServletActionContext;
import org.apache.xmlbeans.impl.store.Path;

import com.fasterxml.jackson.databind.ObjectMapper;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.model.User;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.ParamUtil;
import jp.ill.photon.util.UtilTools;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JsonDataSource;

/**
 * パラメータのデータをPDFに出力するモジュール
 *
 * @author a_kanba
 *
 */
public class ExportReportToPdfModule implements PhotonModule {

	@ModuleParam(required = true)
	private String tplid;
	@ModuleParam(required = true)
	private String maintpl;
	@ModuleParam(required = false)
	private Map<String, Object> subtpl;
	@ModuleParam(required = false)
	private String pdfDirPath;
	@ModuleParam(required = false)
	private String pdfFileName;

	@ModuleParam(required=true)
	private Map<String, Object> src;

	@ModuleParam(required=true)
	private Map<String, Object> common;

	@SuppressWarnings("unchecked")
	@Override
	public ModuleResult execute(ModuleContext context)
			throws PhotonModuleException {

		// 結果オブジェクト生成
		ModuleResult result = new ModuleResult();

		Map<String, Object> parameters = new HashMap<>();
		// 対象パラメータを変換して加算
		Map<String, Object> params = ParamUtil.getParamValueByType(src, context);
		Map<String, Object> tpls = ParamUtil.getParamValueByType(subtpl, context);

		ByteArrayOutputStream output = new ByteArrayOutputStream();

		String userCd = (String) ((Map<String, Object>) params.get("estimate")).get("user_cd");
		User user = User.getUser(context.getDto(), userCd);

		try {
			ObjectMapper mapper = new ObjectMapper();
			PdfDefaultMapper pdm = PdfMapperFactory.getInstance(tplid, common);
			String json = mapper.writeValueAsString(pdm.setupData(user, params));

			JsonDataSource jds = new JsonDataSource(new ByteArrayInputStream(json.getBytes("UTF-8")));

			String jrXmlPath = ServletActionContext.getServletContext()
					.getRealPath("WEB-INF/classes/" + maintpl);

			if (tpls != null && !tpls.isEmpty()) {
				for (Entry<String, Object> e : tpls.entrySet()) {
					String path = ServletActionContext.getServletContext()
							.getRealPath("WEB-INF/classes/" + (String) e.getValue());
					File f = new File(path);
					if (f.exists()) {
						String key = ((String) e.getValue()).replaceAll(".jrxml", "").toUpperCase();
						JasperReport r = JasperCompileManager.compileReport(path);
						parameters.put(key, r);
					}
					f = null;
				}
			}

			JasperReport report = JasperCompileManager.compileReport(jrXmlPath);
			JasperPrint jasperPrint = JasperFillManager.fillReport(report, parameters, jds);

			if (!UtilTools.isEmpty(pdfDirPath)) {
				String path = Paths.get(pdfDirPath, pdfFileName).toString();
				JasperExportManager.exportReportToPdfFile(jasperPrint, path);
				context.getDto().getAction().put("output_module_id", "ret_none");
			} else {
				JasperExportManager.exportReportToPdfStream(jasperPrint, output);
				result.getReturnData().put("filename", pdfFileName);
				result.getReturnData().put("input_stream", output.toByteArray());
			}
		} catch (Exception e) {
			throw new PhotonModuleException("PDFの作成に失敗しました。", e);
		}

		return result;
	}

	public String getTplid() {
		return tplid;
	}

	public void setTplid(String tplid) {
		this.tplid = tplid;
	}

	public String getMaintpl() {
		return maintpl;
	}

	public void setMaintpl(String maintpl) {
		this.maintpl = maintpl;
	}

	public Map<String, Object> getSubtpl() {
		return subtpl;
	}

	public void setSubtpl(Map<String, Object> subtpl) {
		this.subtpl = subtpl;
	}

	public String getPdfDirPath() {
		return pdfDirPath;
	}

	public void setPdfDirPath(String pdfDirPath) {
		this.pdfDirPath = pdfDirPath;
	}

	public String getPdfFileName() {
		return pdfFileName;
	}

	public void setPdfFileName(String pdfFileName) {
		this.pdfFileName = pdfFileName;
	}

	public Map<String, Object> getSrc() {
		return src;
	}

	public void setSrc(Map<String, Object> src) {
		this.src = src;
	}

	public Map<String, Object> getCommon() {
		return common;
	}

	public void setCommon(Map<String, Object> common) {
		this.common = common;
	}
}
