package jp.ill.photon.module.params;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleFactory;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.JsonUtil;
import jp.ill.photon.util.ParamUtil;

public class ModuleParamsMapModule implements PhotonModule {

	@ModuleParam(required=true)
	private List<Map<String, Object>> moduleList;

	/**
	 * moduleListを取得します。
	 * @return moduleList
	 */
	public List<Map<String, Object>> getModuleList() {
		return moduleList;
	}

	/**
	 * moduleListを設定します。
	 * @param moduleList
	 */
	public void setModuleList(List<Map<String, Object>> moduleList) {
		this.moduleList = moduleList;
	}

	@SuppressWarnings({ "rawtypes" })
	@Override
	public ModuleResult execute(ModuleContext context) {

		// 入力:[ {データ1}, {データ2}, ... {データN} ]
		// 出力:{
		//         "モジュールID1": {
		//           "フィールド名1": {
		//             "remars": "",
		//             "transfer_type": "フィールド1に付いているDefaulsParamSettingアノテーションのtransferType",
		//             "transfer_val": "フィールド1に付いているDefaulsParamSettingアノテーションのtransferVal"
		//           },
		//           "フィールド名2": {
		//             "remars": "",
		//             "transfer_type": "フィールド2に付いているDefaulsParamSettingアノテーションのtransferType",
		//             "transfer_val": "フィールド2に付いているDefaulsParamSettingアノテーションのtransferVal"
		//           },
		//
		//           .
		//           .
		//           .
		//
		//           "フィールド名N": {
		//             "remars": "",
		//             "transfer_type": "フィールドNに付いているDefaulsParamSettingアノテーションのtransferType",
		//             "transfer_val": "フィールドNに付いているDefaulsParamSettingアノテーションのtransferVal"
		//           }
		//         }
		//      }

		Map<String, Object> retMap = new HashMap<String, Object>();

		if (moduleList != null) {

			for (Map<String, Object> item : moduleList) {

				// class_nameからモジュール情報取得
				String moduleId = (String)item.get("module_id");
				String className = (String)item.get("module_class");
				PhotonModule module = ModuleFactory.get(className);

				Map<String, Object> fieldParam = new HashMap<String, Object>();

				// フィールド一覧取得
				Field[] fs = module.getClass().getDeclaredFields();
				if (fs != null) {

					int sortNo = 1;
					for (Field f : fs) {

						String fieldName = ParamUtil.camelToSnake(f.getName());
						ModuleParam param = f.getAnnotation(ModuleParam.class);
						if (param != null) {

							// デフォルト値があるか？
							DefaultParamSetting defs = f.getAnnotation(DefaultParamSetting.class);
							// あった場合はその値をセット
							// 無かった場合は空にしておく
							String transferType = "";
							String transferVal = "";
							if (defs != null) {
								transferType = defs.transferType();
								transferVal = defs.transferVal();
							}

							Map<String, String> params = new HashMap<String, String>();
							params.put("remars", "");
							params.put("sort_no", Integer.toString(sortNo));
							params.put("transfer_type", transferType);
							params.put("transfer_val", transferVal);


							fieldParam.put(fieldName, params);

						}
						sortNo++;

					}

				}

				retMap.put(moduleId, fieldParam);

			}

		}

		ModuleResult result = new ModuleResult();
		result.getReturnData().put("map", retMap);
		result.getReturnData().put("json_str", JsonUtil.mapToJson(retMap));

		return result;

	}

}
