package jp.ill.photon.module.output;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedHashMap;
import java.util.Map;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.annotation.ModuleVersion;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.model.MapParam;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.JsonUtil;
import jp.ill.photon.util.ParamUtil;

@ModuleVersion("1.0.0")
public class JSONOutputModule implements PhotonModule {

	@ModuleParam(required = false)
	private String encoding;

	@ModuleParam(required = true)
	private MapParam includes;

	@Override
	public ModuleResult execute(ModuleContext context)
			throws PhotonModuleException {
		ModuleResult result = new ModuleResult();

		String encoding = getEncoding();
		if (encoding == null || encoding.isEmpty()) {
			encoding = "UTF-8";
		}

		// includesパラメータで指定された値をJSONデータとして組み立て
		Map<String, Object> jsonMap = new LinkedHashMap<>();

		String type = null;
		for (Map.Entry<String, Object> entry : getIncludes().getParamMap()
				.entrySet()) {
			type = String.valueOf(((Map) entry.getValue()).get("type"));
			jsonMap.put(entry.getKey(), ParamUtil.getParamValueByType(type,
					((Map) entry.getValue()).get("val"), context.getDto()));
		}
		jsonMap.put("messages", context.getDto().getMappedMessages());

		String json = JsonUtil.mapToJson(jsonMap);
		byte[] jsonBytes = null;
		try {
			jsonBytes = json.getBytes(encoding);
		} catch (UnsupportedEncodingException ex) {
			throw new PhotonModuleException("エンコーディングが不正です", ex);
		}

		result.getReturnData().put("content_type",
				"application/json; charset=" + encoding);
		result.getReturnData().put("content_length", jsonBytes.length);
		result.getReturnData().put("content_disposition", "");

		result.getReturnData().put("input_stream",
				new ByteArrayInputStream(jsonBytes));

		return result;
	}

	public String getEncoding() {
		return encoding;
	}

	public void setEncoding(String encoding) {
		this.encoding = encoding;
	}

	public MapParam getIncludes() {
		return includes;
	}

	public void setIncludes(MapParam includes) {
		this.includes = includes;
	}

}
