package jp.ill.photon.module.output;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.annotation.ModuleVersion;
import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;

@ModuleVersion("1.0.0")
public class HTMLGeneralListPageOutputModule implements PhotonModule {

	@ModuleParam(required = true)
	private String templatePath;

	@ModuleParam(required = true)
	private String pageTitle;

	@ModuleParam(required = true)
	private String contentTitle;

	@ModuleParam(required = true)
	private Map<String, Object> columnList;

	@ModuleParam(required = true)
	private List<Map<String, Object>> rowList;

	@ModuleParam(required = true)
	private Map<String, Object> linkInfo;

	public String getTemplatePath() {
		return templatePath;
	}

	public void setTemplatePath(String templatePath) {
		this.templatePath = templatePath;
	}

	public String getPageTitle() {
		return pageTitle;
	}

	public void setPageTitle(String pageTitle) {
		this.pageTitle = pageTitle;
	}

	public String getContentTitle() {
		return contentTitle;
	}

	public void setContentTitle(String contentTitle) {
		this.contentTitle = contentTitle;
	}

	public Map<String, Object> getColumnList() {
		return columnList;
	}

	public void setColumnList(Map<String, Object> columnList) {
		this.columnList = columnList;
	}

	public List<Map<String, Object>> getRowList() {
		return rowList;
	}

	public void setRowList(List<Map<String, Object>> rowList) {
		this.rowList = rowList;
	}

	public Map<String, Object> getLinkInfo() {
		return linkInfo;
	}

	public void setLinkInfo(Map<String, Object> linkInfo) {
		this.linkInfo = linkInfo;
	}

	@Override
	public ModuleResult execute(ModuleContext context) {

		if (linkInfo != null) {
			rowList = addLinkInfoToRowList(rowList, linkInfo, context.getDto());
		}

		ModuleResult result = new ModuleResult();
		result.getReturnData().put("templatePath", templatePath);
		result.getReturnData().put("page_title", pageTitle);
		result.getReturnData().put("content_title", contentTitle);
		result.getReturnData().put("row_list", rowList);
		result.getReturnData().put("col_list",
				(List<Map<String, String>>) columnList.get("list"));
		result.getReturnData().put("link_info", linkInfo);

		return result;
	}

	/**
	 * データの各明細にリンク生成用情報を追加する
	 *
	 * @param rowList
	 * @param linkInfo
	 * @param dto
	 * @return
	 */
	protected List<Map<String, Object>> addLinkInfoToRowList(	List<Map<String, Object>> rowList,
																Map<String, Object> linkInfo,
																ActionDto dto) {

		Map<String, Object> linkTypeInfo = null;
		Map<String, String> paramMap = null;
		Map<String, Object> linkQueryMap = null;

		List<Map<String, Object>> convertedList = new ArrayList<Map<String, Object>>();
		for (Map<String, Object> row : rowList) {
			linkQueryMap = new HashMap<String, Object>();
			for (Map.Entry<String, Object> entry : linkInfo.entrySet()) {
				linkTypeInfo = (Map) entry.getValue();
				paramMap = (Map) linkTypeInfo.get("params");
				linkQueryMap.put(entry.getKey(),
						createLinkQuery(row, paramMap));
			}
			row.put("link_query", linkQueryMap);
			convertedList.add(row);
		}

		return convertedList;
	}

	/**
	 * URL用のパラメータクエリを生成する
	 *
	 * @param row
	 * @param paramMap
	 * @return
	 */
	protected String createLinkQuery(	Map<String, Object> row,
										Map<String, String> paramMap) {

		StringBuffer paramQuery = new StringBuffer();
		if (paramMap == null) {
			return paramQuery.toString();
		}
		for (Map.Entry<String, String> param : paramMap.entrySet()) {
			if (row.containsKey(param.getKey())) {
				if (paramQuery.length() > 0) {
					paramQuery.append("&");
				}
				paramQuery.append(param.getValue());
				paramQuery.append("=");
				paramQuery.append(row.get(param.getKey()));
			}
		}

		return paramQuery.toString();
	}

}
