package jp.ill.photon.module.output;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.dao.builder.DomaSQLQueryBuilder;
import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.EscapeChars;
import jp.ill.photon.util.JsonUtil;
import jp.ill.photon.util.ParamUtil;

public class HTMLGeneralListOutputModule implements PhotonModule {

	@ModuleParam(required=true)
	private String templatePath;

	@ModuleParam(required=true)
	private String pageTitle;

	@ModuleParam(required=false)
	private String contentTitle;

	@ModuleParam(required=false)
	private Map<String, Object> columnList;

	@ModuleParam(required=false)
	private List<Map<String, Object>> rowList;

	@ModuleParam(required=false)
	private List<Map<String, Object>> condList;

	@ModuleParam(required=false)
	private String mainPostTarget;

	@ModuleParam(required=false)
	private Map<String, Object> formItems;

	@ModuleParam(required=false)
	private Map<String, Object> linkInfo;

	@ModuleParam(required=false)
	private List<Map<String, Object>> errors;

	@ModuleParam(required=false)
	private String dispResultCount;

	@ModuleParam(required=false)
	private String screenId;

	@ModuleParam(required=false)
	private Map<String, Object> objectInfo;

	@ModuleParam(required=false)
	private List<Map<String, Object>> groupSetting;

	@ModuleParam(required=false)
	private String resultListName;

	@ModuleParam(required=false)
	private List<Map<String, Object>> subForms;

	/* クラス内の複数メソッドで使用する変数 */
	protected ActionDto dto;

	/** タイプ */
	public static String TYPE_CHECKBOX = "checkbox";
	public static String TYPE_RADIO = "radio";
	public static String TYPE_BUTTON = "button";
	public static String TYPE_FILE = "file";

	@Override
	public ModuleResult execute(ModuleContext context) {

    	dto = context.getDto();

		Integer cnt = null;
		Integer startNum = null;
		if (!StringUtils.isEmpty(dispResultCount)) {
			cnt = 0;
			startNum = 0;
			if (!CollectionUtils.isEmpty(rowList)) {
				Map<String, Object> mp = rowList.get(0);
				if (mp.get("count") != null) {
					cnt = Integer.parseInt(String.valueOf(mp.get("count")));
					startNum = Integer.parseInt(String.valueOf(mp.get("start_num")));
				}
			}
		}

		if (linkInfo != null) {
			rowList = addLinkInfoToRowList(rowList, linkInfo);
		}
		if (objectInfo != null) {
			rowList = addObjectInfoToRowList(rowList, objectInfo);
		}

		ModuleResult result = new ModuleResult();
		result.getReturnData().put("templatePath", templatePath);
		result.getReturnData().put("page_title", pageTitle);
		result.getReturnData().put("content_title", contentTitle);
		result.getReturnData().put("form_items", formItems);
		result.getReturnData().put("row_list", rowList);
		List<Map<String, Object>> colList = makeColList();
		result.getReturnData().put("col_list", colList);
		result.getReturnData().put("col_map",makeColMapFromColList(colList));
		result.getReturnData().put("link_info", linkInfo);
		result.getReturnData().put("count", cnt);
		result.getReturnData().put("start_num", startNum);
		result.getReturnData().put("cond_list", condList);
		result.getReturnData().put("main_post_target", mainPostTarget);
		result.getReturnData().put("screen_id", StringUtils.defaultString(screenId, ""));
		result.getReturnData().put("group_setting", groupSetting);
		result.getReturnData().put("result_list_name", resultListName);
		result.getReturnData().put("sub_forms", subForms);

		// { "key": ["", ""] }
		result.getReturnData().put("errors", getCombinedErrorMessage());

		return result;
	}

	/**
	 * エラーメッセージの結合
	 *
	 *
	 */
	@SuppressWarnings("unchecked")
	private Map<String, Object> getCombinedErrorMessage() {
		Map<String, Object> ret = new HashMap<String, Object>();
		if (!CollectionUtils.isEmpty(errors)) {
			for (Map<String, Object> mp : errors) {
				// 1つのバリデーションエラーメッセージ
				Map<String, Object> errorMsgMap = (Map<String, Object>)ParamUtil.getParamObjectValueByType(mp, dto);
				if (errorMsgMap != null) {
					for (Map.Entry<String, Object> e : errorMsgMap.entrySet()) {
						List<String> retList = (List<String>) ret.get(e.getKey());
						if (CollectionUtils.isEmpty(retList)) {
							retList = new ArrayList<String>();
						}
						List<String> messageList = (List<String>) e.getValue();
						if (e.getValue() != null) {
							retList.addAll(messageList);
						}
						ret.put(e.getKey(), retList);
					}
				}
			}
		}
		return ret;
	}

	/**
	* col_listを基にcol_mapを作成
	*
	* @param src
	* @return
	*/
	@SuppressWarnings({ "unchecked", "rawtypes" })
	private List<Map<String, Object>> makeColList() {

		List<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
		if (columnList == null) {
			return null;
		}

		// disp_mapのみ、typeとvalから取得したマップに置き換える
		List<Map<String, Object>> list = (List<Map<String, Object>>) columnList.get("list");
		if (list != null) {
			for (Map<String, Object> map : list) {
				Map<String, Object> newMap = new HashMap<String, Object>();
				for (Map.Entry<String, Object> e : map.entrySet()) {
					if ("disp_map".equals(e.getKey())) {
						if (e.getValue() != null) {
							Map dispMapInfo = (Map)e.getValue();
							String type = (String)dispMapInfo.get("type");
							Object val = dispMapInfo.get("val");
							if (e.getValue() instanceof Map) {
								Map<String, Object> valMap = (Map<String, Object>)ParamUtil.getParamValueByType(
										type, val, dto);
								newMap.put(e.getKey(), valMap);
							} else {
								List<Map<String, Object>> valList = (List<Map<String, Object>>)ParamUtil.getParamValueByType(
										type, val, dto);
								if (valList != null) {
									Map<String, Object> valMap = new HashMap<String, Object>();
									for (Map<String, Object> mp : valList) {
										valMap.put((String)mp.get("list_value"), (String)mp.get("list_caption"));
									}
									newMap.put(e.getKey(), valMap);
								}
							}
						}
					} else {
						newMap.put(e.getKey(), e.getValue());
					}
				}
				ret.add(newMap);
			}
		}

		return ret;

	}

	/**
	* col_listを基にcol_mapを作成
	*
	* @param src
	* @return
	*/
	private Map<String, Map<String, Object>> makeColMapFromColList(List<Map<String, Object>> src) {
		Map<String, Map<String, Object>> ret = new HashMap<String, Map<String, Object>>();
		if (src == null) {
			return ret;
		}
		for (Map<String, Object> item : src) {
			String key = (String)item.get("key");
			ret.put(key, item);
		}
		return ret;
	}

	/**
	* データの各明細にリンク生成用情報を追加する
	*
	* @param rowList
	* @param linkInfo
	* @return
	*/
	@SuppressWarnings({ "unchecked", "rawtypes" })
	protected List<Map<String, Object>> addLinkInfoToRowList(List<Map<String, Object>> rowList,
			Map<String, Object> linkInfo) {

		Map<String, Object> linkTypeInfo = null;
		Map<String, Object> paramMap = null;
		Map<String, Object> linkQueryMap = null;
		Map<String, Object> funcMap = null;

		List<Map<String, Object>> convertedList = new ArrayList<Map<String, Object>>();
		if (rowList != null) {
			for (Map<String, Object> row : rowList) {
				linkQueryMap = new HashMap<String, Object>();
				funcMap = new HashMap<String, Object>();
				for (Map.Entry<String, Object> entry : linkInfo.entrySet()) {
					linkTypeInfo = (Map) entry.getValue();
					String type = (String) linkTypeInfo.get("type");
					if ("edit".equals(type)) {
						paramMap = (Map) ((Map) linkTypeInfo.get("val")).get("params");
						linkQueryMap.put(entry.getKey(),
								createLinkQuery(row, paramMap));
					} else if ("func".equals(type)) {
						Map fncInfo = (Map)linkTypeInfo.get("func_info");
						funcMap.put(entry.getKey(),
								createFuncStr(row, fncInfo));
					}
				}
				row.put("link_query", linkQueryMap);
				row.put("func", funcMap);
				convertedList.add(row);
			}
		}

		return convertedList;
	}

	/**
	* URL用のパラメータクエリを生成する
	*
	* @param row
	* @param paramMap
	* @return
	*/
	@SuppressWarnings({ "unchecked", "rawtypes" })
	protected String createLinkQuery(Map<String, Object> row,
			Map<String, Object> paramMap) {

		StringBuffer paramQuery = new StringBuffer();
		for (Map.Entry<String, Object> param : paramMap.entrySet()) {

			if (paramQuery.length() > 0) {
				paramQuery.append("&");
			}

			paramQuery.append(param.getKey());
			paramQuery.append("=");

			Map<String, Object> map = (Map)param.getValue();
			String type = (String)map.get("type");
			String val = (String)map.get("val");

			if ("row".equals(type)){
				if (row.containsKey(param.getKey())) {
					paramQuery.append(row.get(val));
				}
			} else {
				Object value = ParamUtil.getParamValueByType(
						type, val, dto);
				paramQuery.append((String)value);
			}

		}

		return paramQuery.toString();
	}

	/**
	* ファンクション文字列を作成する
	*
	* @param row
	* @param fncInfo
	* @return
	*/
	@SuppressWarnings("unchecked")
	protected String createFuncStr(Map<String, Object> row,
			Map<String, Object> fncInfo) {

		StringBuffer fncStr = new StringBuffer();

		String fncName = (String)fncInfo.get("name");
		fncStr.append(fncName);
		fncStr.append("(");

		List<Map<String, Object>> params = (List<Map<String, Object>>)fncInfo.get("params");

		if (params != null) {

			int cnt = 0;

			for (Map<String, Object> param : params) {

				String type = (String)param.get("type");
				String val = (String)param.get("val");

				if (cnt > 0) {
					fncStr.append(",");
				}

				if ("row".equals(type)){
					if (row.containsKey(val)) {
						fncStr.append("'" + row.get(val) + "'");
						cnt++;
					}
				} else {
					Object value = ParamUtil.getParamValueByType(
							type, val, dto);
					fncStr.append("'" + (String)value + "'");
					cnt++;
				}

			}

		}

		fncStr.append(")");

		return fncStr.toString();

	}


	/**
	* データの各明細にオブジェクト生成用情報を追加する
	*
	* @param rowList
	* @param objectInfo
	* @return
	*/
	@SuppressWarnings({ })
	protected List<Map<String, Object>> addObjectInfoToRowList(
			List<Map<String, Object>> rowList,
			Map<String, Object> objectInfo) {

		List<Map<String, Object>> convertedList = new ArrayList<Map<String, Object>>();
		if (rowList != null) {

			for (Map<String, Object> row : rowList) {

				// 入力項目セット
				Map<String, Object> forms_input = new LinkedHashMap<String, Object>();
				setInputParametersFromStaticJson(objectInfo, forms_input, row);

				row.put("object_info", forms_input);
				convertedList.add(row);

			}

		}
		return convertedList;
	}

	/**
	 * 入力項目のstatic_jsonプロパティからフォーム情報をセットする
	 *
	 * @param src static_json
	 * @param dst フォーム情報をセットする先
	 *
	 * */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	private void setInputParametersFromStaticJson(
			Map<String, Object> src,
			Map<String, Object> dst,
			Map<String, Object> row) {

		if (src != null) {

			Map<String, Object> paramValuesInfo = null;
			Map<String, Object> paramInputsInfo = null;


			for (Map.Entry<String, Object> param : src.entrySet()) {

				String key = param.getKey();

				Map mp = (Map)param.getValue();
				paramValuesInfo = (Map<String, Object>)mp.get("params");
				paramInputsInfo = (Map<String, Object>)mp.get("inputs");
				Map<String, Object> actionIdInfo = (Map<String, Object>)mp.get("action_id");

				Map<String, Object> valMap = new HashMap<String, Object>();

				if (actionIdInfo != null && !actionIdInfo.isEmpty()) {
					valMap.put("action_id", ParamUtil.getParamStrValueByType(actionIdInfo, dto));
				}

				// params属性が存在するときには
				// 配下のパラメータを全て結合し、data-link属性にセットする
				// data-json属性にもセットすること
				if (paramValuesInfo != null && !paramValuesInfo.isEmpty()) {

					StringBuffer sbDataLink = new StringBuffer();
					Map<String, Object> dataJson = new HashMap<String, Object>();
					for (Map.Entry<String, Object> e : paramValuesInfo.entrySet()) {

						if (sbDataLink.length() > 0) {
							sbDataLink.append("&");
						}

						Map<String, Object> item = (Map)e.getValue();
						String type = (String)item.get("type");
						Object val = item.get("val");
						Object value = null;

						if ("row".equals(type)){
							if (row.containsKey(e.getKey())) {
								//TODO:L.Satta エスケープ処理の追加
								if(row.get(val) instanceof String){
									value = EscapeChars.forHrefAmpersand(row.get(val).toString());
								}else{
									row.get(val);
								}
							}
						} else {
							value = ParamUtil.getParamValueByType(type, val, dto);
						}

						if (value != null) {
							sbDataLink.append(e.getKey() + "=" + (String)value);
						}
						dataJson.put(e.getKey(), (String)value);

					}

					if (sbDataLink.length() > 0) {
						valMap.put("data_link", sbDataLink.toString());
					}
					valMap.put("data_json", JsonUtil.mapToJson(dataJson));

				}

				String inputType = (String)paramInputsInfo.get("type");
				valMap.put("type", inputType);

				// 特殊な処理をしない設定値はそのままvalMapにセットする
				for (Map.Entry<String, Object> e : paramInputsInfo.entrySet()) {
					// 特殊な処理をするかどうか
					if (!needOriginalProcess(inputType, key)) {
						valMap.put(e.getKey(), e.getValue());
					}
				}

				if (TYPE_CHECKBOX.equals(inputType) ||
					TYPE_RADIO.equals(inputType)) {

					valMap.put("list", getList((String)paramInputsInfo.get("list_type"), paramInputsInfo.get("list")));

				}

				if (TYPE_FILE.equals(inputType)) {

					String filePath = getFilePath(
							(Map)paramInputsInfo.get("file_dir"),
							(Map)paramInputsInfo.get("file_sub_dir"),
							(Map)paramInputsInfo.get("file_name"),
							row);
					valMap.put("file_name", filePath);
					valMap.put("file_image_disp_width", ParamUtil.getParamStrValueByType(paramInputsInfo.get("file_image_disp_width"), dto));
					valMap.put("file_image_use_flg", ParamUtil.getParamStrValueByType(paramInputsInfo.get("file_image_use_flg"), dto));

				}

				valMap.put("name", key);

				if (paramInputsInfo.containsKey("html_attr")) {
					valMap.put("html_attr", getHtmlAttr(paramInputsInfo.get("html_attr")));
				}

				dst.put(key, valMap);

			}

		}

	}


	/**
	 * "html_attr"属性設定取得
	 *
	 * @param src
	 * @return "html_attr"属性設定
	 *
	 * */
	@SuppressWarnings("unchecked")
	private Map<String, String> getHtmlAttr(Object src) {

		Map<String, String> ret = new HashMap<String, String>();
		if (src != null) {
			ret = (Map<String, String>)src;
		}
		return ret;

	}

	/**
	 * 指定された設定から、ファイル項目設定情報を作成
	 *
	 * @param fileDir
	 * @param fileSubDir
	 * @param fileName
	 * @param row
	 *
	 * */
	private String getFilePath(Map<String, Object> fileDir, Map<String, Object> fileSubDir, Map<String, Object> fileName, Map<String, Object> row) {

		String ret = null;

		String fileDirVal = getParamStrValueByRecType(fileDir, row);
		String fileSubDirVal = getParamStrValueByRecType(fileSubDir, row);
		String fileNameVal = getParamStrValueByRecType(fileName, row);

		StringJoiner sj = new StringJoiner("/");

		if (!StringUtils.isEmpty(fileDirVal)){
			sj.add(fileDirVal);
		}
		if (!StringUtils.isEmpty(fileSubDirVal)){
			sj.add(fileSubDirVal);
		}
		ret = sj.toString();
		ret += "/";
		if (!StringUtils.isEmpty(fileNameVal)){
			ret += fileNameVal;
		}

		return ret;

	}

	/**
	 * 指定された設定から、ファイル項目設定情報を作成
	 *
	 * @param mp
	 * @param row
	 *
	 * @return パラメータ値
	 *
	 * */
	private String getParamStrValueByRecType(Map<String, Object> mp, Map<String, Object> row) {
		String ret = null;
		if ( "row".equals( (String) mp.get("type") ) ){
			ret = (String)row.get( (String) mp.get("val") );
		} else {
			ret = ParamUtil.getParamStrValueByType(mp, dto);
		}
		return ret;
	}

	/**
	 * 指定されたlistTypeから、リストを作成
	 *
	 * @param listType
	 * @param list
	 *
	 * */
	@SuppressWarnings("unchecked")
	private List<Map<String, String>> getList(String listType, Object list) {

		List<Map<String, String>> ret = new ArrayList<Map<String, String>>();

		if ("static".equals(listType)) {

			// staticのときは、"list"属性に定義されているマップを使用
			ret = (List<Map<String, String>>)list;

		} else if ("dto".equals(listType)) {

			// dtoのときは、dtoの中から、"list"属性に指定されているプロパティを指定してマップを取得
			String key = (String)list;
			List<Map<String, Object>> resultList = (List<Map<String, Object>>)ParamUtil.getParamValueByType("dto", key, dto);
			if (resultList != null && !resultList.isEmpty()) {
				for (Map<String, Object> data : resultList) {
					ret.add(new HashMap<String, String>(){{
						put("list_value", (String)data.get("value"));
						put("list_caption", (String)data.get("caption"));
					}});
				}
			}

		} else if ("query".equals(listType)) {

			Map<String, Object> map = (Map<String, Object>)list;
			String query = (String)map.get("query");
			List<Map<String, String>> condList = (List<Map<String, String>>)map.get("cond");
			Map<String, Object> params = new HashMap<String, Object>();

			for (Map<String, String> mp : condList) {
				String value = (String)ParamUtil.getParamValueByType(mp.get("transfer_type"), mp.get("transfer_val"), dto);
				params.put(mp.get("key"), value);
			}

			List<Map<String, Object>> resultList =
					new DomaSQLQueryBuilder().getListResult(query, params, dto);
			if (resultList != null && !resultList.isEmpty()) {
				for (Map<String, Object> data : resultList) {
					ret.add(new HashMap<String, String>(){{
						put("list_value", (String)data.get("value"));
						put("list_caption", (String)data.get("caption"));
					}});
				}
			}

		}

		return ret;

	}


	/**
	 * 特殊な処理が必要か取得
	 *
	 * @param inputType
	 * @param key
	 * @return 特殊な処理が必要か
	 *
	 * */
	private boolean needOriginalProcess(String inputType, String key) {

		if (TYPE_CHECKBOX.equals(inputType) ||
			TYPE_RADIO.equals(inputType)) {

			List<String> list = new ArrayList<String>(){{
				add("list_type");
				add("list");
			}};
			return list.contains(key);

		}

		if (TYPE_FILE.equals(inputType)) {

			List<String> list = new ArrayList<String>(){{
				add("file_store_path_system_setting_id");
				add("file_context_path_system_setting_id");
				add("file_name_select_query");
				add("file_image_use_flg");
				add("file_image_disp_width");
				add("file_extension_list");
				add("file_path");
			}};
			return list.contains(key);

		}

		return false;

	}


	/**
	 * templatePathを取得します。
	 * @return templatePath
	 */
	public String getTemplatePath() {
		return templatePath;
	}

	/**
	 * templatePathを設定します。
	 * @param templatePath
	 */
	public void setTemplatePath(String templatePath) {
		this.templatePath = templatePath;
	}

	/**
	 * pageTitleを取得します。
	 * @return pageTitle
	 */
	public String getPageTitle() {
		return pageTitle;
	}

	/**
	 * pageTitleを設定します。
	 * @param pageTitle
	 */
	public void setPageTitle(String pageTitle) {
		this.pageTitle = pageTitle;
	}

	/**
	 * contentTitleを取得します。
	 * @return contentTitle
	 */
	public String getContentTitle() {
		return contentTitle;
	}

	/**
	 * contentTitleを設定します。
	 * @param contentTitle
	 */
	public void setContentTitle(String contentTitle) {
		this.contentTitle = contentTitle;
	}

	/**
	 * columnListを取得します。
	 * @return columnList
	 */
	public Map<String, Object> getColumnList() {
		return columnList;
	}

	/**
	 * columnListを設定します。
	 * @param columnList
	 */
	public void setColumnList(Map<String, Object> columnList) {
		this.columnList = columnList;
	}

	/**
	 * rowListを取得します。
	 * @return rowList
	 */
	public List<Map<String, Object>> getRowList() {
		return rowList;
	}

	/**
	 * rowListを設定します。
	 * @param rowList
	 */
	public void setRowList(List<Map<String, Object>> rowList) {
		this.rowList = rowList;
	}

	/**
	 * condListを取得します。
	 * @return condList
	 */
	public List<Map<String, Object>> getCondList() {
		return condList;
	}

	/**
	 * condListを設定します。
	 * @param condList
	 */
	public void setCondList(List<Map<String, Object>> condList) {
		this.condList = condList;
	}

	/**
	 * mainPostTargetを取得します。
	 * @return mainPostTarget
	 */
	public String getMainPostTarget() {
		return mainPostTarget;
	}

	/**
	 * mainPostTargetを設定します。
	 * @param mainPostTarget
	 */
	public void setMainPostTarget(String mainPostTarget) {
		this.mainPostTarget = mainPostTarget;
	}

	/**
	 * formItemsを取得します。
	 * @return formItems
	 */
	public Map<String, Object> getFormItems() {
		return formItems;
	}

	/**
	 * formItemsを設定します。
	 * @param formItems
	 */
	public void setFormItems(Map<String, Object> formItems) {
		this.formItems = formItems;
	}

	/**
	 * linkInfoを取得します。
	 * @return linkInfo
	 */
	public Map<String, Object> getLinkInfo() {
		return linkInfo;
	}

	/**
	 * linkInfoを設定します。
	 * @param linkInfo
	 */
	public void setLinkInfo(Map<String, Object> linkInfo) {
		this.linkInfo = linkInfo;
	}

	/**
	 * errorsを取得します。
	 * @return errors
	 */
	public List<Map<String, Object>> getErrors() {
		return errors;
	}

	/**
	 * errorsを設定します。
	 * @param errors
	 */
	public void setErrors(List<Map<String, Object>> errors) {
		this.errors = errors;
	}

	/**
	 * dispResultCountを取得します。
	 * @return dispResultCount
	 */
	public String getDispResultCount() {
		return dispResultCount;
	}

	/**
	 * dispResultCountを設定します。
	 * @param dispResultCount
	 */
	public void setDispResultCount(String dispResultCount) {
		this.dispResultCount = dispResultCount;
	}

	/**
	 * screenIdを取得します。
	 * @return screenId
	 */
	public String getScreenId() {
		return screenId;
	}

	/**
	 * screenIdを設定します。
	 * @param screenId
	 */
	public void setScreenId(String screenId) {
		this.screenId = screenId;
	}

	/**
	 * objectInfoを取得します。
	 * @return objectInfo
	 */
	public Map<String, Object> getObjectInfo() {
		return objectInfo;
	}

	/**
	 * objectInfoを設定します。
	 * @param objectInfo
	 */
	public void setObjectInfo(Map<String, Object> objectInfo) {
		this.objectInfo = objectInfo;
	}

	/**
	 * groupSettingを取得します。
	 * @return groupSetting
	 */
	public List<Map<String, Object>> getGroupSetting() {
		return groupSetting;
	}

	/**
	 * groupSettingを設定します。
	 * @param groupSetting
	 */
	public void setGroupSetting(List<Map<String, Object>> groupSetting) {
		this.groupSetting = groupSetting;
	}

	/**
	 * resultListNameを取得します。
	 * @return resultListName
	 */
	public String getResultListName() {
		return resultListName;
	}

	/**
	 * resultListNameを設定します。
	 * @param resultListName
	 */
	public void setResultListName(String resultListName) {
		this.resultListName = resultListName;
	}

	/**
	 * subFormsを取得します。
	 * @return subForms
	 */
	public List<Map<String, Object>> getSubForms() {
		return subForms;
	}

	/**
	 * subFormsを設定します。
	 * @param subForms
	 */
	public void setSubForms(List<Map<String, Object>> subForms) {
		this.subForms = subForms;
	}

}
