package jp.ill.photon.module.output;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;

import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.annotation.ModuleVersion;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;

@ModuleVersion("1.0.0")
public class HTMLGeneralFileOutputModule implements PhotonModule {

	@ModuleParam(required=true)
	private String filePath;

	@ModuleParam(required=false)
	@DefaultParamSetting(transferType = "static", transferVal = "UTF-8")
	private String encoding;

	public String getFilePath() {
		return filePath;
	}

	public void setFilePath(String filePath) {
		this.filePath = filePath;
	}

	public String getEncoding() {
		return encoding;
	}

	public void setEncoding(String encoding) {
		this.encoding = encoding;
	}

	@Override
	public ModuleResult execute( ModuleContext context ) throws PhotonModuleException {

		ModuleResult result = new ModuleResult();

		if (filePath == null || filePath.isEmpty()) {
			filePath = "";
		}

		Path absolutePath = Paths.get(filePath);

		try (FileInputStream fis = new FileInputStream(absolutePath.toFile())) {

			ByteArrayOutputStream bos = new ByteArrayOutputStream();

			byte[] buf = new byte[512];
			int len;
			while ((len = fis.read(buf)) != -1) {
				bos.write(buf, 0, len);
			}
			bos.flush();
			byte[] file = bos.toByteArray();

			result.getReturnData().put("input_stream", new ByteArrayInputStream(file));
			result.getReturnData().put("content_length", file.length);
			result.getReturnData().put("content_type",
					"text/html; charset=" + encoding);

		} catch (FileNotFoundException ex) {
			throw new PhotonModuleException("File not found.", ex);
		} catch (IOException ex) {
			throw new PhotonModuleException("File io error.", ex);
		}

		return result;
	}
}
