package jp.ill.photon.module.output;

import java.util.List;
import java.util.Map;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.annotation.ModuleVersion;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;

@ModuleVersion("1.0.0")
public class HTMLGeneralEditPageOutputModule implements PhotonModule {

	@ModuleParam(required=true)
	private String templatePath;

	@ModuleParam(required=true)
	private String pageTitle;

	@ModuleParam(required=true)
	private String contentTitle;

	@ModuleParam(required=true)
	private Map<String, Object> columnList;

	@ModuleParam(required=true)
	private Map<String, Object> data;

	@ModuleParam(required=true)
	private Map<String, Object> linkInfo;

	@ModuleParam(required=true)
	private Map<String, Object> errors;

    public String getTemplatePath() {
		return templatePath;
	}

	public void setTemplatePath(String templatePath) {
		this.templatePath = templatePath;
	}

	public String getPageTitle() {
		return pageTitle;
	}

	public void setPageTitle(String pageTitle) {
		this.pageTitle = pageTitle;
	}

	public String getContentTitle() {
		return contentTitle;
	}

	public void setContentTitle(String contentTitle) {
		this.contentTitle = contentTitle;
	}

	public Map<String, Object> getColumnList() {
		return columnList;
	}

	public void setColumnList(Map<String, Object> columnList) {
		this.columnList = columnList;
	}

	public Map<String, Object> getData() {
		return data;
	}

	public void setData(Map<String, Object> data) {
		this.data = data;
	}

	public Map<String, Object> getLinkInfo() {
		return linkInfo;
	}

	public void setLinkInfo(Map<String, Object> linkInfo) {
		this.linkInfo = linkInfo;
	}

	public Map<String, Object> getErrors() {
		return errors;
	}

	public void setErrors(Map<String, Object> errors) {
		this.errors = errors;
	}

	@Override
    public ModuleResult execute( ModuleContext context ) {

        ModuleResult result = new ModuleResult();
        result.getReturnData().put("templatePath", templatePath);
        result.getReturnData().put("page_title", pageTitle);
        result.getReturnData().put("content_title", contentTitle);

        result.getReturnData().put("data", data);

        result.getReturnData().put("col_list",
                (List<Map<String, String>>) columnList.get("list"));
        result.getReturnData().put("link_info", linkInfo);

        result.getReturnData().put("errors", errors);

        return result;
    }

}
