package jp.ill.photon.module.output;

import java.util.LinkedHashMap;
import java.util.Map;

import jp.ill.photon.annotation.ModuleVersion;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;

@ModuleVersion("1.0.0")
public class HTMLActionEditPageOutputModule extends HTMLGeneralEditPageOutputModule implements PhotonModule {

    @Override
    public ModuleResult execute( ModuleContext context ) {

        ModuleResult result =  super.execute(context);

        // アクションパラメータ編集
        result.getReturnData().put("action_params_list", getActionParamList());
        // 出力モジュールパラメータ編集
        result.getReturnData().put("output_params_list", getModuleParamList());
        // モジュールパラメータ編集
        result.getReturnData().put("module_params_list", getModuleParamList());
        // 処理後イベント編集
        result.getReturnData().put("after_events_list", getResultTypeList());
        // 処理後イベント返却値編集
        result.getReturnData().put("return_vals_list", getModuleParamList());

        return result;
    }

    /**
     * アクションパラメータタイプリスト取得.
     *
     * @return アクションパラメータタイプリスト
     *
     * */
    private Map<String, String> getActionParamList() {
        return new LinkedHashMap<String, String>(){{
            put("form", "ユーザーリクエストから取得する");
            put("static", "固定値を設定する(未実装)");
        }};
    }

    /**
     * パラメータタイプリスト取得.
     *
     * @return パラメータタイプリスト
     *
     * */
    private Map<String, String> getModuleParamList() {
        return new LinkedHashMap<String, String>(){{
            put("static", "固定値");
            put("param", "アクションパラメータ");
            put("dto", "DTOの値");
            put("static_json", "固定値JSON");
        }};
    }

    /**
     * 処理後イベント結果タイプリスト取得.
     *
     * @return 処理後イベント結果タイプリスト
     *
     * */
    private LinkedHashMap<String, String> getResultTypeList() {
        return new LinkedHashMap<String, String>(){{
            put("continue", "次のモジュールの処理に進む");
            put("break", "以降のモジュールを実行せず、出力モジュール処理に進む");
            put("redirect", "リダイレクト");
            put("forward", "フォワード");
        }};
    }

 }
