package jp.ill.photon.module.output;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.file.Path;
import java.nio.file.Paths;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.annotation.ModuleVersion;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.StringUtil;

@ModuleVersion("1.0.0")
public class FileDownloadModule implements PhotonModule {

	@ModuleParam(required = false)
	private String fileDirPath;

	@ModuleParam(required = true)
	private String filePath;

	@ModuleParam(required = false)
	private byte[] file;

	@ModuleParam(required = false)
	private String downloadFileName;

	@Override
	public ModuleResult execute(ModuleContext context)
			throws PhotonModuleException {
		ModuleResult result = new ModuleResult();

		String dirPath = getFileDirPath();
		if (dirPath == null || dirPath.isEmpty()) {
			dirPath = "";
		}

		Path absolutePath = Paths.get(dirPath, getFilePath());

		FileInputStream fis = null;
		String encodedFileName = "";
		String downloadFileName = getDownloadFileName();

		try {
			if (StringUtil.defaultString(downloadFileName, "") == "") {
				encodedFileName = URLEncoder
						.encode(absolutePath.getFileName().toString(), "UTF-8")
						.replace("+", "%20");
			} else {
				encodedFileName = URLEncoder.encode(downloadFileName, "UTF-8")
						.replace("+", "%20");
			}

			if (file == null) {
				ByteArrayOutputStream bos = new ByteArrayOutputStream();

				fis = new FileInputStream(absolutePath.toFile());
				byte[] buf = new byte[512];
				int len;
				while ((len = fis.read(buf)) != -1) {
					bos.write(buf, 0, len);
				}
				bos.flush();
				file = bos.toByteArray();
			}

			result.getReturnData().put("input_stream",
					new ByteArrayInputStream(file));
			result.getReturnData().put("content_length", file.length);
			result.getReturnData().put("content_disposition",
					"attachment; filename=" + encodedFileName
							+ "; filename*=UTF-8''" + encodedFileName);
			result.getReturnData().put("content_type",
					"application/octet-stream; charset=UTF-8");
		} catch (FileNotFoundException ex) {
			throw new PhotonModuleException("File not found.", ex);
		} catch (IOException ex) {
			throw new PhotonModuleException("File io error.", ex);
		} finally {
			try {
				if (fis != null) {
					fis.close();
				}
			} catch (Exception ex) {
			}
		}

		return result;
	}

	public String getFilePath() {
		return filePath;
	}

	public void setFilePath(String filePath) {
		this.filePath = filePath;
	}

	public String getFileDirPath() {
		return fileDirPath;
	}

	public void setFileDirPath(String fileDirPath) {
		this.fileDirPath = fileDirPath;
	}

	public byte[] getFile() {
		return file;
	}

	public void setFile(byte[] file) {
		this.file = file;
	}

	public String getDownloadFileName() {
		return downloadFileName;
	}

	public void setDownloadFileName(String downloadFileName) {
		this.downloadFileName = downloadFileName;
	}

}
