package jp.ill.photon.module.order;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import javax.servlet.http.HttpSession;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.seasar.doma.jdbc.tx.TransactionManager;

import jp.co.smbcfs.station.sdk.dto.KyotsuKessaiTsudoRequest;
import jp.co.smbcfs.station.sdk.dto.KyotsuKessaiTsudoResult;
import jp.co.smbcfs.station.sdk.service.Transaction;
import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.dao.DomaConfig;
import jp.ill.photon.dao.JsonDataDao;
import jp.ill.photon.dao.JsonDataDaoImpl;
import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.message.ActionDtoMessage;
import jp.ill.photon.model.AoSetting;
import jp.ill.photon.model.CartItem;
import jp.ill.photon.model.CharacterConst;
import jp.ill.photon.model.CreditInput;
import jp.ill.photon.model.Delivery;
import jp.ill.photon.model.Item;
import jp.ill.photon.model.Money;
import jp.ill.photon.model.Order;
import jp.ill.photon.model.OrderSummary;
import jp.ill.photon.model.SmbcOrder;
import jp.ill.photon.model.SmbcPayment;
import jp.ill.photon.model.SmbcPayment.ApiLink;
import jp.ill.photon.model.TmpOrder;
import jp.ill.photon.model.TmpOrderDetail;
import jp.ill.photon.model.User;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.CheckUtil;
import jp.ill.photon.util.CryptUtil;
import jp.ill.photon.util.DateUtil;
import jp.ill.photon.util.EditTableUtil;
import jp.ill.photon.util.JsonUtil;
import jp.ill.photon.util.LogUtil;
import jp.ill.photon.util.ParamUtil;
import jp.ill.photon.util.StringUtil;
import jp.ill.photon.util.UtilTools;

public class SmbcConnectPreModule implements PhotonModule {

    @ModuleParam(required = true, paramGroup=true)
    private Order order = new Order();

    @ModuleParam(required = true, paramGroup=true)
    private Delivery delivery = new Delivery();

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "got_session.userForm.user_cd")
    private String userCd;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "got_session_charge.userChargeForm.user_charge_id")
    private int userChargeId;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "common.aladdinsetting")
    private AoSetting aoSetting;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "cart.list")
    private List<Map<String, Object>> detailList;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "tax.total_tax_price")
    private String totalTaxPrice;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.smbcApiUserCdDigit.note")
    private int smbcApiUserCdDigit;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.userNameKanaDefValue.note")
    private String userNameKanaDefValue;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.itemNameKanaDefValue.note")
    private String itemNameKanaDefValue;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.connectSmbcApi.note")
    private String smbcConnectApi;

    @ModuleParam(required=false)
    @DefaultParamSetting(transferType = "static", transferVal = "aec_credit_input")
    private String sessionKeyCreditInput = "aec_credit_input";

    @ModuleParam(required = false)
    @DefaultParamSetting(transferType = "dto", transferVal = "tax.delivery_fee")
    private Map<String, Object> deliveryFee;

    @ModuleParam(required = false)
    @DefaultParamSetting(transferType = "dto", transferVal = "tax.total_tax_price_for_sum")
    private String totalTaxPriceForSum;

    @ModuleParam(required = false)
    @DefaultParamSetting(transferType = "dto", transferVal = "tax.charge_fee")
    private Map<String, Object> chargeFee;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "user.first")
    private Map<String, Object> userForm;

    @ModuleParam(required = false)
    private List<Map<String, Object>> orderExtSettingMapList;

    @ModuleParam(required = false)
    private List<Map<String, Object>> orderDetailExtSettingMapList;

    @ModuleParam(required = false)
    private Map<String, Object> orderExtValueMap;

    @ModuleParam(required = false)
    private List<Map<String, Object>> orderDetailExtValueMapList;

    @ModuleParam(required = false)
	@DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.webOrderCampaignItemCd.note")
	private String webOrderCampaignCd;

    public String getWebOrderCampaignCd() {
		return webOrderCampaignCd;
	}

	public void setWebOrderCampaignCd(String webOrderCampaignCd) {
		this.webOrderCampaignCd = webOrderCampaignCd;
	}

	/** メッセージID（SMBC通信結果エラー） */
    public static final String CART_ERROR_MSG_ID = "smbcApiErrMes";

    ActionDto dto;

    public Map<String, Object> getUserForm() {
        return userForm;
    }

    public void setUserForm(Map<String, Object> userForm) {
        this.userForm = userForm;
    }

    public Map<String, Object> getChargeFee() {
        return chargeFee;
    }

    public void setChargeFee(Map<String, Object> chargeFee) {
        this.chargeFee = chargeFee;
    }

    public String getTotalTaxPriceForSum() {
        return totalTaxPriceForSum;
    }

    public void setTotalTaxPriceForSum(String totalTaxPriceForSum) {
        this.totalTaxPriceForSum = totalTaxPriceForSum;
    }

    public Map<String, Object> getDeliveryFee() {
        return deliveryFee;
    }

    public void setDeliveryFee(Map<String, Object> deliveryFee) {
        this.deliveryFee = deliveryFee;
    }

    public String getSessionKeyCreditInput() {
        return sessionKeyCreditInput;
    }

    public void setSessionKeyCreditInput(String sessionKeyCreditInput) {
        this.sessionKeyCreditInput = sessionKeyCreditInput;
    }

    public Delivery getDelivery() {
        return delivery;
    }

    public void setDelivery(Delivery delivery) {
        this.delivery = delivery;
    }

    public String getSmbcConnectApi() {
        return smbcConnectApi;
    }

    public void setSmbcConnectApi(String smbcConnectApi) {
        this.smbcConnectApi = smbcConnectApi;
    }

    public String getUserNameKanaDefValue() {
        return userNameKanaDefValue;
    }

    public void setUserNameKanaDefValue(String userNameKanaDefValue) {
        this.userNameKanaDefValue = userNameKanaDefValue;
    }

    public String getItemNameKanaDefValue() {
        return itemNameKanaDefValue;
    }

    public void setItemNameKanaDefValue(String itemNameKanaDefValue) {
        this.itemNameKanaDefValue = itemNameKanaDefValue;
    }

    public int getSmbcApiUserCdDigit() {
        return smbcApiUserCdDigit;
    }

    public void setSmbcApiUserCdDigit(int smbcApiUserCdDigit) {
        this.smbcApiUserCdDigit = smbcApiUserCdDigit;
    }

    public Order getOrder() {
        return order;
    }

    public void setOrder(Order order) {
        this.order = order;
    }

    public String getUserCd() {
        return userCd;
    }

    public void setUserCd(String userCd) {
        this.userCd = userCd;
    }

    public AoSetting getAoSetting() {
        return aoSetting;
    }

    public void setAoSetting(AoSetting aoSetting) {
        this.aoSetting = aoSetting;
    }

    public List<Map<String, Object>> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<Map<String, Object>> detailList) {
        this.detailList = detailList;
    }

    public String getTotalTaxPrice() {
        return totalTaxPrice;
    }

    public void setTotalTaxPrice(String totalTaxPrice) {
        this.totalTaxPrice = totalTaxPrice;
    }

    public int getUserChargeId() {
        return userChargeId;
    }

    public void setUserChargeId(int userChargeId) {
        this.userChargeId = userChargeId;
    }

    public List<Map<String, Object>> getOrderExtSettingMapList() {
        return orderExtSettingMapList;
    }

    public void setOrderExtSettingMapList(List<Map<String, Object>> orderExtSettingMapList) {
        this.orderExtSettingMapList = orderExtSettingMapList;
    }

    public List<Map<String, Object>> getOrderDetailExtSettingMapList() {
        return orderDetailExtSettingMapList;
    }

    public void setOrderDetailExtSettingMapList(List<Map<String, Object>> orderDetailExtSettingMapList) {
        this.orderDetailExtSettingMapList = orderDetailExtSettingMapList;
    }

    public Map<String, Object> getOrderExtValueMap() {
        return orderExtValueMap;
    }

    public void setOrderExtValueMap(Map<String, Object> orderExtValueMap) {
        this.orderExtValueMap = orderExtValueMap;
    }

    public List<Map<String, Object>> getOrderDetailExtValueMapList() {
        return orderDetailExtValueMapList;
    }

    public void setOrderDetailExtValueMapList(List<Map<String, Object>> orderDetailExtValueMapList) {
        this.orderDetailExtValueMapList = orderDetailExtValueMapList;
    }


    public ModuleResult execute(ModuleContext context) throws PhotonModuleException {
        ModuleResult moduleResult = new ModuleResult();

        dto = context.getDto();

        if (order.isConvenienceSelected() || order.isCreditSelected()) {

            // クレジットの場合は、クレジットカード入力情報をセッションから復元
            if (order.isCreditSelected()) {
                HttpSession session = context.getDto().getSession();
                CreditInput creInput = (CreditInput)session.getAttribute(sessionKeyCreditInput + "-" + context.getDto().getTenantId() + "-" + context.getDto().getAppId());
                order.setCreditNumber(creInput.getNumber());
                order.setCreditLimitMonth(creInput.getLimitMonth());
                order.setCreditLimitYear(creInput.getLimitYear());
                order.setCreditSecurityCd(creInput.getSecurityCd());
                session.removeAttribute(sessionKeyCreditInput + "-" + context.getDto().getTenantId() + "-" + context.getDto().getAppId());
            }

            TransactionManager tm = DomaConfig.singleton().getTransactionManager();
            JsonDataDao dao = new JsonDataDaoImpl();

            User user = User.getUser(context.getDto(), userCd);

            //List<CartItem> cartItems = new ArrayList<CartItem>();
            Map<String, Item> items = new HashMap<String, Item>();

            // TODO: 関数化したい Start
            int calcSumresult = tm.required(() -> {
                // パラメータから来たカート情報をマップにセットしておく
//                Map<String, CartItem> paramCartMap = new HashMap<String, CartItem>();
//                for (Map<String, Object> paramCart : detailList) {
//                    CartItem item = CartItem.valueOf(paramCart);
//                    paramCartMap.put(item.getCartId().toString(), item);
//                }

                // 合計金額を計算する
                OrderSummary summary = new OrderSummary();

                for (int i = 0; i < detailList.size(); i++) {
                    //String cartId = order.getCartId()[i];
                    //CartItem cart = paramCartMap.get(cartId);
                    Map<String, Object> detailMap = detailList.get(i);
                    summary.sumOrderDetail(context, dao, detailMap, userCd, aoSetting, items, userForm, String.valueOf(detailMap.get("item_cd")).equals(webOrderCampaignCd));
                }

                // 配送料
                if (deliveryFee != null) {
                    summary.sumOrderDetail(context, dao, deliveryFee, userCd, aoSetting, items, userForm, true);
                }

                // 手数料
                if (chargeFee != null) {
                    summary.sumOrderDetail(context, dao, chargeFee, userCd, aoSetting, items, userForm, true);
                }

                // 消費税
                if (totalTaxPrice != null) {
                    order.setTaxPrice(new BigDecimal(totalTaxPrice));
                }

                order.setWholesalePrice(new BigDecimal(summary.getSumWholesalePrice()));
                order.setRetailPrice(new BigDecimal(summary.getSumRetailPrice()));

                order.setTotalOrderQuantity(CartItem.getOrderQuantityFormat(new BigDecimal(summary.getTotalQuantity()), aoSetting) );
                order.setTotalShipmentQuantity(CartItem.getOrderQuantityFormat(new BigDecimal(0.0), aoSetting));
                order.setTotalUnshippedQuantity(CartItem.getOrderQuantityFormat(new BigDecimal(summary.getTotalQuantity()), aoSetting) );

                return 0;
            });
            // TODO: 関数化したい End

            String shopOrderNo = tm.required(() -> {
                // ShopOrderNoの採番と採番テーブルの更新
                List<Map<String, Object>> seqMap = dao.getSeqSfNextVal(context.getDto().getTenantId(), "shoporder", "shoporder_no");
                if (seqMap == null || seqMap.isEmpty()) {
                    return null;
                }
//                Integer orderNoRow = Integer.valueOf(String.valueOf(seqMap.get(0).get("seq")));
//                String orderNo = String.format("%017d", orderNoRow);
                BigDecimal bdVal = new BigDecimal( (String) seqMap.get(0).get("seq") );
                String orderNo = StringUtils.leftPad(bdVal.toString(), 17, "0");

                return orderNo;
            });

            SmbcPayment smbcPayment = tm.required(() -> {
                List<Map<String, Object>> smbcMap = dao.getSmbcPayment(context.getDto().getTenantId(), order.getPaymentCd());
                if (smbcMap == null || smbcMap.isEmpty()) {
                    return null;
                }
                else {
                    return SmbcPayment.valueOf(smbcMap.get(0));
                }
            });

            // ログ出力
            LogUtil.getInstance().info("API通信(共通決済都度)開始");

            KyotsuKessaiTsudoRequest request = this.makeKyotsuKessaiTsudoRequestForm(shopOrderNo, user, order,
                    smbcPayment, items);

            SmbcOrder smbcOrder = new SmbcOrder();
            List<ActionDtoMessage> apiErrors = null;
            if (order.isConvenienceSelected()) {

                // コンビニ
                apiErrors = this.doConvenienceLink(request, order.getConveniencePaymentCd(), smbcOrder);

            } else {

                // クレジット
                apiErrors = this.doCreditLink(request, smbcOrder);

            }

            if (!apiErrors.isEmpty()) {
                // エラーメッセージを設定
                moduleResult.setResultCode("error");
                moduleResult.getMessages().put("error_page", apiErrors);
                return moduleResult;
            }

            LogUtil.getInstance().info("API通信正常終了");

            LogUtil.getInstance().info(
                    String.format("請求番号:%s", smbcOrder.getShoporderNo()));

            // コンビニ、クレジット決済(非3Dセキュア)のときには、完了画面に遷移
            if (order.isConvenienceSelected()
                    || (order.isCreditSelected() && !smbcOrder.isSecure3d())) {

                moduleResult.getReturnData().put("shop_order_no", smbcOrder.getShoporderNo());
                moduleResult.getReturnData().put("payout_no1_name", smbcOrder.getPayoutNo1Name());
                moduleResult.getReturnData().put("payout_no1_value", smbcOrder.getPayoutNo1Value());
                moduleResult.getReturnData().put("payout_no2_name", smbcOrder.getPayoutNo2Name());
                moduleResult.getReturnData().put("payout_no2_value", smbcOrder.getPayoutNo2Value());
                moduleResult.getReturnData().put("payout_no3_name", smbcOrder.getPayoutNo3Name());
                moduleResult.getReturnData().put("payout_no3_value", smbcOrder.getPayoutNo3Value());

                moduleResult.setResultCode("cart_con");
                return moduleResult;
            } else {
                // 一時テーブルに注文情報を登録
                String tmpOrderNo = insertTmpOrderData(context, user, items);

                if (tmpOrderNo == null) {
                    // TODO エラー処理
                }

                String tmp_url = getAbsContextPath();

                moduleResult.getReturnData().put("md", smbcOrder.getShoporderNo());
                moduleResult.getReturnData().put("pa_req", smbcOrder.getPaReq());
                moduleResult.getReturnData().put("secure_acs_srv_url", smbcOrder.getSecureAcsSrvUrl());

                moduleResult.getReturnData().put("url_head", tmp_url);
                moduleResult.getReturnData().put("session_id", smbcOrder.getSessionId());

                // 一時テーブルに載せていない引き継ぐパラメータをセット
                moduleResult.getReturnData().put("selected_payment_cd", order.getPaymentCd());
                moduleResult.getReturnData().put("tmp_order_no", tmpOrderNo);


                moduleResult.getReturnData().put("shop_order_no", smbcOrder.getShoporderNo());
                moduleResult.getReturnData().put("payout_no1_name", smbcOrder.getPayoutNo1Name());
                moduleResult.getReturnData().put("payout_no1_value", smbcOrder.getPayoutNo1Value());
                moduleResult.getReturnData().put("payout_no2_name", smbcOrder.getPayoutNo2Name());
                moduleResult.getReturnData().put("payout_no2_value", smbcOrder.getPayoutNo2Value());
                moduleResult.getReturnData().put("payout_no3_name", smbcOrder.getPayoutNo3Name());
                moduleResult.getReturnData().put("payout_no3_value", smbcOrder.getPayoutNo3Value());

                moduleResult.setResultCode("cart_wait");
                return moduleResult;
            }

        } else {
            // コンビニとクレジット以外の時は何もしない
            moduleResult.setResultCode("cart_con");
            return moduleResult;
        }
    }

    /***************************************
     * 絶対ContextPath取得処理 http://aaa.com/bbb/ccc から "http://aaa.com/bbb"を取る。
     *
     * @return String
     ***************************************/
    public String getAbsContextPath() {

        String servletPath = ServletActionContext.getRequest().getServletPath();
        String absURL = ServletActionContext.getRequest().getRequestURL().toString();

        return absURL.substring(0, absURL.indexOf(servletPath));
    }

    /***************************************
     * 相対ContextPath取得処理 http://aaa.com/bbb/ccc から "/bbb"を取る。
     *
     * @return String
     ***************************************/
    public String getRelContextPath() {

        return ServletActionContext.getRequest().getContextPath();
    }

    private String insertTmpOrderData(ModuleContext context, User user, Map<String, Item> items) {
        TransactionManager tm = DomaConfig.singleton().getTransactionManager();
        JsonDataDao dao = new JsonDataDaoImpl();

        String tmpOrderNoResult = tm.required(() -> {

            List<Map<String, Object>> seqMap = dao.getSeqSfNextVal(context.getDto().getTenantId(), "tmporder", "tmp_order_no");
            if (seqMap == null || seqMap.isEmpty()) {
                return null;
            }
            Integer orderNoRow = Integer.valueOf(String.valueOf(seqMap.get(0).get("seq")));
            String tmpOrderNo = String.format("%017d", orderNoRow);

            TmpOrder tmpOrder = new TmpOrder(tmpOrderNo, order, user, delivery);
            tmpOrder.setTmpOrderNo(tmpOrderNo);

            // TODO 移植必要？：表示設定が有効のときのみ、登録処理を行う
//            if (WishingShipmentDateDispFlg.YES.equals(common
//                    .get(SystemSettingId.WISHING_SHIPMENT_DATE_DISP_FLG))) {
//                if (!CheckUtil.isEmpty(order.getWishingShipmentDate())) {
//                    Calendar wishingShipmentCal = DateUtil.toCalendar(order
//                            .getWishingShipmentDate());
//                    tmpOrder.setWishingShipmentDate(new Date(wishingShipmentCal
//                            .getTimeInMillis()));
//                }
//            }

            // 一時テーブル見出し登録
            try {
                dao.insertEditTableData(context.getDto().getTenantId(), "tmporder", user.getUserCd(), JsonUtil.mapToJsonSnakeCaseKey(tmpOrder));
                // TODO: ■■見出拡張項目データ(t_bt_tmp_order_ext)を登録
                insertOrderExt(context.getDto().getTenantId(), user.getUserCd(), tmpOrderNo, dao);
            } catch (Exception ex) {
            }

            Integer recordNo = 1;
            for (Map<String, Object> paramDetail : detailList) {
                Item item = items.get(paramDetail.get("item_cd"));
                TmpOrderDetail tmpOrderDetail = new TmpOrderDetail(tmpOrderNo, recordNo, paramDetail, item, user);

                // 一時テーブル明細登録
                try {
                    dao.insertEditTableData(
                            context.getDto().getTenantId(),
                            "tmporderdetail",
                            user.getUserCd(),
                            JsonUtil.mapToJsonSnakeCaseKey(tmpOrderDetail));
                    // TODO: ■■見出拡張項目データ(t_bt_tmp_order_detail_ext)を登録
                    insertOrderDetailExt(context.getDto().getTenantId(), user.getUserCd(), tmpOrderNo, recordNo, dao);
                } catch (Exception ex) {
                }
                recordNo++;
            }

            return tmpOrderNo;
        });

        return tmpOrderNoResult;
    }

    /**
     * クレジット通信.
     *
     * @param request リクエストフォーム
     * @param retForm 戻りデータ格納フォーム
     * @return エラーメッセージ
     *
     * @throws Exception
     */
    private List<ActionDtoMessage> doCreditLink(  KyotsuKessaiTsudoRequest request, SmbcOrder retForm) {

        LogUtil log = LogUtil.getInstance();
        List<ActionDtoMessage> errorMessages = new ArrayList<ActionDtoMessage>();

        // 接続
        Transaction t = getSmbcConnection(smbcConnectApi);

        // 通信
        KyotsuKessaiTsudoResult result = t.send(request);
        // "000000"か"000100"のときは正常終了
        if (ApiLink.Result.SUCCESS.equals(result.getRescd())
                || ApiLink.Result.SUCCESS_3D.equals(result.getRescd())) {

            // 正常終了
            retForm.setShoporderNo(request.getShoporder_no());
            retForm.setPaReq(result.getPareq());
            retForm.setSecureAcsSrvUrl(result.getIssuer_url());
            retForm.setSessionId(result.getSessionid());
            retForm.setSecure3d(ApiLink.Result.SUCCESS_3D.equals(result
                    .getRescd()));
        } else {

            // 異常終了
            String errMsg = String.format("[%s]%s", result.getRescd(), result.getRes());
            // ログ出力
            log.error("API通信異常終了");
            log.error(errMsg + "\n");
            Map<String, Object> params = new HashMap<>();
            Map<String, Object> mp = new HashMap<>();
            mp.put("type", "static");
            mp.put("val", errMsg);
            params.put("%1$s", mp);
            ActionDtoMessage msg = new ActionDtoMessage();
            msg.setMessageId(CART_ERROR_MSG_ID);
            msg.setParams(params);
            errorMessages.add(msg);
        }

        retForm.setShoporderNo(result.getShoporder_no());
        retForm.setPaReq(result.getPareq());
        retForm.setSecureAcsSrvUrl(result.getIssuer_url());
        retForm.setSessionId(result.getSessionid());

        return errorMessages;
    }

    /**
     * コンビニ通信.
     *
     * @param request リクエストフォーム
     * @param retForm 戻りデータ格納フォーム
     * @return エラーメッセージ
     *
     * @throws Exception
     */
    private List<ActionDtoMessage> doConvenienceLink( KyotsuKessaiTsudoRequest request,
                                            String conveniencePaymentCd,
                                            SmbcOrder retForm) {
        LogUtil log = LogUtil.getInstance();
        List<ActionDtoMessage> errorMessages = new ArrayList<ActionDtoMessage>();

        // 接続
        Transaction t = getSmbcConnection(smbcConnectApi);
        // 通信
        KyotsuKessaiTsudoResult result = t.send(request);
        if (ApiLink.Result.SUCCESS.equals(result.getRescd())) {

            // 正常終了
            // 請求No、払い出しNo1～3を
            String[] payoutName = ApiLink.PaymentMethodCd.PAYOUT_NAME_MAP
                    .get(conveniencePaymentCd);
            retForm.setShoporderNo(request.getShoporder_no());
            retForm.setPayoutNo1Name(payoutName[0]);
            retForm.setPayoutNo1Value(result.getHaraidashi_no1());
            retForm.setPayoutNo2Name(payoutName[1]);
            retForm.setPayoutNo2Value(result.getHaraidashi_no2());
            retForm.setPayoutNo3Name(payoutName[2]);
            retForm.setPayoutNo3Value(result.getHaraidashi_no3());

        } else {

            // 異常終了
            String errMsg = String.format("[%s]%s", result.getRescd(),
                    result.getRes());
            // ログ出力
            log.error("API通信異常終了");
            log.error(errMsg + "\n");
            Map<String, Object> params = new HashMap<>();
            Map<String, Object> mp = new HashMap<>();
            mp.put("type", "static");
            mp.put("val", errMsg);
            params.put("%1$s", mp);
            ActionDtoMessage msg = new ActionDtoMessage();
            msg.setMessageId(CART_ERROR_MSG_ID);
            msg.setParams(params);
            errorMessages.add(msg);
        }

        return errorMessages;
    }

    public static Transaction getSmbcConnection(String smbcConnectApi) {

        // システム設定"connectSmbcApi"の値が"1"であれば本番
        // データが存在しない、しても1以外だったらテスト環境に接続

        if (SmbcPayment.ApiLink.ConnectSmbcApi.PERFORMANCE
                .equals(smbcConnectApi)) {
            return Transaction.getInstance();
        }
        return Transaction.getTestInstance();

    }

    private KyotsuKessaiTsudoRequest makeKyotsuKessaiTsudoRequestForm( String shoporderNo,
            User user, Order order, SmbcPayment smbcPayment, Map<String, Item> items) {

        KyotsuKessaiTsudoRequest request = new KyotsuKessaiTsudoRequest();
        String roundingDivPrice =StringUtil.defaultString(userForm.get("price_fraction_div"), "0");

        // 整形済みの各項目
        // 得意先コード(0埋め)
        // 指定桁数まで0埋め
        String userCdFormatted = StringUtil.zeroPadding(user.getUserCd(),
                smbcApiUserCdDigit);

        // 処理日時
        Calendar today = Calendar.getInstance();

        // 支払期限日数
        int limitDay = smbcPayment.getPaymentLimitDay();
        Calendar shiharaiDate = DateUtil.plusDay(DateUtil.getCalendar(), limitDay);

        // YYMMDDフォーマット
        SimpleDateFormat sdf = new SimpleDateFormat(SmbcPayment.ApiLink.DateTimeFormat.FORMAT_YYMMDD);

        // バージョン
        // (半角英数・3バイト)
        request.setVersion(ApiLink.Version.PC_SITE_ALL);

        // 決済手段区分
        // (半角数字・2バイト)
        request.setBill_method(ApiLink.AccountWay.ACCOUNT_WAY_MAP.get(order.getPaymentCd()));

        // 決済種類コード
        // (半角数字・2バイト)
        // コンビニ : セブンイレブン : 0301
        // 　　　　　 ローソン・ミニストップ : 0302
        // 　　　　　 セイコーマート : 0303
        // 　　　　　 ファミリーマート : 0304
        // 　　　　　 サークルK・サンクス : 0305
        // クレジット : "0501"
        if (order.isConvenienceSelected()) {
            request.setKessai_id(ApiLink.PaymentMethodCd.PAYMENT_METHOD_CD_MAP
                    .get(order.getConveniencePaymentCd()));
        } else {
            request.setKessai_id(ApiLink.PaymentWay.CREDIT);
        }

        // 契約コード
        // (半角英数・7バイト)
        request.setShop_cd(smbcPayment.getShopCd());
        // 収納企業コード
        // (半角英数・8バイト)
        request.setSyuno_co_cd(smbcPayment.getReceiptCoCd());
        // 拠点コード
        // (半角英数・8バイト)
        //request.setKyoten_cd(smbcPayment.getBaseCd());
        // ショップパスワード
        // (半角英数・20バイト)

        String shopPw = CryptUtil
                .getBase64DecodedStr(smbcPayment.getShopPassword());
        request.setShop_pwd(shopPw);

        // 請求番号
        // (半角数字・17バイト)
        request.setShoporder_no(shoporderNo);

        // 請求金額
        // (半角数字・13バイト)
        request.setSeikyuu_kingaku(this.getRoundedValue(order.getTaxWholesalePrice(String.valueOf(totalTaxPriceForSum)).toString(),
                Money.Fraction.FRACTION_MAP.get(roundingDivPrice)));

        // 内消費税
        // (半角数字・13バイト)
        // 請求金額と同じ端数処理区分を用いている
        request.setShouhi_tax(this.getRoundedValue(order.getTaxPrice().toString(),
                Money.Fraction.FRACTION_MAP.get(String.valueOf(user.getTaxFractionDiv()))));

        // 内送料
        // (半角数字・13バイト)
        request.setSouryou("");
        // 顧客番号
        // (半角英数・12 or 14バイト)
        request.setBill_no(userCdFormatted);

        // 顧客名
        // (全角・60バイト)
        String bill_name = StringUtil.lengthSplitBytes(
                StringUtil.toZenkaku(StringUtil.defaultString(
                        user.getUserName1(), "")
                        + StringUtil.defaultString(user.getUserName2(), "")),
                ApiLink.Length.USER_NAME, jp.ill.photon.model.CharacterConst.CharacterCd.SJIS)[0];
        request.setBill_name(bill_name);

        // 顧客カナ名
        // (半角・60バイト)
        String billKana = user.getUserNameKana();
        // 空白、または、得意先カナに半角カナ以外の文字が入っていた場合は、システム設定から取得する。
        if (CheckUtil.isEmpty(billKana) || !CheckUtil.isHalfKanaOnly(billKana)) {
            billKana = userNameKanaDefValue;
        }
        String bill_kana = StringUtil.lengthSplitBytes(billKana,
                ApiLink.Length.USER_KANA, CharacterConst.CharacterCd.SJIS)[0];

        request.setBill_kana(bill_kana);

        // 顧客郵便番号
        // (半角数字 or 記号・8バイト)

        if (CheckUtil.isSmbcZipFormatCheck(user.getZip())) {
            request.setBill_zip(user.getZip());
        }

        // 顧客住所１
        // (半角 or 全角・50バイト)
        String bill_adr_1 = StringUtil.lengthSplitBytes(user.getCityName1(),
                ApiLink.Length.USER_CITY_1, CharacterConst.CharacterCd.SJIS)[0];
        request.setBill_adr_1(bill_adr_1);
        // 顧客住所２
        // (半角 or 全角・50バイト)
        String bill_adr_2 = StringUtil.lengthSplitBytes(user.getCityName2(),
                ApiLink.Length.USER_CITY_2, CharacterConst.CharacterCd.SJIS)[0];
        request.setBill_adr_2(bill_adr_2);
        // 顧客住所３
        // (半角 or 全角・50バイト)
        String bill_adr_3 = StringUtil.lengthSplitBytes(user.getCityName3(),
                ApiLink.Length.USER_CITY_3, CharacterConst.CharacterCd.SJIS)[0];
        request.setBill_adr_3(bill_adr_3);
        // 顧客住所４
        // (半角 or 全角・50バイト)
        request.setBill_adr_4("");
        // 顧客住所５
        // (半角 or 全角・50バイト)
        request.setBill_adr_5("");
        // 顧客電話番号
        // (半角数字 or 記号・14バイト)
        request.setBill_phon(user.getTel());

        if (!CheckUtil.isEmpty(user.getMail())) {
            // 顧客メールアドレス
            // (半角英数 or 記号・256バイト)
            request.setBill_mail(user.getMail());
            // 顧客メールアドレス区分
            // (半角数字・1バイト)
            request.setBill_mail_kbn(ApiLink.CustomerMailAddressDiv.PC);
        }

        // メッセージ１
        // (半角 or 全角・256バイト)
        request.setMsg_1("");
        // メッセージ２
        // (半角 or 全角・256バイト)
        request.setMsg_2("");
        // 成約日
        // (半角数字・8バイト)
        request.setSeiyaku_date(sdf.format(today.getTime()));
        // 支払期限日
        // (半角数字・8バイト)

        if (shiharaiDate != null) {
            request.setShiharai_date(sdf.format(shiharaiDate.getTime()));
        }

        // 支払期限時分
        // (半角数字・4バイト)
        request.setShiharai_time("");

        // カートの内容
        String firstItemName = "";
        String firstItemNameKana = "";
        String subTotal = "";
        String sumWholesalePrice = "0";
        String sumQuantity = "0";

        for (int i = 0; i < detailList.size(); i++) {
            // キャンペーン明細かどうかで分岐
            Map<String, Object> detailMap = detailList.get(i);

            if (i == 0) {
                // 商品1の商品名 : 明細情報の1行目の商品名1 + 2 + " " + 明細情報の1行目の商品の数量 + "点"
                // 商品1の単価 : 明細情報の1行目の商品の(単価 * 数量)
                // 商品1の数量 : 固定値:1

                Item item = items.get(detailMap.get("item_cd"));
                firstItemNameKana = item.getItemNameKana();

                firstItemName = StringUtil
                        .defaultString(item.getItemName1(), "")
                        + StringUtil.defaultString(item.getItemName2(), "");

                // 商品数
                String goodsName1 = String.format("%s %s点", firstItemName, this
                        .getRoundedValue(String.valueOf(detailMap.get("order_quantity")),
                                BigDecimal.ROUND_DOWN));

                // 商品１の商品名
                // (半角 or 全角・100バイト)
                request.setGoods_name_1(goodsName1);

                // 商品１の単価
                // (半角数字・11バイト)

                request.setUnit_price_1(UtilTools.multiplyBigDecimal(String.valueOf(detailMap.get("wholesale_price")),
                        String.valueOf(detailMap.get("order_quantity")), true));

                // 商品１の数量
                // (半角数字・3バイト)
                request.setQuantity_1("1");
            } else {

                // 商品2から20までは、数量、金額のトータルを算出し、
                // 商品2の明細にセットする
                String orderQuantity = StringUtil.defaultString(
                        String.valueOf(detailMap.get("order_quantity")), "0");

                // 1明細当たりの小計を算出
                // (数量 * 単価)
                subTotal = CartItem.getSubTotalPriceFormat(aoSetting, detailMap, userForm).toString();

                // 小計を合計金額へ加算
                sumWholesalePrice = UtilTools.addBigDecimal(sumWholesalePrice,
                        subTotal.replace(",", ""));

                // 数量を加算
                sumQuantity = UtilTools.addBigDecimal(sumQuantity,
                        orderQuantity.replace(",", ""));
            }
        }

        if (detailList.size() > 1) {
            // 商品2の商品名 : 固定値:"その他 " + 明細情報の2行目以降のすべての商品の数量 + "点"
            // 商品2の単価 : 明細情報の2行目以降のすべての商品の(単価 * 数量)の合計
            // 商品2の数量 : 固定値:1

            // 商品２の商品名
            // (半角 or 全角・100バイト)
            request.setGoods_name_2("その他 " + sumQuantity + "点");

            // 商品２の単価
            // (半角数字・11バイト)
            request.setUnit_price_2(sumWholesalePrice);

            // 商品２の数量
            // (半角数字・3バイト)
            request.setQuantity_2("1");
        }

     // 請求内容（漢字）
        // (全角・100バイト)
        String billkanji = StringUtil.lengthSplitBytes(
                StringUtil.toZenkaku(firstItemName), ApiLink.Length.USER_NAME,
                CharacterConst.CharacterCd.SJIS)[0];
        request.setSeikyuu_name(billkanji);
        // 請求内容（カナ）

        // 空白、または、商品カナに半角カナ以外の文字が入っていた場合は、システム設定から取得する。
        String seikyuuKana = StringUtil.defaultString(firstItemNameKana, "");
        if (CheckUtil.isEmpty(seikyuuKana)
                || !CheckUtil.isHalfKanaOnly(seikyuuKana)) {
            seikyuuKana = StringUtil.toZenkaku(itemNameKanaDefValue);
        }
        String seikyuu_Kana = StringUtil.lengthSplitBytes(
                StringUtil.toZenkaku(seikyuuKana), ApiLink.Length.USER_NAME,
                CharacterConst.CharacterCd.SJIS)[0];
        request.setSeikyuu_kana(seikyuu_Kana);

        // 利用年月
        // (半角数字・6バイト)
        request.setRiyou_nengetsu("");
        // 請求年月
        // (半角数字・6バイト)
        request.setSeikyuu_nengetsu("");

        // 督促区分
        // (半角数字・1バイト)
        request.setTokusoku_kbn("");
        // 通知書区分
        // (半角数字・1バイト)
        request.setTuuchisho_kbn("");

        // クレジットカード番号
        // (半角数字・16バイト)
        // コンビニ : 空白
        // クレジット : クレジットカード番号
        request.setCard_no(order.isConvenienceSelected() ? "" : order
                .getCreditNumber());

        // クレジットカード有効期限
        // (半角数字・4バイト)
        // コンビニ : 空白
        // クレジット : クレジットカード有効期限（年） + クレジットカード有効期限（月）
        String cart_yukokigen = "";
        if (order.isCreditSelected()) {
            cart_yukokigen = StringUtil.zeroPadding(
                    order.getCreditLimitMonth(), 2)
                    + StringUtil.zeroPadding(order.getCreditLimitYear(), 2);
        }
        request.setCard_yukokigen(cart_yukokigen);

        // クレジットカード支払区分
        // (半角数字・2バイト)
        // コンビニ : 空白
        // クレジット : 支払方法、支払回数から区分を取得
        String shiharai_kbn = "";
        if (order.isCreditSelected()) {
            if (order.isCreditPaymentMethodDivideRaw()) {
                // クレジット支払方法が"分割払い"だった時
                shiharai_kbn = ApiLink.CreditPayDiv.CREDIT_PAY_DIV_DEVIDED_MAP
                        .get(order.getCreditNumberOfPaymentCd());
            } else {
                shiharai_kbn = ApiLink.CreditPayDiv.CREDIT_PAY_DIV_NOT_DEVIDED_MAP
                        .get(order.getCreditPaymentMethodCd());
            }
        }
        request.setShiharai_kbn(shiharai_kbn);

        // 支払金融機関コード
        // (半角数字・4バイト)
        request.setShiharai_kinyukikan_cd("");
        // 発行区分
        // (半角数字・1バイト)
        request.setHakkou_kbn("");
        // 郵送先区分
        // (半角数字・1バイト)
        request.setYuusousaki_kbn("");

        // セキュリティコード
        // (半角数字・4バイト)
        // コンビニ : 空白
        // クレジット : セキュリティコード
        request.setSecurity_cd(order.isConvenienceSelected() ? "" : order
                .getCreditSecurityCd());

        return request;
    }

    /**
     * カンマ除去、端数処理を実施した後の文字列を取得.
     *
     * @param String
     * @retrun String
     *
     * */
    private String getRoundedValue(String val, int roundingMode) {
        BigDecimal bdVal = StringUtil.toBigDecimal(StringUtil.toNumString(val),
                BigDecimal.ZERO);
        bdVal = bdVal.setScale(0, roundingMode);
        return bdVal.toString();
    }

    /***
     *
     * 受注見出拡張項目登録
     *
     * @param tenantId
     * @param userName
     * @param tmpOrderNo
     * @param dao
     *
     */
    @SuppressWarnings("unchecked")
    private void insertOrderExt(String tenantId, String userName, String tmpOrderNo, JsonDataDao dao) {

        if (!CollectionUtils.isEmpty(orderExtSettingMapList)) {
            for (Map<String, Object> mp : orderExtSettingMapList) {

                String colCd = (String) mp.get("col_cd");
                String dataInputType = (String) mp.get("data_input_type");

                Map<String, Object> model = new HashMap<String, Object>();
                model.put("tmp_order_no", tmpOrderNo);
                model.put("tmp_order_ext_col_cd", colCd );

                // --------------------------------
                // タイプによって格納する値の形態を変える
                // ・チェックボックス、リストボックスのとき
                // 　exItemForm.getExtValues()の値exItemFormをセットする
                // ・その他のとき：
                // 　exItemForm.getExtValue()の値をセットする
                // --------------------------------
                if (EditTableUtil.DataInputType.CHECKBOX.equals(dataInputType) ||
                        EditTableUtil.DataInputType.LISTBOX.equals(dataInputType)) {

                    String value = null;
                    String separator = (String) mp.get("choice_list_separator");

                    if (orderExtValueMap != null) {
                        // 複数選択されている値をセパレータでJOIN
                        Map<String, Object> valMap = (Map<String, Object>) orderExtValueMap.get(colCd);
                        String[] values = (String[]) ParamUtil.getParamObjectValueByType(valMap, dto);
                        if (values != null) {
                            StringJoiner sj = new StringJoiner(separator);
                            for (String val : values) {
                                sj.add(val);
                            }
                            value = sj.toString();
                        }
                    }
                    model.put("tmp_order_ext_value", value);
                    model.put("tmp_order_ext_value_separator", separator);

                } else if (EditTableUtil.DataInputType.FILE.equals(dataInputType)) {

                    // --------------------------------
                    // ファイルアップロード時、パスやファイル名を保持する
                    // 実際のファイルは、ここに来る前に一時保管領域にUPLOADされている前提
                    // --------------------------------

                    String fullPath = null;
                    String fileName = null;
                    if (orderExtValueMap != null) {
                        fullPath = ParamUtil.getParamStrValueByType(orderExtValueMap.get(colCd + ".saved_ext_full_path"), dto);
                        fileName = ParamUtil.getParamStrValueByType(orderExtValueMap.get(colCd + ".saved_ext_file_name"), dto);
                    }
                    model.put("tmp_order_ext_file_name", fileName);
                    model.put("tmp_order_ext_file_path", fullPath);

                } else {

                    String value = null;
                    if (orderExtValueMap != null) {
                        Map<String, Object> valMap = (Map<String, Object>) orderExtValueMap.get(colCd);
                        value = ParamUtil.getParamStrValueByType(valMap, dto);
                    }
                    model.put("tmp_order_ext_value", value);

                }

                dao.insertEditTableData(tenantId, "tmporderext", userName, JsonUtil.mapToJson(model));

            }
        }
    }

    /***
     *
     * 受注明細拡張項目登録
     *
     * @param tenantId
     * @param userName
     * @param tmpOrderNo
     * @param recordNo
     * @param dao
     *
     */
    private void insertOrderDetailExt(String tenantId, String userName, String tmpOrderNo, Integer recordNo, JsonDataDao dao) {

        int idx = recordNo - 1;

        if (!CollectionUtils.isEmpty(orderDetailExtSettingMapList)) {

            for (Map<String, Object> mp : orderDetailExtSettingMapList) {

                String colCd = (String) mp.get("col_cd");
                String dataInputType = (String) mp.get("data_input_type");
                String value = "";

                Map<String, Object> model = new HashMap<String, Object>();
                model.put("tmp_order_no", tmpOrderNo);
                model.put("record_no", StringUtil.defaultString(recordNo));
                model.put("tmp_order_detail_ext_col_cd", colCd );

                Map<String, Object> orderDetailExtValues = null;
                for (Map<String, Object> item : orderDetailExtValueMapList) {
                    orderDetailExtValues = new HashMap<String, Object>();
                    String idxStr = ParamUtil.getParamStrValueByType(item.get("idx"), dto);
                    if (item.containsKey(colCd) && Integer.toString(idx).equals(idxStr)) {
                        orderDetailExtValues.put("value",
                                ParamUtil.getParamObjectValueByType(item.get(colCd), dto));
                        if (EditTableUtil.DataInputType.FILE.equals(dataInputType)) {
                            orderDetailExtValues.put("saved_ext_file_name",
                                    ParamUtil.getParamObjectValueByType(
                                            item.get(colCd + ".saved_ext_file_name"), dto));
                            orderDetailExtValues.put("saved_ext_full_path",
                                    ParamUtil.getParamObjectValueByType(
                                            item.get(colCd + ".saved_ext_full_path"), dto));
                        }
                        break;
                    }
                }

                // --------------------------------
                // タイプによって格納する値の形態を変える
                // ・チェックボックス、リストボックスのとき
                // 　exItemForm.getExtValues()の値exItemFormをセットする
                // ・その他のとき：
                // 　exItemForm.getExtValue()の値をセットする
                // --------------------------------
                if (EditTableUtil.DataInputType.CHECKBOX.equals(dataInputType) ||
                        EditTableUtil.DataInputType.LISTBOX.equals(dataInputType)) {

                    String separator = (String) mp.get("choice_list_separator");

                    if (orderDetailExtValues != null) {
                        value = getStrValue(orderDetailExtValues, separator);
                    }
                    model.put("tmp_order_detail_ext_value", value);
                    model.put("tmp_order_detail_ext_value_separator", separator);

                } else if (EditTableUtil.DataInputType.FILE.equals(dataInputType)) {

                    // --------------------------------
                    // ファイルアップロード時、パスやファイル名を保持する
                    // 実際のファイルは、ここに来る前に一時保管領域にUPLOADされている前提
                    // --------------------------------
                    model.put("tmp_order_detail_ext_file_name", orderDetailExtValues.get("saved_ext_file_name"));
                    model.put("tmp_order_detail_ext_file_path", orderDetailExtValues.get("saved_ext_full_path"));

                } else {

                    if (orderDetailExtValues != null) {
                        value = getStrValue(orderDetailExtValues, "");
                    }
                    model.put("tmp_order_detail_ext_value", value);

                }

                dao.insertEditTableData(tenantId, "tmporderdetailext", userName, JsonUtil.mapToJson(model));

            }

        }

    }

    /***
    *
    * 値を取得
    *
    * @param mp
    * @param separator
    * @return
    */
   private String getStrValue(Map<String, Object> mp, String separator) {
       String value = null;
       Object paramValue = mp.get("value");
       if (paramValue != null) {
           if (paramValue.getClass() == String[].class) {
               value = "[" + String.join(separator, (String[]) paramValue) + "]";
           } else {
               value = (String) mp.get("value");
           }
       }
       return value;
   }


}
