package jp.ill.photon.module.order;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.co.smbcfs.station.sdk.dto.CreditCardKessai3DSecureKekkaTorokuTsudoRequest;
import jp.co.smbcfs.station.sdk.dto.KyotsuKessaiTsudoResult;
import jp.co.smbcfs.station.sdk.service.Transaction;
import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.dao.DomaConfig;
import jp.ill.photon.dao.JsonDataDao;
import jp.ill.photon.dao.JsonDataDaoImpl;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.message.ActionDtoMessage;
import jp.ill.photon.model.SmbcPayment;
import jp.ill.photon.model.SmbcPayment.ApiLink;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.CryptUtil;
import jp.ill.photon.util.LogUtil;

import org.seasar.doma.jdbc.tx.TransactionManager;

public class SmbcConnectPostModule implements PhotonModule {

    @ModuleParam(required = false)
    @DefaultParamSetting(transferType = "param", transferVal = "tmp_order_no")
    private String tmpOrderNo;

    @ModuleParam(required = false)
    @DefaultParamSetting(transferType = "param", transferVal = "MD")
    private String md;

    @ModuleParam(required = false)
    @DefaultParamSetting(transferType = "param", transferVal = "PaRes")
    private String paRes;

    @ModuleParam(required = false)
    @DefaultParamSetting(transferType = "param", transferVal = "sessionId")
    private String sessionId;

    @ModuleParam(required = false)
    @DefaultParamSetting(transferType = "param", transferVal = "selected_payment_cd")
    private String paymentCd;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.connectSmbcApi.note")
    private String smbcConnectApi;

    /** メッセージID（SMBC通信結果エラー） */
    public static final String CART_ERROR_MSG_ID = "smbcApiErrMes";

    public String getSmbcConnectApi() {
        return smbcConnectApi;
    }

    public void setSmbcConnectApi(String smbcConnectApi) {
        this.smbcConnectApi = smbcConnectApi;
    }

    public String getPaymentCd() {
        return paymentCd;
    }

    public void setPaymentCd(String paymentCd) {
        this.paymentCd = paymentCd;
    }

    public String getMd() {
        return md;
    }

    public void setMd(String md) {
        this.md = md;
    }

    public String getPaRes() {
        return paRes;
    }

    public void setPaRes(String paRes) {
        this.paRes = paRes;
    }

    public String getSessionId() {
        return sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getTmpOrderNo() {
        return tmpOrderNo;
    }

    public void setTmpOrderNo(String tmpOrderNo) {
        this.tmpOrderNo = tmpOrderNo;
    }

    public ModuleResult execute(ModuleContext context) throws PhotonModuleException {
        ModuleResult moduleResult = new ModuleResult();

        // tmpOrderNoが空でない（3DセキュアON）の場合のみ処理する
        if (tmpOrderNo != null) {

            CreditCardKessai3DSecureKekkaTorokuTsudoRequest request = new CreditCardKessai3DSecureKekkaTorokuTsudoRequest();

            TransactionManager tm = DomaConfig.singleton().getTransactionManager();
            JsonDataDao dao = new JsonDataDaoImpl();

            SmbcPayment smbcPayment = tm.required(() -> {
                List<Map<String, Object>> smbcMap = dao.getSmbcPayment(context.getDto().getTenantId(), paymentCd);
                if (smbcMap == null || smbcMap.isEmpty()) {
                    return null;
                }
                else {
                    return SmbcPayment.valueOf(smbcMap.get(0));
                }
            });

            // 契約コード
            // (半角英数・7バイト)
            request.setShop_cd(smbcPayment.getShopCd());
            // 収納企業コード
            // (半角英数・8バイト)
            request.setSyuno_co_cd(smbcPayment.getReceiptCoCd());
            // 拠点コード
            // (半角英数・8バイト)
            //request.setKyoten_cd(smbcPayment.getBaseCd());
            // ショップパスワード
            // (半角英数・20バイト)

            String shopPw = CryptUtil
                    .getBase64DecodedStr(smbcPayment.getShopPassword());
            request.setShop_pwd(shopPw);

            // 請求番号
            // (半角数字・17バイト)
            request.setShoporder_no(md);
            // セッションＩＤ
            // (半角英数・70バイト)
            request.setSessionid(sessionId);
            // PaRes
            // (半角英数記号・3000バイト)
            request.setPares(paRes);

            // 接続
            Transaction t = SmbcConnectPreModule.getSmbcConnection(smbcConnectApi);
            // 通信
            KyotsuKessaiTsudoResult result = t.send(request);

            if (!ApiLink.Result.SUCCESS.equals(result.getRescd())) {

                // 異常終了
                List<ActionDtoMessage> apiErrors = new ArrayList<ActionDtoMessage>();
                ActionDtoMessage msg = new ActionDtoMessage();
                Map<String, Object> params = new HashMap<>();
                Map<String, Object> mp = new HashMap<>();

                String errMsg = String.format("[%s]%s", result.getRescd(), result.getRes());

                // ログ出力
                LogUtil.getInstance().error("API通信異常終了");
                LogUtil.getInstance().error(errMsg + "\n");

                mp.put("type", "static");
                mp.put("val", errMsg);
                params.put("%1$s", mp);

                msg.setMessageId(CART_ERROR_MSG_ID);
                msg.setParams(params);
                apiErrors.add(msg);

                moduleResult.setResultCode("error");
                moduleResult.getMessages().put("error_page", apiErrors);
                return moduleResult;
            }

            moduleResult.getReturnData().put("shop_order_no", md);

        }

        return moduleResult;
    }

}
