package jp.ill.photon.module.order;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.seasar.doma.jdbc.tx.TransactionManager;

import jp.co.smbcfs.station.sdk.dto.CreditCardKessaiSeikyuKakuteiTsudoRequest;
import jp.co.smbcfs.station.sdk.dto.CreditCardKessaiYoshinTorikeshiZengakuTsudoRequest;
import jp.co.smbcfs.station.sdk.dto.KyotsuKessaiTsudoResult;
import jp.co.smbcfs.station.sdk.service.Transaction;
import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.dao.DomaConfig;
import jp.ill.photon.dao.JsonDataDao;
import jp.ill.photon.dao.JsonDataDaoImpl;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.message.ActionDtoMessage;
import jp.ill.photon.model.MapListParam;
import jp.ill.photon.model.MapParam;
import jp.ill.photon.model.SmbcPayment;
import jp.ill.photon.model.SmbcPayment.ApiLink;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.CheckUtil;
import jp.ill.photon.util.CryptUtil;
import jp.ill.photon.util.JsonUtil;
import jp.ill.photon.util.StringUtil;

public class ShopOrderUpdateModule implements PhotonModule {

	@ModuleParam(required = true)
	private String mode;

	@ModuleParam(required = false)
	private MapParam form;

	@ModuleParam(required = false)
	private MapListParam formList;

	@ModuleParam(required = true)
	@DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.connectSmbcApi.note")
	private String smbcConnectApi;


	public String getMode() {
		return mode;
	}

	public void setMode(String mode) {
		this.mode = mode;
	}

	public MapParam getForm() {
		return form;
	}

	public void setForm(MapParam form) {
		this.form = form;
	}

	public MapListParam getFormList() {
		return formList;
	}

	public void setFormList(MapListParam formList) {
		this.formList = formList;
	}

	public String getSmbcConnectApi() {
        return smbcConnectApi;
    }

    public void setSmbcConnectApi(String smbcConnectApi) {
        this.smbcConnectApi = smbcConnectApi;
    }

	protected static class CreditStatus {
		public static final String WAIT = "確定待ち";
		public static final String DETERMINATE = "確定済み";
		public static final String CANCEL = "与信キャンセル済み";
	}

    @Override
    public ModuleResult execute(ModuleContext context) throws PhotonModuleException {

        ModuleResult result = new ModuleResult();

        List<Map<String, Object>> paramList = new ArrayList<>();

        if (form != null) {
            Map<String, Object> param = form.getParamMap();
            paramList.add(param);
        }

        if (formList != null) {
            paramList = formList.getParamList();
        }

        if (paramList == null || paramList.size() == 0) {
            return result;
        }

        TransactionManager tm = DomaConfig.singleton().getTransactionManager();
        JsonDataDao dao = new JsonDataDaoImpl();

        SmbcPayment smbcPayment = tm.required(() -> {
            List<Map<String, Object>> smbcMap = dao.getSmbcPayment(context.getDto().getTenantId(), "04");
            if (smbcMap == null || smbcMap.isEmpty()) {
                return null;
            }
            else {
                return SmbcPayment.valueOf(smbcMap.get(0));
            }
        });

        List<Map<String, Object>> successList = new ArrayList<>();

        for (Map<String, Object> param : paramList) {

            if ("fix".equals(mode)) {
                tm.required(() -> {
                    String shoporderNo = StringUtil.defaultString(param.get("shoporder_no"), "");
                    if (param.get("billing_amount") != null) {
                        Transaction t = SmbcConnectPreModule.getSmbcConnection(smbcConnectApi);

                        CreditCardKessaiSeikyuKakuteiTsudoRequest request = new CreditCardKessaiSeikyuKakuteiTsudoRequest();

                        // 契約コード
                        request.setShop_cd(smbcPayment.getShopCd());
                        // 収納企業コード
                        request.setSyuno_co_cd(smbcPayment.getReceiptCoCd());
                        // ショップパスワード
                        String shopPw = CryptUtil.getBase64DecodedStr(smbcPayment.getShopPassword());
                        request.setShop_pwd(shopPw);
                        // 請求番号
                        request.setShoporder_no(shoporderNo);
                        // 請求金額
                        request.setSeikyuu_kingaku(this.getRoundedValue((String)param.get("billing_amount"), BigDecimal.ROUND_DOWN));

                        // 通信
                        KyotsuKessaiTsudoResult apiResult = t.send(request);

                        if (!ApiLink.Result.SUCCESS.equals(apiResult.getRescd())) {
                            System.out.println("■　■　■　■　異常終了　■　■　■　■");
                            List<ActionDtoMessage> errorMessages = new ArrayList<ActionDtoMessage>();
                            ActionDtoMessage msg = new ActionDtoMessage();
                            msg.setMessage(String.format("%s:%s", apiResult.getRescd(), apiResult.getRes()));
                            errorMessages.add(msg);
                            result.getMessages().put("error_page", errorMessages);
                            result.setResultCode("validate_ng");
                            return;
                        } else {
                            // 請求を確定済みにする
                            Map<String, Object> map = new HashMap<>();
                            map.put("order_no", StringUtil.defaultString(param.get("order_no"), ""));
                            map.put("shoporder_no", shoporderNo);
                            map.put("status", 1);

                            String data = JsonUtil.mapToJson(map);
                            Map<String, Object> ret = dao.updateEditTableData(context.getDto().getTenantId(), "shoporder", "system", data);
                            if ((int) ret.get("ret") == 0) {
                                map.put("status_name", CreditStatus.DETERMINATE);
                                successList.add(map);
                            }
                        }
                    }
                });
            } else if ("cancel".equals(mode)) {
                tm.required(() -> {
                    String shoporderNo = StringUtil.defaultString(param.get("shoporder_no"), "");
                    if (param.get("billing_amount") != null) {
                        Transaction t = SmbcConnectPreModule.getSmbcConnection(smbcConnectApi);

                        CreditCardKessaiYoshinTorikeshiZengakuTsudoRequest request = new CreditCardKessaiYoshinTorikeshiZengakuTsudoRequest();

                        // 契約コード
                        request.setShop_cd(smbcPayment.getShopCd());
                        // 収納企業コード
                        request.setSyuno_co_cd(smbcPayment.getReceiptCoCd());
                        // ショップパスワード
                        String shopPw = CryptUtil.getBase64DecodedStr(smbcPayment.getShopPassword());
                        request.setShop_pwd(shopPw);
                        // 請求番号
                        request.setShoporder_no(shoporderNo);
                        // 請求金額
                        request.setSeikyuu_kingaku(this.getRoundedValue((String)param.get("billing_amount"), BigDecimal.ROUND_DOWN));

                        // 通信
                        KyotsuKessaiTsudoResult apiResult = t.send(request);
apiResult.setRescd(ApiLink.Result.SUCCESS);
                        if (!ApiLink.Result.SUCCESS.equals(apiResult.getRescd())) {
                            System.out.println("■　■　■　■　異常終了　■　■　■　■");
                            List<ActionDtoMessage> errorMessages = new ArrayList<ActionDtoMessage>();
                            ActionDtoMessage msg = new ActionDtoMessage();
                            msg.setMessage(String.format("%s:%s", apiResult.getRescd(), apiResult.getRes()));
                            errorMessages.add(msg);
                            result.getMessages().put("error_page", errorMessages);
                            result.setResultCode("validate_ng");
                            return;
                        } else {
                            // 請求をキャンセル済みにする
                            Map<String, Object> map = new HashMap<>();
                            map.put("order_no", StringUtil.defaultString(param.get("order_no"), ""));
                            map.put("shoporder_no", shoporderNo);
                            map.put("status", 2);

                            String data = JsonUtil.mapToJson(map);
                            Map<String, Object> ret = dao.updateEditTableData(context.getDto().getTenantId(), "shoporder", "system", data);
                            if ((int) ret.get("ret") == 0) {
                                map.put("status_name", CreditStatus.CANCEL);
                                successList.add(map);
                            }
                        }
                    }
                });
            }
        }

        Map<String, Object> tmp = new HashMap<>();
        tmp.put("list", successList);
        result.setReturnData(tmp);
        return result;
    }

    /**
     * カンマ除去、端数処理を実施した後の文字列を取得.
     *
     * @param String
     * @retrun String
     *
     * */
    private String getRoundedValue(String val, int roundingMode) {
        String replacedVal = (CheckUtil.isEmpty(val) ? "0" : val.replaceAll(
                ",", ""));
        BigDecimal bdVal = new BigDecimal(replacedVal);
        bdVal = bdVal.setScale(0, roundingMode);
        return bdVal.toString();
    }

    /**
     * 空(NULL)文字チェック.
     *
     * @param string
     * @return boolean (true:空文字又はNULL false:空文字、NULL以外)
     */
    public static boolean isEmpty(String string) {
        if (string == null || string.trim().equals("")) {
            return true;
        }
        return false;
    }

}
