package jp.ill.photon.module.order;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.seasar.doma.MapKeyNamingType;
import org.seasar.doma.internal.jdbc.command.MapResultListHandler;
import org.seasar.doma.jdbc.command.SelectCommand;
import org.seasar.doma.jdbc.query.SqlSelectQuery;
import org.seasar.doma.jdbc.tx.TransactionManager;

import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.dao.DomaConfig;
import jp.ill.photon.dao.JsonDataDao;
import jp.ill.photon.dao.JsonDataDaoImpl;
import jp.ill.photon.doma.PhotonSqlUpdateQuery;
import jp.ill.photon.doma.PhotonUpdateCommand;
import jp.ill.photon.doma.SqlSelectQueryFactory;
import jp.ill.photon.doma.SqlUpdateQueryFactory;
import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.model.ChargeFee;
import jp.ill.photon.model.ConveniencePayment;
import jp.ill.photon.model.CreditNumberOfPayment;
import jp.ill.photon.model.CreditPayment;
import jp.ill.photon.model.Payment;
import jp.ill.photon.model.SmbcPayment;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.CryptUtil;
import jp.ill.photon.util.JsonUtil;
import jp.ill.photon.util.SQLUtil;
import jp.ill.photon.util.StringUtil;

public class PaymentUpdateModule implements PhotonModule {

    @ModuleParam(required = true, paramGroup=true)
    private Payment payment = new Payment();

    @ModuleParam(required = true, paramGroup=true)
    private SmbcPayment smbcPayment = new SmbcPayment();

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "param_multi", transferVal = "cod_fee_setting.threshold")
    private String[] codFeeThreshold;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "param_multi", transferVal = "cod_fee_setting.fee")
    private String[] codFeeFee;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "param_multi", transferVal = "convenience_payment_setting")
    private String[] conveniencePaymentSetting;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "param_multi", transferVal = "credit_payment_method_setting")
    private String[] creditPaymentMethodSetting;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "param_multi", transferVal = "credit_numberof_payment_method_setting")
    private String[] creditNumberOfPaymentSetting;

    public String[] getCreditNumberOfPaymentSetting() {
        return creditNumberOfPaymentSetting;
    }

    public void setCreditNumberOfPaymentSetting(String[] creditNumberOfPaymentSetting) {
        this.creditNumberOfPaymentSetting = creditNumberOfPaymentSetting;
    }

    public String[] getCreditPaymentMethodSetting() {
        return creditPaymentMethodSetting;
    }

    public void setCreditPaymentMethodSetting(String[] creditPaymentMethodSetting) {
        this.creditPaymentMethodSetting = creditPaymentMethodSetting;
    }

    public String[] getConveniencePaymentSetting() {
        return conveniencePaymentSetting;
    }

    public void setConveniencePaymentSetting(String[] conveniencePaymentSetting) {
        this.conveniencePaymentSetting = conveniencePaymentSetting;
    }

    public Payment getPayment() {
        return payment;
    }

    public void setPayment(Payment payment) {
        this.payment = payment;
    }

    public SmbcPayment getSmbcPayment() {
        return smbcPayment;
    }

    public void setSmbcPayment(SmbcPayment smbcPayment) {
        this.smbcPayment = smbcPayment;
    }

    public String[] getCodFeeThreshold() {
        return codFeeThreshold;
    }

    public void setCodFeeThreshold(String[] codFeeThreshold) {
        this.codFeeThreshold = codFeeThreshold;
    }

    public String[] getCodFeeFee() {
        return codFeeFee;
    }

    public void setCodFeeFee(String[] codFeeFee) {
        this.codFeeFee = codFeeFee;
    }

    // ■□■□■□■□■□■□■□■□■□■□■□
    // ■□ 利用者の注文履歴決済リスト更新処理 ■□
    // ■□
    // ■□ TODO:【希望】L.Satta - 各Entityデータの項目定義用のクラス作成
    // ■□ 例：ENTITY.PAYMENT.DISP_FLG
    // ■□ 例：ENTITY.PAYMENT.INSERT_DIV・・・
    // ■□ 自動的に作成される様にする（フォーマットについて、データベースと合わす）

    @ModuleParam(required = false)
    @DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.exSqlFileDir.note")
    private String sqlFileDirPath;

    public String getSqlFileDirPath() {
        return sqlFileDirPath;
    }
    public void setSqlFileDirPath(String sqlFileDirPath) {
        this.sqlFileDirPath = sqlFileDirPath;
    }

    /**
     * GetSearchPaymentListSQL
     * 決済方法の検索条件に追加対象のデータを取得処理
     *
     * @author L.Satta
     */
    public static final class GetSearchPaymentListSQL {

        /** SQLパス */
        public static final String SQL_PATH = "aec20/admin_payment/getSearchPaymentList.sql";
        /** SQL引数 */
        public static final HashMap<Integer, String> SQL_PARAMS = new HashMap<Integer, String>() {{
            put(0,"tenantId");       // テナント
        }};
        /** SQL戻値 */
        public static final HashMap<Integer, String> SQL_RETURNS = new HashMap<Integer, String>() {{
            put(0,"payment_cd");     // 決済コード
            put(1,"payment_name");   // 決済名称
        }};
    }

    /**
     * UpdateFormFieldPaymentListSQL
     * 決済方法リストを更新処理
     *
     * @author L.Satta
     */
    public static final class UpdateFormFieldPaymentListSQL {

        /** 決済方法リスト形式 */
        public static final class EcuserOrderHisList{
            /** 項目名 */
            public static String ECUSER_ORDERHIS_LIST = "ecuser_orderhis_list";
            /** インデント */
            public static String ECUSER_ORDERHIS_LIST_INDENT = ",";
            /** */
            public static String ECUSER_ORDERHIS_LIST_COMP = "\"";
        }
        /** SQLパス */
        public static final String SQL_PATH = "aec20/admin_payment/updateFormFieldPaymentList.sql";
        /** SQL引数 */
        public static final HashMap<Integer, String> SQL_PARAMS = new HashMap<Integer, String>() {{
            put(0,"tenantId");       // テナント
            put(1,"formCd");         // フォーム
            put(2,"formFieldCd");    // フォーム項目
            put(3,"choiceList");     // 検索条件リスト
            put(4,"updateUserName"); // 更新者
        }};
    }
    // ■□                                    ■□
    // ■□ 利用者の注文履歴決済リスト更新処理 ■□
    // ■□■□■□■□■□■□■□■□■□■□■□

    @Override
    public ModuleResult execute(ModuleContext context) throws PhotonModuleException {
        ModuleResult result = new ModuleResult();

		ActionDto dto = context.getDto();
		Map<String, Object> params = new LinkedHashMap<String, Object>();

        TransactionManager tm = DomaConfig.singleton().getTransactionManager();
        JsonDataDao dao = new JsonDataDaoImpl();

		// 登録/変更日時
		String nowDatetime = SQLUtil.getNowDatetime();
		String loginAdminUserName = SQLUtil.getLoginAdminUserName(dto);
		String tenantId = dto.getTenantId();

        int r = tm.required(() -> {

            // 決済方法マスタ TODO ここのデータの詰め方、どうするか？
            {
                Map<String, Object> map = new HashMap<String, Object>();
                map.put("payment_cd", payment.getPaymentCd());
                map.put("disp_flg", payment.getDispFlg());
                map.put("description", payment.getDescription());
                String data = JsonUtil.mapToJson(map);
                dao.updateEditTableData(tenantId, "payment", loginAdminUserName, data); // TODO 更新ユーザ
            }

            // ■□■□■□■□■□■□■□■□■□■□■□■□
            // ■□ 利用者の注文履歴決済リスト更新処理開始 ■□
            // ■□
            // ■□ OLD : 「00,掛売り,01,代金引換,02,銀行振込,03,コンビニ決済,04,クレジット」固定

            try {

               // 決済方法の検索条件に追加対象のデータを取得する
                SqlSelectQueryFactory selectFactory = SqlSelectQueryFactory.newInstance();
                HashMap<String, Object> getSearchPaymentListParams = new HashMap<String, Object>();
                getSearchPaymentListParams.put(GetSearchPaymentListSQL.SQL_PARAMS.get(0), toSubMap(tenantId.toString()));
                SqlSelectQuery getSearchPaymentListQuery = selectFactory.createSelectQueryFromFile(
                        getSearchPaymentListParams, context.getDto(),
                        sqlFileDirPath, GetSearchPaymentListSQL.SQL_PATH);
                getSearchPaymentListQuery.prepare();

                // 取得SQLを実行する
                List<Map<String, Object>> orderData = tm.required(() -> {
                    SelectCommand<List<Map<String, Object>>> command = new SelectCommand<>(
                            getSearchPaymentListQuery,
                            new MapResultListHandler(MapKeyNamingType.NONE));
                    return command.execute();
                    });

                // 決済方法の検索条件リストを作成する

                // 決済方法リスト
                String  choiceList = "";
                // 決済方法リストのカウンタ
                int cntpaymentList = 0 ;

                choiceList=choiceList + UpdateFormFieldPaymentListSQL.EcuserOrderHisList.ECUSER_ORDERHIS_LIST_COMP;
                for(Map<String, Object> info : orderData){
                    // 決済方法リストの1件目以外の場合、インデントする
                    if(cntpaymentList != 0){
                        choiceList=choiceList + UpdateFormFieldPaymentListSQL.EcuserOrderHisList.ECUSER_ORDERHIS_LIST_INDENT;
                        }
                    // 決済方法リストに取得された決済方法を追加する
                    choiceList=choiceList + (String) info.get(GetSearchPaymentListSQL.SQL_RETURNS.get(0));
                    choiceList=choiceList + UpdateFormFieldPaymentListSQL.EcuserOrderHisList.ECUSER_ORDERHIS_LIST_INDENT;
                    choiceList=choiceList + (String) info.get(GetSearchPaymentListSQL.SQL_RETURNS.get(1));
                    cntpaymentList++;
                    }
                choiceList=choiceList + UpdateFormFieldPaymentListSQL.EcuserOrderHisList.ECUSER_ORDERHIS_LIST_COMP;

                // 決済方法リストを更新する
                SqlUpdateQueryFactory updateFactory = SqlUpdateQueryFactory.newInstance();
                HashMap<String, Object> updateFormFieldPaymentListParams = new HashMap<String, Object>();

                updateFormFieldPaymentListParams.put(
                        UpdateFormFieldPaymentListSQL.SQL_PARAMS.get(0), toSubMap(tenantId.toString()));
                updateFormFieldPaymentListParams.put(
                        UpdateFormFieldPaymentListSQL.SQL_PARAMS.get(1), toSubMap(UpdateFormFieldPaymentListSQL.EcuserOrderHisList.ECUSER_ORDERHIS_LIST));
                updateFormFieldPaymentListParams.put(
                        UpdateFormFieldPaymentListSQL.SQL_PARAMS.get(2), toSubMap(GetSearchPaymentListSQL.SQL_RETURNS.get(0)));
                updateFormFieldPaymentListParams.put(
                        UpdateFormFieldPaymentListSQL.SQL_PARAMS.get(3), toSubMap(choiceList));
                updateFormFieldPaymentListParams.put(
                        UpdateFormFieldPaymentListSQL.SQL_PARAMS.get(4), toSubMap(loginAdminUserName));

                PhotonSqlUpdateQuery updateFormFieldPaymentListQuery = updateFactory.createUpdateQueryFromFile(
                        updateFormFieldPaymentListParams, context.getDto(),
                        sqlFileDirPath, UpdateFormFieldPaymentListSQL.SQL_PATH);
                updateFormFieldPaymentListQuery.prepare();

                // 更新クエリ実行
                tm.required(() -> {
                    PhotonUpdateCommand command = new PhotonUpdateCommand(updateFormFieldPaymentListQuery);
                    return command.execute();
                    });

            } catch (Exception e) {
                System.out.println(e.getMessage());
            }
            // ■□ 利用者の注文履歴決済リスト更新処理終了 ■□
            // ■□■□■□■□■□■□■□■□■□■□■□■□

            // SMBC決済方法マスタ
            if ("03".equals(payment.getPaymentCd()) || "04".equals(payment.getPaymentCd())) {
                Map<String, Object> map = new HashMap<String, Object>();
                map.put("payment_cd", payment.getPaymentCd());
                map.put("shop_cd", smbcPayment.getShopCd());
                map.put("receipt_co_cd", smbcPayment.getReceiptCoCd());
                map.put("base_cd", smbcPayment.getBaseCd());
                map.put("shop_password", CryptUtil.getBase64EncodedStr(smbcPayment.getShopPassword()));
                map.put("payment_limit_day", smbcPayment.getPaymentLimitDay());
                map.put("security_cd_input_div", StringUtil.defaultString(smbcPayment.getSecurityCdInputDiv(), "0"));
                String data = JsonUtil.mapToJson(map);
                dao.updateEditTableData(tenantId, "smbcpayment", loginAdminUserName, data); // TODO 更新ユーザ
            }

            // 決済代引手数料設定テーブル 削除→登録
            if ("01".equals(payment.getPaymentCd())) {
                if (codFeeFee.length == codFeeThreshold.length) {
                    // 削除
                    List<Map<String, Object>> chargeFeeListMap = dao.getChargeFeeSettingList(tenantId);
                    for (Map<String, Object> codMap : chargeFeeListMap) {
                        ChargeFee cf = ChargeFee.valueOf(codMap);

                        Map<String, Object> map = new HashMap<String, Object>();
                        map.put("payment_cd", payment.getPaymentCd());
                        map.put("sort_no", cf.getSortNo());
                        String where = JsonUtil.mapToJson(map);
                        dao.deleteEditTableData(tenantId, "codfeesetting", where);
                    }

                    // 登録
                    for (int i=0; i < codFeeFee.length; i++) {
                        if (!StringUtils.isEmpty(codFeeThreshold[i]) && !StringUtils.isEmpty(codFeeFee[i])) {
                            Map<String, Object> map = new HashMap<String, Object>();
                            map.put("payment_cd", payment.getPaymentCd());
                            map.put("sort_no", i);
                            map.put("threshold", codFeeThreshold[i]);
                            map.put("fee", codFeeFee[i]);
                            String data = JsonUtil.mapToJson(map);
                            dao.insertEditTableData(tenantId, "codfeesetting", loginAdminUserName, data);
                        }
                    }
                }
            }

            // コンビニ支払方法設定テーブル
            if ("03".equals(payment.getPaymentCd())) {

                List<Map<String, Object>> conveniencePaymentListMap = dao.getConveniencePayment(tenantId);
                for (Map<String, Object> conveniencePaymentMap : conveniencePaymentListMap) {
                    ConveniencePayment cp = ConveniencePayment.valueOf(conveniencePaymentMap);

                    // 削除
                    Map<String, Object> map = new HashMap<String, Object>();
                    map.put("payment_cd", payment.getPaymentCd());
                    map.put("payment_method_cd", cp.getPaymentMethodCd());
                    String where = JsonUtil.mapToJson(map);
                    dao.deleteEditTableData(tenantId, "conveniencepaymentmethodsetting", where);

                    // 登録
                    map = new HashMap<String, Object>();
                    map.put("payment_cd", payment.getPaymentCd());
                    map.put("payment_method_cd", cp.getPaymentMethodCd());
                    int value = Arrays.asList(conveniencePaymentSetting).contains(cp.getPaymentMethodCd()) ? 1 : 0;
                    map.put("payment_method_div", value);
                    String data = JsonUtil.mapToJson(map);
                    dao.insertEditTableData(tenantId, "conveniencepaymentmethodsetting", loginAdminUserName, data);
                }
            }

            // クレジット支払方法設定テーブル (クレジット支払い方法、クレジット支払回数)
            if ("04".equals(payment.getPaymentCd())) {

                List<Map<String, Object>> creditPaymentListMap = dao.getCreditPaymentMethod(tenantId);
                for (Map<String, Object> creditPaymentMap : creditPaymentListMap) {
                    CreditPayment cp = CreditPayment.valueOf(creditPaymentMap);

                    // 削除
                    Map<String, Object> map = new HashMap<String, Object>();
                    map.put("payment_cd", payment.getPaymentCd());
                    map.put("payment_method_cd", cp.getPaymentMethodCd());
                    String where = JsonUtil.mapToJson(map);
                    dao.deleteEditTableData(tenantId, "creditpaymentmethodsetting", where);

                    // 登録
                    map = new HashMap<String, Object>();
                    map.put("payment_cd", payment.getPaymentCd());
                    map.put("payment_method_cd", cp.getPaymentMethodCd());
                    int value = Arrays.asList(creditPaymentMethodSetting).contains(cp.getPaymentMethodCd()) ? 1 : 0;
                    map.put("payment_method_div", value);
                    String data = JsonUtil.mapToJson(map);
                    dao.insertEditTableData(tenantId, "creditpaymentmethodsetting", loginAdminUserName, data);
                }

                List<Map<String, Object>> creditNumberOfPaymentListMap = dao.getCreditNumberOfPaymentMethod(tenantId);
                for (Map<String, Object> creditNumberOfPaymentMap : creditNumberOfPaymentListMap) {
                    CreditNumberOfPayment cp = CreditNumberOfPayment.valueOf(creditNumberOfPaymentMap);

                    // 削除
                    Map<String, Object> map = new HashMap<String, Object>();
                    map.put("payment_cd", payment.getPaymentCd());
                    map.put("number_of_payment_cd", cp.getNumberOfPaymentCd());
                    String where = JsonUtil.mapToJson(map);
                    dao.deleteEditTableData(tenantId, "creditnumberofpaymentsetting", where);

                    // 登録
                    map = new HashMap<String, Object>();
                    map.put("payment_cd", payment.getPaymentCd());
                    map.put("number_of_payment_cd", cp.getNumberOfPaymentCd());
                    int value = Arrays.asList(creditNumberOfPaymentSetting).contains(cp.getNumberOfPaymentCd()) ? 1 : 0;
                    map.put("number_of_payment_div", value);
                    String data = JsonUtil.mapToJson(map);
                    dao.insertEditTableData(tenantId, "creditnumberofpaymentsetting", loginAdminUserName, data);

                }

            }

            return 0;
        });

        result.setResultCode("success");

        return result;
    }

	private Map<String, Object> toSubMap(String val){
         Map<String, Object> subMap = new  LinkedHashMap<String, Object>();
         subMap.put("type", "static");
         subMap.put("val", val);
         return subMap;
    }

}
