package jp.ill.photon.module.order;

import java.util.Map;

import jp.ill.photon.action.ActionParamMap;
import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.CryptUtil;

public class PaymentFormCreateModule implements PhotonModule {

    @ModuleParam(required = false)
    @DefaultParamSetting(transferType = "dto", transferVal = "smbc_payment.first.shop_password")
    private String shopPassword;

	@Override
	public ModuleResult execute( ModuleContext context ) {

		ModuleResult result = new ModuleResult();

		ActionDto dto = context.getDto();
		ActionParamMap params = dto.getParams();
		/** 結果区分 */
		String resultDiv = (String) params.get("resultDiv");

		// バリデーションエラー時
		if("validation_error".equals(resultDiv)){
			// ショップパスワードをデコードせず、入力値をそのまま表示
		}else{
			Map<String, Object> form = (Map<String, Object>) dto.getDataMap().get("form");
			// ショップパスワードをデコード
			((Map<String, Object>)form.get("values")).put("smbc_payment.shop_password", CryptUtil.getBase64DecodedStr(shopPassword));
			dto.getDataMap().put("form", form);
		}

		return result;
	}

    public String getShopPassword() {
        return shopPassword;
    }

    public void setShopPassword(String shopPassword) {
        this.shopPassword = shopPassword;
    }


}
