package jp.ill.photon.module.order;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.dao.DomaConfig;
import jp.ill.photon.dao.JsonDataDao;
import jp.ill.photon.dao.JsonDataDaoImpl;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.JsonUtil;

import org.seasar.doma.jdbc.tx.TransactionManager;

public class OrderImportPermitModule implements PhotonModule {

    @ModuleParam(required = false)
    @DefaultParamSetting(transferType = "param_multi", transferVal = "no")
    private String[] orderNo;

    @ModuleParam(required = false)
    @DefaultParamSetting(transferType = "param_multi", transferVal = "permitFlg")
    private String[] permitFlg;

    @ModuleParam(required = false)
    @DefaultParamSetting(transferType = "dto", transferVal = "order.list")
    private List<Map<String, Object>> orderList;

    public String[] getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String[] orderNo) {
        this.orderNo = orderNo;
    }

    public String[] getPermitFlg() {
        return permitFlg;
    }

    public void setPermitFlg(String[] permitFlg) {
        this.permitFlg = permitFlg;
    }

    public List<Map<String, Object>> getOrderList() {
        return orderList;
    }

    public void setOrderList(List<Map<String, Object>> orderList) {
        this.orderList = orderList;
    }

    @Override
    public ModuleResult execute(ModuleContext context) throws PhotonModuleException {
        ModuleResult result = new ModuleResult();

        // orderNo指定のとき
        if (orderNo != null) {
            if (orderNo.length != permitFlg.length) {
                return result;
            }

            TransactionManager tm = DomaConfig.singleton().getTransactionManager();
            JsonDataDao dao = new JsonDataDaoImpl();

            tm.required(() -> {

                for (int i = 0; i < orderNo.length; i++) {
                    String no = orderNo[i];

                    // 既に取り込み済みでなければ、取り込み済みフラグを更新
                    if (!"1".equals(permitFlg)) {
                        Map<String, Object> map = new HashMap<String, Object>();
                        map.put("order_no", no);
                        map.put("import_permit_div", "1");

                        String data = JsonUtil.mapToJson(map);
                        dao.updateEditTableData(context.getDto().getTenantId(), "order", "system", data);
                    }
                }

            });
        }
        // 検索条件指定の時
        if (orderList != null) {
            TransactionManager tm = DomaConfig.singleton().getTransactionManager();
            JsonDataDao dao = new JsonDataDaoImpl();

            tm.required(() -> {

                for (int i = 0; i < orderList.size(); i++) {
                    String no = (String)orderList.get(i).get("order_no");

                    // 既に取り込み済みでなければ、取り込み済みフラグを更新
                    if (!"1".equals(permitFlg)) {
                        Map<String, Object> map = new HashMap<String, Object>();
                        map.put("order_no", no);
                        map.put("import_permit_div", "1");

                        String data = JsonUtil.mapToJson(map);
                        dao.updateEditTableData(context.getDto().getTenantId(), "order", "system", data);
                    }
                }

            });
        }

        return result;
    }

}
