package jp.ill.photon.module.order;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.model.SearchForm;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.db.SqlFileSelectModule;

@Deprecated
public class OrderHisListModule extends SqlFileSelectModule {

    /** TODO 親クラスに書かれていれば書かなくてもいいようにしたい */
    @ModuleParam(required = true, domainObject = true)
    private SearchForm searchForm;

    @ModuleParam(required = true)
    private String sqlFileDirPath;

    @ModuleParam(required = true)
    private String sqlFilePath;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.serviceChargeCd.note")
    private String chargeFeeItemCd;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.deliveryFeeItemCd.note")
    private String deliveryFeeItemCd;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.webOrderCampaignItemCd.note")
    private String webOrderCampaignCd;

    public String getChargeFeeItemCd() {
        return chargeFeeItemCd;
    }

    public void setChargeFeeItemCd(String chargeFeeItemCd) {
        this.chargeFeeItemCd = chargeFeeItemCd;
    }

    public String getDeliveryFeeItemCd() {
        return deliveryFeeItemCd;
    }

    public void setDeliveryFeeItemCd(String deliveryFeeItemCd) {
        this.deliveryFeeItemCd = deliveryFeeItemCd;
    }

    public String getWebOrderCampaignCd() {
        return webOrderCampaignCd;
    }

    public void setWebOrderCampaignCd(String webOrderCampaignCd) {
        this.webOrderCampaignCd = webOrderCampaignCd;
    }

    @Override
    public ModuleResult execute(ModuleContext context)
            throws PhotonModuleException {
        ModuleResult result = super.execute(context);

        List<Map<String, Object>> orderList = (List<Map<String, Object>>)result.getReturnData().get("list");

        Map<String, List<Map<String, Object>>> orderDetailListMap = new HashMap<String, List<Map<String, Object>>>();

        int count = 0;
        String prevOrderNo = "";

        Map<String, Integer> itemCdMap = new HashMap<String, Integer>();
        List<String> itemCdList = new ArrayList<String>();

        List<Map<String, Object>> orderDetailList = new ArrayList<Map<String, Object>>();

        for (int i=0; i < orderList.size(); i++) {
            Map<String, Object> orderMap = orderList.get(i);

            if (!prevOrderNo.equals(orderMap.get("order_no"))) {
                count++;
                orderMap.put("chg_flg", "true");

                orderDetailList = new ArrayList<Map<String, Object>>();
                orderDetailListMap.put((String)orderMap.get("order_no"), orderDetailList);
            } else {
                orderMap.put("chg_flg", "false");
            }

            if (OrderHisListModule.isSpecialDetail((String)orderMap.get("item_cd"), chargeFeeItemCd, deliveryFeeItemCd, webOrderCampaignCd)) {
                orderMap.put("is_display", "false");
            } else {
                orderMap.put("is_display", "true");

                if (itemCdMap.get((String)orderMap.get("item_cd")) == null) {
                    itemCdMap.put((String)orderMap.get("item_cd"), new Integer(0));
                    itemCdList.add((String)orderMap.get("item_cd"));
                }
            }

            if (orderMap.get("import_permit_div") != null) {
                orderMap.put("import_permit_div_msg",
                        importPermitDiv.IMPORT_PERMIT_DIV_MAP.get(orderMap.get("import_permit_div")));
            }

            if (orderMap.get("shipment_end_flg") != null) {
                orderMap.put("shipment_end_flg_disp", ShipmentEndFlg.SHIPMENT_END_MAP.get(orderMap.get("shipment_end_flg")));
            }

            orderMap.put("detail_count", i);

            prevOrderNo = (String)orderMap.get("order_no");



            orderList.set(i, orderMap);
            orderDetailList.add(orderMap);
        }

        result.getReturnData().put("detail_map", orderDetailListMap);
        result.getReturnData().put("item_cd", itemCdList);
        result.getReturnData().put("count", count);

        return result;

    }

    /** 出荷フラグ */
    public static class ShipmentEndFlg {
        /** 条件なし */
        public static final String NOT = "9";
        /** 未出荷 */
        public static final String NO = "0";
        /** 出荷済み */
        public static final String YES = "1";
        /** 一部出荷 */
        public static final String PART = "2";
        /** キャンセル済み */
        public static final String CANCEL = "3";
        /** マップ */
        public static final LinkedHashMap<String, String> SHIPMENT_END_MAP = new LinkedHashMap<String, String>();
        static {
            SHIPMENT_END_MAP.put(NO, "未出荷");
            SHIPMENT_END_MAP.put(YES, "出荷済み");
            SHIPMENT_END_MAP.put(PART, "一部出荷");
            SHIPMENT_END_MAP.put(CANCEL, "キャンセル済み");
        }
    }

    /** 取り込み許可区分 */
    public static class importPermitDiv {
        /** 不許可 */
        public static final String OFF = "0";
        /** 許可 */
        public static final String ON = "1";

        /* アラジンECtoB 2ndバージョンリリース #3605 START */
        /** 未処理 */
        public static final String NOT_YET = "0";
        /** 処理中 */
        public static final String IN_PROCESS = "1";
        /** 条件なし */
        public static final String NOT = "9";
        /* アラジンECtoB 2ndバージョンリリース #3605 END */

        /** マップ */
        public static final LinkedHashMap<String, String> INPORT_PERMIT_MAP = new LinkedHashMap<String, String>();
        static {
            INPORT_PERMIT_MAP.put(OFF, "不許可");
            INPORT_PERMIT_MAP.put(ON, "許可");
        }
        /* アラジンECtoB 2ndバージョンリリース #3605 START */
        /** マップ */
        public static final LinkedHashMap<String, String> IMPORT_PERMIT_DIV_MAP = new LinkedHashMap<String, String>();
        static {
            IMPORT_PERMIT_DIV_MAP.put(NOT, "条件なし");
            IMPORT_PERMIT_DIV_MAP.put(NOT_YET, "未処理");
            IMPORT_PERMIT_DIV_MAP.put(IN_PROCESS, "処理中");
        }
        /* アラジンECtoB 2ndバージョンリリース #3605 END */
    }

    public static boolean isSpecialDetail(String itemCd, String chargeFeeItemCd, String deliveryFeeItemCd, String webOrderCampaignCd) {
        if (itemCd.equals(chargeFeeItemCd) || itemCd.equals(deliveryFeeItemCd) || itemCd.equals(webOrderCampaignCd)) {
            return true;
        } else {
            return false;
        }
    }

}
