package jp.ill.photon.module.order;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;

import org.seasar.doma.jdbc.tx.TransactionManager;

import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.dao.DomaConfig;
import jp.ill.photon.dao.JsonDataDao;
import jp.ill.photon.dao.JsonDataDaoImpl;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.model.AoSetting;
import jp.ill.photon.model.CartItem;
import jp.ill.photon.model.DeliveryFee;
import jp.ill.photon.model.Item;
import jp.ill.photon.model.OrderCampaign;
import jp.ill.photon.model.OrderDetail;
import jp.ill.photon.model.SearchForm;
import jp.ill.photon.model.Tax;
import jp.ill.photon.model.TaxSetting;
import jp.ill.photon.model.User;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.db.SqlFileSelectModule;
import jp.ill.photon.module.tax.CalcTaxModule;
import jp.ill.photon.util.AoUtil;
import jp.ill.photon.util.CheckUtil;
import jp.ill.photon.util.DateUtil;
import jp.ill.photon.util.StringUtil;
import jp.ill.photon.util.UtilTools;

public class OrderHisDetailModule extends SqlFileSelectModule {

	/** TODO 親クラスに書かれていれば書かなくてもいいようにしたい */
	@ModuleParam(required = true, domainObject = true)
	private SearchForm searchForm;

	@ModuleParam(required = true)
	private String sqlFileDirPath;

	@ModuleParam(required = true)
	private String sqlFilePath;

	@ModuleParam(required = false)
	@DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.serviceChargeCd.note")
	private String chargeFeeItemCd;

	@ModuleParam(required = false)
	@DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.deliveryFeeItemCd.note")
	private String deliveryFeeItemCd;

	@ModuleParam(required = false)
	@DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.webOrderCampaignItemCd.note")
	private String webOrderCampaignCd;

	@ModuleParam(required = true)
	@DefaultParamSetting(transferType = "dto", transferVal = "common.aladdinsetting")
	private AoSetting aoSetting;

	@ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "order.first")
	private Map<String, Object> orderMap;

	@ModuleParam(required = false)
    @DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.postageFreeThreshold.note")
    private String postageFreeThreshold;

	@ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.verNo.note")
    private String verNo;

	public String getPostageFreeThreshold() {
		return postageFreeThreshold;
	}

	public void setPostageFreeThreshold(String postageFreeThreshold) {
		this.postageFreeThreshold = postageFreeThreshold;
	}

	public Map<String, Object> getOrderMap() {
        return orderMap;
    }

    public void setOrderMap(Map<String, Object> orderMap) {
        this.orderMap = orderMap;
    }

    public String getVerNo() {
        return verNo;
    }

    public void setVerNo(String verNo) {
        this.verNo = verNo;
    }

	public AoSetting getAoSetting() {
		return aoSetting;
	}

	public void setAoSetting(AoSetting aoSetting) {
		this.aoSetting = aoSetting;
	}

	public SearchForm getSearchForm() {
		return searchForm;
	}

	public void setSearchForm(SearchForm searchForm) {
		this.searchForm = searchForm;
	}

	public String getSqlFileDirPath() {
		return sqlFileDirPath;
	}

	public void setSqlFileDirPath(String sqlFileDirPath) {
		this.sqlFileDirPath = sqlFileDirPath;
	}

	public String getSqlFilePath() {
		return sqlFilePath;
	}

	public void setSqlFilePath(String sqlFilePath) {
		this.sqlFilePath = sqlFilePath;
	}

	public String getChargeFeeItemCd() {
		if (chargeFeeItemCd == null) {
			chargeFeeItemCd = "";
		}
		return chargeFeeItemCd;
	}

	public void setChargeFeeItemCd(String chargeFeeItemCd) {
		this.chargeFeeItemCd = chargeFeeItemCd;
	}

	public String getDeliveryFeeItemCd() {
		if (deliveryFeeItemCd == null) {
			deliveryFeeItemCd = "";
		}
		return deliveryFeeItemCd;
	}

	public void setDeliveryFeeItemCd(String deliveryFeeItemCd) {
		this.deliveryFeeItemCd = deliveryFeeItemCd;
	}

	public String getWebOrderCampaignCd() {
		if (webOrderCampaignCd == null) {
			webOrderCampaignCd = "";
		}
		return webOrderCampaignCd;
	}

	public void setWebOrderCampaignCd(String webOrderCampaignCd) {
		this.webOrderCampaignCd = webOrderCampaignCd;
	}

	private boolean isExistDelivery = false;
	private boolean isExistCampaign = false;

	@Override
	public ModuleResult execute(ModuleContext context)
			throws PhotonModuleException {
		ModuleResult result = super.execute(context);

		List<Map<String, Object>> detailList = (List<Map<String, Object>>) result
				.getReturnData().get("list");

		String orderTaxDiv = "1";
		String orderTaxCalcDiv = "1";

		String totalWholeSalePrice = "0";

		String chargeFeeItemCd = getChargeFeeItemCd();
		String deliveryFeeItemCd = getDeliveryFeeItemCd();
		String webOrderCampaignCd = getWebOrderCampaignCd();

		String userCd = (String)orderMap.get("user_cd");
        Map<String, Object> userMap = User.getUserMap(context.getDto(), userCd);

		for (int i = 0; i < detailList.size(); i++) {

			Map<String, Object> detailMap = detailList.get(i);

			String itemCd = (String) detailMap.get("item_cd");

			if (OrderHisListModule.isSpecialDetail(itemCd, chargeFeeItemCd,
					deliveryFeeItemCd, webOrderCampaignCd)) {
				detailMap.put("is_display", "false");
			} else {
				detailMap.put("is_display", "true");
			}

			String priceFractionDiv = "0";
			if (userMap != null) {
				priceFractionDiv = StringUtil.defaultString(
						userMap.getOrDefault("price_fraction_div", "0"), "0");

				result.getReturnData().put("user_map", userMap);
			}

			String subTotalPrice = AoUtil.convAoRoundingSalesPrice(
					String.valueOf(detailMap.get("wholesale_price")),
					String.valueOf(detailMap.get("order_quantity")),
					AoUtil.DispPattern.PATTERN_NO_COMMA,
					aoSetting.getSalesPriceDigitNum(), priceFractionDiv);
			detailMap.put("sub_total", subTotalPrice);

			totalWholeSalePrice = UtilTools.addBigDecimal(totalWholeSalePrice,
					subTotalPrice.toString());

			if (itemCd.equals(chargeFeeItemCd)) {
				detailMap.put("charge_fee", "true");

				result.getReturnData().put("charge_fee",
						String.valueOf(detailMap.get("wholesale_price")));
			} else if (itemCd.equals(deliveryFeeItemCd)) {
			    isExistDelivery = true;

				detailMap.put("delivery_fee", "true");

				result.getReturnData().put("delivery_fee",
						String.valueOf(detailMap.get("wholesale_price")));
			} else if (itemCd.equals(webOrderCampaignCd)) {
			    isExistCampaign = true;

				detailMap.put("campaign_price", "true");

				result.getReturnData().put("campaign_price",
						String.valueOf(detailMap.get("wholesale_price")));
			}

			orderTaxDiv = String.valueOf(detailMap.get("tax_div"));
			orderTaxCalcDiv = String.valueOf(detailMap.get("tax_calc_div"));
		}

		TransactionManager tm = DomaConfig.singleton().getTransactionManager();
		JsonDataDao dao = new JsonDataDaoImpl();
		tm.required(() -> {

		    User user = User.valueOf(userMap);
		    int recordNo = detailList.size();

    		// 配送料とキャンペーンはなかったら足す TODO キャンペーンがまだ
    		if (!isExistDelivery) {
    		    CartItem deliveryFeeItem = new CartItem();
    	        deliveryFeeItem.setItemCd(deliveryFeeItemCd);
    	        deliveryFeeItem.setOrderQuantity(new BigDecimal(1.0));
    	        deliveryFeeItem.setOrderCaseQuantity(new BigDecimal(0.0));
    	        deliveryFeeItem.setRetailPrice(new BigDecimal(0.0));
    	        deliveryFeeItem.setWholesalePrice(new BigDecimal(0.0));
    	        deliveryFeeItem.setQuantityPerCase(new BigDecimal(0.0));

    	        List<Map<String, Object>> itemMap = dao.getItemForOrder(context.getDto().getTenantId(), deliveryFeeItemCd, userCd);
    	        if (itemMap == null || itemMap.isEmpty()) {
    	            return;
    	        }
    	        Item item = Item.valueOf(itemMap.get(0));

    	        TaxSetting taxSetting = getTaxSetting(item, tm, dao, context);

                OrderDetail detail = new OrderDetail((String)detailList.get(0).get("order_no"), ++recordNo, deliveryFeeItem, item, user, aoSetting, userMap);
                Map<String, Object> deliveryDetailMap = detail.toMap();
                deliveryDetailMap.put("delivery_fee", "true");
                deliveryDetailMap.put("is_display", "false");
                deliveryDetailMap.put("sub_total", "0");
                deliveryDetailMap.put("tax_rate", taxSetting != null ? taxSetting.getTaxRate().toString() : (String)detailList.get(0).get("tax_rate"));
                deliveryDetailMap.put("tax_price", "0");

                detailList.add(deliveryDetailMap);
    		}
    		if (!isExistCampaign) {
    		    CartItem campaignItem = new CartItem();
                campaignItem.setItemCd(webOrderCampaignCd);
                campaignItem.setOrderQuantity(new BigDecimal(1.0));
                campaignItem.setOrderCaseQuantity(new BigDecimal(0.0));
                campaignItem.setRetailPrice(new BigDecimal(0.0));
                campaignItem.setWholesalePrice(new BigDecimal(0.0));
                campaignItem.setQuantityPerCase(new BigDecimal(0.0));

                List<Map<String, Object>> itemMap = dao.getItemForOrder(context.getDto().getTenantId(), webOrderCampaignCd, userCd);
                if (itemMap == null || itemMap.isEmpty()) {
                    return;
                }
                Item item = Item.valueOf(itemMap.get(0));

                TaxSetting taxSetting = getTaxSetting(item, tm, dao, context);

                OrderDetail detail = new OrderDetail((String)detailList.get(0).get("order_no"), ++recordNo, campaignItem, item, user, aoSetting, userMap);
                Map<String, Object> campaignDetailMap = detail.toMap();
                campaignDetailMap.put("campaign_price", "true");
                campaignDetailMap.put("is_display", "false");
                campaignDetailMap.put("sub_total", "0");
                campaignDetailMap.put("tax_rate", taxSetting != null ? taxSetting.getTaxRate().toString() : (String)detailList.get(0).get("tax_rate"));
                campaignDetailMap.put("tax_price", "0");

                detailList.add(campaignDetailMap);
    		}
		});

		// 手数料設定を取得しておく
		List<Map<String, Object>> chargeFeeList = tm.required(() -> {
			return dao.getChargeFeeSettingList(context.getDto().getTenantId());
		});

		String chargeFeeTaxRate = Tax.TaxDiv.INCLUDING.equals(orderTaxDiv) ? String.valueOf(1 + CalcTaxModule.getTaxRateFromItemCd(context, chargeFeeItemCd, userCd,  verNo)) : "1";

		for (Map<String, Object> codMap : chargeFeeList) {
			if (Tax.TaxDiv.INCLUDING.equals(orderTaxDiv)) {
        		codMap.put("threshold", new BigDecimal(UtilTools.multiplyBigDecimal(codMap.get("threshold").toString(), String.valueOf(chargeFeeTaxRate))));
        	}
		}

		result.getReturnData().put("cod_fee_list", chargeFeeList);
		result.getReturnData().put("charge_fee_taxrate", chargeFeeTaxRate);

		// キャンペン手数料と比率を取得しておく TODO 共通化したい
		Timestamp orderDate = DateUtil.toSqlTimestamp((String)orderMap.get("order_date"));
		OrderCampaign orderCampaign = tm.required(() -> {
			List<Map<String, Object>> campaignMap = dao
					.getWebCampaignListForOrderHisInfo(context.getDto().getTenantId(), orderDate);
			if (campaignMap == null || campaignMap.isEmpty()) {
				return null;
			} else {
				return OrderCampaign.valueOf(campaignMap.get(0));
			}
		});
		String discountRate = "";
		String discountPrice = "";
		String discountAmountBorder = "0";
		String discountFreeTaxRate = Tax.TaxDiv.INCLUDING.equals(orderTaxDiv) ? String.valueOf(1 + CalcTaxModule.getTaxRateFromItemCd(context, webOrderCampaignCd, userCd,  verNo)) : "1";

		if (orderCampaign != null) {
			// 割合値引
			if (orderCampaign.getDiscountRate() != null) {
				if (orderCampaign.getDiscountRate()
						.compareTo(BigDecimal.ZERO) == 0) {
					discountRate = "0";
				} else {
					discountRate = orderCampaign.getDiscountRate()
							.multiply(new BigDecimal("0.01")).toString();
				}
			}

			discountAmountBorder = orderCampaign.getDiscountAmountBorder()
					.toString();
			discountAmountBorder = Tax.TaxDiv.INCLUDING.equals(orderTaxDiv) ? UtilTools.multiplyBigDecimal(discountAmountBorder, discountFreeTaxRate) : discountAmountBorder;

			// 固定値引
			discountPrice = String
					.valueOf(orderCampaign.getFixedDiscountPrice());
		}

		result.getReturnData().put("discount_rate", discountRate);
		result.getReturnData().put("discount_price", discountPrice);


		result.getReturnData().put("discount_amount_border",
				discountAmountBorder);
		result.getReturnData().put("discount_taxrate", discountFreeTaxRate);

		// 配送料を取得しておく
		DeliveryFee deliveryFee = CalcDeliveryFeeModule
				.getMatchingDeliveryFeeCd(context, (String)orderMap.getOrDefault("city_name1", ""),
				        (String)orderMap.getOrDefault("city_name2", ""), (String)orderMap.getOrDefault("city_name3", ""));

		if (deliveryFee != null) {
			result.getReturnData().put("delivery_fee_map", deliveryFee.toMap());
		}

		String deliveryFeeTaxRate = Tax.TaxDiv.INCLUDING.equals(orderTaxDiv) ? String.valueOf(1 + CalcTaxModule.getTaxRateFromItemCd(context, deliveryFeeItemCd, userCd,  verNo)) : "1";
		result.getReturnData().put("delivery_fee_taxrate", deliveryFeeTaxRate);

		if (Tax.TaxDiv.INCLUDING.equals(orderTaxDiv) && !CheckUtil.isEmpty(postageFreeThreshold)) {
			postageFreeThreshold = UtilTools.multiplyBigDecimal(postageFreeThreshold, String.valueOf(deliveryFeeTaxRate));
		}
		result.getReturnData().put("postage_fee_threshold", postageFreeThreshold);

		result.getReturnData().put("tax_div", orderTaxDiv);
		result.getReturnData().put("tax_calc_div", orderTaxCalcDiv);

		return result;
	}

	/**
     * AO12 軽減税率非対応版判定
     */
    public boolean isVer12() {
        return "1.2notax".equals(getVerNo());
    }

	private TaxSetting getTaxSetting(Item item, TransactionManager tm, JsonDataDao dao, ModuleContext context) {
	    Timestamp nowDate = new Timestamp(System.currentTimeMillis());
	    TaxSetting taxSetting = null;

	    if (isVer12()) {
	        taxSetting = tm.required(() -> {
	            List<Map<String, Object>> taxMap = dao.getTaxRateByDate(
	                    context.getDto().getTenantId(),
	                    nowDate);
	            if (taxMap == null || taxMap.isEmpty()) {
	                return null;
	            } else {
	                if (taxMap.size() > 1) {
	                    return null;
	                } else {
	                    return TaxSetting.valueOf(taxMap.get(0));
	                }
	            }
	        });
	    } else {
	        taxSetting = tm.required(() -> {
	            List<Map<String, Object>> taxMap = dao.getTaxSettingByTaxDivCd(
	                    context.getDto().getTenantId(),
	                    String.valueOf(item.getTaxBracketCd()),
	                    nowDate);
	            if (taxMap == null || taxMap.isEmpty()) {
	                return null;
	            } else {
	                if (taxMap.size() > 1) {
	                    return null;
	                } else {
	                    return TaxSetting.valueOf(taxMap.get(0));
	                }
	            }
	        });
	    }

	    return taxSetting;
	}

}
