package jp.ill.photon.module.order;

import java.util.HashMap;
import java.util.Map;

import org.seasar.doma.jdbc.tx.TransactionManager;

import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.dao.DomaConfig;
import jp.ill.photon.dao.JsonDataDao;
import jp.ill.photon.dao.JsonDataDaoImpl;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.JsonUtil;

public class OrderDeleteModule implements PhotonModule {

    @ModuleParam(required = false)
    @DefaultParamSetting(transferType = "param", transferVal = "orderNo")
    private String orderNo;

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public ModuleResult execute(ModuleContext context) {
        ModuleResult moduleResult = new ModuleResult();

        TransactionManager tm = DomaConfig.singleton().getTransactionManager();
        JsonDataDao dao = new JsonDataDaoImpl();

        tm.required(() -> {
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("order_no", orderNo);
            String where = JsonUtil.mapToJson(map);

            dao.deleteEditTableData(context.getDto().getTenantId(), "order", where);
            dao.deleteOrderDetail(context.getDto().getTenantId(), orderNo);
        });

        return moduleResult;
    }

}
