package jp.ill.photon.module.order;

import java.io.File;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.seasar.doma.jdbc.tx.TransactionManager;
import org.springframework.util.CollectionUtils;

import jp.ill.photon.action.ActionDispatcher;
import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.dao.DomaConfig;
import jp.ill.photon.dao.JsonDataDao;
import jp.ill.photon.dao.JsonDataDaoImpl;
import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.model.AoSetting;
import jp.ill.photon.model.CartItem;
import jp.ill.photon.model.Delivery;
import jp.ill.photon.model.Item;
import jp.ill.photon.model.Order;
import jp.ill.photon.model.OrderDetail;
import jp.ill.photon.model.OrderSummary;
import jp.ill.photon.model.Payment;
import jp.ill.photon.model.SystemSetting;
import jp.ill.photon.model.SystemSetting.CaseNumDiv;
import jp.ill.photon.model.TmpOrder;
import jp.ill.photon.model.TmpOrderDetail;
import jp.ill.photon.model.User;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.CheckUtil;
import jp.ill.photon.util.EditTableUtil;
import jp.ill.photon.util.FileUtil;
import jp.ill.photon.util.JsonUtil;
import jp.ill.photon.util.LogUtil;
import jp.ill.photon.util.ParamUtil;
import jp.ill.photon.util.SQLUtil;
import jp.ill.photon.util.StringUtil;


public class OrderCreateModule implements PhotonModule {

    @ModuleParam(required = true, paramGroup=true)
    private Order order = new Order();

    @ModuleParam(required = true, paramGroup=true)
    private Delivery delivery = new Delivery();

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "got_session.userForm.user_cd")
    private String userCd;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "got_session_charge.userChargeForm.user_charge_id")
    private int userChargeId;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.caseNumDiv.note")
    private String caseNumDiv;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.orderHistoryRetentionPeriod.note")
    private String orderHistoryRetentionPeriod;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.orderDataImportDiv.note")
    private String orderDataImportDiv;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType="dto", transferVal="common.aladdinsetting")
    private AoSetting aoSetting;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType="dto", transferVal="common.systemsetting")
    private SystemSetting systemSetting;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "cart.list")
    private List<Map<String, Object>> cartList;

    @ModuleParam(required = false)
    @DefaultParamSetting(transferType = "dto", transferVal = "tax.total_tax_price")
    private String totalTaxPrice;

    @ModuleParam(required = false)
    @DefaultParamSetting(transferType = "dto", transferVal = "tax.total_tax_price_for_sum")
    private String totalTaxPriceForSum;

    @ModuleParam(required = false)
    @DefaultParamSetting(transferType = "param", transferVal = "tmp_order_no")
    private String tmpOrderNo;

    @ModuleParam(required = false)
    @DefaultParamSetting(transferType = "dto", transferVal = "tax.delivery_fee")
    private Map<String, Object> deliveryFee;

    @ModuleParam(required = false)
    @DefaultParamSetting(transferType = "dto", transferVal = "tax.charge_fee")
    private Map<String, Object> chargeFee;

    @ModuleParam(required = false)
    @DefaultParamSetting(transferType = "dto", transferVal = "smbc_pre.shop_order_no")
    private String shopOrderNo;

    @ModuleParam(required = false)
    @DefaultParamSetting(transferType = "dto", transferVal = "smbc_pre.payout_no1_name")
    private String payoutNo1Name;

    @ModuleParam(required = false)
    @DefaultParamSetting(transferType = "dto", transferVal = "smbc_pre.payout_no1_value")
    private String payoutNo1Value;

    @ModuleParam(required = false)
    @DefaultParamSetting(transferType = "dto", transferVal = "smbc_pre.payout_no2_name")
    private String payoutNo2Name;

    @ModuleParam(required = false)
    @DefaultParamSetting(transferType = "dto", transferVal = "smbc_pre.payout_no2_value")
    private String payoutNo2Value;

    @ModuleParam(required = false)
    @DefaultParamSetting(transferType = "dto", transferVal = "smbc_pre.payout_no3_name")
    private String payoutNo3Name;

    @ModuleParam(required = false)
    @DefaultParamSetting(transferType = "dto", transferVal = "smbc_pre.payout_no3_value")
    private String payoutNo3Value;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "got_session_charge.userChargeForm.user_charge_name")
    private String userChargeName;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "user.first")
    private Map<String, Object> userForm;

	@ModuleParam(required = false)
	@DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.webOrderCampaignItemCd.note")
	private String webOrderCampaignCd;

    @ModuleParam(required = false)
    private List<Map<String, Object>> orderExtSettingMapList;

    @ModuleParam(required = false)
    private List<Map<String, Object>> orderDetailExtSettingMapList;

    @ModuleParam(required = false)
    private Map<String, Object> orderExtValueMap;

    @ModuleParam(required = false)
    private List<Map<String, Object>> orderDetailExtValueMapList;


    public String getWebOrderCampaignCd() {
		return webOrderCampaignCd;
	}

	public void setWebOrderCampaignCd(String webOrderCampaignCd) {
		this.webOrderCampaignCd = webOrderCampaignCd;
	}

	public Map<String, Object> getUserForm() {
        return userForm;
    }

    public void setUserForm(Map<String, Object> userForm) {
        this.userForm = userForm;
    }

    public String getPayoutNo1Name() {
        return payoutNo1Name;
    }

    public void setPayoutNo1Name(String payoutNo1Name) {
        this.payoutNo1Name = payoutNo1Name;
    }

    public String getPayoutNo1Value() {
        return payoutNo1Value;
    }

    public void setPayoutNo1Value(String payoutNo1Value) {
        this.payoutNo1Value = payoutNo1Value;
    }

    public String getPayoutNo2Name() {
        return payoutNo2Name;
    }

    public void setPayoutNo2Name(String payoutNo2Name) {
        this.payoutNo2Name = payoutNo2Name;
    }

    public String getPayoutNo2Value() {
        return payoutNo2Value;
    }

    public void setPayoutNo2Value(String payoutNo2Value) {
        this.payoutNo2Value = payoutNo2Value;
    }

    public String getPayoutNo3Name() {
        return payoutNo3Name;
    }

    public void setPayoutNo3Name(String payoutNo3Name) {
        this.payoutNo3Name = payoutNo3Name;
    }

    public String getPayoutNo3Value() {
        return payoutNo3Value;
    }

    public void setPayoutNo3Value(String payoutNo3Value) {
        this.payoutNo3Value = payoutNo3Value;
    }

    public String getShopOrderNo() {
        return shopOrderNo;
    }

    public void setShopOrderNo(String shopOrderNo) {
        this.shopOrderNo = shopOrderNo;
    }

    public Map<String, Object> getChargeFee() {
        return chargeFee;
    }

    public void setChargeFee(Map<String, Object> chargeFee) {
        this.chargeFee = chargeFee;
    }

    public String getTotalTaxPriceForSum() {
        return totalTaxPriceForSum;
    }

    public void setTotalTaxPriceForSum(String totalTaxPriceForSum) {
        this.totalTaxPriceForSum = totalTaxPriceForSum;
    }

    public Map<String, Object> getDeliveryFee() {
        return deliveryFee;
    }

    public void setDeliveryFee(Map<String, Object> deliveryFee) {
        this.deliveryFee = deliveryFee;
    }

    public String getTmpOrderNo() {
        return tmpOrderNo;
    }

    public void setTmpOrderNo(String tmpOrderNo) {
        this.tmpOrderNo = tmpOrderNo;
    }

    public List<Map<String, Object>> getCartList() {
        return cartList;
    }

    public void setCartList(List<Map<String, Object>> cartList) {
        this.cartList = cartList;
    }

    public String getTotalTaxPrice() {
        return totalTaxPrice;
    }

    public void setTotalTaxPrice(String totalTaxPrice) {
        this.totalTaxPrice = totalTaxPrice;
    }

    public AoSetting getAoSetting() {
        return aoSetting;
    }

    public void setAoSetting(AoSetting aoSetting) {
        this.aoSetting = aoSetting;
    }

    public SystemSetting getSystemSetting() {
        return systemSetting;
    }

    public void setSystemSetting(SystemSetting systemSetting) {
        this.systemSetting = systemSetting;
    }

    public String getCaseNumDiv() {
        return caseNumDiv;
    }

    public void setCaseNumDiv(String caseNumDiv) {
        this.caseNumDiv = caseNumDiv;
    }

    public String getUserCd() {
        return userCd;
    }

    public void setUserCd(String userCd) {
        this.userCd = userCd;
    }

    public int getUserChargeId() {
        return userChargeId;
    }

    public void setUserChargeId(int userChargeId) {
        this.userChargeId = userChargeId;
    }

    public Order getOrder() {
        return order;
    }

    public void setOrder(Order order) {
        this.order = order;
    }

    public Delivery getDelivery() {
        return delivery;
    }

    public void setDelivery(Delivery delivery) {
        this.delivery = delivery;
    }

    public String getOrderHistoryRetentionPeriod() {
        return orderHistoryRetentionPeriod;
    }

    public void setOrderHistoryRetentionPeriod(String orderHistoryRetentionPeriod) {
        this.orderHistoryRetentionPeriod = orderHistoryRetentionPeriod;
    }

    public String getOrderDataImportDiv() {
        return orderDataImportDiv;
    }

    public void setOrderDataImportDiv(String orderDataImportDiv) {
        this.orderDataImportDiv = orderDataImportDiv;
    }

    public List<Map<String, Object>> getOrderExtSettingMapList() {
        return orderExtSettingMapList;
    }

    public void setOrderExtSettingMapList(List<Map<String, Object>> orderExtSettingMapList) {
        this.orderExtSettingMapList = orderExtSettingMapList;
    }

    public List<Map<String, Object>> getOrderDetailExtSettingMapList() {
        return orderDetailExtSettingMapList;
    }

    public void setOrderDetailExtSettingMapList(List<Map<String, Object>> orderDetailExtSettingMapList) {
        this.orderDetailExtSettingMapList = orderDetailExtSettingMapList;
    }

    public Map<String, Object> getOrderExtValueMap() {
        return orderExtValueMap;
    }

    public void setOrderExtValueMap(Map<String, Object> orderExtValueMap) {
        this.orderExtValueMap = orderExtValueMap;
    }

    public List<Map<String, Object>> getOrderDetailExtValueMapList() {
        return orderDetailExtValueMapList;
    }

    public void setOrderDetailExtValueMapList(List<Map<String, Object>> orderDetailExtValueMapList) {
        this.orderDetailExtValueMapList = orderDetailExtValueMapList;
    }

    // Module内で使用する変数
    /** ログ用変数 */
    protected final LogUtil logger = new LogUtil(ActionDispatcher.class);

    /** DTO */
    ActionDto dto;

    /** テナントID */
    String tenantId;

    public ModuleResult execute(ModuleContext context)
            throws PhotonModuleException {
        ModuleResult moduleResult = new ModuleResult();

        dto = context.getDto();
        tenantId = dto.getTenantId();

        TransactionManager tm = DomaConfig.singleton().getTransactionManager();
        JsonDataDao dao = new JsonDataDaoImpl();

        // TODO トランザクションに入れたほうがいいか？
        User user = User.getUser(dto, userCd);

        // 登録日時
        Timestamp nowDate = new Timestamp(System.currentTimeMillis());

        // 仮注文データからカートや注文情報を復元
        if (tmpOrderNo != null) {

            TmpOrder tmpOrder = tm.required(() -> {
                List<Map<String, Object>> tmpOrderMap = dao.getTmpOrder(tenantId, tmpOrderNo);
                if (tmpOrderMap == null || tmpOrderMap.isEmpty()) {
                    return null;
                }
                else {
                    return TmpOrder.valueOf(tmpOrderMap.get(0));
                }
            });

            logger.info(String.format("仮注文データ中の受注見出拡張項目を読み込み　仮注文No：%s", tmpOrderNo));
            List<Map<String, Object>> list = tm.required(() -> {
                return dao.getTmpOrderExt(tenantId, tmpOrderNo);
            });

            if (!CollectionUtils.isEmpty(list)) {

                logger.info("orderExtValueMapの中身を仮注文受注見出拡張項目から取得したデータで上書き");
                orderExtValueMap = new HashMap<String, Object>();

                for (Map<String, Object> mp : list) {

                    String key = (String)mp.get("tmp_order_ext_col_cd");
                    orderExtValueMap.put( key, new HashMap<String, Object>(){{
                        put("type", "static");
                        put("val", mp.get("tmp_order_ext_value"));
                    }});
                    orderExtValueMap.put( key + ".saved_ext_file_name", new HashMap<String, Object>(){{
                        put("type", "static");
                        put("val", mp.get("tmp_order_ext_file_name"));
                    }});
                    orderExtValueMap.put( key + ".saved_ext_full_path", new HashMap<String, Object>(){{
                        put("type", "static");
                        put("val", mp.get("tmp_order_ext_file_path"));
                    }});
                    orderExtValueMap.put( key + ".separator", new HashMap<String, Object>(){{
                        put("type", "static");
                        put("val", mp.get("tmp_order_ext_value_separator"));
                    }});

                }
            }

            order.setWishingShipmentDate(tmpOrder.getWishingShipmentDate());
            order.setUserOrderNo(tmpOrder.getUserOrderNo());
            order.setRemarks(tmpOrder.getRemarks());
            order.setPaymentCd(tmpOrder.getPaymentCd());
            order.setConveniencePaymentCd(tmpOrder.getConveniencePaymentCd());
            order.setCreditPaymentMethodCd(tmpOrder.getCreditPaymentMethodCd());
            order.setCreditNumberOfPaymentCd(tmpOrder.getCreditNumberOfPaymentCd());
            order.setAreaName(tmpOrder.getAreaName());
            order.setDeliveryFeeCd(tmpOrder.getDeliveryFeeCd());
            order.setPaymentName(tmpOrder.getPaymentName());

            delivery.setUserDeliveryCd(tmpOrder.getUserDeliveryCd());
            delivery.setUserDeliveryName1(tmpOrder.getUserDeliveryName1());
            delivery.setUserDeliveryName2(tmpOrder.getUserDeliveryName2());
            delivery.setZip(tmpOrder.getZip());
            delivery.setTel(tmpOrder.getTel());
            delivery.setFax(tmpOrder.getFax());
            delivery.setCityName1(tmpOrder.getCityName1());
            delivery.setCityName2(tmpOrder.getCityName2());
            delivery.setCityName3(tmpOrder.getCityName3());

            String[] cartIds = tm.required(() -> {
                List<Map<String, Object>> tmpDetailMap = dao.getTmpOrderDetail(tenantId, tmpOrderNo);
                if (tmpDetailMap == null || tmpDetailMap.isEmpty()) {
                    return new String[]{};
                }
                else {
                    ArrayList<String> ids = new ArrayList<String>();
                    for (Map<String, Object> detailMap : tmpDetailMap) {
                        TmpOrderDetail detail = TmpOrderDetail.valueOf(detailMap);
                        ids.add(detail.getCartId().toString());
                    }
                    return ids.toArray(new String[ids.size()]);
                }
            });

            logger.info(String.format("仮注文データ中の受注明細拡張項目を読み込み　仮注文No：%s", tmpOrderNo));
            List<Map<String, Object>> listDetail = tm.required(() -> {
                    return dao.getTmpOrderDetailExt(tenantId, tmpOrderNo);
            });
            if (!CollectionUtils.isEmpty(listDetail)) {

                // 値のコンバート
                SQLUtil.convertDbValues(listDetail);

                logger.info("orderDetailExtValueMapListの中身を仮注文受注明細拡張項目から取得したデータで上書き");
                orderDetailExtValueMapList = new ArrayList<Map<String, Object>>();

                for (Map<String, Object> mp : listDetail) {

                    // String no = Integer.toString(i);
                    String no = Integer.toString(StringUtil.toInteger((String) mp.get("record_no")) - 1);

                    orderDetailExtValueMapList.add(new HashMap<String, Object>(){{
                        put( "idx", new HashMap<String, Object>(){{
                            put("type", "static");
                            put("val", no);
                        }});
                        String key = (String)mp.get("tmp_order_detail_ext_col_cd");
                        put( key, new HashMap<String, Object>(){{
                            put("type", "static");
                            put("val", mp.get("tmp_order_detail_ext_value"));
                        }});
                        put( key + ".saved_ext_file_name", new HashMap<String, Object>(){{
                            put("type", "static");
                            put("val", mp.get("tmp_order_detail_ext_file_name"));
                        }});
                        put( key + ".saved_ext_full_path", new HashMap<String, Object>(){{
                            put("type", "static");
                            put("val", mp.get("tmp_order_detail_ext_file_path"));
                        }});
                        put( key + ".separator", new HashMap<String, Object>(){{
                            put("type", "static");
                            put("val", mp.get("tmp_order_detail_ext_value_separator"));
                        }});
                    }});

                }
            }

            order.setCartId(cartIds);

        }

        int result = tm.required(() -> {

            // OrderNoの採番と採番テーブルの更新
            List<Map<String, Object>> seqMap = dao.getSeqSfNextVal(tenantId, "order", "order_no");
            if (seqMap == null || seqMap.isEmpty()) {
                return -1;
            }
            Integer orderNoRow = Integer.valueOf(String.valueOf(seqMap.get(0).get("seq")));
            String orderNo = String.format("%08d", orderNoRow);

            int recordNo = 0;

            OrderSummary summary = new OrderSummary();
            List<OrderDetail> orderDetails = new ArrayList<OrderDetail>();

            // パラメータから来たカート情報をマップにセットしておく
            Map<String, CartItem> paramCartMap = new HashMap<String, CartItem>();
            for (Map<String, Object> paramCart : cartList) {
                CartItem item = CartItem.valueOf(paramCart);
                paramCartMap.put(item.getCartId().toString(), item);
            }

            // パラメータのカートIDごとに処理
            for (int i = 0; i < order.getCartId().length; i++) {

                String cartId = order.getCartId()[i];

                // レコードNoをカウントアップ
                recordNo++;

                // カート情報をDBから取得して、該当カートレコードをロック
                CartItem cart = null;
                List<Map<String, Object>> cartMap = dao.getCartForOrder(tenantId, cartId, userCd, String.valueOf(userChargeId));
                if (cartMap == null || cartMap.isEmpty()) {
                    if (paramCartMap.get(cartId) == null) {
                        return -1;
                    } else {
                        // キャンペーンの場合
                        cart = paramCartMap.get(cartId);
                    }
                } else {
                    cart = CartItem.valueOf(cartMap.get(0));
                }

                // 明細消費税を取得してセット
                CartItem paramCart = paramCartMap.get(cart.getCartId().toString());
                if (paramCart != null) {
                    cart.setTaxPrice(paramCart.getTaxPrice());
                    cart.setTaxRate(paramCart.getTaxRate());
                }

                Item item = summary.sumOrderDetail(context, dao, cart, userCd, aoSetting, null, null, userForm, cart.getItemCd().equals(webOrderCampaignCd));

                // ケース数入力が管理画面などからOFFに変更されており、かつケース数1以上の注文が含まれていれば
                // その注文は削除してスキップ
                if (CaseNumDiv.OFF.equals(caseNumDiv)
                        && cart.getOrderCaseQuantity().compareTo(
                                BigDecimal.ZERO) != 0) {
                    dao.deleteCartItem(tenantId, cartId, userCd, String.valueOf(userChargeId));
                    continue;
                }

                OrderDetail detail = new OrderDetail(orderNo, recordNo, cart, item, user, aoSetting, userForm);
                if (item.getItemCd().equals(webOrderCampaignCd)) {
                	detail.setWebPriceUseDiv(1);
                }
                // コンビニ決済、クレジット決済ではすべての明細でWEB単価採用区分を1にする
                if (order.isConvenienceSelected() || order.isCreditSelected()) {
                	detail.setWebPriceUseDiv(1);
                }
                orderDetails.add(detail);

                // カート削除
                dao.deleteCartItem(tenantId, cartId, userCd, String.valueOf(userChargeId));
            }

            // 配送料
            if (deliveryFee != null) {
                CartItem deliveryFeeItem = CartItem.valueOf(deliveryFee);
                Item item = summary.sumOrderDetail(context, dao, deliveryFeeItem, userCd, aoSetting, null, null, userForm, true);
                OrderDetail detail = new OrderDetail(orderNo, ++recordNo, deliveryFeeItem, item, user, aoSetting, userForm);
                detail.setWebPriceUseDiv(1);
                orderDetails.add(detail);
            }

            // 手数料
            if (chargeFee != null) {
                CartItem chargeFeeItem = CartItem.valueOf(chargeFee);
                Item item = summary.sumOrderDetail(context, dao, chargeFeeItem, userCd, aoSetting, null, null, userForm, true);
                OrderDetail detail = new OrderDetail(orderNo, ++recordNo, chargeFeeItem, item, user, aoSetting, userForm);
                detail.setWebPriceUseDiv(1);
                orderDetails.add(detail);
            }

            // 受注明細登録
            for (OrderDetail detail : orderDetails) {
                String detailMapStr = JsonUtil.mapToJsonSnakeCaseKey(detail);
                Map<String, Object> detailMap = JsonUtil.jsonToMap(detailMapStr);
                try {
                    dao.insertEditTableData(tenantId, "orderdetail", user.getUserCd(), detailMapStr);
                    logger.info(String.format("登録した受注明細に拡張項目の値をUPDATEする　注文No：%s、行No：%s", orderNo, Integer.toString(detail.getRecordNo())));
                    Map<String, Object> afterData = dao.selectEditTableDataFromJson(tenantId, "orderdetail", detailMapStr);
                    if (!MapUtils.isEmpty(afterData)) {
                        String guid = StringUtil.defaultString(afterData.get("guid"), "");
                        if (!StringUtils.isEmpty(guid)) {
                            detailMap.put("guid", guid);
                        }
                    }
                    updateOrderDetailExt(dao, orderNo, detail.getRecordNo(), JsonUtil.mapToJson(detailMap));
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }

            // 消費税
            if (totalTaxPrice != null) {
                order.setTaxPrice(new BigDecimal(totalTaxPrice));
            }

            // 受注見出し登録
            SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            if (!order.isCreditSelected()) {
                order.setCreditPaymentMethodCd(null);
                order.setCreditNumberOfPaymentCd(null);
            } else {
                if (!Payment.CreditPaymentMethod.BUNKAtSU.equals(order.getCreditPaymentMethodCd())) {
                    order.setCreditNumberOfPaymentCd(null);
                }
            }
            if (!order.isConvenienceSelected()) {
                order.setConveniencePaymentCd(null);
            }

            order.setOrderNo(orderNo);
            order.setOrderDate(df.format(nowDate));
            order.setUser(user);
            order.setOrderMakeUserChargeId(String.valueOf(userChargeId));
            order.setDelivery(delivery);
            order.setWholesalePrice(new BigDecimal(summary.getSumWholesalePrice()));
            order.setRetailPrice(new BigDecimal(summary.getSumRetailPrice()));
            order.setTotalOrderQuantity(CartItem.getOrderQuantityFormat(new BigDecimal(summary.getTotalQuantity()), aoSetting) );
            order.setTotalShipmentQuantity(CartItem.getOrderQuantityFormat(new BigDecimal(0.0), aoSetting));
            order.setTotalUnshippedQuantity(CartItem.getOrderQuantityFormat(new BigDecimal(summary.getTotalQuantity()), aoSetting) );
            order.setUserSiteDispEndTime(df.format(getUserSiteDispEndTime(orderHistoryRetentionPeriod, nowDate)));
            order.setImportPermitDiv(getImportPermitDiv(orderDataImportDiv));
            order.setUserChargeName(userChargeName);

            String orderMapStr = JsonUtil.mapToJsonSnakeCaseKey(order.toMap());
            Map<String, Object> orderMap = JsonUtil.jsonToMap(orderMapStr);
            try {
                dao.insertEditTableData(tenantId, "order", user.getUserCd(), orderMapStr);
                logger.info(String.format("登録した受注見出に拡張項目の値をUPDATEする　注文No：%s", orderNo));
                Map<String, Object> afterData = dao.selectEditTableDataFromJson(tenantId, "order", orderMapStr);
                if (!MapUtils.isEmpty(afterData)) {
                    String guid = StringUtil.defaultString(afterData.get("guid"), "");
                    if (!StringUtils.isEmpty(guid)) {
                    	orderMap.put("guid", guid);
                    }
                }
                updateOrderExt(dao, orderNo, JsonUtil.mapToJson(orderMap));
            } catch (Exception ex) {
                ex.printStackTrace();
            }

            // 請求情報登録
            if (order.isConvenienceSelected() || order.isCreditSelected()) {
                Map<String, Object> shopOrder = new HashMap<String, Object>();

                shopOrder.put("order_no", orderNo);
                shopOrder.put("shoporder_no", shopOrderNo);
                shopOrder.put("payment_cd", order.getPaymentCd());
                shopOrder.put("billing_amount", order.getTaxWholesalePrice(String.valueOf(totalTaxPriceForSum)).toString());

                int status = 0;
                if (order.isConvenienceSelected()) {
                    shopOrder.put("payout_no_1_name", payoutNo1Name);
                    shopOrder.put("payout_no_1_value", payoutNo1Value);
                    shopOrder.put("payout_no_2_name", payoutNo2Name);
                    shopOrder.put("payout_no_2_value", payoutNo2Value);
                    shopOrder.put("payout_no_3_name", payoutNo3Name);
                    shopOrder.put("payout_no_3_value", payoutNo3Value);
                    status = 1;
                }

                shopOrder.put("status", status);

                try {
                    dao.insertEditTableData(tenantId, "shoporder", user.getUserCd(), JsonUtil.mapToJsonSnakeCaseKey(shopOrder));
                } catch (Exception ex) {
                    ex.printStackTrace();
                }

                if (payoutNo1Name != null && !"".equals(payoutNo1Name)) {
                    shopOrder.put("is_payout_no1_disp", true);
                }
                if (payoutNo2Name != null && !"".equals(payoutNo2Name)) {
                    shopOrder.put("is_payout_no2_disp", true);
                }
                if (payoutNo3Name != null && !"".equals(payoutNo3Name)) {
                    shopOrder.put("is_payout_no3_disp", true);
                }

                moduleResult.getReturnData().put("shop_order", shopOrder);
            }

            return 0;
        });

        moduleResult.getReturnData().put("order", order.toMap());

        return moduleResult;
    }

    public static int getImportPermitDiv(String orderDataImportDiv) {
        if (Order.takeInType.SELECT.equals(orderDataImportDiv)) {
            // 注文データ取込方式が選択の場合
            return Integer.parseInt(Order.importPermitDiv.OFF);
        } else {
            // 注文データ取込方式が自動の場合
            return Integer.parseInt(Order.importPermitDiv.ON);
        }
    }

    public static Timestamp getUserSiteDispEndTime(String orderHistoryRetentionPeriod, Timestamp nowDate) {
        if (!CheckUtil.isEmpty(orderHistoryRetentionPeriod)) {
            int amount = Integer.parseInt(orderHistoryRetentionPeriod);
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(nowDate.getTime());
            cal.add(Calendar.DAY_OF_MONTH, amount);
            Timestamp userSiteDispEndTime = new Timestamp(
                    cal.getTimeInMillis());
            return userSiteDispEndTime;
        } else {
            // ここには来ないはず
            return nowDate;
        }
    }

    /***
     *
     * 受注見出の拡張項目で入力された値を更新
     *
     * @param dao
     * @param orderNo
     * @param data
     */
    private void updateOrderExt(JsonDataDao dao, String orderNo, String data) {

        if (CollectionUtils.isEmpty(orderExtSettingMapList)) {
            logger.info("　受注見出拡張項目設定データ（order_ext_setting_map_list）にデータが入っていないため、受注見出拡張項目の更新は行わない");
            return;
        }

        logger.info("　受注見出拡張項目設定データ（order_ext_setting_map_list）にデータが入っている");

        Map<String, Object> updateMap = new HashMap<String, Object>();

        for (Map<String, Object> orderExtSetting : orderExtSettingMapList) {

            String colCd = (String) orderExtSetting.get("col_cd");
            String dataInputType = (String) orderExtSetting.get("data_input_type");
            String value = "";

            // 対応する値を取得
            Map<String, Object> orderExtValues = null;
            if (orderExtValueMap != null) {

                logger.info("　受注見出拡張項目値マップ（order_ext_value_map）にデータが入っている");

                orderExtValues = new HashMap<String, Object>();
                orderExtValues.put("value",
                        ParamUtil.getParamObjectValueByType(orderExtValueMap.get(colCd), dto));
                if (EditTableUtil.DataInputType.FILE.equals(dataInputType)) {
                    orderExtValues.put("saved_ext_file_name",
                            ParamUtil.getParamObjectValueByType(
                                    orderExtValueMap.get(colCd + ".saved_ext_file_name"), dto));
                    orderExtValues.put("saved_ext_full_path",
                            ParamUtil.getParamObjectValueByType(
                                    orderExtValueMap.get(colCd + ".saved_ext_full_path"), dto));
                } else if (EditTableUtil.DataInputType.CHECKBOX.equals(dataInputType) ||
                        EditTableUtil.DataInputType.LISTBOX.equals(dataInputType)) {
                    orderExtValues.put("separator",
                            ParamUtil.getParamObjectValueByType(
                                    orderExtValueMap.get(colCd + ".separator"), dto));
                }
                if (orderExtValues != null) {
                    value = getStrValue(orderExtValues);
                }
            }

            // --------------------------------
            // ファイルアップロード
            // --------------------------------
            if (EditTableUtil.DataInputType.FILE.equals(dataInputType)) {

                // ファイルを登録できたら、そのファイル名を値として保存すること
                logger.info(String.format("　受注見出拡張項目ファイルアップロード　カラムコード：%s", colCd));
                String fileName = uploadFile(dao, "order", data, orderExtSetting, orderExtValues);
                if (!StringUtils.isEmpty(fileName)) {
                    value = fileName;
                }

            }

            // updateのためのパラメータ
            updateMap.put(colCd, value);

        }

        logger.info(String.format("　更新対象の値セット：%s ", updateMap));
        if (!MapUtils.isEmpty(updateMap)) {
            // 更新
            updateMap.put("order_no", orderNo);
            dao.updateEditTableData(tenantId, "order", userCd, JsonUtil.mapToJson(updateMap));
            ;
        }

    }

    /***
     *
     * 受注明細の拡張項目で入力された値を更新
     *
     * @param dao
     * @param orderNo
     * @param recordNo
     * @param data
     */
    private void updateOrderDetailExt(JsonDataDao dao, String orderNo, int recordNo, String data) {

        Map<String, Object> updateMap = new HashMap<String, Object>();

        if (CollectionUtils.isEmpty(orderDetailExtSettingMapList)) {
            logger.info("　受注明細拡張項目設定データ（order_detail_ext_setting_map_list）がデータが入っていないため、受注明細拡張項目の更新は行わない");
            return;
        }

        logger.info("　受注明細拡張項目設定データ（order_detail_ext_setting_map_list）にデータが入っている");

        for (Map<String, Object> orderDetailExtSetting : orderDetailExtSettingMapList) {

            String colCd = (String) orderDetailExtSetting.get("col_cd");
            String dataInputType = (String) orderDetailExtSetting.get("data_input_type");
            String value = "";

            // 対応する値を取得
            Map<String, Object> orderDetailExtValues = null;
            if (orderDetailExtValueMapList != null) {

                logger.info("　受注明細拡張項目値マップリスト（order_detail_ext_value_map_list）にデータが入っている");

                for (Map<String, Object> item : orderDetailExtValueMapList) {
                    orderDetailExtValues = new HashMap<String, Object>();
                    String idx = ParamUtil.getParamStrValueByType(item.get("idx"), dto);
                    if (item.containsKey(colCd) && Integer.toString(recordNo - 1).equals(idx)) {
                        orderDetailExtValues.put("value",
                                ParamUtil.getParamObjectValueByType(item.get(colCd), dto));
                        if (EditTableUtil.DataInputType.FILE.equals(dataInputType)) {
                            orderDetailExtValues.put("saved_ext_file_name",
                                    ParamUtil.getParamObjectValueByType(
                                            item.get(colCd + ".saved_ext_file_name"), dto));
                            orderDetailExtValues.put("saved_ext_full_path",
                                    ParamUtil.getParamObjectValueByType(
                                            item.get(colCd + ".saved_ext_full_path"), dto));
                        } else if (EditTableUtil.DataInputType.CHECKBOX.equals(dataInputType) ||
                                EditTableUtil.DataInputType.LISTBOX.equals(dataInputType)) {
                            orderDetailExtValues.put("separator",
                                    ParamUtil.getParamObjectValueByType(
                                            item.get(colCd + ".separator"), dto));
                        }
                        break;
                    }
                }
                if (orderDetailExtValues != null) {
                    value = getStrValue(orderDetailExtValues);
                }

                // --------------------------------
                // ファイルアップロード
                // --------------------------------
                if (EditTableUtil.DataInputType.FILE.equals(dataInputType)) {

                    // ファイルを登録できたら、そのファイル名を値として保存すること
                    logger.info(String.format("　受注明細拡張項目ファイルアップロード　カラムコード：%s", colCd));
                    value = uploadFile(dao, "orderdetail", data, orderDetailExtSetting, orderDetailExtValues);

                }

                // updateのためのパラメータ
                updateMap.put(colCd, value);

            }

        }

        logger.info(String.format("　更新対象の値セット：%s ", updateMap));
        if (!MapUtils.isEmpty(updateMap)) {
            // 更新
            updateMap.put("order_no", orderNo);
            updateMap.put("record_no", Integer.toString(recordNo));
            dao.updateEditTableData(tenantId, "orderdetail", userCd, JsonUtil.mapToJson(updateMap));
            ;
        }

    }

    /***
     *
     * 値を取得
     *
     * @param mp
     * @return
     */
    private String getStrValue(Map<String, Object> mp) {
        String value = null;
        Object paramValue = mp.get("value");
        String separator = (mp.get("separator") == null)? "," : (String) mp.get("separator");
        if (paramValue != null) {
            if (paramValue.getClass() == String[].class) {
                value = String.join(separator, (String[]) paramValue);
            } else {
                value = (String) mp.get("value");
            }
        }
        return value;
    }

    /***
     *
     * ファイルアップロード
     *
     *
     * @param dao            DAOオブジェクト
     * @param editTableCd    テーブルコード
     * @param data           見出、明細から呼び出されるデータ
     * @param extSetting     設定
     * @param extValue       値
     * @return
     */
    private String uploadFile(JsonDataDao dao, String editTableCd,
                                String data, Map<String, Object> extSetting, Map<String, Object> extValue ) {

        // --------------------------------
        // ファイル保存先基準ディレクトリの取得
        // --------------------------------
        logger.info("　　ファイル保存先基準ディレクトリの取得");
        String baseDir = "";
        try {
            String fileStorePathSystemSettingId = (String) extSetting.get("file_store_path_system_setting_id");
            String saveBaseDirPath = null;
            if (!CheckUtil.isEmpty(fileStorePathSystemSettingId)) {
                saveBaseDirPath = systemSetting.get(fileStorePathSystemSettingId);
            }
            if (CheckUtil.isEmpty(saveBaseDirPath)) {
                saveBaseDirPath = systemSetting.get("exItemFileDir_" + editTableCd);
            }
            if (CheckUtil.isEmpty(saveBaseDirPath)) {
                saveBaseDirPath = null;
            }
            baseDir = saveBaseDirPath;
        } catch (Exception e) {
        }
        logger.info(String.format("　　→ファイル保存先基準ディレクトリ：%s", baseDir));

        // 保存先ディレクトリの作成
        String saveDirPath = baseDir;

        // ファイル名作成
        String fileName = "";
        try {

            // 拡張項目定義からファイル名を取得
            String fileNameSelectQuery = (String) extSetting.get("file_name_select_query");
            // ファイル名作成クエリが取得できた場合
            if (!CheckUtil.isEmpty(fileNameSelectQuery)) {

                // 条件の作成＆SQL実行
                // 取得したサブディレクトリにはBase64でエンコードすること
                Map<String, Object> ret = dao.selectEditTableDataFieldFromJson(tenantId, editTableCd, data, fileNameSelectQuery);
                if (!MapUtils.isEmpty(ret)) {
                    fileName = (String) ret.get("data");
                }

            }

        } catch (Exception e) {
        }

        FileUtil fileUtil = new FileUtil();

        if (StringUtils.isEmpty(fileName)) {
            fileName = (String) extValue.get("saved_ext_file_name");
        } else {
            // 拡張子を付与
            fileName = fileName + "." + fileUtil.getSuffix((String) extValue.get("saved_ext_file_name"));
        }

        if (!StringUtils.isEmpty(fileName) && !StringUtils.isEmpty(saveDirPath) && !StringUtils.isEmpty((String) extValue.get("saved_ext_full_path"))) {

            String guid = (String) JsonUtil.jsonToMap(data).get("guid");
            String colCd = (String) extSetting.get("col_cd");
            // --------------------------------
            // ファイルパス作成
            // --------------------------------
            // ファイル名部分は難読化する
            String suffix = fileUtil.getSuffix(fileName);
            // String convertedFileName = String.format("%s_%s_%s", guid, editTableCd, colCd) + "." + suffix;
            String convertedFileName = FileUtil.getAttachmentFileName(guid, editTableCd, colCd, suffix);
            String saveFilePath = saveDirPath + File.separator + convertedFileName;

            // --------------------------------
            // ファイル保存
            // --------------------------------
            File file = null;
            try {
                file = new File((String) extValue.get("saved_ext_full_path"));
                fileUtil.moveFile(file.getPath(), saveFilePath);
                logger.info(String.format("　　ファイルを保存しました　保存先：%s", saveFilePath));
            } catch (Exception e) {
                fileName = null;
            }

            // --------------------------------
            // ファイル保存テーブルにデータ登録
            // --------------------------------
            Map<String, Object> attachmentMap = new HashMap<String, Object>();
            String saveBaseDirSysId = StringUtils.defaultIfEmpty((String) extSetting.get("file_store_path_system_setting_id"), "exItemFileDir_" + editTableCd);
            String refBaseDirSysId = StringUtils.defaultIfEmpty((String) extSetting.get("file_context_path_system_setting_id"), "exItemFilePath_" + editTableCd);
            attachmentMap.put("edit_table_cd", editTableCd);
            attachmentMap.put("col_cd", colCd);
            attachmentMap.put("ref_guid", guid);
            attachmentMap.put("save_base_dir_sys_id",saveBaseDirSysId);
            attachmentMap.put("ref_base_dir_sys_id", refBaseDirSysId);
            attachmentMap.put("file_name", convertedFileName);
            attachmentMap.put("org_file_name", fileName);
            String mapStr = JsonUtil.mapToJson(attachmentMap);
            dao.deleteEditTableData(tenantId, "attachment", mapStr);
            dao.insertEditTableData(tenantId, "attachment", userCd, mapStr);
            logger.info(String.format("　　ファイル保存テーブルに保存しました　保存したデータ：%s", mapStr));

        }
        logger.info(String.format("　　ファイル名：%s", fileName));
        return fileName;

    }

    /**
     * userChargeNameを取得します。
     * @return userChargeName
     */
    public String getUserChargeName() {
        return userChargeName;
    }

    /**
     * userChargeNameを設定します。
     * @param userChargeName userChargeName
     */
    public void setUserChargeName(String userChargeName) {
        this.userChargeName = userChargeName;
    }


}
