package jp.ill.photon.module.order;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.seasar.doma.jdbc.tx.TransactionManager;

import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.dao.DomaConfig;
import jp.ill.photon.dao.JsonDataDao;
import jp.ill.photon.dao.JsonDataDaoImpl;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.model.AoSetting;
import jp.ill.photon.model.CommonFlg;
import jp.ill.photon.model.ConveniencePayment;
import jp.ill.photon.model.CreditNumberOfPayment;
import jp.ill.photon.model.CreditPayment;
import jp.ill.photon.model.Payment;
import jp.ill.photon.model.Payment.AccountWayDiv;
import jp.ill.photon.model.PaymentWay;
import jp.ill.photon.model.SmbcPayment;
import jp.ill.photon.model.UserPaymentSetting;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.AoUtil;
import jp.ill.photon.util.AoUtil.DispPattern;
import jp.ill.photon.util.CheckUtil;
import jp.ill.photon.util.StringUtil;

public class GetPaymentMethodModule implements PhotonModule {

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "got_session.userForm.user_cd")
    private String userCd;

    @ModuleParam(required = false)
    @DefaultParamSetting(transferType = "param", transferVal = "selected_payment_cd")
    private String selectedPaymentCd;

    @ModuleParam(required = false)
    @DefaultParamSetting(transferType = "param", transferVal = "selected_convenience_payment_cd")
    private String selectedConveniencePaymentCd;

    @ModuleParam(required = false)
    @DefaultParamSetting(transferType = "param", transferVal = "selected_credit_payment_cd")
    private String selectedCreditPaymentCd;

    @ModuleParam(required = false)
    @DefaultParamSetting(transferType = "param", transferVal = "selected_credit_number_of_payment_cd")
    private String selectedCreditNumberOfPaymentCd;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType="dto", transferVal="common.aladdinsetting")
    private AoSetting aoSetting;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "user.first")
    private Map<String, Object> userForm;

    @ModuleParam(required=false)
    private String sessionKeyCreditInput = null;

    @ModuleParam(required = false)
    @DefaultParamSetting(transferType = "dto", transferVal = "got_payment_session.selectedPaymentCd")
    private String sessionSelectedPaymentCd = null;

    @ModuleParam(required = false)
    @DefaultParamSetting(transferType = "dto", transferVal = "got_payment_session.selectedConveniencePaymentCd")
    private String sessionSelectedConveniencePaymentCd = null;

    @ModuleParam(required = false)
    @DefaultParamSetting(transferType = "dto", transferVal = "got_payment_session.selectedCreditPaymentCd")
    private String sessionSelectedCreditPaymentCd = null;

    @ModuleParam(required = false)
    @DefaultParamSetting(transferType = "dto", transferVal = "got_payment_session.selectedCreditNumberOfPaymentCd")
    private String sessionSelectedCreditNumberOfPaymentCd = null;

	public String getSessionSelectedPaymentCd() {
		return sessionSelectedPaymentCd;
	}

	public void setSessionSelectedPaymentCd(String sessionSelectedPaymentCd) {
		this.sessionSelectedPaymentCd = sessionSelectedPaymentCd;
	}

	public String getSessionSelectedConveniencePaymentCd() {
		return sessionSelectedConveniencePaymentCd;
	}

	public void setSessionSelectedConveniencePaymentCd(String sessionSelectedConveniencePaymentCd) {
		this.sessionSelectedConveniencePaymentCd = sessionSelectedConveniencePaymentCd;
	}

	public String getSessionSelectedCreditPaymentCd() {
		return sessionSelectedCreditPaymentCd;
	}

	public void setSessionSelectedCreditPaymentCd(String sessionSelectedCreditPaymentCd) {
		this.sessionSelectedCreditPaymentCd = sessionSelectedCreditPaymentCd;
	}

	public String getSessionSelectedCreditNumberOfPaymentCd() {
		return sessionSelectedCreditNumberOfPaymentCd;
	}

	public void setSessionSelectedCreditNumberOfPaymentCd(String sessionSelectedCreditNumberOfPaymentCd) {
		this.sessionSelectedCreditNumberOfPaymentCd = sessionSelectedCreditNumberOfPaymentCd;
	}

	public String getSessionKeyCreditInput() {
        return sessionKeyCreditInput;
    }

    public void setSessionKeyCreditInput(String sessionKeyCreditInput) {
        this.sessionKeyCreditInput = sessionKeyCreditInput;
    }

    public Map<String, Object> getUserForm() {
        return userForm;
    }

    public void setUserForm(Map<String, Object> userForm) {
        this.userForm = userForm;
    }

    public AoSetting getAoSetting() {
        return aoSetting;
    }

    public void setAoSetting(AoSetting aoSetting) {
        this.aoSetting = aoSetting;
    }

    public String getUserCd() {
        return userCd;
    }

    public void setUserCd(String userCd) {
        this.userCd = userCd;
    }

    public String getSelectedPaymentCd() {
        return selectedPaymentCd;
    }

    public void setSelectedPaymentCd(String selectedPaymentCd) {
        this.selectedPaymentCd = selectedPaymentCd;
    }

    public String getSelectedConveniencePaymentCd() {
        return selectedConveniencePaymentCd;
    }

    public void setSelectedConveniencePaymentCd(String selectedConveniencePaymentCd) {
        this.selectedConveniencePaymentCd = selectedConveniencePaymentCd;
    }

    public String getSelectedCreditPaymentCd() {
        return selectedCreditPaymentCd;
    }

    public void setSelectedCreditPaymentCd(String selectedCreditPaymentCd) {
        this.selectedCreditPaymentCd = selectedCreditPaymentCd;
    }

    public String getSelectedCreditNumberOfPaymentCd() {
        return selectedCreditNumberOfPaymentCd;
    }

    public void setSelectedCreditNumberOfPaymentCd(String selectedCreditNumberOfPaymentCd) {
        this.selectedCreditNumberOfPaymentCd = selectedCreditNumberOfPaymentCd;
    }

    @Override
    public ModuleResult execute(ModuleContext context)
            throws PhotonModuleException {
        ModuleResult result = new ModuleResult();

        if (sessionKeyCreditInput != null) {
            HttpSession session = context.getDto().getSession();
            session.removeAttribute(sessionKeyCreditInput + "-" + context.getDto().getTenantId() + "-" + context.getDto().getAppId());
        }

        // 決済情報のセッション情報があれば積む
        HttpSession session = context.getDto().getSession();

        String paymentCd = CheckUtil.isEmpty(selectedPaymentCd) ? sessionSelectedPaymentCd : selectedPaymentCd;

        JsonDataDao dao = new JsonDataDaoImpl();
        TransactionManager tm = DomaConfig.singleton().getTransactionManager();

        List<Map<String, Object>> paymentListMap = tm.required(() -> {
            return dao.getPayment(context.getDto().getTenantId());
        });
        List<Payment> paymentList = new ArrayList<Payment>();
        for (Map<String, Object> paymentMap : paymentListMap) {
            Payment payment = Payment.valueOf(paymentMap);
            paymentList.add(payment);
        }

        // 「お支払方法」の表示/非表示を切り替えるための情報取得
        Map<String, Boolean> paymentDispMap = getPaymentDispMap(context, paymentList);

        String currentPaymentCd = null;
        if (CheckUtil.isEmpty(paymentCd)) {
            // 表示可能な一番上の項目を設定
            for (Map.Entry<String, Boolean> ent : paymentDispMap.entrySet()) {
                if (ent.getValue() != null
                        && ent.getValue().equals(Boolean.TRUE)) {
                    result.getReturnData().put("selected_payment_cd", ent.getKey());
                    currentPaymentCd = ent.getKey();
                    break;
                }
            }
        } else {
            // 選択した決済方法が無効になっていたらエラー
            if (!paymentDispMap.get(paymentCd)) {
                // TODO: ERROR
            } else {
                result.getReturnData().put("selected_payment_cd", paymentCd);
                currentPaymentCd = paymentCd;
            }
        }
        List<Map<String, Object>> paymentListMapResult = new ArrayList<Map<String,Object>>();
        for (Payment payment : paymentList) {
            if (paymentDispMap.get(payment.getPaymentCd())) {
                paymentListMapResult.add(payment.toMap());
                if (payment.getPaymentCd().equals(currentPaymentCd)) {
                    result.getReturnData().put("selected_payment_name", payment.getPaymentName());
                }
            }
        }
        result.getReturnData().put("payment_list", paymentListMapResult);

        // クレジット上限額の取得
        PaymentWay pwCredit = tm.required(() -> {
            List<Map<String, Object>> pwMap = dao.getPaymentWay(context.getDto().getTenantId(), Payment.AccountWayDiv.CREDIT_SMBC, Payment.CreditPaymentMethod.IKKATSU);
            if (pwMap == null || pwMap.isEmpty()) {
                return null;
            }
            else {
                return PaymentWay.valueOf(pwMap.get(0));
            }
        });
        if (pwCredit != null) {
        	result.getReturnData().put("request_amount_max_credit", AoUtil.convAoRoundingSalesPrice(pwCredit.getRequestAmountMax().toString(), "1",
                    DispPattern.PATTERN_1, aoSetting.getSalesPriceDigitNum(), StringUtil.defaultString(userForm.get("price_fraction_div"), "0") ));
        }

        // コンビニのリストを取得
        List<Map<String, Object>> conveniencePaymentListMap = tm.required(() -> {
            return dao.getConveniencePayment(context.getDto().getTenantId());
        });
        List<ConveniencePayment> conveniencePaymentList = new ArrayList<ConveniencePayment>();
        for (Map<String, Object> conveniencePaymentMap : conveniencePaymentListMap) {
            ConveniencePayment payment = ConveniencePayment.valueOf(conveniencePaymentMap);
            conveniencePaymentList.add(payment);
        }

        String conveniencePaymentCd = CheckUtil.isEmpty(selectedConveniencePaymentCd) ? sessionSelectedConveniencePaymentCd : selectedConveniencePaymentCd;
        if (CheckUtil.isEmpty(conveniencePaymentCd)) {
            // 表示可能な一番上の項目を設定
            if (conveniencePaymentList != null && conveniencePaymentList.size() > 0) {
                result.getReturnData().put("selected_convenience_payment_cd", conveniencePaymentList.get(0).getPaymentMethodCd());
                conveniencePaymentCd = conveniencePaymentList.get(0).getPaymentMethodCd();
            }
        } else {
            boolean found = false;
            for (ConveniencePayment payment : conveniencePaymentList) {
                if (conveniencePaymentCd.equals(payment.getPaymentMethodCd())) {
                    result.getReturnData().put("selected_convenience_payment_name", payment.getPaymentMethodName());
                    found = true;
                    break;
                }
            }
            if (!found) {
                // TODO: ERROR
            } else {
                result.getReturnData().put("selected_convenience_payment_cd", conveniencePaymentCd);
            }
        }
        result.getReturnData().put("convenience_payment_list", conveniencePaymentListMap);

        // コンビニ上限額の取得
        PaymentWay coCredit = tm.required(() -> {
            List<Map<String, Object>> coMap = dao.getPaymentWay(context.getDto().getTenantId(), AccountWayDiv.CONVENIENCE_STORE_RECEPTION_SMBC, selectedConveniencePaymentCd);
            if (coMap == null || coMap.isEmpty()) {
                return null;
            }
            else {
                return PaymentWay.valueOf(coMap.get(0));
            }
        });
        if (coCredit != null) {
        	result.getReturnData().put("request_amount_max_convenience", AoUtil.convAoRoundingSalesPrice(coCredit.getRequestAmountMax().toString(), "1",
                DispPattern.PATTERN_1, aoSetting.getSalesPriceDigitNum(), StringUtil.defaultString(userForm.get("price_fraction_div"), "0") ));
        }

        // クレジット支払い方法の取得
        SmbcPayment smbcPayment = tm.required(() -> {
            List<Map<String, Object>> smbcMap = dao.getSmbcPayment(context.getDto().getTenantId(), AccountWayDiv.CREDIT_SMBC);
            if (smbcMap == null || smbcMap.isEmpty()) {
                return null;
            }
            else {
                return SmbcPayment.valueOf(smbcMap.get(0));
            }
        });

        if (smbcPayment != null) {
	        // セキュリティコードを表示するかどうかのフラグ
	        String securityCdInputDiv = CommonFlg.ON.equals(String.valueOf(smbcPayment.getSecurityCdInputDiv())) ? "1" : "0";
	        result.getReturnData().put("need_security_cd_input", securityCdInputDiv);
        }

        // クレジット支払い方法の設定
        List<Map<String, Object>> creditPaymentListMap = tm.required(() -> {
            return dao.getCreditPayment(context.getDto().getTenantId());
        });
        List<CreditPayment> creditPaymentList = new ArrayList<CreditPayment>();
        for (Map<String, Object> creditPaymentMap : creditPaymentListMap) {
            CreditPayment payment = CreditPayment.valueOf(creditPaymentMap);
            creditPaymentList.add(payment);
        }

        String creditPaymentCd = CheckUtil.isEmpty(selectedCreditPaymentCd) ? sessionSelectedCreditPaymentCd : selectedCreditPaymentCd;

        if (CheckUtil.isEmpty(creditPaymentCd)) {
            if (creditPaymentList != null && creditPaymentList.size() > 0) {
                result.getReturnData().put("selected_credit_payment_cd", creditPaymentList.get(0).getPaymentMethodCd());
            }
        } else {
            boolean found = false;
            for (CreditPayment payment : creditPaymentList) {
                if (creditPaymentCd.equals(payment.getPaymentMethodCd())) {
                    result.getReturnData().put("selected_credit_payment_name", payment.getPaymentMethodName());
                    found = true;
                    break;
                }
            }
            if (!found) {
                // TODO: ERROR
            } else {
                result.getReturnData().put("selected_credit_payment_cd", creditPaymentCd);
            }
        }
        result.getReturnData().put("credit_payment_list", creditPaymentListMap);

        // クレジット支払い回数の設定
        List<Map<String, Object>> creditNumberOfPaymentListMap = tm.required(() -> {
            return dao.getCreditNumberOfPayment(context.getDto().getTenantId());
        });
        List<CreditNumberOfPayment> creditNumberOfPaymentList = new ArrayList<CreditNumberOfPayment>();
        for (Map<String, Object> creditNumberOfPaymentMap : creditNumberOfPaymentListMap) {
            CreditNumberOfPayment payment = CreditNumberOfPayment.valueOf(creditNumberOfPaymentMap);
            creditNumberOfPaymentList.add(payment);
        }

        String creditNumberOfPaymentCd = CheckUtil.isEmpty(selectedCreditNumberOfPaymentCd) ? sessionSelectedCreditNumberOfPaymentCd : selectedCreditNumberOfPaymentCd;

        if (CheckUtil.isEmpty(creditNumberOfPaymentCd)) {
            if (creditNumberOfPaymentList != null && creditNumberOfPaymentList.size() > 0) {
                result.getReturnData().put("selected_credit_number_of_payment_cd", creditNumberOfPaymentList.get(0).getNumberOfPaymentCd());
            }
        } else {
            boolean found = false;
            if (Payment.CreditPaymentMethod.BUNKAtSU.equals(creditPaymentCd)) {
                for (CreditNumberOfPayment payment : creditNumberOfPaymentList) {
                    if (creditNumberOfPaymentCd.equals(payment.getNumberOfPaymentCd())) {
                        result.getReturnData().put("selected_credit_number_of_payment_name", payment.getNumberOfPaymentName());
                        found = true;
                        break;
                    }
                }
            }
            if (!found) {
                    // TODO: ERROR
            } else {
                result.getReturnData().put("selected_credit_number_of_payment_cd", creditNumberOfPaymentCd);
            }
        }
        result.getReturnData().put("credit_number_of_payment_list", creditNumberOfPaymentListMap);

        return result;
    }

    private Map<String, Boolean> getPaymentDispMap(ModuleContext context, List<Payment> paymentList) {
        JsonDataDao dao = new JsonDataDaoImpl();
        TransactionManager tm = DomaConfig.singleton().getTransactionManager();

        Map<String, Boolean> paymentDispMap = new LinkedHashMap<String, Boolean>();

        // 決済方法マスタから取得
        for (Payment payment : paymentList) {
            boolean disp = false;
            /* Aladdin-EC 3rdリリース #6718_3 START */
            if (payment.getDispFlg() != null) {
                /* Aladdin-EC 3rdリリース #6718_3 END */
                disp = payment.getDispFlg().equals(
                        Integer.parseInt(CommonFlg.ON));
            }
            paymentDispMap.put(payment.getPaymentCd(), disp);
        }

        // 得意先別決済方法設定テーブルから取得
        List<Map<String, Object>> userPaymentSettingMap = tm.required(() -> {
            return dao.getUserPaymentSetting(context.getDto().getTenantId(), userCd);
        });


        Map<String, Boolean> userPaymentDispMap = new LinkedHashMap<String, Boolean>();


        for (Map<String,Object> userPaymentMap : userPaymentSettingMap) {
            UserPaymentSetting setting = UserPaymentSetting.valueOf(userPaymentMap);

            boolean disp = false;
            if (setting.getPaymentDiv() == null) {
                disp = false;
            } else {
                disp = setting.getPaymentDiv().equals(Integer.parseInt(CommonFlg.ON));
            }

            userPaymentDispMap.put(setting.getPaymentCd(), disp);
        }

        for (String key : paymentDispMap.keySet()) {
            if (userPaymentDispMap.get(key) == null) {
                // 得意先別の決済方法のエントリがないときは非表示
                paymentDispMap.put(key, false);
            } else {
                // 決済方法マスタの設定が「非表示」の場合、決済方法マスタの設定を使用する
                if(!paymentDispMap.get(key).booleanValue()){
                    paymentDispMap.put(key, paymentDispMap.get(key));
                }else{
                    // それ以外、得意先別の決済方法設定を使用する
                    paymentDispMap.put(key, userPaymentDispMap.get(key));
                }
            }
        }

        return paymentDispMap;
    }

}
