package jp.ill.photon.module.order;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.seasar.doma.jdbc.command.UpdateCommand;
import org.seasar.doma.jdbc.query.UpdateQuery;
import org.seasar.doma.jdbc.tx.TransactionManager;

import jp.ill.photon.action.ActionParamMap;
import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.dao.DomaConfig;
import jp.ill.photon.dao.JsonDataDao;
import jp.ill.photon.dao.JsonDataDaoImpl;
import jp.ill.photon.doma.SqlUpdateQueryFactory;
import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.AoFormatCheckUtil;
import jp.ill.photon.util.JsonUtil;
import jp.ill.photon.util.SQLUtil;
import jp.ill.photon.util.UtilTools;

public class DeliveryFeeUpdateModule implements PhotonModule {

	@ModuleParam(required = true)
	@DefaultParamSetting(transferType = "param_multi", transferVal = "delivery_fee.deliveryFeeCd[]")
	private String[] deliveryFeeCd;

	@ModuleParam(required = true)
	@DefaultParamSetting(transferType = "param_multi", transferVal = "delivery_fee.areaName[]")
	private String[] areaName;

	@ModuleParam(required = true)
	@DefaultParamSetting(transferType = "param_multi", transferVal = "delivery_fee.deliveryCharge[]")
	private String[] deliveryCharge;

	@ModuleParam(required = true)
	@DefaultParamSetting(transferType = "param_multi", transferVal = "delivery_fee.address[]")
	private String[] address;

	@ModuleParam(required = true)
	@DefaultParamSetting(transferType = "param_multi", transferVal = "delivery_fee.delFlg[]")
	private String[] delFlg;

	public String[] getDeliveryFeeCd() {
		return deliveryFeeCd;
	}

	public void setDeliveryFeeCd(String[] deliveryFeeCd) {
		this.deliveryFeeCd = deliveryFeeCd;
	}

	public String[] getAreaName() {
		return areaName;
	}

	public void setAreaName(String[] areaName) {
		this.areaName = areaName;
	}

	public String[] getDeliveryCharge() {
		return deliveryCharge;
	}

	public void setDeliveryCharge(String[] deliveryCharge) {
		this.deliveryCharge = deliveryCharge;
	}

	public String[] getAddress() {
		return address;
	}

	public void setAddress(String[] address) {
		this.address = address;
	}

	public String[] getDelFlg() {
		return delFlg;
	}

	public void setDelFlg(String[] delFlg) {
		this.delFlg = delFlg;
	}

	@ModuleParam(required = false)
	@DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.exSqlFileDir.note")
	private String sqlFileDirPath;

	@Override
	public ModuleResult execute(ModuleContext context)
			throws PhotonModuleException {

		ActionDto dto = context.getDto();
		ActionParamMap params = dto.getParams();

		// テナントID
		String tenantId = params.get("_init.tenant_id");
		// 一律設定チェック
		String applyAll = params.get("delivery_fee.applyAll");
		// 一律配送料
		String allDeliveryCharge = params.get("delivery_fee.allDeliveryCharge");
		// 無料設定チェック
		String checkPostageFreeThreshold = params
				.get("delivery_fee.checkPostageFreeThreshold");
		// 配送料無料注文金額閾値
		String postageFreeThreshold = params
				.get("delivery_fee.postageFreeThreshold");

		ModuleResult result = new ModuleResult();

		TransactionManager tm = DomaConfig.singleton().getTransactionManager();
		JsonDataDao dao = new JsonDataDaoImpl();

		int r = tm.required(() -> {

			int size = deliveryFeeCd.length;
			if (size != areaName.length && size != deliveryCharge.length
					&& size != address.length && size != delFlg.length) {
				// TODO
				return -1;
			}

			// 先に削除
			for (int i = 0; i < size; i++) {
				if ("1".equals(delFlg[i])) {
					String feeCd = deliveryFeeCd[i];

					if (!"".equals(feeCd)) {
						dao.deleteDeliveryFeeCd(context.getDto().getTenantId(),
								feeCd);
					}
				}
			}

			// 登録＆更新
			for (int i = 0; i < size; i++) {
				if (!"1".equals(delFlg[i])) {
					String feeCd = deliveryFeeCd[i];

					List<String> addressList = Arrays
							.asList(address[i].split(","));

					// 先に削除
					if (!"".equals(feeCd)) {
						dao.deleteDeliveryFeeCd(context.getDto().getTenantId(),
								feeCd);
					}

					int feeCdInt = 0;
					if ("".equals(feeCd)) {
						// 配送料コードを採番
						// 挿入
						List<Map<String, Object>> seqMap = dao.getSeqSfNextVal(
								context.getDto().getTenantId(), "deliveryfee",
								"delivery_fee_cd");
						if (seqMap == null || seqMap.isEmpty()) {
							// TODO Error
						}

						feeCdInt = Integer.valueOf(
								String.valueOf(seqMap.get(0).get("seq")));
					}

					// ログイン中の管理者ユーザ名
					String loginAdminUserName = SQLUtil
							.getLoginAdminUserName(dto);

					for (int j = 0; j < addressList.size(); j++) {
						if ("".equals(feeCd)) {

							Map<String, Object> map = new HashMap<String, Object>();
							map.put("delivery_fee_cd", feeCdInt);
							map.put("record_no", j);
							map.put("area_name", areaName[i]);
							if (!UtilTools.isEmpty(applyAll)
									&& !UtilTools.isEmpty(allDeliveryCharge)) {
								// 一括配送料を設定
								map.put("delivery_charge", AoFormatCheckUtil
										.removeComma(allDeliveryCharge));
							} else {
								// 個別配送料を設定
								map.put("delivery_charge", deliveryCharge[i]);
							}
							map.put("address", addressList.get(j));
							map.put("priory_no", i);

							String data = JsonUtil.mapToJson(map);
							dao.insertEditTableData(
									context.getDto().getTenantId(),
									"deliveryfee", loginAdminUserName, data);

						} else {
							// 更新
							feeCdInt = Integer.valueOf(feeCd);
							Map<String, Object> map = new HashMap<String, Object>();
							map.put("delivery_fee_cd", feeCdInt);
							map.put("record_no", j);
							map.put("area_name", areaName[i]);
							if (!UtilTools.isEmpty(applyAll)
									&& !UtilTools.isEmpty(allDeliveryCharge)) {
								// 一括配送料を設定
								map.put("delivery_charge", AoFormatCheckUtil
										.removeComma(allDeliveryCharge));
							} else {
								// 個別配送料を設定
								map.put("delivery_charge", deliveryCharge[i]);
							}
							map.put("address", addressList.get(j));
							map.put("priory_no", i);

							String data = JsonUtil.mapToJson(map);
							dao.insertEditTableData(
									context.getDto().getTenantId(),
									"deliveryfee", loginAdminUserName, data);
						}
					}
				}
			}

			return 0;
		});

		// 無料設定にチェックが入っていない場合は空文字で更新
		if (UtilTools.isEmpty(checkPostageFreeThreshold)) {
			postageFreeThreshold = "";
		}

		/** システム設定テーブルの更新 */
		String nowDatetime = SQLUtil.getNowDatetime();
		String loginUserName = SQLUtil.getLoginAdminUserName(dto);

		// 配送料無料注文金額閾値を更新 ※配送料無料注文金額閾値が空の場合は空で更新する
		SqlUpdateQueryFactory updateFactory = SqlUpdateQueryFactory
				.newInstance();
		HashMap<String, Object> updateSystemSettingParamMap = SQLUtil
				.createUpdateSystemSettingParams(tenantId,
						"postageFreeThreshold",
						AoFormatCheckUtil.removeComma(postageFreeThreshold),
						nowDatetime, loginUserName);
		UpdateQuery updateNewsInfoQuery = updateFactory
				.createUpdateQueryFromFile(updateSystemSettingParamMap,
						context.getDto(), sqlFileDirPath,
						"aec20/systemsetting/updateSystemSetting.sql");
		updateNewsInfoQuery.prepare();

		// 更新処理を実行
		int r2 = tm.required(() -> {
			UpdateCommand command = new UpdateCommand(updateNewsInfoQuery);
			return command.execute();
		});

		return result;
	}

	/**
	 * sqlFileDirPathを取得します。
	 * 
	 * @return sqlFileDirPath
	 */
	public String getSqlFileDirPath() {
		return sqlFileDirPath;
	}

	/**
	 * sqlFileDirPathを設定します。
	 * 
	 * @param sqlFileDirPath
	 */
	public void setSqlFileDirPath(String sqlFileDirPath) {
		this.sqlFileDirPath = sqlFileDirPath;
	}

}
