package jp.ill.photon.module.order;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.ill.photon.action.ActionParamMap;
import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.model.SearchForm;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.db.SqlFileSelectModule;

public class DeliveryFeeSettingModule extends SqlFileSelectModule {

	@ModuleParam(required = false)
	@DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.postageFreeThreshold.note")
	private String postageFreeThreshold;

	@ModuleParam(required = true)
	private Map<String, Object> paramJson;

    /** TODO 親クラスに書かれていれば書かなくてもいいようにしたい */
    @ModuleParam(required = true, domainObject = true)
    private SearchForm searchForm;

    @ModuleParam(required = true)
    private String sqlFileDirPath;

    @ModuleParam(required = true)
    private String sqlFilePath;

    @Override
    public ModuleResult execute(ModuleContext context)
            throws PhotonModuleException {
        ModuleResult result = super.execute(context);

        List<Map<String, Object>> deliveryFeeList = (List<Map<String, Object>>)result.getReturnData().get("list");
        List<Map<String, Object>> deliveryFeeDispList = new ArrayList<Map<String, Object>>();

        // 一律配送料を取得
        String allDeliveryCharge = null;

        if (deliveryFeeList == null || deliveryFeeList.size() <= 1) {
            allDeliveryCharge = null;
        } else {

            StringBuffer address = new StringBuffer();

            for (int i = 0; i < deliveryFeeList.size(); i++) {

                Map<String, Object> deliveryFee = deliveryFeeList.get(i);
                String feeCd = (String)deliveryFee.get("delivery_fee_cd");

                if (i < deliveryFeeList.size() - 1) {
                    String nextCd = (String)deliveryFeeList.get(i+1).get("delivery_fee_cd");

                    if (!feeCd.equals(nextCd)) {
                        // ここで詰める
                        address.append(deliveryFee.get("address"));

                        Map<String, Object> deliveryFeeDisp = new HashMap<String, Object>();
                        deliveryFeeDisp.put("delivery_fee_cd", deliveryFee.get("delivery_fee_cd"));
                        deliveryFeeDisp.put("area_name", deliveryFee.get("area_name"));
                        deliveryFeeDisp.put("delivery_charge", deliveryFee.get("delivery_charge"));
                        deliveryFeeDisp.put("address", address.toString());
                        deliveryFeeDisp.put("priory_no", deliveryFee.get("priory_no"));

                        deliveryFeeDispList.add(deliveryFeeDisp);

                        address = new StringBuffer();
                    } else {
                        address.append(deliveryFee.get("address"));
                        address.append(",");
                    }
                } else {
                    // ここで詰める
                    address.append(deliveryFee.get("address"));

                    Map<String, Object> deliveryFeeDisp = new HashMap<String, Object>();
                    deliveryFeeDisp.put("delivery_fee_cd", deliveryFee.get("delivery_fee_cd"));
                    deliveryFeeDisp.put("area_name", deliveryFee.get("area_name"));
                    deliveryFeeDisp.put("delivery_charge", deliveryFee.get("delivery_charge"));
                    deliveryFeeDisp.put("address", address.toString());
                    deliveryFeeDisp.put("priory_no", deliveryFee.get("priory_no"));

                    deliveryFeeDispList.add(deliveryFeeDisp);

                    address = new StringBuffer();
                }
            }

            boolean sameFlg = true;
            String firstValue = (String)deliveryFeeDispList.get(0).get("delivery_charge");
            for (Map<String, Object> deliveryDispFee : deliveryFeeDispList) {
                if (deliveryDispFee.get("delivery_fee_cd") == null || "".equals(deliveryDispFee.get("delivery_fee_cd"))) {
                    continue;
                }
                if (!firstValue.equals(deliveryDispFee.get("delivery_charge"))) {
                    sameFlg = false;
                    break;
                }
            }
            if (sameFlg) {
                allDeliveryCharge =  firstValue;
            }
        }

		/** バリデーションエラー時は入力値を設定 */
		/** 結果区分 */
		ActionDto dto = context.getDto();
		ActionParamMap params = dto.getParams();
		String resultDiv = (String) params.get("resultDiv");
		if("validation_error".equals(resultDiv)){
			if (params != null) {
				if(params.getParams().get("allDeliveryCharge") != null){
					String inputVal = params.getParams().get("allDeliveryCharge")[0];
					result.getReturnData().put("allDeliveryCharge", inputVal);
				}
				if(params.getParams().get("postageFreeThreshold") != null){
					String inputVal = params.getParams().get("postageFreeThreshold")[0];
					result.getReturnData().put("postageFreeThreshold", inputVal);
				}
			}
		}else{
	        result.getReturnData().put("allDeliveryCharge", allDeliveryCharge);
	        result.getReturnData().put("postageFreeThreshold", postageFreeThreshold);
		}
        result.getReturnData().put("disp_list", deliveryFeeDispList);

        return result;
    }

	/**
	 * postageFreeThresholdを取得します。
	 * @return postageFreeThreshold
	 */
	public String getPostageFreeThreshold() {
		return postageFreeThreshold;
	}

	/**
	 * postageFreeThresholdを設定します。
	 * @param postageFreeThreshold
	 */
	public void setPostageFreeThreshold(String postageFreeThreshold) {
		this.postageFreeThreshold = postageFreeThreshold;
	}

	/**
	 * paramJsonを取得します。
	 * @return paramJson
	 */
	public Map<String, Object> getParamJson() {
		return paramJson;
	}

	/**
	 * paramJsonを設定します。
	 * @param paramJson
	 */
	public void setParamJson(Map<String, Object> paramJson) {
		this.paramJson = paramJson;
	}

    public SearchForm getSearchForm() {
        return searchForm;
    }

    public void setSearchForm(SearchForm searchForm) {
        this.searchForm = searchForm;
    }

    public String getSqlFileDirPath() {
        return sqlFileDirPath;
    }

    public void setSqlFileDirPath(String sqlFileDirPath) {
        this.sqlFileDirPath = sqlFileDirPath;
    }

    public String getSqlFilePath() {
        return sqlFilePath;
    }

    public void setSqlFilePath(String sqlFilePath) {
        this.sqlFilePath = sqlFilePath;
    }

}
