package jp.ill.photon.module.order;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.message.ActionDtoMessage;
import jp.ill.photon.model.Payment.AccountWayDiv;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;

public class CheckPaymentAmountModule implements PhotonModule {

    @ModuleParam(required = false)
    @DefaultParamSetting(transferType = "dto", transferVal = "sum.result_price")
    private String checkAmount;

    @ModuleParam(required = false)
    @DefaultParamSetting(transferType = "param", transferVal = "selected_payment_cd")
    private String selectedPaymentCd;

    @ModuleParam(required = false)
    @DefaultParamSetting(transferType = "dto", transferVal = "payment.request_amount_max_credit")
    private String requestAmountMaxCredit;

    @ModuleParam(required = false)
    @DefaultParamSetting(transferType = "dto", transferVal = "payment.request_amount_max_convenience")
    private String requestAmountMaxConvenience;

    /** メッセージID（見積注文済みエラー） */
    public static final String PAYMENT_LIMIT_AMOUNT_ERROR_MSG_ID = "paymentLimitAmountOver";

    public String getCheckAmount() {
        return checkAmount;
    }

    public void setCheckAmount(String checkAmount) {
        this.checkAmount = checkAmount;
    }

    public String getSelectedPaymentCd() {
        return selectedPaymentCd;
    }

    public void setSelectedPaymentCd(String selectedPaymentCd) {
        this.selectedPaymentCd = selectedPaymentCd;
    }

    public String getRequestAmountMaxCredit() {
        return requestAmountMaxCredit;
    }

    public void setRequestAmountMaxCredit(String requestAmountMaxCredit) {
        this.requestAmountMaxCredit = requestAmountMaxCredit;
    }

    public String getRequestAmountMaxConvenience() {
        return requestAmountMaxConvenience;
    }

    public void setRequestAmountMaxConvenience(String requestAmountMaxConvenience) {
        this.requestAmountMaxConvenience = requestAmountMaxConvenience;
    }

    @Override
    public ModuleResult execute(ModuleContext context)
            throws PhotonModuleException {
        ModuleResult result = new ModuleResult();

        if (AccountWayDiv.CONVENIENCE_STORE_RECEPTION_SMBC.equals(selectedPaymentCd)) {

            if (new BigDecimal(checkAmount.replaceAll(",", "")).compareTo(new BigDecimal(requestAmountMaxConvenience.replaceAll(",", "")) ) > 0) {
                result.setResultCode("error");

                List<ActionDtoMessage> errorMessages = new ArrayList<ActionDtoMessage>();
                ActionDtoMessage msg = new ActionDtoMessage();
                msg.setMessageId(PAYMENT_LIMIT_AMOUNT_ERROR_MSG_ID);
				msg.setFormFieldCd("payment_cd");
                errorMessages.add(msg);
				result.getMessages().put("error_field", errorMessages);
            }

        } else if (AccountWayDiv.CREDIT_SMBC.equals(selectedPaymentCd)) {

            if (new BigDecimal(checkAmount.replaceAll(",", "")).compareTo(new BigDecimal(requestAmountMaxCredit.replaceAll( ",", "")) ) > 0) {
                result.setResultCode("error");

                List<ActionDtoMessage> errorMessages = new ArrayList<ActionDtoMessage>();
                ActionDtoMessage msg = new ActionDtoMessage();
                msg.setMessageId(PAYMENT_LIMIT_AMOUNT_ERROR_MSG_ID);
				msg.setFormFieldCd("payment_cd");
                errorMessages.add(msg);
				result.getMessages().put("error_field", errorMessages);
            }

        }

        return result;
    }

}
