package jp.ill.photon.module.news;

import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.converters.BigDecimalConverter;
import org.seasar.doma.MapKeyNamingType;
import org.seasar.doma.internal.jdbc.command.MapResultListHandler;
import org.seasar.doma.jdbc.command.DeleteCommand;
import org.seasar.doma.jdbc.command.InsertCommand;
import org.seasar.doma.jdbc.command.SelectCommand;
import org.seasar.doma.jdbc.command.UpdateCommand;
import org.seasar.doma.jdbc.query.DeleteQuery;
import org.seasar.doma.jdbc.query.InsertQuery;
import org.seasar.doma.jdbc.query.SelectQuery;
import org.seasar.doma.jdbc.query.UpdateQuery;
import org.seasar.doma.jdbc.tx.TransactionManager;

import jp.ill.photon.action.ActionParamMap;
import jp.ill.photon.action.FileParam;
import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.dao.DomaConfig;
import jp.ill.photon.dao.JsonDataDao;
import jp.ill.photon.dao.JsonDataDaoImpl;
import jp.ill.photon.doma.SqlDeleteQueryFactory;
import jp.ill.photon.doma.SqlInsertQueryFactory;
import jp.ill.photon.doma.SqlSelectQueryFactory;
import jp.ill.photon.doma.SqlUpdateQueryFactory;
import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.model.FileForm;
import jp.ill.photon.model.News;
import jp.ill.photon.model.Publishing;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.module.file.FileCopyModule;
import jp.ill.photon.module.file.FileDeleteModule;
import jp.ill.photon.util.ParamUtil;
import jp.ill.photon.util.SQLUtil;
import jp.ill.photon.util.StringUtil;
import jp.ill.photon.util.UtilTools;

public class NewsUpdateModule implements PhotonModule {

	@ModuleParam(required = true)
	private Map<String, Object> paramJson;

	@ModuleParam(required = true)
	private String execType;

	@ModuleParam(required = false)
	private List<FileForm> fileForms;

	@ModuleParam(required = false)
	@DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.exSqlFileDir.note")
	private String sqlFileDirPath;

	@SuppressWarnings({ "unchecked", "rawtypes" })
	public ModuleResult execute(ModuleContext context)
			throws PhotonModuleException {

		ActionDto dto = context.getDto();
		ActionParamMap paramMap = dto.getParams();
		ModuleResult moduleResult = new ModuleResult();

		JsonDataDao dao = new JsonDataDaoImpl();

		Map<String, Object> common = (Map<String, Object>) dto.getDataMap()
				.get("common");
		Map<String, Object> systemSettingMap = (Map<String, Object>) common
				.get("systemsetting");

		News news = new News();

		Map<String, Object> params = new LinkedHashMap<String, Object>();
		// 入力値をマップにする
		if (paramJson != null) {
			Map<String, String> paramInfo = null;
			for (Map.Entry<String, Object> input : paramJson.entrySet()) {
				paramInfo = (Map) input.getValue();
				params.put(input.getKey(), ParamUtil.getParamValueByType(
						paramInfo.get("type"), paramInfo.get("val"), dto));
			}
		}
		// JSON形式で登録できるようにエスケープ
		for (Entry<String, Object> entry : params.entrySet()) {
			String key = entry.getKey();
			params.put(key, StringUtil.escapeJsonStr((String) params.get(key)));
		}

		// 新規登録かどうか
		boolean isNewRegist = false;

		// 登録/変更日時
		String nowDatetime = SQLUtil.getNowDatetime();
		String loginUserName = SQLUtil.getLoginAdminUserName(dto);

		TransactionManager tm = DomaConfig.singleton().getTransactionManager();
		int result;

		// テナントID
		String tenantId = paramMap.get("_init.tenant_id");
		// お知らせID
		String newsId = paramMap.get("newsInfo.newsId");
		// お知らせIDが未設定の場合は新規採番
		if (UtilTools.isEmpty(newsId)) {

			// 新規登録
			isNewRegist = true;

/*			SqlSelectQueryFactory selectFactory = SqlSelectQueryFactory
					.newInstance();

			*//** お知らせID新規採番 *//*
			HashMap<String, Object> newsIdNexValParams = SQLUtil
					.createNewsIdNextValParams(tenantId);
			SqlSelectQuery getNextNewsIdQuery = selectFactory
					.createSelectQueryFromFile(newsIdNexValParams,
							context.getDto(), sqlFileDirPath,
							"aec20/news/getNewsIdNextVal.sql");
			getNextNewsIdQuery.prepare();

			List<Map<String, Object>> newsIdNextValMap = tm.required(() -> {
				SelectCommand<List<Map<String, Object>>> command = new SelectCommand<>(
						getNextNewsIdQuery,
						new MapResultListHandler(MapKeyNamingType.NONE));
				return command.execute();
			});
			newsId = StringUtil
					.defaultString(newsIdNextValMap.get(0).get("news_id"));*/


			// シーケンス使用可能フラグ
			boolean isFree = false;

			while(!isFree){

				isFree = true;
				// NewsNoの採番と採番テーブルの更新
	            List<Map<String, Object>> seqMap = dao.getSeqSfNextVal(tenantId, "news", "news_id");
	            if (seqMap == null || seqMap.isEmpty()) {
	            	moduleResult.setResultType(ModuleResult.ResultTypes.ERROR);
	                return moduleResult;
	            }

	            newsId = StringUtil.defaultString(String.valueOf(seqMap.get(0).get("seq")));

	            SqlSelectQueryFactory  seleteFactory = SqlSelectQueryFactory.newInstance();
				HashMap<String, Object> selectNewsInfoParamMap = new HashMap<String, Object>();
				selectNewsInfoParamMap.put("tenantId", SQLUtil.toSubMap(tenantId));
				selectNewsInfoParamMap.put("newsId", SQLUtil.toSubMap(StringUtil.defaultString(newsId)));
				SelectQuery seleteNewsInfoQuery = seleteFactory.createSelectQueryFromFile(
						selectNewsInfoParamMap, context.getDto(),
						sqlFileDirPath, "aec20/news/selectNewsInfoByNewsId.sql");
				seleteNewsInfoQuery.prepare();

				// シーケンスから取得されたお知らせIDの存在チェックを行う
				List<Map<String, Object>> newsInfo = tm.required(() -> {
					SelectCommand<List<Map<String, Object>>> command = new SelectCommand<>(
							seleteNewsInfoQuery,new MapResultListHandler(MapKeyNamingType.NONE));
					return command.execute();
				});

	            if(!newsInfo.isEmpty()){
	            	isFree = false;
	            }
			}
		}

		// お知らせ公開先テーブル
		List<Publishing> newsPublishingList = new ArrayList<Publishing>();
		// 選択した得意先分類1
		String[] selectedUserCategories1 = paramMap
				.getValues("newsInfo.selectedUserCategories1");
		int rowNum = 1;
		if (selectedUserCategories1 != null
				&& selectedUserCategories1.length > 0) {
			for (String userCategory : selectedUserCategories1) {

				Publishing publishing = new Publishing();
				publishing.setId(StringUtil.toInteger(newsId, 0));
				publishing.setUserCategoryNum(
						Integer.parseInt(UserCategoryNum.USER_CATEGORY_1));
				publishing.setUserCategoryNumRen(rowNum);
				publishing.setUserCategoryCd(userCategory);
				publishing.setUpdateUserName(loginUserName);
				publishing.setUpdateDatetime(nowDatetime);
				publishing.setUpdateDiv(1);
				publishing.setInsertUserName(loginUserName);
				publishing.setInsertDatetime(nowDatetime);
				publishing.setInsertDiv(1);
				newsPublishingList.add(publishing);
				rowNum++;
			}
		}

		// 選択した得意先分類2
		String[] selectedUserCategories2 = paramMap
				.getValues("newsInfo.selectedUserCategories2");
		rowNum = 1;
		if (selectedUserCategories2 != null
				&& selectedUserCategories2.length > 0) {
			for (String userCategory : selectedUserCategories2) {

				Publishing publishing = new Publishing();
				publishing.setId(StringUtil.toInteger(newsId, 0));
				publishing.setUserCategoryNum(
						Integer.parseInt(UserCategoryNum.USER_CATEGORY_2));
				publishing.setUserCategoryNumRen(rowNum);
				publishing.setUserCategoryCd(userCategory);
				publishing.setUpdateUserName(loginUserName);
				publishing.setUpdateDatetime(nowDatetime);
				publishing.setUpdateDiv(1);
				publishing.setInsertUserName(loginUserName);
				publishing.setInsertDatetime(nowDatetime);
				publishing.setInsertDiv(1);
				newsPublishingList.add(publishing);
				rowNum++;
			}
		}

		// 選択した得意先分類3
		String[] selectedUserCategories3 = paramMap
				.getValues("newsInfo.selectedUserCategories3");
		rowNum = 1;
		if (selectedUserCategories3 != null
				&& selectedUserCategories3.length > 0) {
			for (String userCategory : selectedUserCategories3) {

				Publishing publishing = new Publishing();
				publishing.setId(StringUtil.toInteger(newsId, 0));
				publishing.setUserCategoryNum(
						Integer.parseInt(UserCategoryNum.USER_CATEGORY_3));
				publishing.setUserCategoryNumRen(rowNum);
				publishing.setUserCategoryCd(userCategory);
				publishing.setUpdateUserName(loginUserName);
				publishing.setUpdateDatetime(nowDatetime);
				publishing.setUpdateDiv(1);
				publishing.setInsertUserName(loginUserName);
				publishing.setInsertDatetime(nowDatetime);
				publishing.setInsertDiv(1);
				newsPublishingList.add(publishing);
				rowNum++;
			}
		}

		// 選択した得意先
		String[] selectedUsers = paramMap.getValues("newsInfo.selectedUsers");
		rowNum = 1;
		if (selectedUsers != null && selectedUsers.length > 0) {
			for (String user : selectedUsers) {

				Publishing publishing = new Publishing();
				publishing.setId(StringUtil.toInteger(newsId, 0));
				publishing.setUserCategoryNum(
						Integer.parseInt(UserCategoryNum.USER));
				publishing.setUserCategoryNumRen(rowNum);
				publishing.setUserCd(user);
				publishing.setUpdateUserName(loginUserName);
				publishing.setUpdateDatetime(nowDatetime);
				publishing.setUpdateDiv(1);
				publishing.setInsertUserName(loginUserName);
				publishing.setInsertDatetime(nowDatetime);
				publishing.setInsertDiv(1);
				newsPublishingList.add(publishing);
				rowNum++;
			}
		}

		String commonNewsImgDir = (String) ((Map<String, Object>) systemSettingMap
				.get("newsImagePath")).get("note");
		String imagePath = (String) params.get("imagePath");
		String imageDelFlg = (String) params.get("imageDelFlg");

		/** お知らせ画像のファイル操作 */
		String imageFileName = "";
		if (!UtilTools.isEmpty(imagePath)) {
			// 画像ファイル名を設定 (お知らせID + 拡張子)
			imageFileName = newsId + "." + getSuffix(imagePath);
		}
		if (imageDelFlg != null && "1".equals(imageDelFlg)) {
			// お知らせ画像の削除
			params.put("imagePath", "");

			if (!UtilTools.isEmpty(commonNewsImgDir)
					&& !UtilTools.isEmpty(imagePath)) {
				FileDeleteModule filedeleteModule = new FileDeleteModule();
				filedeleteModule.setDirPath(commonNewsImgDir);
				filedeleteModule.setFileName(imageFileName);
				filedeleteModule.execute(context);
			}

		} else {

			if (!UtilTools.isEmpty(imageFileName)) {

				// お知らせ画像のアップロード
				FileParam newsImageParam = paramMap
						.getFile("newsInfo.newsImage");
				if (newsImageParam != null) {
					File newsImage = newsImageParam.getFile();

					if (newsImage != null
							&& !UtilTools.isEmpty(commonNewsImgDir)) {
						FileCopyModule fileCopyModule = new FileCopyModule();
						fileCopyModule.setSrcFilePath(newsImage.getPath());
						fileCopyModule.setDestDirPath(commonNewsImgDir);
						fileCopyModule.setDestFilePath(imageFileName);
						fileCopyModule.execute(context);
					}
				}
			}
		}

		/** お知らせPDFのファイル操作 */
		String commonNewsPdfDir = (String) ((Map<String, Object>) systemSettingMap
				.get("newsPdfDir")).get("note");
		FileParam[] newsPdfParams = paramMap.getFileParams("newsInfo.newsPdf");
		String[] pdfPath = paramMap.getParams().get("newsInfo.pdfPath");
		String[] pdfDelFlg = paramMap.getParams().get("newsInfo.pdfDelFlg");

		/** お知らせPDF削除(お知らせファイルテーブル) */
		deleteNewsFile(tenantId, newsId, context);

		/** お知らせPDFアップロード */
		if (pdfPath != null && pdfPath.length > 0) {
			for (int i = 0; i < pdfPath.length; i++) {
				String recordNo = StringUtil.defaultString((int) (i + 1));
				String subDirName = newsId + "_" + recordNo;
				String attachedFile = pdfPath[i];

				if (UtilTools.isEmpty(pdfPath[i])) {
					continue;
				}

				// 保存先ディレクトリの作成
				String saveDirPath = commonNewsPdfDir + File.separator
						+ subDirName;
				File saveDir = new File(saveDirPath);
				if (!saveDir.exists()) {
					saveDir.mkdirs();
				}

				FileParam newsPdfParam = null;
				for (int j = 0; j < newsPdfParams.length; j++) {
					FileParam tmpParam = newsPdfParams[j];
					if (pdfPath[i].equals(tmpParam.getFileName())) {
						newsPdfParam = tmpParam;
						break;
					}
				}

				if (newsPdfParam != null
						&& !UtilTools.isEmpty(commonNewsPdfDir)) {
					// お知らせPDFファイルのアップロード
					File newsPdf = newsPdfParam.getFile();
					FileCopyModule fileCopyModule = new FileCopyModule();
					fileCopyModule.setSrcFilePath(newsPdf.getPath());
					fileCopyModule.setDestDirPath(saveDirPath);
					fileCopyModule.setDestFilePath(attachedFile);
					fileCopyModule.execute(context);
				}

				// 削除していなければ再登録
				if (pdfDelFlg[i] == null || !"1".equals(pdfDelFlg[i])) {
					/** お知らせPDF登録(お知らせファイルテーブル) */
					insertNewsFile(tenantId, newsId, context, recordNo,
							attachedFile);
				}
			}
		}

		try {
			ConvertUtils.register(new BigDecimalConverter(null),
					BigDecimal.class);
			BeanUtils.copyProperties(news, params);
			ConvertUtils.deregister();
		} catch (Exception e) {
			e.printStackTrace();
		}

		/** 新規登録 or 更新 */
		if ("insert".equals(execType) || "update".equals(execType)) {
			String startDate = (String) params.get("startDate");
			String endDate = (String) params.get("endDate");
			news.setStartDate(startDate);
			news.setEndDate(endDate);
			news.setNewsImage(imageFileName);

			news.setUpdateDatetime(nowDatetime);
			news.setUpdateUserName(loginUserName);
			news.setUpdateDiv(1);
			news.setInsertDatetime(nowDatetime);
			news.setInsertUserName(loginUserName);
			news.setInsertDiv(1);

			if (isNewRegist) {
				news.setNewsId(StringUtil.toInteger(newsId));

				/** お知らせマスタに新規登録 */
				SqlInsertQueryFactory insertFactory = SqlInsertQueryFactory
						.newInstance();
				HashMap<String, Object> insertNewsInfoParamMap = SQLUtil
						.createNewsInfoParams(tenantId, news, isNewRegist);
				InsertQuery insertNewsInfoQuery = insertFactory
						.createInsertQueryFromFile(insertNewsInfoParamMap,
								context.getDto(), sqlFileDirPath,
								"aec20/news/insertNewsInfo.sql");
				insertNewsInfoQuery.prepare();

				// 登録処理を実行
				result = tm.required(() -> {
					InsertCommand command = new InsertCommand(
							insertNewsInfoQuery);
					return command.execute();
				});

			} else {
				/** お知らせマスタの更新 */
				SqlUpdateQueryFactory updateFactory = SqlUpdateQueryFactory
						.newInstance();
				HashMap<String, Object> updateNewsInfoParamMap = SQLUtil
						.createNewsInfoParams(tenantId, news, isNewRegist);
				UpdateQuery updateNewsInfoQuery = updateFactory
						.createUpdateQueryFromFile(updateNewsInfoParamMap,
								context.getDto(), sqlFileDirPath,
								"aec20/news/updateNewsInfo.sql");
				updateNewsInfoQuery.prepare();

				// 更新処理を実行
				result = tm.required(() -> {
					UpdateCommand command = new UpdateCommand(
							updateNewsInfoQuery);
					return command.execute();
				});
			}

			/** お知らせ公開先削除 */
			SqlDeleteQueryFactory deleteFactory = SqlDeleteQueryFactory
					.newInstance();
			HashMap<String, Object> deleteNewsPubParamMap = new HashMap<String, Object>();
			deleteNewsPubParamMap.put("tenantId", SQLUtil.toSubMap(tenantId));
			deleteNewsPubParamMap.put("procDiv", SQLUtil.toSubMap("news"));
			deleteNewsPubParamMap.put("newsId", SQLUtil
					.toSubMap(StringUtil.defaultString(news.getNewsId())));
			DeleteQuery deleteNewsPubQuery = deleteFactory
					.createDeleteQueryFromFile(deleteNewsPubParamMap,
							context.getDto(), sqlFileDirPath,
							"aec20/publish/deletePublishById.sql");
			deleteNewsPubQuery.prepare();

			// 削除処理を実行
			result = tm.required(() -> {
				DeleteCommand command = new DeleteCommand(deleteNewsPubQuery);
				return command.execute();
			});

			/** お知らせ公開先登録 */
			SqlInsertQueryFactory insertFactory = SqlInsertQueryFactory
					.newInstance();
			for (Publishing newsPub : newsPublishingList) {
				HashMap<String, Object> insertNewsPubParamMap = SQLUtil
						.createInsertPubParams(tenantId, newsPub, "news");
				InsertQuery insertNewsPubQuery = insertFactory
						.createInsertQueryFromFile(insertNewsPubParamMap,
								context.getDto(), sqlFileDirPath,
								"aec20/publish/insertPublishById.sql");
				insertNewsPubQuery.prepare();

				// 登録処理を実行
				result = (int) tm.required(() -> {
					InsertCommand command = new InsertCommand(
							insertNewsPubQuery);
					return command.execute();
				});
			}

			/** 削除 */
		} else if ("delete".equals(execType)) {

			/** お知らせマスタの削除 */
			SqlSelectQueryFactory deleteFactory = SqlSelectQueryFactory
					.newInstance();
			HashMap<String, Object> deleteNewsInfoParamMap = new HashMap<String, Object>();
			deleteNewsInfoParamMap.put("tenantId", SQLUtil.toSubMap(tenantId));
			deleteNewsInfoParamMap.put("newsId",
					SQLUtil.toSubMap(StringUtil.defaultString(newsId)));
			SelectQuery deleteNewsInfoQuery = deleteFactory
					.createSelectQueryFromFile(deleteNewsInfoParamMap,
							context.getDto(), sqlFileDirPath,
							"aec20/news/deleteNewsInfo.sql");
			deleteNewsInfoQuery.prepare();

			// 削除処理を実行
			tm.required(() -> {
				SelectCommand<List<Map<String, Object>>> command = new SelectCommand<>(
						deleteNewsInfoQuery,new MapResultListHandler(MapKeyNamingType.NONE));
				return command.execute();
			});

		}

		return moduleResult;
	}

	/** お知らせ公開先 - 得意先分類番号 */
	public static class UserCategoryNum {
		/** 得意先分類1 */
		public static final String USER_CATEGORY_1 = "1";
		/** 得意先分類2 */
		public static final String USER_CATEGORY_2 = "2";
		/** 得意先分類3 */
		public static final String USER_CATEGORY_3 = "3";
		/** 得意先 */
		public static final String USER = "4";
	}

	/**
	 * ファイル名から拡張子を返します。
	 *
	 * @param fileName ファイル名
	 * @return ファイルの拡張子
	 */
	private String getSuffix(String fileName) {
		if (fileName == null) {
			return null;
		}
		int point = fileName.lastIndexOf(".");
		if (point != -1) {
			return fileName.substring(point + 1);
		}
		return fileName;
	}

	/** お知らせPDF削除(お知らせファイルテーブル) */
	private int deleteNewsFile(	String tenantId,
								String newsId,
								ModuleContext context)
			throws PhotonModuleException {
		TransactionManager tm = DomaConfig.singleton().getTransactionManager();
		SqlSelectQueryFactory deleteFactory = SqlSelectQueryFactory
				.newInstance();
		HashMap<String, Object> deleteNewsPdfMap = new HashMap<String, Object>();
		deleteNewsPdfMap.put("tenantId", SQLUtil.toSubMap(tenantId));
		deleteNewsPdfMap.put("newsId",
				SQLUtil.toSubMap(StringUtil.defaultString(newsId)));
		SelectQuery deleteNewsPdfQuery = deleteFactory
				.createSelectQueryFromFile(deleteNewsPdfMap, context.getDto(),
						sqlFileDirPath, "aec20/news/deleteNewsPdf.sql");
		deleteNewsPdfQuery.prepare();

		// 削除処理を実行
		tm.required(() -> {
			SelectCommand<List<Map<String, Object>>> command = new SelectCommand<>(
					deleteNewsPdfQuery,new MapResultListHandler(MapKeyNamingType.NONE));
			return command.execute();
		});

		return Integer.valueOf(0);
	}

	/** お知らせPDF登録(お知らせファイルテーブル) */
	private int insertNewsFile(	String tenantId,
								String newsId,
								ModuleContext context,
								String recordNo,
								String attachedFile)
			throws PhotonModuleException {
		TransactionManager tm = DomaConfig.singleton().getTransactionManager();
		SqlInsertQueryFactory insertFactory = SqlInsertQueryFactory
				.newInstance();
		HashMap<String, Object> insertNewsPdfMap = new HashMap<String, Object>();
		String nowDatetime = SQLUtil.getNowDatetime();
		String loginUserName = SQLUtil.getLoginAdminUserName(context.getDto());
		insertNewsPdfMap.put("tenantId", SQLUtil.toSubMap(tenantId));
		insertNewsPdfMap.put("newsId",
				SQLUtil.toSubMap(StringUtil.defaultString(StringUtil.toInteger(newsId, 0))));
		insertNewsPdfMap.put("recordNo", SQLUtil.toSubMap(recordNo));
		insertNewsPdfMap.put("attachedFile", SQLUtil.toSubMap(attachedFile));
		insertNewsPdfMap.put("updateUserName", SQLUtil.toSubMap(loginUserName));
		insertNewsPdfMap.put("updateDatetime", SQLUtil.toSubMap(nowDatetime));
		insertNewsPdfMap.put("insertUserName", SQLUtil.toSubMap(loginUserName));
		insertNewsPdfMap.put("insertDatetime", SQLUtil.toSubMap(nowDatetime));
		InsertQuery insertNewsPdfQuery = insertFactory
				.createInsertQueryFromFile(insertNewsPdfMap, context.getDto(),
						sqlFileDirPath, "aec20/news/insertNewsPdf.sql");
		insertNewsPdfQuery.prepare();

		// 登録処理を実行
		int result = (int) tm.required(() -> {
			InsertCommand command = new InsertCommand(insertNewsPdfQuery);
			return command.execute();
		});
		return result;
	}

	/**
	 * paramJsonを取得します。
	 *
	 * @return paramJson
	 */
	public Map<String, Object> getParamJson() {
		return paramJson;
	}

	/**
	 * paramJsonを設定します。
	 *
	 * @param paramJson
	 */
	public void setParamJson(Map<String, Object> paramJson) {
		this.paramJson = paramJson;
	}

	/**
	 * fileFormsを取得します。
	 *
	 * @return fileForms
	 */
	public List<FileForm> getFileForms() {
		return fileForms;
	}

	/**
	 * fileFormsを設定します。
	 *
	 * @param fileForms
	 */
	public void setFileForms(List<FileForm> fileForms) {
		this.fileForms = fileForms;
	}

	/**
	 * sqlFileDirPathを取得します。
	 *
	 * @return sqlFileDirPath
	 */
	public String getSqlFileDirPath() {
		return sqlFileDirPath;
	}

	/**
	 * sqlFileDirPathを設定します。
	 *
	 * @param sqlFileDirPath
	 */
	public void setSqlFileDirPath(String sqlFileDirPath) {
		this.sqlFileDirPath = sqlFileDirPath;
	}

	/**
	 * execTypeを取得します。
	 *
	 * @return execType
	 */
	public String getExecType() {
		return execType;
	}

	/**
	 * execTypeを設定します。
	 *
	 * @param execType
	 */
	public void setExecType(String execType) {
		this.execType = execType;
	}

}
