package jp.ill.photon.module.news;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.dao.DomaConfig;
import jp.ill.photon.dao.JsonDataDao;
import jp.ill.photon.dao.JsonDataDaoImpl;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.model.SearchForm;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.db.SqlFileSelectModule;

import org.seasar.doma.jdbc.tx.TransactionManager;

public class NewsDetailModule extends SqlFileSelectModule {

    @ModuleParam(required = true, domainObject = true)
    private SearchForm searchForm;

    @ModuleParam(required = true)
    private String sqlFileDirPath;

    @ModuleParam(required = true)
    private String sqlFilePath;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "param", transferVal = "news_id")
    private String newsId;

    public SearchForm getSearchForm() {
        return searchForm;
    }

    public void setSearchForm(SearchForm searchForm) {
        this.searchForm = searchForm;
    }

    public String getSqlFileDirPath() {
        return sqlFileDirPath;
    }

    public void setSqlFileDirPath(String sqlFileDirPath) {
        this.sqlFileDirPath = sqlFileDirPath;
    }

    public String getSqlFilePath() {
        return sqlFilePath;
    }

    public void setSqlFilePath(String sqlFilePath) {
        this.sqlFilePath = sqlFilePath;
    }

    public String getNewsId() {
        return newsId;
    }

    public void setNewsId(String newsId) {
        this.newsId = newsId;
    }

    @Override
    public ModuleResult execute(ModuleContext context) throws PhotonModuleException {
        ModuleResult result = super.execute(context);

        List<Map<String, Object>> newsList = (List<Map<String, Object>>)result.getReturnData().get("list");

        Map<String, Object> newsMap = null;

        // 有効データチェック
        boolean isChecked = false;
        for (Map<String, Object> news : newsList) {
            String checkId = String.valueOf(news.get("news_id"));
            if (newsId.equals(checkId)) {
                isChecked = true;
                newsMap = news;
                break;
            }
        }

        if (newsMap != null) {
            String contentFormat = String.valueOf(newsMap.get("content_format"));
            String detail = String.valueOf(newsMap.get("detail"));
            if ("0".equals(contentFormat)) {
                newsMap.put("detail", detail.replaceAll("\n", "<br />"));
            } else {
                //newsMap.put("detail", StringEscapeUtils.escapeXml(detail));
            }
        }
        result.getReturnData().put("news", newsMap);

        if (!isChecked) {
            result.getReturnData().put("news_validity_flg", "0");
        }

        // お知らせファイル情報取得
        TransactionManager tm = DomaConfig.singleton().getTransactionManager();
        JsonDataDao dao = new JsonDataDaoImpl();

        List<Map<String, Object>> newsFileList = tm.required(() -> {
            return dao.getNewsFileData(context.getDto().getTenantId(), newsId);
        });

        result.getReturnData().put("news_file_list", newsFileList);

        // リストを日付順にソート
        Collections.sort(newsList, new Comparator() {
            public int compare (Object news1, Object news2) {
                String news1DateStr = ((Map<String, Object>)news1).get("start_date") == null ? "1900-01-01" : String.valueOf(((Map<String, Object>)news1).get("start_date"));
                news1DateStr = "".equals(news1DateStr) ? "1900-01-01" : news1DateStr.substring(0,  11);

                String news2DateStr = ((Map<String, Object>)news2).get("start_date") == null ? "1900-01-01" : String.valueOf(((Map<String, Object>)news2).get("start_date"));
                news2DateStr = "".equals(news2DateStr) ? "1900-01-01" : news2DateStr.substring(0,  11);

                return news1DateStr.compareTo(news2DateStr);
            }
        });

        int index = -1;
        for (int i = 0; i < newsList.size(); i++) {
            Map<String, Object> news = newsList.get(i);
            String checkId = String.valueOf(news.get("news_id"));
            if (newsId.equals(checkId)) {
                index = i;
            }
        }
        if (index == -1) {
        	return result;
        }
        // 前、次のお知らせ情報を取得
        String prevNewsId = index == 0 ? "" : String.valueOf(newsList.get(index - 1).get("news_id"));
        String nextNewsId = index == newsList.size() - 1 ? "" : String.valueOf(newsList.get(index + 1).get("news_id"));

        result.getReturnData().put("prev_news_id", prevNewsId);
        result.getReturnData().put("next_news_id", nextNewsId);

        return result;
    }




}
