package jp.ill.photon.module.news;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.model.SearchForm;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.db.SqlFileSelectModule;
import jp.ill.photon.util.JsonUtil;
import jp.ill.photon.util.StringUtil;

public class NewsDetailAdminModule extends SqlFileSelectModule {

    @ModuleParam(required = true, domainObject = true)
    private SearchForm searchForm;

    @ModuleParam(required = true)
    private String sqlFileDirPath;

    @ModuleParam(required = true)
    private String sqlFilePath;

    @ModuleParam(required = false)
    @DefaultParamSetting(transferType = "param", transferVal = "news_id")
    private String newsId;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "published_user_category1_list.list")
    private List<Map<String, Object>> publishedUserCategory1List;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "published_user_category2_list.list")
    private List<Map<String, Object>> publishedUserCategory2List;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "published_user_category3_list.list")
    private List<Map<String, Object>> publishedUserCategory3List;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "published_user_list.list")
    private List<Map<String, Object>> publishedUserList;

    public SearchForm getSearchForm() {
        return searchForm;
    }

    public void setSearchForm(SearchForm searchForm) {
        this.searchForm = searchForm;
    }

    public String getSqlFileDirPath() {
        return sqlFileDirPath;
    }

    public void setSqlFileDirPath(String sqlFileDirPath) {
        this.sqlFileDirPath = sqlFileDirPath;
    }

    public String getSqlFilePath() {
        return sqlFilePath;
    }

    public void setSqlFilePath(String sqlFilePath) {
        this.sqlFilePath = sqlFilePath;
    }

    public String getNewsId() {
        return newsId;
    }

    public void setNewsId(String newsId) {
        this.newsId = newsId;
    }

    public List<Map<String, Object>> getPublishedUserCategory1List() {
        return publishedUserCategory1List;
    }

    public void setPublishedUserCategory1List(List<Map<String, Object>> publishedUserCategory1List) {
        this.publishedUserCategory1List = publishedUserCategory1List;
    }

    public List<Map<String, Object>> getPublishedUserCategory2List() {
        return publishedUserCategory2List;
    }

    public void setPublishedUserCategory2List(List<Map<String, Object>> publishedUserCategory2List) {
        this.publishedUserCategory2List = publishedUserCategory2List;
    }

    public List<Map<String, Object>> getPublishedUserCategory3List() {
        return publishedUserCategory3List;
    }

    public void setPublishedUserCategory3List(List<Map<String, Object>> publishedUserCategory3List) {
        this.publishedUserCategory3List = publishedUserCategory3List;
    }

    public List<Map<String, Object>> getPublishedUserList() {
        return publishedUserList;
    }

    public void setPublishedUserList(List<Map<String, Object>> publishedUserList) {
        this.publishedUserList = publishedUserList;
    }

    @Override
    public ModuleResult execute(ModuleContext context) throws PhotonModuleException {
        ModuleResult result = super.execute(context);

        @SuppressWarnings("unchecked")
		Map<String, Object> newsInfo = (Map<String, Object>) result.getReturnData().get("first");

        Map<String, Object> newsMap = new HashMap<String, Object>();
        if(newsInfo != null){
	        String newsId = (String) newsInfo.get("news_id");
	        newsMap.put("news_id", newsId);
	        newsMap.put("title", newsInfo.get("title"));
	        newsMap.put("image", newsInfo.get("image"));
	        newsMap.put("content_format", newsInfo.get("content_format"));
	        newsMap.put("detail", newsInfo.get("detail"));
	        newsMap.put("news_type", newsInfo.get("news_type"));
			newsMap.put("start_date", newsInfo.get("start_date"));
			newsMap.put("start_datetime", newsInfo.get("start_datetime"));
			newsMap.put("end_date", newsInfo.get("end_date"));
			newsMap.put("end_datetime", newsInfo.get("end_datetime"));
			newsMap.put("disp_flg", newsInfo.get("disp_flg"));
			newsMap.put("sort_no", newsInfo.get("sort_no"));
			newsMap.put("disp_div", newsInfo.get("disp_div"));
			newsMap.put("user_category1_disp_div", StringUtil.defaultString(newsInfo.get("user_category1_disp_div"), "0"));
			newsMap.put("user_category2_disp_div", StringUtil.defaultString(newsInfo.get("user_category2_disp_div"), "0"));
			newsMap.put("user_category3_disp_div", StringUtil.defaultString(newsInfo.get("user_category3_disp_div"), "0"));
			newsMap.put("user_disp_div", StringUtil.defaultString(newsInfo.get("user_disp_div"), "0"));

			// 公開先得意先分類リスト
			newsMap.put("published_user_category1_list_json", JsonUtil.mapToJson(getPublishedUserCategory1List()));
			newsMap.put("published_user_category2_list_json", JsonUtil.mapToJson(getPublishedUserCategory2List()));
			newsMap.put("published_user_category3_list_json", JsonUtil.mapToJson(getPublishedUserCategory3List()));
			// 公開先得意先リスト
			newsMap.put("published_user_list_json", JsonUtil.mapToJson(getPublishedUserList()));

			newsMap.put("meta_description", newsInfo.get("meta_description"));
			newsMap.put("meta_keywords", newsInfo.get("meta_keywords"));

        }else{

        	// 新規登録デフォルト値
	        newsMap.put("content_format", "1");
	        newsMap.put("news_type", "1");
			newsMap.put("disp_flg", "1");
			newsMap.put("disp_div", "1");
        }

        result.setReturnData(newsMap);

        return result;
    }

}
