package jp.ill.photon.module.mail;

import java.util.LinkedHashMap;
import java.util.Map;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.ParamUtil;
import jp.ill.photon.util.StringUtil;
import jp.ill.photon.util.mail.MailUtil;

public class TransferMailContentModule implements PhotonModule {

	@ModuleParam(required = true)
	private String templateContent;

	@ModuleParam(required = true)
	private Map<String, Object> transferContent;

	@ModuleParam(required = true)
	private String title;

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getTemplateContent() {
		return templateContent;
	}

	public void setTemplateContent(String templateContent) {
		this.templateContent = templateContent;
	}

	public Map<String, Object> getTransferContent() {
		return transferContent;
	}

	public void setTransferContent(Map<String, Object> transferContent) {
		this.transferContent = transferContent;
	}

	@Override
	public ModuleResult execute(ModuleContext context)
			throws PhotonModuleException {

		ModuleResult result = new ModuleResult();

		Map<String, Object> params = new LinkedHashMap<>();
		Map<String, String> paramFormats = new LinkedHashMap<>();
		String paramType = null;
		for (Map.Entry<String, Object> param : transferContent.entrySet()) {
			paramType = StringUtil
					.defaultString((((Map) param.getValue()).get("type")), "");
			params.put((String) param.getKey(),
					ParamUtil.getParamValueByType(paramType,
							((Map) param.getValue()).get("val"),
							context.getDto()));
			paramFormats.put((String) param.getKey(), StringUtil
					.defaultString(((Map) param.getValue()).get("format"), ""));
		}

		String resultTitle = MailUtil.processMailTemplate(title, params,
				paramFormats);
		String resultContent = MailUtil.processMailTemplate(templateContent,
				params, paramFormats);

		result.getReturnData().put("result_title", resultTitle);
		result.getReturnData().put("result_contents", resultContent);

		return result;
	}
}
