package jp.ill.photon.module.mail;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.mail.EmailException;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.message.ActionDtoMessage;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.LogUtil;
import jp.ill.photon.util.StringUtil;
import jp.ill.photon.util.UtilTools;
import jp.ill.photon.util.mail.SmtpMailSender;

/**
 * テストメール送信モジュール
 *
 * @author y_hirota
 *
 */
public class TestMailSendModule implements PhotonModule {

	/** メール送信サーバアドレス */
	@ModuleParam(required = true)
	private String smtpHost;

	/** メール送信サーバポート */
	@ModuleParam(required = true)
	private String smtpPort;

	/** メール送信認証用ユーザー名 */
	@ModuleParam(required = false)
	private String smtpUserName;

	/** メール送信認証用パスワード */
	@ModuleParam(required = false)
	private String smtpPassword;

	/** テスト送信先メールアドレス */
	@ModuleParam(required = true)
	private String testToAddress;

	/** 送信メール件名 */
	@ModuleParam(required = true)
	private String subject;

	/** 送信メール内容 */
	@ModuleParam(required = true)
	private String contents;

	/** 送信メールキャラクタセット */
	@ModuleParam(required = false)
	private String charSet;

	/** 送信元メールアドレス */
	@ModuleParam(required = true)
	private String fromAddress;

	/** 送信者名 */
	@ModuleParam(required = true)
	private String fromAddressName;

	/** 返信用メールアドレス */
	@ModuleParam(required = true)
	private String replyAddress;

	/** ログ用変数 */
	protected final LogUtil logger = new LogUtil(TestMailSendModule.class);

	@Override
	public ModuleResult execute(ModuleContext context)
			throws PhotonModuleException {

		ModuleResult result = new ModuleResult();

		Map<String, Object> messages = new HashMap<>();
		List<ActionDtoMessage> pageInfoMessageList = new ArrayList<>();
		List<ActionDtoMessage> pageErrorMessageList = new ArrayList<>();
		messages.put("info_page", pageInfoMessageList);
		messages.put("error_page", pageErrorMessageList);

		int port = Integer.parseInt(getSmtpPort());
		SmtpMailSender sender = new SmtpMailSender(getSmtpHost(), port,
				getSmtpUserName(), getSmtpPassword());

		Map<String, String> testMailAddressMap = new HashMap<String, String>();
		if (!UtilTools.isEmpty(testToAddress)) {
			testMailAddressMap.put(testToAddress, testToAddress);
		} else {
			ActionDtoMessage message = new ActionDtoMessage();
			message.setMessageId("inputErrTestMailAddressEmpty");
			pageErrorMessageList.add(message);

			result.setResultCode("failed");
			result.setMessages(messages);
			return result;
		}

		try {
			sender.sendMail(testMailAddressMap, null, null, getSubject(),
					getContents(), getCharSet(), getFromAddress(),
					getFromAddressName(), getReplyAddress());
			logger.error("テストメール送信完了："
					+ StringUtil.defaultString(testToAddress, ""));
		} catch (EmailException e) {
			logger.error("テストメール送信失敗", e);
			ActionDtoMessage message = new ActionDtoMessage();
			message.setMessageId("testMailSendFailed");
			pageErrorMessageList.add(message);

			result.setResultCode("failed");
			result.setMessages(messages);
			return result;
		}

		ActionDtoMessage message = new ActionDtoMessage();
		message.setMessageId("testMailSendSuccess");
		pageInfoMessageList.add(message);

		result.setResultCode("success");
		result.setMessages(messages);
		return result;
	}

	public String getSmtpHost() {
		return smtpHost;
	}

	public void setSmtpHost(String smtpHost) {
		this.smtpHost = smtpHost;
	}

	public String getSmtpPort() {
		return smtpPort;
	}

	public void setSmtpPort(String smtpPort) {
		this.smtpPort = smtpPort;
	}

	public String getSmtpUserName() {
		return smtpUserName;
	}

	public void setSmtpUserName(String smtpUserName) {
		this.smtpUserName = smtpUserName;
	}

	public String getSmtpPassword() {
		return smtpPassword;
	}

	public void setSmtpPassword(String smtpPassword) {
		this.smtpPassword = smtpPassword;
	}

	public String getTestToAddress() {
		return testToAddress;
	}

	public void setTestToAddress(String testToAddress) {
		this.testToAddress = testToAddress;
	}

	public String getSubject() {
		return subject;
	}

	public void setSubject(String subject) {
		this.subject = subject;
	}

	public String getContents() {
		return contents;
	}

	public void setContents(String contents) {
		this.contents = contents;
	}

	public String getCharSet() {
		return charSet;
	}

	public void setCharSet(String charSet) {
		this.charSet = charSet;
	}

	public String getFromAddress() {
		return fromAddress;
	}

	public void setFromAddress(String fromAddress) {
		this.fromAddress = fromAddress;
	}

	public String getFromAddressName() {
		return fromAddressName;
	}

	public void setFromAddressName(String fromAddressName) {
		this.fromAddressName = fromAddressName;
	}

	public String getReplyAddress() {
		return replyAddress;
	}

	public void setReplyAddress(String replyAddress) {
		this.replyAddress = replyAddress;
	}

}
