package jp.ill.photon.module.mail;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.commons.mail.EmailException;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.CheckUtil;
import jp.ill.photon.util.ParamUtil;
import jp.ill.photon.util.StringUtil;
import jp.ill.photon.util.mail.MailUtil;
import jp.ill.photon.util.mail.SmtpMailSender;

/**
 * SMTPメール送信モジュール
 *
 */
public class SmtpMailSendMultipleUserModule implements PhotonModule {

	/** メール送信サーバアドレス（デフォルトはシステム設定値） */
	@ModuleParam(required = false)
	private String smtpHost;

	/** メール送信サーバポート（デフォルトはシステム設定値） */
	@ModuleParam(required = false)
	private String smtpPort;

	/** メール送信認証用ユーザー名（デフォルトはシステム設定値） */
	@ModuleParam(required = false)
	private String smtpUserName;

	/** メール送信認証用パスワード（デフォルトはシステム設定値） */
	@ModuleParam(required = false)
	private String smtpPassword;

	/** TO送信先マップ（キーが名称で値がメール・アドレス） */
	@ModuleParam(required = false)
	private List<Map<String, Object>> toAddressesList;

	/** TO送信先マップ（キーが名称で値がメール・アドレス） */
	@ModuleParam(required = false)
	private Map<String, Object> toAddresses;

	/** CC送信先マップ（キーが名称で値がメール・アドレス） */
	@ModuleParam(required = false)
	private Map<String, Object> ccAddresses;

	/** BCC送信先マップ（キーが名称で値がメール・アドレス） */
	@ModuleParam(required = false)
	private Map<String, Object> bccAddresses;

	/** メール件名 */
	@ModuleParam(required = true)
	private String templateTitle;

	/** メール本文 */
	@ModuleParam(required = true)
	private String templateContent;
	
	/** 無効フラグ  0:有効　1:無効 */
	@ModuleParam(required = true)
	private Integer invaildFlg;

	/** 特定文字と置換文字の設定 */
	@ModuleParam(required = false)
	private Map<String, Object> transferContent;

	/** メール出力値 */
	@ModuleParam(required = false)
	private List<Map<String, Object>> contentsList;

	/** 送信メール内容 */
	@ModuleParam(required = false)
	private String contents;

	/** 送信メールキャラクタセット */
	@ModuleParam(required = false)
	private String charSet;

	/** 送信元メールアドレス */
	@ModuleParam(required = false)
	private String fromAddress;

	/** 送信者名 */
	@ModuleParam(required = false)
	private String fromAddressName;

	/** 返信用メールアドレス */
	@ModuleParam(required = false)
	private String replyAddress;

	@SuppressWarnings({ "unchecked", "rawtypes" })
	@Override
	public ModuleResult execute(ModuleContext context)
			throws PhotonModuleException {
		// 結果オブジェクト生成
		ModuleResult result = new ModuleResult();

		// メール送信サーバアドレス
		if (CheckUtil.isEmpty(smtpHost)) {
			smtpHost = String.valueOf(ParamUtil.getParamValueByType("dto", "common.systemsetting.smtp.note", context.getDto()));
		}
		// メール送信サーバポート
		if (CheckUtil.isEmpty(smtpPort)) {
			smtpPort = String.valueOf(ParamUtil.getParamValueByType("dto", "common.systemsetting.sendMailPort.note", context.getDto()));
		}
		// メール送信認証用ユーザー名
		if (CheckUtil.isEmpty(smtpUserName)) {
			smtpUserName = String.valueOf(ParamUtil.getParamValueByType("dto", "common.systemsetting.sendMailUserName.note", context.getDto()));
		}
		// メール送信認証用パスワード
		if (CheckUtil.isEmpty(smtpPassword)) {
			smtpPassword = String.valueOf(ParamUtil.getParamValueByType("dto", "common.systemsetting.sendMailPassword.note", context.getDto()));
		}
		// 送信先初期化
		if (toAddresses == null) {
			toAddresses = new HashMap<String, Object>();
		}
		if (ccAddresses == null) {
			ccAddresses = new HashMap<String, Object>();
		}
		if (bccAddresses == null) {
			bccAddresses = new HashMap<String, Object>();
		}

		SmtpMailSender sender = new SmtpMailSender(getSmtpHost(), Integer.valueOf(getSmtpPort()), getSmtpUserName(), getSmtpPassword());

		// 送信先メールアドレス設定 <メールアドレス, メール出力内容>のリストを作成
		List<Map<String, Object>> mailAddressContentsList = new ArrayList<Map<String, Object>>();
		List<Map<String, Object>> mailAddressContentsSuccessList = new ArrayList<Map<String, Object>>();
		List<Map<String, Object>> mailAddressContentsFaildList = new ArrayList<Map<String, Object>>();
		if (contentsList != null && contentsList.size() > 0) {
			// メール出力値の設定を優先
			for (Map<String, Object> map : contentsList) {
				if (map.get("send_mail_address") == null) {
					// １件でも設定がない場合は、TO送信先マップを使用する
					mailAddressContentsList = new ArrayList<Map<String, Object>>();
					break;

				} else {
					Map<String, Object> contentMap = new HashMap<String, Object>();
					contentMap.put(String.valueOf(map.get("send_mail_address")), map);
					mailAddressContentsList.add(contentMap);
				}
			}
		}

		if (mailAddressContentsList.size() == 0 && toAddressesList != null) {
			// TO送信先マップの設定を使用
			for (Map<String, Object> map : toAddressesList) {
				if (map.isEmpty()) {
					// 送信先メールアドレスの設定がない場合は処理終了
					return result;

				} else {
					Map<String, Object> contentMap = new HashMap<String, Object>();
					String send_mail_address = "";
					for (Map.Entry<String, Object> param : map.entrySet()) {
						Map content = (Map) param.getValue();
						send_mail_address = String.valueOf(
								ParamUtil.getParamValueByType(String.valueOf(content.get("type")), content.get("val"), context.getDto()));

					}
					contentMap.put(send_mail_address, new HashMap<String, Object>());
					mailAddressContentsList.add(contentMap);

				}
			}

			if (toAddresses != null && !toAddresses.isEmpty()) {
				String send_mail_address = "";
				for (Map.Entry<String, Object> param : toAddresses.entrySet()) {
					Map content = (Map) param.getValue();
					send_mail_address = String.valueOf(
							ParamUtil.getParamValueByType(String.valueOf(content.get("type")), content.get("val"), context.getDto()));

				}
				Map<String, Object> contentMap = new HashMap<String, Object>();
				contentMap.put(send_mail_address, new HashMap<String, Object>());
				mailAddressContentsList.add(contentMap);

			}
		}

		for (Map<String, Object> map : mailAddressContentsList) {
			for (Entry<String, Object> entry : map.entrySet()) {
				Map tmpMap = null;
				try {
					// 送信メール内容を作成
					tmpMap = (Map) entry.getValue();
					// 件名
					String title = StringUtil.getDecodString(templateTitle, transferContent, tmpMap);
					// 本文
					String content = StringUtil.getDecodString(templateContent, transferContent, tmpMap);

					// to送信先
					toAddresses.put(entry.getKey(), entry.getKey());

					// メール送信 無効フラグが 0:有効 の場合、送信する
					if (invaildFlg == 0) {
						sender.sendMail(
								MailUtil.getAddressFormat(getToAddresses()),
								MailUtil.getAddressFormat(getCcAddresses(), context),
								MailUtil.getAddressFormat(getBccAddresses(), context),
								title,
								content,
								getCharSet(),
								getFromAddress(),
								getFromAddressName(),
								getReplyAddress());
					}

					// メール送信成功
					tmpMap.put("result", "success");
					mailAddressContentsSuccessList.add(tmpMap);

				} catch (EmailException emailException) {
					// メール送信失敗
					tmpMap.put("result", "false");
					mailAddressContentsFaildList.add(tmpMap);

				} catch (Exception e) {
					if (tmpMap == null) {
						// input異常
						throw e;

					} else {
						// メール送信失敗
						tmpMap.put("result", "err");
						mailAddressContentsFaildList.add(tmpMap);

					}
				}

				map.put(entry.getKey(), tmpMap);
			}
		}

		result.setResultCode("success");
		result.getReturnData().put("mail_contents", mailAddressContentsList);
		result.getReturnData().put("mail_contents_success", mailAddressContentsSuccessList);
		result.getReturnData().put("mail_contents_faild", mailAddressContentsFaildList);

		return result;
	}

	/**
	 * メール送信サーバアドレス（デフォルトはシステム設定値）を取得します。
	 * @return メール送信サーバアドレス（デフォルトはシステム設定値）
	 */
	public String getSmtpHost() {
	    return smtpHost;
	}

	/**
	 * メール送信サーバアドレス（デフォルトはシステム設定値）を設定します。
	 * @param smtpHost メール送信サーバアドレス（デフォルトはシステム設定値）
	 */
	public void setSmtpHost(String smtpHost) {
	    this.smtpHost = smtpHost;
	}

	/**
	 * メール送信サーバポート（デフォルトはシステム設定値）を取得します。
	 * @return メール送信サーバポート（デフォルトはシステム設定値）
	 */
	public String getSmtpPort() {
	    return smtpPort;
	}

	/**
	 * メール送信サーバポート（デフォルトはシステム設定値）を設定します。
	 * @param smtpPort メール送信サーバポート（デフォルトはシステム設定値）
	 */
	public void setSmtpPort(String smtpPort) {
	    this.smtpPort = smtpPort;
	}

	/**
	 * メール送信認証用ユーザー名（デフォルトはシステム設定値）を取得します。
	 * @return メール送信認証用ユーザー名（デフォルトはシステム設定値）
	 */
	public String getSmtpUserName() {
	    return smtpUserName;
	}

	/**
	 * メール送信認証用ユーザー名（デフォルトはシステム設定値）を設定します。
	 * @param smtpUserName メール送信認証用ユーザー名（デフォルトはシステム設定値）
	 */
	public void setSmtpUserName(String smtpUserName) {
	    this.smtpUserName = smtpUserName;
	}

	/**
	 * メール送信認証用パスワード（デフォルトはシステム設定値）を取得します。
	 * @return メール送信認証用パスワード（デフォルトはシステム設定値）
	 */
	public String getSmtpPassword() {
	    return smtpPassword;
	}

	/**
	 * メール送信認証用パスワード（デフォルトはシステム設定値）を設定します。
	 * @param smtpPassword メール送信認証用パスワード（デフォルトはシステム設定値）
	 */
	public void setSmtpPassword(String smtpPassword) {
	    this.smtpPassword = smtpPassword;
	}

	/**
	 * TO送信先マップ（キーが名称で値がメール・アドレス）を取得します。
	 * @return TO送信先マップ（キーが名称で値がメール・アドレス）
	 */
	public List<Map<String,Object>> getToAddressesList() {
	    return toAddressesList;
	}

	/**
	 * TO送信先マップ（キーが名称で値がメール・アドレス）を設定します。
	 * @param toAddressesList TO送信先マップ（キーが名称で値がメール・アドレス）
	 */
	public void setToAddressesList(List<Map<String,Object>> toAddressesList) {
	    this.toAddressesList = toAddressesList;
	}

	/**
	 * TO送信先マップ（キーが名称で値がメール・アドレス）を取得します。
	 * @return TO送信先マップ（キーが名称で値がメール・アドレス）
	 */
	public Map<String,Object> getToAddresses() {
	    return toAddresses;
	}

	/**
	 * TO送信先マップ（キーが名称で値がメール・アドレス）を設定します。
	 * @param toAddresses TO送信先マップ（キーが名称で値がメール・アドレス）
	 */
	public void setToAddresses(Map<String,Object> toAddresses) {
	    this.toAddresses = toAddresses;
	}

	/**
	 * CC送信先マップ（キーが名称で値がメール・アドレス）を取得します。
	 * @return CC送信先マップ（キーが名称で値がメール・アドレス）
	 */
	public Map<String,Object> getCcAddresses() {
	    return ccAddresses;
	}

	/**
	 * CC送信先マップ（キーが名称で値がメール・アドレス）を設定します。
	 * @param ccAddresses CC送信先マップ（キーが名称で値がメール・アドレス）
	 */
	public void setCcAddresses(Map<String,Object> ccAddresses) {
	    this.ccAddresses = ccAddresses;
	}

	/**
	 * BCC送信先マップ（キーが名称で値がメール・アドレス）を取得します。
	 * @return BCC送信先マップ（キーが名称で値がメール・アドレス）
	 */
	public Map<String,Object> getBccAddresses() {
	    return bccAddresses;
	}

	/**
	 * BCC送信先マップ（キーが名称で値がメール・アドレス）を設定します。
	 * @param bccAddresses BCC送信先マップ（キーが名称で値がメール・アドレス）
	 */
	public void setBccAddresses(Map<String,Object> bccAddresses) {
	    this.bccAddresses = bccAddresses;
	}

	/**
	 * メール件名を取得します。
	 * @return メール件名
	 */
	public String getTemplateTitle() {
	    return templateTitle;
	}

	/**
	 * メール件名を設定します。
	 * @param templateTitle メール件名
	 */
	public void setTemplateTitle(String templateTitle) {
	    this.templateTitle = templateTitle;
	}

	/**
	 * メール本文を取得します。
	 * @return メール本文
	 */
	public String getTemplateContent() {
	    return templateContent;
	}

	/**
	 * メール本文を設定します。
	 * @param templateContent メール本文
	 */
	public void setTemplateContent(String templateContent) {
	    this.templateContent = templateContent;
	}

	/**
	 * 無効フラグを取得します。  0:有効　1:無効
	 * @return 無効フラグ
	 */
	public Integer getInvaildFlg() {
	    return invaildFlg;
	}

	/**
	 * 無効フラグを設定します。 0:有効　1:無効
	 * @param invaildFlg 無効フラグ
	 */
	public void setInvaildFlg(Integer invaildFlg) {
	    this.invaildFlg = invaildFlg;
	}

	/**
	 * 特定文字と置換文字の設定を取得します。
	 * @return 特定文字と置換文字の設定
	 */
	public Map<String,Object> getTransferContent() {
	    return transferContent;
	}

	/**
	 * 特定文字と置換文字の設定を設定します。
	 * @param transferContent 特定文字と置換文字の設定
	 */
	public void setTransferContent(Map<String,Object> transferContent) {
	    this.transferContent = transferContent;
	}

	/**
	 * メール出力値を取得します。
	 * @return メール出力値
	 */
	public List<Map<String,Object>> getContentsList() {
	    return contentsList;
	}

	/**
	 * メール出力値を設定します。
	 * @param contentsList メール出力値
	 */
	public void setContentsList(List<Map<String,Object>> contentsList) {
	    this.contentsList = contentsList;
	}

	/**
	 * 送信メール内容を取得します。
	 * @return 送信メール内容
	 */
	public String getContents() {
	    return contents;
	}

	/**
	 * 送信メール内容を設定します。
	 * @param contents 送信メール内容
	 */
	public void setContents(String contents) {
	    this.contents = contents;
	}

	/**
	 * 送信メールキャラクタセットを取得します。
	 * @return 送信メールキャラクタセット
	 */
	public String getCharSet() {
	    return charSet;
	}

	/**
	 * 送信メールキャラクタセットを設定します。
	 * @param charSet 送信メールキャラクタセット
	 */
	public void setCharSet(String charSet) {
	    this.charSet = charSet;
	}

	/**
	 * 送信元メールアドレスを取得します。
	 * @return 送信元メールアドレス
	 */
	public String getFromAddress() {
	    return fromAddress;
	}

	/**
	 * 送信元メールアドレスを設定します。
	 * @param fromAddress 送信元メールアドレス
	 */
	public void setFromAddress(String fromAddress) {
	    this.fromAddress = fromAddress;
	}

	/**
	 * 送信者名を取得します。
	 * @return 送信者名
	 */
	public String getFromAddressName() {
	    return fromAddressName;
	}

	/**
	 * 送信者名を設定します。
	 * @param fromAddressName 送信者名
	 */
	public void setFromAddressName(String fromAddressName) {
	    this.fromAddressName = fromAddressName;
	}

	/**
	 * 返信用メールアドレスを取得します。
	 * @return 返信用メールアドレス
	 */
	public String getReplyAddress() {
	    return replyAddress;
	}

	/**
	 * 返信用メールアドレスを設定します。
	 * @param replyAddress 返信用メールアドレス
	 */
	public void setReplyAddress(String replyAddress) {
	    this.replyAddress = replyAddress;
	}
}
