package jp.ill.photon.module.mail;

import java.util.LinkedHashMap;
import java.util.Map;

import org.seasar.doma.jdbc.tx.TransactionManager;

import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.dao.DomaConfig;
import jp.ill.photon.dao.JsonDataDao;
import jp.ill.photon.dao.JsonDataDaoImpl;
import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.ParamUtil;
import jp.ill.photon.util.SQLUtil;
import jp.ill.photon.util.StringUtil;


public class MailSettingUpdateModule implements PhotonModule {

	@ModuleParam(required = true)
	private Map<String, Object> paramJson;

	@ModuleParam(required = true)
	private String execType;

	@ModuleParam(required = false)
	@DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.exSqlFileDir.note")
	private String sqlFileDirPath;

	@SuppressWarnings({ "unchecked", "rawtypes" })
	public ModuleResult execute(ModuleContext context)
			throws PhotonModuleException {

		ActionDto dto = context.getDto();
		ModuleResult moduleResult = new ModuleResult();

		Map<String, Object> params = new LinkedHashMap<String, Object>();
		// 入力値をマップにする
		if (paramJson != null) {
			Map<String, String> paramInfo = null;
			for (Map.Entry<String, Object> input : paramJson.entrySet()) {
				paramInfo = (Map) input.getValue();
				params.put(input.getKey(), ParamUtil.getParamValueByType(
						paramInfo.get("type"), paramInfo.get("val"), dto));
			}
		}

		TransactionManager tm = DomaConfig.singleton().getTransactionManager();
		JsonDataDao dao = new JsonDataDaoImpl();

		// 登録/変更日時
		String nowDatetime = SQLUtil.getNowDatetime();
		String loginUserName = SQLUtil.getLoginAdminUserName(dto);

		String tenantId = (String) params.get("tenantId");

		int result = tm.required(() -> {

			String mailId = StringUtil.escapeJsonStr((String) params.get("selectedMailId"));
			String invalidFlg = StringUtil.escapeJsonStr((String) params.get("invalidFlg"));
			String reMailName = StringUtil.escapeJsonStr((String) params.get("reMailName"));
			String reMail = StringUtil.escapeJsonStr((String) params.get("reMail"));
			String ccMail = StringUtil.escapeJsonStr((String) params.get("ccMail"));
			String bccMail = StringUtil.escapeJsonStr((String) params.get("bccMail"));
			String mailTitle = StringUtil.escapeJsonStr((String) params.get("mailTitle"));
			String mailBody = StringUtil.escapeJsonStr((String) params.get("mailBody"));

			if ("update".equals(execType)) {
				dao.updateMailSettingData(tenantId, mailId, invalidFlg, reMailName, reMail, ccMail, bccMail, mailTitle, mailBody);
			}
			return 0;

		});

		return moduleResult;
	}

	/**
	 * paramJsonを取得します。
	 * @return paramJson
	 */
	public Map<String, Object> getParamJson() {
		return paramJson;
	}

	/**
	 * paramJsonを設定します。
	 * @param paramJson
	 */
	public void setParamJson(Map<String, Object> paramJson) {
		this.paramJson = paramJson;
	}

	/**
	 * sqlFileDirPathを取得します。
	 * @return sqlFileDirPath
	 */
	public String getSqlFileDirPath() {
		return sqlFileDirPath;
	}

	/**
	 * sqlFileDirPathを設定します。
	 * @param sqlFileDirPath
	 */
	public void setSqlFileDirPath(String sqlFileDirPath) {
		this.sqlFileDirPath = sqlFileDirPath;
	}

	/**
	 * execTypeを取得します。
	 * @return execType
	 */
	public String getExecType() {
		return execType;
	}

	/**
	 * execTypeを設定します。
	 * @param execType
	 */
	public void setExecType(String execType) {
		this.execType = execType;
	}

}
