package jp.ill.photon.module.mail;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.seasar.doma.jdbc.tx.TransactionManager;

import jp.ill.photon.action.ActionParamMap;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.dao.DomaConfig;
import jp.ill.photon.dao.JsonDataDao;
import jp.ill.photon.dao.JsonDataDaoImpl;
import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.model.ComboBoxItem;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.UtilTools;

public class MailSettingFormCreateModule implements PhotonModule {

	@ModuleParam(required = true)
	private Map<String, Object> paramJson;

	@Override
	public ModuleResult execute( ModuleContext context ) {

		ModuleResult result = new ModuleResult();

		ActionParamMap params = context.getDto().getParams();

		/** メール用途コンボボックス */
		ArrayList<ComboBoxItem> mailPatternList = createMailPatternList(context.getDto());
		result.getReturnData().put("mailPatternList", mailPatternList);

		/** 選択中のメール用途 */
		String selectedMailId = (String) params.get("selectedMailId");
		if(UtilTools.isEmpty(selectedMailId)){
			// 初期表示時はリストの先頭を選択
			selectedMailId = mailPatternList.get(0).getValue();
		}
		result.getReturnData().put("selectedMailId", selectedMailId);

		/** 選択中のメール用途の情報をセット */
		List<Map<String, Object>> mailPatternData = getMailPatternList(context.getDto());
		for(Map<String, Object> mp : mailPatternData){
			String mail_id = (String) mp.get("mail_id");
			if(!UtilTools.isEmpty(mail_id) && mail_id.equals(selectedMailId)){
				result.getReturnData().put("mailId", mail_id);
				result.getReturnData().put("invalidFlg", (String) mp.get("invalid_flg"));
				result.getReturnData().put("reMailName", (String) mp.get("re_mail_name"));
				result.getReturnData().put("reMail", (String) mp.get("re_mail"));
				result.getReturnData().put("ccMail", (String) mp.get("cc_mail"));
				result.getReturnData().put("bccMail", (String) mp.get("bcc_mail"));
				result.getReturnData().put("mailTitle", (String) mp.get("mail_title"));
				result.getReturnData().put("mailBody", (String) mp.get("mail_body"));
				result.getReturnData().put("specialKey", (String) mp.get("special_key"));
				break;
			}
		}

		/** メッセージ */
		String message = (String) params.get("message");
		result.getReturnData().put("message", message);
		/** エラーメッセージ */
		String errorMessage = (String) params.get("errorMessage");
		result.getReturnData().put("errorMessage", errorMessage);

		return result;
	}

	/** メール用途コンボボックスを生成 */
	public ArrayList<ComboBoxItem> createMailPatternList( ActionDto dto ){

		ArrayList<ComboBoxItem> mailPatternList = new ArrayList<ComboBoxItem>();
		List<Map<String, Object>> mailPatternData = getMailPatternList(dto);

		for(Map<String, Object> mp: mailPatternData){
			String mail_id = (String) mp.get("mail_id");
			String memo = (String) mp.get("memo");
			mailPatternList.add(new ComboBoxItem(mail_id, memo));
		}

		return mailPatternList;
	}

	/** メール用途リストを取得 */
	public List<Map<String, Object>> getMailPatternList( ActionDto dto ) {

		TransactionManager tm = DomaConfig.singleton().getTransactionManager();
		JsonDataDao dao = new JsonDataDaoImpl();

		List<Map<String, Object>> mail_pattern_data = tm.required(() -> {
			return dao.getMailPatternList(dto.getTenantId());
		});

		return mail_pattern_data;
	}
}
