package jp.ill.photon.module.list;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.model.MapListParam;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;

/**
 * マップのリストを指定されたキーの値をキーとするマップに変換する
 * 
 * @author h_tanaka
 *
 */
public class ExtractListToMapModule implements PhotonModule {

	/**
	 * 変換対象のマップリスト
	 */
	@ModuleParam(required = true)
	private MapListParam list;

	/**
	 * 新しいマップのキーにする値のキー名
	 */
	@ModuleParam(required = true)
	private String extractKey;

	@Override
	public ModuleResult execute(ModuleContext context)
			throws PhotonModuleException {
		ModuleResult result = new ModuleResult();

		List<Map<String, Object>> paramList = getList().getParamList();

		Map<String, Map<String, Object>> newMap = new LinkedHashMap<>();
		if (paramList != null) {
			String key = null;
			for (Map<String, Object> item : paramList) {
				key = String.valueOf(item.get(getExtractKey()));
				newMap.put(key, item);
			}
		}

		result.getReturnData().put("map", newMap);

		return result;
	}

	public MapListParam getList() {
		return list;
	}

	public void setList(MapListParam list) {
		this.list = list;
	}

	public String getExtractKey() {
		return extractKey;
	}

	public void setExtractKey(String extractKey) {
		this.extractKey = extractKey;
	}
}
