package jp.ill.photon.module.item;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.dao.DomaConfig;
import jp.ill.photon.dao.JsonDataDao;
import jp.ill.photon.dao.JsonDataDaoImpl;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.model.FileForm;
import jp.ill.photon.model.Item;
import jp.ill.photon.model.ItemFile;
import jp.ill.photon.model.ItemStockThreshold;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.FileUtil;
import jp.ill.photon.util.ParamUtil;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.converters.BigDecimalConverter;
import org.apache.commons.lang3.StringUtils;
import org.seasar.doma.jdbc.tx.TransactionManager;


public class ItemUpdateModule implements PhotonModule {

	@ModuleParam(required = true)
	private Map<String, Object> paramJson;

	@ModuleParam(required = true)
	private String execType;

	@ModuleParam(required = false)
	private List<FileForm> fileForms;

	@ModuleParam(required = false)
	@DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.exSqlFileDir.note")
	private String sqlFileDirPath;

	@ModuleParam(required = false)
	@DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.itemImagePath.note")
	private String itemImagePath;

	@ModuleParam(required = false)
	@DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.itemPdfDir.note")
	private String itemPdfDir;

	@SuppressWarnings({ "unchecked", "rawtypes" })
	public ModuleResult execute(ModuleContext context)
			throws PhotonModuleException {
		ModuleResult moduleResult = new ModuleResult();

		Map<String, Object> params = new LinkedHashMap<String, Object>();
		// 入力値をマップにする
		if (paramJson != null) {
			Map<String, String> paramInfo = null;
			for (Map.Entry<String, Object> input : paramJson.entrySet()) {
				paramInfo = (Map) input.getValue();
				params.put(input.getKey(), ParamUtil.getParamValueByType(
						paramInfo.get("type"), paramInfo.get("val"), context.getDto()));
			}

		}

		TransactionManager tm = DomaConfig.singleton().getTransactionManager();
		JsonDataDao dao = new JsonDataDaoImpl();

		// 登録/変更日時
		String nowDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Timestamp(System.currentTimeMillis()));
		String loginUserName = "test"; // TODO:ログインユーザ名にしておくこと

		String itemCd = (String) params.get("itemCd");
		String tenantId = (String) params.get("tenantId");

		Item shohin = new Item();
		try {

			ConvertUtils.register(new BigDecimalConverter(null), BigDecimal.class);
			BeanUtils.copyProperties(shohin, params);
			ConvertUtils.deregister();

			shohin.setUpdateDatetime(nowDate);
			shohin.setUpdateUserName(loginUserName);
			shohin.setUpdateDiv(1);
			shohin.setInsertDatetime(nowDate);
			shohin.setInsertUserName(loginUserName);
			shohin.setInsertDiv(1);
		} catch (Exception e) {
			e.printStackTrace();
		}

		int result = tm.required(() -> {

			// FileUtil fileUtil = new FileUtil();

			// TODO:ファイル操作
			// FileForm itemImage1 = (FileForm) input.get("item_image1");
			//setImageInfo(itemImage1);

			// FileForm itemImage2 = (FileForm) input.get("item_image2");
			//setImageInfo(itemImage2);

			// FileForm itemImage3 = (FileForm) input.get("item_image3");
			//setImageInfo(itemImage3);

			// FileForm itemImage4 = (FileForm) input.get("item_image4");
			//setImageInfo(itemImage4);

			// FileForm itemImage5 = (FileForm) input.get("item_image5");
			//setImageInfo(itemImage5);

			if ("insert".equals(execType)) {
				dao.insertShohinData(tenantId, shohin);
			} else if ("update".equals(execType)) {
				dao.updateShohinData(tenantId, shohin);
			} else if ("delete".equals(execType)) {
				dao.deleteShohinData(tenantId, shohin.getItemCd());
			}

			// 先に商品コードに紐づく全データを削除
			dao.deleteShohinFiles(tenantId, itemCd);

			int insRecNo = 1; // テーブル登録用の行番号

			if ("insert".equals(execType) || "update".equals(execType)) {

				// セットされているファイル分ループ
				if (fileForms != null) {
					for (FileForm fileForm : fileForms) {

						//String recordNo = String.valueOf(fileForm.getRecordNo());
						//String fromDir = itemPdfDir + File.separator + itemCd + "_" + recordNo;
						//String toDir = itemPdfDir + File.separator + itemCd + "_" + insRecNo;
						//String delDir = fromDir + File.separator;

						if (fileForm.getFile() != null) {

							if (fileForm.getRecordNo() != 0) {
								// 既にアップロード済みファイルが存在する場合、ディレクトリごと削除
								//delDirectory(delDir);
							}

							//String fileName = fileForm.getFileName();
							//String toFilePath = toDir + File.separator + fileName;
							//fileUtil.moveFile(fileForm.getFile(), toFilePath);

							// TODO:商品ファイルテーブル登録
							ItemFile file = new ItemFile();
							file.setItemCd(itemCd);
							file.setRecordNo(fileForm.getRecordNo());
							file.setAttachedFile(fileForm.getFileName());
							file.setUpdateUserName(loginUserName);
							file.setUpdateDatetime(nowDate);
							file.setUpdateDiv(1);
							file.setInsertUserName(loginUserName);
							file.setInsertDatetime(nowDate);
							file.setInsertDiv(1);

							dao.insertShohinFileData(tenantId, file);

							++insRecNo;

						// 削除指定されてなく、新しいファイル指定もなし
						} else if ("0".equals(fileForm.getDelFlg()) && fileForm.getFile() == null) {

							// 行追加したレコードの場合
							if (fileForm.getRecordNo() == 0) {
								continue;
							}

							// 既にアップロードされているファイルで、行番号が変わる場合
							if (fileForm.getRecordNo() != insRecNo) {

								// 既存の行番号を新しい行番号に変更してリネーム
								//fileUtil.renamePath(fromDir, toDir);

							}

							// TODO:商品ファイルテーブル登録
							// [N]番目にセットされているファイル「insertShohinFiles.sql」を実行
							ItemFile file = new ItemFile();
							file.setItemCd(itemCd);
							file.setRecordNo(fileForm.getRecordNo());
							file.setAttachedFile(fileForm.getFileName());
							file.setUpdateUserName(loginUserName);
							file.setUpdateDatetime(nowDate);
							file.setUpdateDiv(1);
							file.setInsertUserName(loginUserName);
							file.setInsertDatetime(nowDate);
							file.setInsertDiv(1);

							dao.insertShohinFileData(tenantId, file);

							++insRecNo;

						// 削除指定されていて、新しいファイルの指定なし
						} else if ("1".equals(fileForm.getDelFlg()) && fileForm.getFile() == null) {

							//delDirectory(delDir);

						}

					}
				}

				ItemStockThreshold itemStockThreshold = new ItemStockThreshold();
				BigDecimal num = null;
				if (params.get("stockThresholdNum") != null) {
					String stockThresholdNumStr = (String)params.get("stockThresholdNum");
					if (!StringUtils.isEmpty(stockThresholdNumStr)) {
						num = new BigDecimal((String)params.get("stockThresholdNum"));
					}
				}
				itemStockThreshold.setItemCd(itemCd);
				itemStockThreshold.setStockThresholdNum(num);
				itemStockThreshold.setUpdateUserName(loginUserName);
				itemStockThreshold.setUpdateDatetime(nowDate);
				itemStockThreshold.setUpdateDiv(1);

				// 商品在庫閾値データ取得
				List<Map<String, Object>> threshold = dao.selectShohinThresholdData(tenantId, itemCd);

				if (threshold != null && !threshold.isEmpty()) {
					// データが存在していた場合
					// 商品在庫閾値データ更新
					dao.updateShohinThresholdData(tenantId, itemStockThreshold);
				} else {
					// データが存在しなかった場合
					// 商品在庫閾値データ登録
					itemStockThreshold.setInsertUserName(loginUserName);
					itemStockThreshold.setInsertDatetime(nowDate);
					itemStockThreshold.setInsertDiv(1);
					dao.insertShohinThresholdData(tenantId, itemStockThreshold);
				}

			} else if ("delete".equals(execType)) {

				// 商品在庫閾値データ削除
				dao.deleteShohinThresholdData(tenantId, itemCd);

			}


			return 0;

		});

		return moduleResult;
	}

	/**
	 *  画像情報設定、ファイル物理操作
	 * @throws Exception
	 *
	 * */
	private void setImageInfo(FileForm fileForm) throws Exception {

		if (fileForm != null) {
			FileUtil fileUtil = new FileUtil();
			if ("1".equals(fileForm.getDelFlg())) {
				fileUtil.delFile(itemImagePath, fileForm.getFileName());
			}
			if (fileForm.getFile() != null) {
				fileUtil.moveFile(fileForm.getFile(), itemImagePath, fileForm.getFileName());
			}
		}

	}

	/**
	 *  ディレクトリごと削除
	 * @throws Exception
	 *
	 * */
	private void delDirectory(String delDir) throws Exception {

		FileUtil fileUtil = new FileUtil();
		fileUtil.delDirectory(delDir);
		try {
			Thread.sleep(10);
		} catch (InterruptedException e) {
		}

	}

	/**
	 * paramJsonを取得します。
	 * @return paramJson
	 */
	public Map<String, Object> getParamJson() {
		return paramJson;
	}

	/**
	 * paramJsonを設定します。
	 * @param paramJson
	 */
	public void setParamJson(Map<String, Object> paramJson) {
		this.paramJson = paramJson;
	}

	/**
	 * fileFormsを取得します。
	 * @return fileForms
	 */
	public List<FileForm> getFileForms() {
		return fileForms;
	}

	/**
	 * fileFormsを設定します。
	 * @param fileForms
	 */
	public void setFileForms(List<FileForm> fileForms) {
		this.fileForms = fileForms;
	}

	/**
	 * sqlFileDirPathを取得します。
	 * @return sqlFileDirPath
	 */
	public String getSqlFileDirPath() {
		return sqlFileDirPath;
	}

	/**
	 * sqlFileDirPathを設定します。
	 * @param sqlFileDirPath
	 */
	public void setSqlFileDirPath(String sqlFileDirPath) {
		this.sqlFileDirPath = sqlFileDirPath;
	}

	/**
	 * itemImagePathを取得します。
	 * @return itemImagePath
	 */
	public String getItemImagePath() {
		return itemImagePath;
	}

	/**
	 * itemImagePathを設定します。
	 * @param itemImagePath
	 */
	public void setItemImagePath(String itemImagePath) {
		this.itemImagePath = itemImagePath;
	}

	/**
	 * itemPdfDirを取得します。
	 * @return itemPdfDir
	 */
	public String getItemPdfDir() {
		return itemPdfDir;
	}

	/**
	 * itemPdfDirを設定します。
	 * @param itemPdfDir
	 */
	public void setItemPdfDir(String itemPdfDir) {
		this.itemPdfDir = itemPdfDir;
	}

	/**
	 * execTypeを取得します。
	 * @return execType
	 */
	public String getExecType() {
		return execType;
	}

	/**
	 * execTypeを設定します。
	 * @param execType
	 */
	public void setExecType(String execType) {
		this.execType = execType;
	}

}
