package jp.ill.photon.module.item;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.FileUtil;
import jp.ill.photon.util.ParamUtil;
import jp.ill.photon.util.StringUtil;

/**
 *
 * 画像フルパス取得モジュール
 *
 * @author m_fukukawa
 *
 */
public class ItemImageLumpUploadFilePathModule implements PhotonModule {

	/* モジュールパラメータ */
	@ModuleParam(required = true)
	private List<Map<String, Object>> fieldList; // カラム設定

	@ModuleParam(required = false)
	private String[] items; // 画面のに表示されていた商品の商品コード

	@ModuleParam(required = false)
	@DefaultParamSetting(transferType = "static", transferVal = "true")
	private boolean dragAndDrop; // D&Dかどうか

	@ModuleParam(required = false)
	private String dropImageFileNameItemName; // D&Dに使用するファイル名を保存するときの項目名。モジュールの中ではここの設定値の後ろに[コード]_[項目名]が付与された状態で使用される

	@ModuleParam(required = false)
	private String dropImageItemName; // D&Dに使用するファイルを保存するときの項目名。モジュールの中ではここの設定値の後ろに[コード]_[項目名]が付与された状態で使用される

	@ModuleParam(required = false)
	private String delFlgName; // 削除時の項目名。モジュールの中ではここの設定値の後ろに[コード]_[項目名]が付与された状態で使用される

	@Override
	public ModuleResult execute(ModuleContext context)
			throws PhotonModuleException {

		ModuleResult result = new ModuleResult();
		if (getItems() == null) {
			result.getReturnData().put("file_info",
					new HashMap<String, Object>());
			return result;
		}

		Map<String, Object> pathInfoMap = createFileFullPathInfo(
				Arrays.asList(getItems()), context.getDto());

		List<Map<String, Object>> pathInfoList = new ArrayList<>();
		if (pathInfoMap != null) {
			for (Map.Entry<String, Object> entry : pathInfoMap.entrySet()) {
				pathInfoList.add((Map<String, Object>) entry.getValue());
			}
		}

		result.getReturnData().put("file_info", pathInfoMap);
		result.getReturnData().put("file_info_list", pathInfoList);

		return result;

	}

	/**
	 *
	 * ファイルパス生成
	 *
	 * @param cdList コードリスト
	 *
	 */
	private Map<String, Object> createFileFullPathInfo(	List<String> itemCdList,
														ActionDto dto) {

		Map<String, Object> pathInfoMap = new HashMap<>();
		List<Map<String, Object>> fieldList = getFieldList();
		if (CollectionUtils.isEmpty(fieldList)) {
			return pathInfoMap;
		}

		String colCd = null;
		String dataSrcItemName = null;
		String fileGetKey = null;
		String fileGetType = null;
		String fileName = null;
		String value = null;
		Map<String, String> filePathInfo = null;
		for (String itemCd : itemCdList) {

			for (Map<String, Object> col : fieldList) {

				colCd = StringUtil.defaultString(col.getOrDefault("col_cd", ""),
						"");
				dataSrcItemName = itemCd + "_" + colCd;
				fileGetKey = "";
				fileGetType = "";

				filePathInfo = new HashMap<>();
				filePathInfo.put("name", dataSrcItemName);
				filePathInfo.put("edit_table_cd", "item");
				filePathInfo.put("col_cd", colCd);
				filePathInfo.put("item_cd", itemCd);
				filePathInfo.put("file_name", "");
				filePathInfo.put("path", "");
				filePathInfo.put("image", "");
				filePathInfo.put("image_size", "0");
				filePathInfo.put("del_flg", "0");
				filePathInfo.put("is_dnd", "0");

				if (dragAndDrop) {
					fileGetKey = dropImageFileNameItemName + "."
							+ dataSrcItemName;
					fileGetType = ParamUtil.TransferTypes.PARAM;
				} else {
					fileGetKey = dataSrcItemName + ".file_name";
					fileGetType = ParamUtil.TransferTypes.PARAM_FILE;
				}

				fileName = (String) ParamUtil.getParamValueByType(fileGetType,
						fileGetKey, dto);
				if (!StringUtils.isEmpty(fileName)) {

					value = "";
					if (dragAndDrop) {
						String base64Str = (String) ParamUtil
								.getParamValueByType(fileGetType,
										dropImageItemName + "."
												+ dataSrcItemName,
										dto);
						value = FileUtil.getFileBase64(base64Str);
						filePathInfo.put("is_dnd", "1");
						filePathInfo.put("image", value);
						byte[] inByte = Base64.decodeBase64(value);
						BigDecimal dbSize = new BigDecimal(inByte.length);
						filePathInfo.put("image_size", dbSize.toString());
					} else {
						value = (String) ParamUtil.getParamValueByType(
								fileGetType,
								dataSrcItemName + ".file.absolute_path", dto);
						filePathInfo.put("is_dnd", "0");
						filePathInfo.put("path", value);
					}

					if (!StringUtils.isEmpty(value)) {
						filePathInfo.put("file_name", fileName);
					}

				}

				fileGetKey = delFlgName + "." + dataSrcItemName;
				fileGetType = ParamUtil.TransferTypes.PARAM;
				value = (String) ParamUtil.getParamValueByType(fileGetType,
						fileGetKey, dto);
				if (!StringUtils.isEmpty(value)) {
					filePathInfo.put("del_flg", value);
				}

				if (!filePathInfo.getOrDefault("path", "").equals("")
						|| !filePathInfo.getOrDefault("image", "").equals("")
						|| filePathInfo.getOrDefault("del_flg", "0")
								.equals("1")) {
					pathInfoMap.put(dataSrcItemName, filePathInfo);
				}
			}
		}

		return pathInfoMap;
	}

	/**
	 * itemsを取得します。
	 * 
	 * @return items
	 */
	public String[] getItems() {
		return items;
	}

	/**
	 * itemsを設定します。
	 * 
	 * @param items
	 */
	public void setItems(String[] items) {
		this.items = items;
	}

	/**
	 * dragAndDropを取得します。
	 * 
	 * @return dragAndDrop
	 */
	public boolean isDragAndDrop() {
		return dragAndDrop;
	}

	/**
	 * dragAndDropを設定します。
	 * 
	 * @param dragAndDrop
	 */
	public void setDragAndDrop(boolean dragAndDrop) {
		this.dragAndDrop = dragAndDrop;
	}

	/**
	 * dropImageFileNameItemNameを取得します。
	 * 
	 * @return dropImageFileNameItemName
	 */
	public String getDropImageFileNameItemName() {
		return dropImageFileNameItemName;
	}

	/**
	 * dropImageFileNameItemNameを設定します。
	 * 
	 * @param dropImageFileNameItemName
	 */
	public void setDropImageFileNameItemName(String dropImageFileNameItemName) {
		this.dropImageFileNameItemName = dropImageFileNameItemName;
	}

	/**
	 * dropImageItemNameを取得します。
	 * 
	 * @return dropImageItemName
	 */
	public String getDropImageItemName() {
		return dropImageItemName;
	}

	/**
	 * dropImageItemNameを設定します。
	 * 
	 * @param dropImageItemName
	 */
	public void setDropImageItemName(String dropImageItemName) {
		this.dropImageItemName = dropImageItemName;
	}

	public List<Map<String, Object>> getFieldList() {
		return fieldList;
	}

	public void setFieldList(List<Map<String, Object>> fieldList) {
		this.fieldList = fieldList;
	}

	public String getDelFlgName() {
		return delFlgName;
	}

	public void setDelFlgName(String delFlgName) {
		this.delFlgName = delFlgName;
	}

}
