package jp.ill.photon.module.init;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.postgresql.util.PGobject;
import org.seasar.doma.jdbc.tx.TransactionManager;

import jp.ill.photon.annotation.ModuleVersion;
import jp.ill.photon.dao.DomaConfig;
import jp.ill.photon.dao.JsonDataDao;
import jp.ill.photon.dao.JsonDataDaoImpl;
import jp.ill.photon.dao.MetaObjectDao;
import jp.ill.photon.dao.MetaObjectDaoImpl;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.JsonUtil;
import jp.ill.photon.util.LogUtil;

/**
 * 初期データ取得モジュール
 *
 * @author h_tanaka
 *
 */
@ModuleVersion("1.0.0")
public class InitActionModule implements PhotonModule {

	/** ログ用変数 */
	protected final LogUtil logger = new LogUtil(InitActionModule.class);

	@Override
	public ModuleResult execute(ModuleContext context) {

		// TODO 汎用化のためにパラメータとして対象テーブルを受け取れるようにする
		List<String> targetTables = Arrays.asList("systemsetting",
				"aladdinsetting", "label", "mesg");

		Map<String, String> keyColumnMap = getKeyColumns(
				context.getDto().getTenantId(), targetTables);
		List<Map<String, Object>> settings = getSettings(
				context.getDto().getTenantId(), targetTables);

		ModuleResult result = new ModuleResult();

		String editTableCd = null;
		Map<String, Object> tableSetting = null;
		Map<String, Object> jsonValue = null;
		for (Map<String, Object> setting : settings) {
			editTableCd = (String) setting.get("edit_table_cd");
			tableSetting = (result.getReturnData().containsKey(editTableCd))
					? (Map<String, Object>) result.getReturnData()
							.get(editTableCd)
					: new LinkedHashMap<>();
			jsonValue = JsonUtil
					.jsonToMap(((PGobject) setting.get("val")).getValue());
			tableSetting.put(
					String.valueOf(
							jsonValue.get(keyColumnMap.get(editTableCd))),
					jsonValue);
			// }
			result.getReturnData().put(editTableCd, tableSetting);
		}

		return result;
	}

	/**
	 * テーブルごとのキー列情報を取得する。複合キーはdot区切りで結合する
	 *
	 * @param targetTables
	 * @return
	 */
	protected Map<String, String> getKeyColumns(String tenantId,
												List<String> targetTables) {
		TransactionManager tm = DomaConfig.singleton().getTransactionManager();
		MetaObjectDao metaDao = new MetaObjectDaoImpl();

		List<Map<String, Object>> keyColumns = tm.required(() -> {
			return metaDao.selectTableKeyColumns(tenantId, targetTables);
		});

		Map<String, String> keyColumnMap = new HashMap<String, String>();
		for (Map<String, Object> keyColumn : keyColumns) {
			keyColumnMap.put((String) keyColumn.get("edit_table_cd"),
					(String) keyColumn.get("key_column"));
		}

		return keyColumnMap;
	}

	/**
	 * 指定したテーブルのデータを一括取得する
	 *
	 * @param tenantId
	 * @param targetTables
	 * @return
	 */
	protected List<Map<String, Object>> getSettings(String tenantId,
													List<String> targetTables) {
		TransactionManager tm = DomaConfig.singleton().getTransactionManager();
		JsonDataDao dao = new JsonDataDaoImpl();

		List<Map<String, Object>> settings = tm.required(() -> {
			return dao.selectSettings(tenantId, targetTables);
		});

		return settings;
	}
}