package jp.ill.photon.module.fixedmessage;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.seasar.doma.jdbc.tx.TransactionManager;

import jp.ill.photon.action.ActionParamMap;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.dao.DomaConfig;
import jp.ill.photon.dao.JsonDataDao;
import jp.ill.photon.dao.JsonDataDaoImpl;
import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.model.ComboBoxItem;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.UtilTools;

public class FixedMessageFormCreateModule implements PhotonModule {

	@ModuleParam(required = true)
	private Map<String, Object> paramJson;

	@Override
	public ModuleResult execute( ModuleContext context ) {

		ModuleResult result = new ModuleResult();

		ActionParamMap params = context.getDto().getParams();

		/** 定型文用途コンボボックス */
		ArrayList<ComboBoxItem> fixedMessageList = createFixedMessageList(context.getDto());
		result.getReturnData().put("fixedMessageList", fixedMessageList);

		/** 選択中の定型文 */
		String selectedFixedMessage = (String) params.get("selectedFixedMessage");
		/** 定型文本文 */
		String note = (String) params.get("note");
		/** 処理区分 */
		String resultDiv = (String) params.get("resultDiv");
		if(UtilTools.isEmpty(selectedFixedMessage)){
			// 初期表示時はリストの先頭を選択
			selectedFixedMessage = fixedMessageList.get(0).getValue();
		}
		result.getReturnData().put("selectedFixedMessage", selectedFixedMessage);

		/** 選択中の定型文の定型文ID、定型文本文をセット */
		List<Map<String, Object>> fixedMessageData = getFixedMessageList(context.getDto());
		for(Map<String, Object> fm : fixedMessageData){
			String id = (String) fm.get("id");
			if(!UtilTools.isEmpty(id) && id.equals(selectedFixedMessage)){
				result.getReturnData().put("fixedMessageId", id);
				if("validation_error".equals(resultDiv)){
					result.getReturnData().put("fixedMessageNote", note);
				}else{
					result.getReturnData().put("fixedMessageNote", (String) fm.get("note"));
				}
				break;
			}
		}

		return result;
	}

	/** 定型文用途コンボボックスを生成 */
	public ArrayList<ComboBoxItem> createFixedMessageList( ActionDto dto ){

		ArrayList<ComboBoxItem> fixedMessageList = new ArrayList<ComboBoxItem>();
		List<Map<String, Object>> fixedMessageData = getFixedMessageList(dto);

		for(Map<String, Object> fm: fixedMessageData){
			String id = (String) fm.get("id");
			String name = "〔  " + (String) fm.get("name1") + "  〕  " + (String) fm.get("name2");
			fixedMessageList.add(new ComboBoxItem(id, name));
		}

		return fixedMessageList;
	}

	/** 定型文リストを取得 */
	public List<Map<String, Object>> getFixedMessageList( ActionDto dto ) {

		TransactionManager tm = DomaConfig.singleton().getTransactionManager();
		JsonDataDao dao = new JsonDataDaoImpl();

		List<Map<String, Object>> fixed_message_data = tm.required(() -> {
			return dao.getFixedMessageListEditable(dto.getTenantId());
		});

		return fixed_message_data;
	}

	/**
	 * paramJsonを取得します。
	 * @return paramJson
	 */
	public Map<String, Object> getParamJson() {
		return paramJson;
	}

	/**
	 * paramJsonを設定します。
	 * @param paramJson
	 */
	public void setParamJson(Map<String, Object> paramJson) {
		this.paramJson = paramJson;
	}
}
