package jp.ill.photon.module.file;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.exception.PhotonPageNotFoundException;
import jp.ill.photon.model.MapParam;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.LogUtil;
import jp.ill.photon.util.ParamUtil;
import jp.ill.photon.util.StringUtil;

/**
 * ディレクトリを作成するモジュール。親ディレクトリが存在しない場合は親ディレクトリも作成する。
 * 
 * @author h_tanaka
 *
 */
public class MakeDirectoriesModule implements PhotonModule {

	@ModuleParam(required = true)
	private String rootDirPath;

	@ModuleParam(required = false)
	private MapParam subDirPaths;

	/** ログ用変数 */
	protected final LogUtil logger = new LogUtil(MakeDirectoriesModule.class);

	@Override
	public ModuleResult execute(ModuleContext context)
			throws PhotonModuleException, PhotonPageNotFoundException {
		ModuleResult result = new ModuleResult();

		Map<String, Object> subDirPaths = null;
		if (getSubDirPaths() == null) {
			subDirPaths = new HashMap<>();
		} else {
			subDirPaths = getSubDirPaths().getParamMap();
		}

		Path srcPath = null;
		if (subDirPaths != null && subDirPaths.size() > 0) {
			Map<String, Object> subDirMap = new LinkedHashMap<>();
			for (Map.Entry<String, Object> param : subDirPaths.entrySet()) {

				String type = StringUtil.defaultString(
						((Map) param.getValue()).get("type"), "");
				subDirMap.put((String) param.getKey(),
						ParamUtil.getParamValueByType(type,
								((Map) param.getValue()).get("val"),
								context.getDto()));
			}

			List<Object> subDirList = subDirMap.entrySet().stream()
					.sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue)
					.collect(Collectors.toList());

			int i = 0;
			String[] subdir = new String[subDirList.size()];
			for (Object v : subDirList) {
				subdir[i] = StringUtil.defaultString(v, "");
				i++;
			}
			srcPath = Paths.get(rootDirPath, subdir);
		} else {
			srcPath = Paths.get(rootDirPath);
		}

		srcPath.toFile().mkdirs();

		result.getReturnData().put("path", srcPath.toString());

		return result;
	}

	public String getRootDirPath() {
		return rootDirPath;
	}

	public void setRootDirPath(String rootDirPath) {
		this.rootDirPath = rootDirPath;
	}

	public MapParam getSubDirPaths() {
		return subDirPaths;
	}

	public void setSubDirPaths(MapParam subDirPaths) {
		this.subDirPaths = subDirPaths;
	}
}
