package jp.ill.photon.module.file;

import java.util.HashMap;
import java.util.Map;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.LogUtil;
import jp.ill.photon.util.ParamUtil;

import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

/**
 * Tmp領域（System.getProperty("java.io.tmpdir")）からファイルパスを取得するモジュール
 *
 * @author m_fukukawa
 *
 */
public class LoadFilesFromTmpAreaModule implements PhotonModule {

	/* モジュールパラメータ */
	@ModuleParam(required = false)
	private Map<String, Object> fileInfoMap;

	@ModuleParam(required = false)
	private String processName;

	@ModuleParam(required = false)
	private String operator;

	/** ログ用変数 */
	protected final LogUtil logger = new LogUtil(LoadFilesFromTmpAreaModule.class);

	@SuppressWarnings("unchecked")
	@Override
	public ModuleResult execute(ModuleContext context) throws PhotonModuleException {

		ModuleResult result = new ModuleResult();
		ActionDto dto = context.getDto();

		/*
		 * fileInfoMapの中身想定
		 *
		 * "key1": {
		 *   "full_path": {
		 *     "type": "param",
		 *     "val": "key1.saved_ext_full_path"
		 *   },
		 *   "file_name": {
		 *     "type": "param_file",
		 *     "val": "key1.saved_ext_file_name"
		 *   }
		 * },
		 * "key2": {
		 *   "full_path": {
		 *     "type": "param",
		 *     "val": "key2.saved_ext_full_path"
		 *   },
		 *   "file_name": {
		 *     "type": "param_file",
		 *     "val": "key2.saved_ext_file_name"
		 *   }
		 * }
		 *
		 *
		 */

		Map<String, Object> ret = new HashMap<String, Object>();

		if (!MapUtils.isEmpty(fileInfoMap)) {

			for (Map.Entry<String, Object> entry : fileInfoMap.entrySet()) {

				String key = entry.getKey();
				Map<String, Object> valMap = (Map<String, Object>) entry.getValue();

				String filePath = ParamUtil.getParamStrValueByType(valMap.get("full_path"), dto);
				String fileName = ParamUtil.getParamStrValueByType(valMap.get("file_name"), dto);

				if (!StringUtils.isEmpty(fileName)) {
					ret.put(key, new HashMap<String, Object>(){{
						put("file_name", filePath);
						put("full_path", fileName);
					}});
				}

			}

		}

		// result.getReturnData().put("set", destFileNameList);
		result.getReturnData().put("file_map", ret);
		result.setResultCode("load");

		return result;

	}

	/**
	 * fileInfoMapを取得します。
	 * @return fileInfoMap
	 */
	public Map<String, Object> getFileInfoMap() {
		return fileInfoMap;
	}

	/**
	 * fileInfoMapを設定します。
	 * @param fileInfoMap
	 */
	public void setFileInfoMap(Map<String, Object> fileInfoMap) {
		this.fileInfoMap = fileInfoMap;
	}

	/**
	 * processNameを取得します。
	 * @return processName
	 */
	public String getProcessName() {
		return processName;
	}

	/**
	 * processNameを設定します。
	 * @param processName
	 */
	public void setProcessName(String processName) {
		this.processName = processName;
	}

	/**
	 * operatorを取得します。
	 * @return operator
	 */
	public String getOperator() {
		return operator;
	}

	/**
	 * operatorを設定します。
	 * @param operator
	 */
	public void setOperator(String operator) {
		this.operator = operator;
	}

}
