package jp.ill.photon.module.estimate;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.model.AoSetting;
import jp.ill.photon.model.SearchForm;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.db.SqlFileSelectModule;
import jp.ill.photon.util.AoUtil;
import jp.ill.photon.util.StringUtil;
import jp.ill.photon.util.UtilTools;

public class EstimateHisDetailModule extends SqlFileSelectModule {

	/** TODO 親クラスに書かれていれば書かなくてもいいようにしたい */
	@ModuleParam(required = true, domainObject = true)
	private SearchForm searchForm;

	@ModuleParam(required = true)
	private String sqlFileDirPath;

	@ModuleParam(required = true)
	private String sqlFilePath;

	@ModuleParam(required = false)
	@DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.webOrderCampaignItemCd.note")
	private String webOrderCampaignCd;

	@ModuleParam(required = false)
    @DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.deliveryFeeItemCd.note")
    private String deliveryFeeItemCd;

	@ModuleParam(required = true)
	@DefaultParamSetting(transferType = "dto", transferVal = "common.aladdinsetting")
	private AoSetting aoSetting;

	@ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "user.first")
    private Map<String, Object> userForm;

    public Map<String, Object> getUserForm() {
        return userForm;
    }

    public void setUserForm(Map<String, Object> userForm) {
        this.userForm = userForm;
    }

	public SearchForm getSearchForm() {
		return searchForm;
	}

	public void setSearchForm(SearchForm searchForm) {
		this.searchForm = searchForm;
	}

	public String getSqlFileDirPath() {
		return sqlFileDirPath;
	}

	public void setSqlFileDirPath(String sqlFileDirPath) {
		this.sqlFileDirPath = sqlFileDirPath;
	}

	public String getSqlFilePath() {
		return sqlFilePath;
	}

	public void setSqlFilePath(String sqlFilePath) {
		this.sqlFilePath = sqlFilePath;
	}

	public String getWebOrderCampaignCd() {
		return webOrderCampaignCd;
	}

	public void setWebOrderCampaignCd(String webOrderCampaignCd) {
		this.webOrderCampaignCd = webOrderCampaignCd;
	}

	public String getDeliveryFeeItemCd() {
        return deliveryFeeItemCd;
    }

    public void setDeliveryFeeItemCd(String deliveryFeeItemCd) {
        this.deliveryFeeItemCd = deliveryFeeItemCd;
    }

    public AoSetting getAoSetting() {
		return aoSetting;
	}

	public void setAoSetting(AoSetting aoSetting) {
		this.aoSetting = aoSetting;
	}

	@Override
	public ModuleResult execute(ModuleContext context)
			throws PhotonModuleException {
		ModuleResult result = super.execute(context);

		List<Map<String, Object>> detailList = (List<Map<String, Object>>) result
				.getReturnData().get("list");

		List itemCdList = new ArrayList();

		String totalWholeSalePrice = "0";
		String subTotalWholeSalePrice = "0";

		for (int i = 0; i < detailList.size(); i++) {

			Map<String, Object> detailMap = detailList.get(i);

			String itemCd = (String) detailMap.get("item_cd");
			itemCdList.add(itemCd);

			if ((webOrderCampaignCd != null && isSpecialDetail(itemCd, webOrderCampaignCd) ||
			        deliveryFeeItemCd != null && isSpecialDetail(itemCd, deliveryFeeItemCd))) {
				detailMap.put("is_display", "false");
			} else {
				detailMap.put("is_display", "true");
			}

			String subTotalVal = AoUtil.convAoRoundingSalesPrice(
					String.valueOf(detailMap.get("wholesale_price")),
					String.valueOf(detailMap.get("order_quantity")),
					AoUtil.DispPattern.PATTERN_NO_COMMA,
					aoSetting.getSalesPriceDigitNum(),
					StringUtil.defaultString(userForm.get("price_fraction_div"), "0") );

			detailMap.put("sub_total", subTotalVal);

			totalWholeSalePrice = UtilTools.addBigDecimal(totalWholeSalePrice, subTotalVal);

			if (!((webOrderCampaignCd != null && itemCd.equals(webOrderCampaignCd))
					|| (deliveryFeeItemCd != null && isSpecialDetail(itemCd, deliveryFeeItemCd))) ) {
				subTotalWholeSalePrice = UtilTools.addBigDecimal(subTotalWholeSalePrice, subTotalVal);
			}


			if (webOrderCampaignCd != null
					&& itemCd.equals(webOrderCampaignCd)) {
				result.getReturnData().put("campaign_price",
						AoUtil.convAoRoundingSalesPrice(
								String.valueOf(
										detailMap.get("wholesale_price")),
								AoUtil.DispPattern.PATTERN_NO_COMMA,
								aoSetting.getSalesPriceDigitNum(),
								StringUtil.defaultString(userForm.get("price_fraction_div"), "0") ));
			}
			if (deliveryFeeItemCd != null && isSpecialDetail(itemCd, deliveryFeeItemCd)) {
			    result.getReturnData().put("delivery_fee_price",
                        AoUtil.convAoRoundingSalesPrice(
                                String.valueOf(
                                        detailMap.get("wholesale_price")),
                                AoUtil.DispPattern.PATTERN_NO_COMMA,
                                aoSetting.getSalesPriceDigitNum(),
                                StringUtil.defaultString(userForm.get("price_fraction_div"), "0") ));
			}

		}

		result.getReturnData().put("item_cd", itemCdList);
		result.getReturnData().put("total_whole_sale_price", totalWholeSalePrice);
		result.getReturnData().put("sub_total_whole_sale_price", subTotalWholeSalePrice);

		return result;
	}

	public static boolean isSpecialDetail(	String itemCd,
											String detailCd) {
		if (itemCd.equals(detailCd)) {
			return true;
		} else {
			return false;
		}
	}

}
