package jp.ill.photon.module.estimate;

import java.util.Map;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.model.Estimate;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;

public class CheckEstimateInput implements PhotonModule {

    @ModuleParam(required = true, paramGroup=true)
    private Estimate estimate = new Estimate();

    public Estimate getEstimate() {
        return estimate;
    }

    public void setEstimate(Estimate estimate) {
        this.estimate = estimate;
    }

    @Override
    public ModuleResult execute(ModuleContext context) throws PhotonModuleException {
        ModuleResult result = new ModuleResult();

        // 入力値のチェック
        Map<String, Object> resultMap = estimate.toMap();

        resultMap.put("cart_id", estimate.getCartId());
        resultMap.put("quantity", estimate.getQuantity());
        resultMap.put("case_quantity", estimate.getCaseQuantity());

        result.getReturnData().put("estimate", resultMap);

        return result;
    }

}
