package jp.ill.photon.module.db;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.model.SearchForm;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.JsonUtil;
import jp.ill.photon.util.StringUtil;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;



/**
 * カラム設定を読んで、データ取得処理を実施するクラス（詳細画面用）
 *
 * @author m_fukukawa
 *
 */
public class SettingDataToSearchDetailProcessModule extends SettingDataToSearchProcessBaseModule implements PhotonModule {

	/* モジュールパラメータ */
	@ModuleParam(required=true)
	protected List<Map<String, Object>> columnMap;

	@ModuleParam(required=false)
	protected List<Map<String, Object>> keyColumns;

	@ModuleParam(required=false)
	protected Map<String, Object> common;

	@ModuleParam(required = true)
	protected SearchForm searchForm;

	@Override
	public ModuleResult executeCustom(ModuleContext context) throws PhotonModuleException {

		ModuleResult result = new ModuleResult();

		setBasicParams();

		// クエリ作成
		buildSelectFiedldStr(columnMap, keyColumns);
		buildColumnsBySearchMap();

		Map<String, Object> data = getRow();
		data = formatRow(data);

		if (!CollectionUtils.isEmpty(columnMap)) {
			for (Map<String, Object> column : columnMap) {
				// 日付の表示
				data = generateDate(data, column);
				// 複数選択可能項目の設定
				data = generateMultiSelectItem(data, column);
				// 拡張項目のときのファイル項目を参照
				data = generataFileName(data, column);
			}
		}

		result.getReturnData().put("first", data);

		return result;

	}

	/**
	 * 条件部を作成
	 *
	 * @return 条件部
	 *
	 * */
	private void buildColumnsBySearchMap() {

		// tenant_id + edit_table_cd + キー項目として設定されているカラム名
		// 上記項目名をrequestから取得

		String result = null;
		StringJoiner sj = new StringJoiner(" AND ");
		sj.add(String.format("tenant_id = $$%s$$ ", tenantId));
		sj.add(String.format("edit_table_cd = $$%s$$ ", editTableCd));
		String work = makeWhereStrFromKeyColumn(request, true);
		if (!StringUtils.isEmpty(work)) {
			sj.add(work);
		}

		result = sj.toString();

		// 条件が無い場合はSQLで使用しないようにNULLを設定
		if ("".equals(result)) {
			result = null;
		}

		where = result;

	}

	/**
	 *
	 * 検索結果データ取得
	 *
	 * @return 検索結果データ
	 * @throws PhotonModuleException
	 *
	 * */
	private Map<String, Object> getRow() throws PhotonModuleException {

		sort = null;
		page = null;
		limit = null;
		List<Map<String, Object>> list = getRows();

		return ( (CollectionUtils.isEmpty(list))? new HashMap<String, Object>() : list.get(0) );

	}

	/**
	 *
	 * 日時のデータフォーマット
	 *
	 * @return 検索結果データ
	 * @throws PhotonModuleException
	 *
	 * */
	private Map<String, Object> generateDate(Map<String, Object> row, Map<String, Object> column) throws PhotonModuleException {

		Map<String, Object> result = row;
		String type = (String)column.get("data_input_type");
		String key = getKeyName(column);

		if (DataInputType.DATETIME.equals(type)) {

			String datetime = (String)result.get(key);
			String[] datetimeVal = datetime.split(" ");
			String dateVal = "";
			String timeVal = "";
			if (datetimeVal.length  >= 2) {
				timeVal = datetimeVal[1];
			}
			if (datetimeVal.length  >= 1) {
				dateVal = datetimeVal[0];
			}

			StringJoiner sj = new StringJoiner(" ");
			if (!StringUtils.isEmpty(dateVal)) {
				sj.add(dateVal);
			}
			if (!StringUtils.isEmpty(timeVal)) {
				sj.add(timeVal);
			}
			result.put(key, sj.toString());

		}

		return result;

	}
	/**
	 *
	 * 複数選択可能項目の設定
	 *
	 * @return 検索結果データ
	 * @throws PhotonModuleException
	 *
	 * */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	private Map<String, Object> generateMultiSelectItem(Map<String, Object> row, Map<String, Object> column) throws PhotonModuleException {

		Map<String, Object> result = row;
		String type = (String)column.get("data_input_type");
		String key = getKeyName(column);

		if (DataInputType.CHECKBOX.equals(type) || DataInputType.LISTBOX.equals(type)) {

			String val = (String)result.get(key);
			Object[] arr = new Object[]{};

			// ex_field_flgが1のデータは、choice_list_separatorで結合された値として保存されている前提
			if ("1".equals((String)column.get("ex_field_flg"))) {

				if (!StringUtils.isEmpty(val)) {

					String separator = (String) column.getOrDefault("choice_list_separator", ",");
					arr = val.split(separator);

				}

			} else {

				if (StringUtils.isEmpty(val)) {
					val = "[]";
				}
				List list = null;
				if (JsonUtil.isAbleToConverToList(val)){
					list = JsonUtil.jsonToList(val);
				} else {
					list = new ArrayList<String>();
					list.add(val);
				}

				if (list != null) {
					arr = list.toArray();
				}

			}

			result.put(key, arr);

		}

		return result;

	}

	/**
	 *
	 * 拡張項目のときのファイル項目を参照
	 *
	 * @return 検索結果データ
	 * @throws PhotonModuleException
	 *
	 * */
	private Map<String, Object> generataFileName(Map<String, Object> row, Map<String, Object> column) throws PhotonModuleException {

		Map<String, Object> result = row;
		String type = (String)column.get("data_input_type");
		String key = getKeyName(column);

		if (DataInputType.FILE.equals(type)) {

			if ("1".equals((String)column.get("ex_field_flg"))) {

				// 画像を表示するときだけ、物理ファイル名を取得する
				if ("1".equals((String)column.get("file_image_use_flg"))) {

					// ファイル名がセットされているときだけ、ファイル名を置き換える
					if (!StringUtils.isEmpty((String) row.get(key))) {

						// attachmentテーブルからデータを取得し、
						// 値にfile_nameの値をセットしなおす
						Map<String, Object> mp = getAttachment( StringUtil.defaultString(row.get("guid")), key);
						String fileName = "";
						if (mp != null) {
							fileName = (String) mp.get("file_name");
						}

						result.put(key, fileName);

					}

				}

			}

		}

		return result;

	}


	/**
	 * columnMapを取得します。
	 * @return columnMap
	 */
	public List<Map<String, Object>> getColumnMap() {
		return columnMap;
	}

	/**
	 * columnMapを設定します。
	 * @param columnMap
	 */
	public void setColumnMap(List<Map<String, Object>> columnMap) {
		this.columnMap = columnMap;
	}

	/**
	 * searchMapを取得します。
	 * @return searchMap
	 */
	public List<Map<String, Object>> getSearchMap() {
		return null;
	}

	/**
	 * sortDataを取得します。
	 * @return sortData
	 */
	public List<Map<String, Object>> getSortData() {
		return null;
	}

	/**
	 * keyColumnsを取得します。
	 * @return keyColumns
	 */
	public List<Map<String, Object>> getKeyColumns() {
		return keyColumns;
	}

	/**
	 * keyColumnsを設定します。
	 * @param keyColumns
	 */
	public void setKeyColumns(List<Map<String, Object>> keyColumns) {
		this.keyColumns = keyColumns;
	}

	/**
	 * commonを取得します。
	 * @return common
	 */
	public Map<String, Object> getCommon() {
		return common;
	}

	/**
	 * commonを設定します。
	 * @param common
	 */
	public void setCommon(Map<String, Object> common) {
		this.common = common;
	}

	/**
	 * searchFormを取得します。
	 * @return searchForm
	 */
	public SearchForm getSearchForm() {
		return searchForm;
	}

	/**
	 * searchFormを設定します。
	 * @param searchForm
	 */
	public void setSearchForm(SearchForm searchForm) {
		this.searchForm = searchForm;
	}

}
