package jp.ill.photon.module.db;

import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.StringUtil;

/**
 * カラム設定を読んで、他のモジュールで使用できるデータを出力するクラスの基底クラス
 *
 * @author m_fukukawa
 *
 */
public abstract class SettingDataToManipulateBaseModule
		implements PhotonModule {

	/* クラス内の複数メソッドで使用する変数 */
	protected ActionDto dto;
	protected Map<String, Object> request;

	protected static class ColumnName {
		public static final String COLUMN_NAME = "c_";
		public static final String COLUMN_NAME_START = "s_";
		public static final String COLUMN_NAME_END = "e_";
	}

	/** 有効フラグ */
	protected static class ValidFlg {
		/** 条件なし */
		public static final String NOT = "9";
		/** 有効 */
		public static final String ON = "1";
		/** 無効 */
		public static final String OFF = "0";
	}

	/** 表示フラグ */
	protected static class DispFlg {
		/** 非表示 */
		public static final String NO = "0";
		/** 表示 */
		public static final String YES = "1";
	}

	// /** データ入力方式 */
	// protected static class DataInputType {
	// /** ラベル */
	// public static final String LABEL = "0";
	// /** 単一行テキスト */
	// public static final String TEXT = "1";
	// /** チェックボックス */
	// public static final String CHECKBOX = "2";
	// /** ラジオボタン */
	// public static final String RADIO = "3";
	// /** コンボボックス */
	// public static final String COMBOBOX = "4";
	// /** リストボックス */
	// public static final String LISTBOX = "5";
	// /** テキストエリア */
	// public static final String TEXTAREA = "6";
	// /** ファイル選択 */
	// public static final String FILE = "7";
	// /** パスワード入力 */
	// protected static String PASSWORD = "9";
	// /** 日付 */
	// public static final String DATE = "21";
	// /** 日時 */
	// public static final String DATETIME = "22";
	// /** リッチテキストエディタ */
	// public static final String RICHTEXT = "23";
	// /** 選択ポップアップ */
	// public static final String POPUP = "24";
	// }
	/** データ入力方式 */
	protected static class DataInputType {
		/** ラベル */
		protected static final String LABEL = "0";
		/** 単一行テキスト */
		protected static final String TEXT = "1";
		/** チェックボックス */
		protected static final String CHECKBOX = "2";
		/** ラジオボタン */
		protected static final String RADIO = "3";
		/** コンボボックス */
		protected static final String COMBOBOX = "4";
		/** リストボックス */
		protected static final String LISTBOX = "5";
		/** テキストエリア */
		protected static final String TEXTAREA = "6";
		/** ファイル選択 */
		protected static final String FILE = "7";
		/** データコンボボックス */
		protected static String DATA_COMBOBOX = "8";
		/** パスワード入力 */
		protected static String PASSWORD = "9";
		/** 日付 */
		protected static final String DATE = "21";
		/** 日時 */
		protected static final String DATETIME = "22";
		/** リッチテキストエディタ */
		protected static final String RICHTEXT = "23";
		/** 選択ポップアップ */
		protected static final String POPUP = "24";
		/** 単一行テキスト(カラーパレット付) */
		protected static final String COLOR = "25";
		/** 日時_時分秒 */
		protected static final String DATETIME_HMS = "26";
		/** 範囲（文字列） */
		protected static String RANGE_TEXT = "31";
		/** 範囲（数値） */
		protected static String RANGE_NUMBER = "32";
		/** 範囲（日付） */
		protected static String RANGE_DATE = "33";
		/** 範囲（日時） */
		protected static String RANGE_DATETIME = "34";
		/** hidden */
		protected static String HIDDEN = "99";
	}

	/** 編集テーブル自動採番区分 */
	protected static class EtcolAutnumDiv {
		// /** なし */
		// public static final String NOT = "0";
		// /** 整数形式で自動採番 */
		// public static final String SERIAL = "1";
		// /** 伝票形式で自動採番 */
		// public static final String ZERO = "2";
		/** 整数形式で自動採番 */
		public static final String SERIAL = "0";
		/** 伝票形式で自動採番 */
		public static final String ZERO = "1";
	}

	/** 削除フラグ */
	protected static class DeleteFlg {
		/** 未削除 */
		public static final String DELETE_FLG_OFF = "0";
		/** 削除済 */
		public static final String DELETE_FLG_ON = "1";
	}

	/** 拡張項目テキストデータ形式 */
	protected static class TextDataFormat {
		/** 制限なし */
		public static final String NONE = "0";
		/** 半角数字のみ */
		public static final String NUMBER = "1";
		/** 数値 */
		public static final String NUMERIC = "2";
		/** 半角英数字のみ */
		public static final String ALPH_NUMBER = "3";
		/** 半角文字のみ */
		public static final String CHARACTER = "4";
		/** 電話番号 */
		public static final String TELNUMBER = "5";
		/** メールアドレス */
		public static final String MAILADDRESS = "6";
	}

	/** 0埋めフラグ */
	protected static class TextHalfZeroFillFlgType {
		/** 0埋めする */
		protected static final String TEXT_HALF_ZERO_FILL_FLG = "1";
	}

	@Override
	public ModuleResult execute(ModuleContext context)
			throws PhotonModuleException {

		dto = context.getDto();
		request = context.getDto().getRawParams();

		// 子クラスのexecuteメソッド実行
		ModuleResult result = executeCustom(context);

		return result;

	}

	/**
	 * キャプション文字列生成
	 *
	 * @param src
	 * @param common
	 *
	 * @return
	 */
	protected String getCaption(Map<String, Object> src, Object common) {

		return getCaptionImpl((String) src.get("display_name"),
				(String) src.get("disp_label"), common);

	}

	/**
	 * キャプション文字列生成(popup)
	 *
	 * @param src
	 * @param common
	 *
	 * @return
	 */
	protected String getCaptionPopup(Map<String, Object> src, Object common) {

		return getCaptionImpl((String) src.get("sel_pop_data_name"),
				(String) src.get("disp_label"), common);

	}

	/**
	 * キャプション文字列生成
	 *
	 * @param keyStr
	 * @param dispLabelKeyStr
	 * @param common
	 *
	 * @return
	 */
	@SuppressWarnings("unchecked")
	protected String getCaptionImpl(String keyStr,
									String dispLabelKeyStr,
									Object common) {

		String val = dispLabelKeyStr;

		String front = "%%%{";
		String rear = "}%%%";
		String[] list = StringUtils.substringsBetween(val, front, rear); // この時点で、val
																			// =
																			// %%%{テーブルコード.キー文字列.値が格納されているフィールド名}%%%
																			// の想定

		if (list != null && list.length > 0) {
			for (int i = 0; i < list.length; i++) {
				// この時点で、val = テーブルコード.キー文字列.値が格納されているフィールド名 の想定
				String[] id = list[i].split("\\.");
				String editTableCd = id[0];
				String key = id[1];
				String value = id[2];
				String replaceTargetLagelStr = getValueFromSystemSetting(
						((Map<String, Object>) common).get(editTableCd), key,
						value);
				if (replaceTargetLagelStr == null) {
					replaceTargetLagelStr = "";
				}
				val = StringUtils.replace(val, front + list[i] + rear,
						replaceTargetLagelStr);
			}
		}

		if (StringUtils.isEmpty(val)) {
			// disp_labelが設定されていないときはdisplay_nameの値をそのまま表示
			return keyStr;
		}

		return val;
	}

	/***
	 *
	 * 設定系のオブジェクトから値を取得
	 *
	 * @param setting Map
	 * @param idKey idが格納されているキー
	 * @param valueKey 値が格納されているキー
	 * @return
	 */
	@SuppressWarnings({ "unchecked" })
	protected String getValueFromSystemSetting(	Object setting,
												String idKey,
												String valueKey) {
		if (setting == null) {
			return null;
		}
		Map<String, Object> valMap = (Map<String, Object>) ((Map<String, Object>) setting)
				.get(idKey);
		if (valMap == null) {
			return null;
		}
		return (String) valMap.get(valueKey);
	}

	/**
	 *
	 * 設定情報の"choice_list"、"choice_list_separator"より配列を作成する。
	 *
	 * @param mp 設定
	 *
	 * @return 配列
	 *
	 */
	protected String[] getStringArrayFromChoiceList(Map<String, Object> mp) {

		String[] ret = null;

		String choiceList = (String) mp.getOrDefault("choice_list", "");
		String choiceListSeparator = (String) mp
				.getOrDefault("choice_list_separator", "");

		if (!StringUtils.isEmpty(choiceList)
				&& !StringUtils.isEmpty(choiceListSeparator)) {
			ret = choiceList
					.split(StringUtil.escapeRegexpMeta(choiceListSeparator), 0);
		}

		return ret;

	}

	/**
	 * 子クラスのexecuteメソッド実行
	 *
	 * @param context
	 * @return
	 * @throws PhotonModuleException
	 */
	protected abstract ModuleResult executeCustom(ModuleContext context)
			throws PhotonModuleException;

}
