package jp.ill.photon.module.db;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.module.PhotonModule;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

/**
 * [create_search_form_from_data]
 * 一覧画面用、カラム設定->GeneralSearchFormCreateModule用データ変換モジュール.
 *
 * <p>
 * 一覧画面作成用にカラム設定を読んで、GeneralSearchFormCreateModuleで使用できるデータを出力する.
 * </p>
 *
 * @author m_fukukawa
 *
 */
public class SettingDataToGeneralSearchFormModule
		extends SettingDataToGeneralFormBaseModule implements PhotonModule {

	/**
	 * カラム設定用モジュールパラメータ.
	 *
	 * <p>
	 * 下記のSQLが返すリストと同様の結果が渡されることを想定:<br/>
	 * aec20/table/selectColumnSettingsByFormCd.sql
	 * </p>
	 */
	@ModuleParam(required = true)
	protected List<Map<String, Object>> settingData;

	@ModuleParam(required = false)
	protected List<Map<String, Object>> addInputList;

	@ModuleParam(required = false)
	protected Map<String, Object> common;

	@ModuleParam(required = false)
	protected String redisplayFlg;

	@ModuleParam(required = false)
	protected String procMode;

	@ModuleParam(required = false)
	protected Map<String, Map<String, Object>> externalList;

	@ModuleParam(required = false)
	@DefaultParamSetting(transferType = "static", transferVal = "true")
	protected boolean editable;

	@ModuleParam(required = false)
	protected List<Map<String, Object>> addButtonInfoList;

	@ModuleParam(required = false)
	protected Map<String, Object> commonButtonList;

	@ModuleParam(required = false)
	protected List<Map<String, Object>> headerSettingData;

	/**
	 * キー名を取得
	 *
	 * @param src
	 * @return
	 *
	 */
	@Override
	protected String getKeyName(Map<String, Object> src) {
		return StringUtils.defaultIfEmpty((String) src.get("key_name"),
				ColumnName.COLUMN_NAME + (String) src.get("cond_no"));
	}

	/**
	 * 入力項目ガイド文字列を作成
	 *
	 * @param src 元になるデータ
	 *
	 */
	protected String generateColumnGuideStr(Map<String, Object> src) {

		return "";

	}

	/**
	 * 初期値を作成
	 *
	 * @param src 元になるデータ
	 * @param dst 設定後のデータ
	 *
	 */
	@Override
	protected void setInitItems(Map<String, Object> src,
								Map<String, Object> dst) {

		// 入力タイプにより初期値を作成
		if (DataInputType.RADIO.equals(type)) {

			// ラジオボタン
			dst.put("list_top_items_type", "static");
			dst.put("list_top_items", new ArrayList<Map<String, Object>>() {
				{
					add(new HashMap<String, Object>() {
						{
							put("list_value", "");
							put("list_caption", "条件無し");
						}
					});
				}
			});

		} else if (DataInputType.COMBOBOX.equals(type)) {

			// ドロップダウン
			dst.put("list_top_items_type", "static");
			dst.put("list_top_items", new ArrayList<Map<String, Object>>() {
				{
					add(new HashMap<String, Object>() {
						{
							put("list_value", "");
							put("list_caption", "");
						}
					});
				}
			});

		}

	}

	/**
	 * 有効か無効化を返却
	 *
	 * @param src
	 * @return
	 *
	 */
	@Override
	protected boolean getEnable(Map<String, Object> src) {
		boolean editable = isEditable();
		if (!editable) {
			return editable;
		}
		String readonly = (String) src.get("readonly");
		if ("1".equals(readonly)) {
			return false;
		}
		return true;
	}

	/**
	 *
	 * この画面表示モードでボタン追加を行うか
	 *
	 * @param settingMode
	 * @param screenMode
	 * @return
	 *
	 */
	protected boolean isAppendButtonOnThisMode(String mode, String screenMode) {
		return mode.equals(screenMode);
	}

	/**
	 *
	 * テーブル定義情報によるボタン追加を行うか
	 *
	 * @return
	 *
	 */
	@Override
	protected boolean isAppendButtonFromSettingData() {
		return true;
	}

	/**
	 * 画面表示モードリストを取得
	 *
	 * @return
	 *
	 */
	protected List<String> getScreenModeList() {
		return new ArrayList<String>() {
			{
				add("");
				add("bottom");
				add("bottom_under");
			}
		};
	}

	/**
	 * HTML属性の設定
	 *
	 * @param htmlContent
	 *
	 */
	@Override
	protected void setHtmlSizeAttr(	Map<String, Object> src,
									Map<String, Object> htmlContent) {
		if (TYPE_TEXT.equals(outputType)
				|| DataInputType.RANGE_TEXT.equals(type)
				|| DataInputType.RANGE_NUMBER.equals(type)
				|| DataInputType.RANGE_DATE.equals(type)
				|| DataInputType.RANGE_DATETIME.equals(type)) {
			htmlContent.put("size", (String) src.get("text_input_size"));
			String maxLengthVal = StringUtils
					.defaultIfEmpty((String) src.get("text_length_max"), "0");
			if (Integer.parseInt(maxLengthVal) > 0) {
				htmlContent.put("maxlength",
						(String) src.get("text_length_max"));
			}
		}
	}

	/**
	 * 初期処理
	 *
	 */
	@Override
	protected void initCustom() {
	}

	/**
	 * 値参照先の設定
	 *
	 * @param src
	 * @param content
	 *
	 */
	@Override
	protected void setValueReferences(	Map<String, Object> src,
										Map<String, Object> content) {
		setDefaultValueReferences(src, content);
	}

	/**
	 * デフォルト値の設定
	 *
	 * @param src
	 * @param content
	 *
	 */
	@Override
	protected void setDetaultValue(	Map<String, Object> src,
									Map<String, Object> content) {
		if (TYPE_COMBOBOX.equals(outputType) || TYPE_RADIO.equals(outputType)
				|| TYPE_LISTBOX.equals(outputType)) {
			content.put("default", "");
		}
	}

	/**
	 * target_action_idを取得
	 *
	 */
	@Override
	protected String getTargetActionId() {
		String ret = "edit_table_data_popup_list";
		return ret;
	}

	/**
	 * 範囲入力項目の設定
	 *
	 * @param content
	 *
	 */
	@Override
	protected void setRangeInput(	Map<String, Object> src,
									Map<String, Object> content) {
		if (DataInputType.RANGE_TEXT.equals(type)
				|| DataInputType.RANGE_NUMBER.equals(type)
				|| DataInputType.RANGE_DATE.equals(type)
				|| DataInputType.RANGE_DATETIME.equals(type)) {
			// content.put("range_separator", "～");
			String val = StringUtils
					.defaultIfEmpty((String) src.get("range_separator"), "～");
			content.put("range_separator", new HashMap<String, Object>() {
				{
					put("type", "static");
					put("val", val);
				}
			});
		}
	}

	/**
	 * データコンボボックスの設定
	 *
	 * @param src
	 * @param content
	 *
	 */
	@Override
	@SuppressWarnings("unchecked")
	protected void setDataTypeCombobox(	Map<String, Object> src,
										Map<String, Object> content) {
		if (DataInputType.DATA_COMBOBOX.equals(type)) {

			String selDropdownCd = (String) src.get("sel_dropdown_cd");
			List<Map<String, Object>> retList = new ArrayList<Map<String, Object>>();

			Map<String, Map<String, Object>> externalList = getExternalList();
			if (externalList != null
					&& externalList.get(selDropdownCd) != null) {
				Map<String, Object> mp = (Map<String, Object>) externalList
						.get(selDropdownCd);
				List<Map<String, Object>> list = (List<Map<String, Object>>) mp
						.get("list");
				if (!CollectionUtils.isEmpty(list)) {
					for (Map<String, Object> data : list) {
						retList.add(new HashMap<String, Object>() {
							{
								put("list_value", data.get("list_value"));
								put("list_caption", data.get("list_caption"));
							}
						});
					}
				}
			}

			content.put("list_type", "static");
			content.put("list", retList);

			// 検索条件として使用するので、一番頭には未選択を表す空白項目を追加する
			content.put("list_top_items_type", "static");
			content.put("list_top_items", new ArrayList<Map<String, Object>>() {
				{
					add(new HashMap<String, Object>() {
						{
							put("list_value", "");
							put("list_caption", "");
						}
					});
				}
			});

		}

	}

	/**
	 * settingDataを取得します。
	 *
	 * @return settingData
	 */
	@Override
	public List<Map<String, Object>> getSettingData() {
		return settingData;
	}

	/**
	 * settingDataを設定します。
	 *
	 * @param settingData
	 */
	public void setSettingData(List<Map<String, Object>> settingData) {
		this.settingData = settingData;
	}

	/**
	 * addInputListを取得します。
	 *
	 * @return addInputList
	 */
	@Override
	public List<Map<String, Object>> getAddInputList() {
		return addInputList;
	}

	/**
	 * addInputListを設定します。
	 *
	 * @param addInputList
	 */
	public void setAddInputList(List<Map<String, Object>> addInputList) {
		this.addInputList = addInputList;
	}

	/**
	 * commonを取得します。
	 *
	 * @return common
	 */
	@Override
	public Map<String, Object> getCommon() {
		return common;
	}

	/**
	 * commonを設定します。
	 *
	 * @param common
	 */
	public void setCommon(Map<String, Object> common) {
		this.common = common;
	}

	/**
	 * redisplayFlgを取得します。
	 *
	 * @return redisplayFlg
	 */
	@Override
	public String getRedisplayFlg() {
		return redisplayFlg;
	}

	/**
	 * redisplayFlgを設定します。
	 *
	 * @param redisplayFlg
	 */
	public void setRedisplayFlg(String redisplayFlg) {
		this.redisplayFlg = redisplayFlg;
	}

	/**
	 * procModeを取得します。
	 *
	 * @return procMode
	 */
	@Override
	public String getProcMode() {
		return procMode;
	}

	/**
	 * procModeを設定します。
	 *
	 * @param procMode
	 */
	public void setProcMode(String procMode) {
		this.procMode = procMode;
	}

	/**
	 * externalListを取得します。
	 *
	 * @return externalList
	 */
	@Override
	public Map<String, Map<String, Object>> getExternalList() {
		return externalList;
	}

	/**
	 * externalListを設定します。
	 *
	 * @param externalList
	 */
	public void setExternalList(Map<String, Map<String, Object>> externalList) {
		this.externalList = externalList;
	}

	/**
	 * editableを取得します。
	 *
	 * @return editable
	 */
	@Override
	public boolean isEditable() {
		return editable;
	}

	/**
	 * editableを設定します。
	 *
	 * @param editable
	 */
	public void setEditable(boolean editable) {
		this.editable = editable;
	}

	/**
	 * addButtonInfoListを取得します。
	 *
	 * @return addButtonInfoList
	 */
	@Override
	public List<Map<String, Object>> getAddButtonInfoList() {
		return addButtonInfoList;
	}

	/**
	 * addButtonInfoListを設定します。
	 *
	 * @param addButtonInfoList
	 */
	public void setAddButtonInfoList(List<Map<String, Object>> addButtonInfoList) {
		this.addButtonInfoList = addButtonInfoList;
	}

	/**
	 * commonButtonListを取得します。
	 *
	 * @return commonButtonList
	 */
	@Override
	public Map<String, Object> getCommonButtonList() {
		return commonButtonList;
	}

	/**
	 * commonButtonListを設定します。
	 *
	 * @param commonButtonList
	 */
	public void setCommonButtonList(Map<String, Object> commonButtonList) {
		this.commonButtonList = commonButtonList;
	}

	/**
	 * headerSettingDataを取得します。
	 *
	 * @return headerSettingData
	 */
	@Override
	public List<Map<String, Object>> getHeaderSettingData() {
		return headerSettingData;
	}

	/**
	 * headerSettingDataを設定します。
	 *
	 * @param headerSettingData
	 */
	public void setHeaderSettingData(List<Map<String, Object>> headerSettingData) {
		this.headerSettingData = headerSettingData;
	}

}
