package jp.ill.photon.module.db;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.JsonUtil;
import jp.ill.photon.util.ParamUtil;
import jp.ill.photon.util.StringUtil;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

/**
 * カラム設定を読んで、HTMLGeneralListOutputModuleで使用できるデータを出力するクラス
 *
 * @author m_fukukawa
 * @see jp.ill.photon.module.output.HTMLGeneralListOutputModule
 *
 */
public class SettingDataToGeneralOutputModule extends SettingDataToManipulateBaseModule implements PhotonModule {

	@ModuleParam(required=true)
	public List<Map<String, Object>> settingData;

	@ModuleParam(required=false)
	public Map<String, Object> common;

	@ModuleParam(required=false)
	protected List<Map<String, Object>> keyColumns;

	@ModuleParam(required=false)
	@DefaultParamSetting(transferType = "static", transferVal = "true")
	public boolean needSelectCheckBox;

	@ModuleParam(required=false)
	@DefaultParamSetting(transferType = "static", transferVal = "true")
	public boolean needEditBtn;

	@ModuleParam(required=false)
	@DefaultParamSetting(transferType = "static", transferVal = "編集")
	public String editBtnCaption;

	@ModuleParam(required=false)
	@DefaultParamSetting(transferType = "static", transferVal = "edit_table_data_detail")
	public String detailUrl;

	@ModuleParam(required=false)
	public String editTableCd;

	@ModuleParam(required=false)
	public String menuDiv;

	/** タイプ */
	public static String TYPE_TEXT = "text";
	public static String TYPE_CHECKBOX = "checkbox";
	public static String TYPE_RADIO = "radio";
	public static String TYPE_COMBOBOX = "combobox";
	public static String TYPE_BUTTON = "button";
	public static String TYPE_DATE = "date";
	public static String TYPE_FILE = "file";

	private static class FileImageUseflg {
		public static final String USE = "1";
	}
	private static class LinkFlg {
		public static final String ON = "1";
	}
	@Override
	public ModuleResult executeCustom(ModuleContext context) {

		Map<String, Object> columnList = new HashMap<String, Object>();
		Map<String, Object> linkInfo = new HashMap<String, Object>();
		Map<String, Object> objectInfo = new HashMap<String, Object>();

		if (settingData != null) {

			List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();

			// キー項目の名前を取得
			List<String> keyInfo = new ArrayList<String>();
			for (Map<String, Object> mp : settingData) {
				String keyNo = String.valueOf( mp.get("key_no") );
				if (!StringUtils.isEmpty(keyNo) && !"0".equals(keyNo)) {
					keyInfo.add((String) mp.get("col_cd"));
				}
			}
			if (!CollectionUtils.isEmpty(keyColumns)) {
				for (Map<String, Object> mp : keyColumns) {
					String colCd = (String) mp.get("col_cd");
					if (!keyInfo.contains(colCd)) {
						keyInfo.add(colCd);
					}
				}
			}

			if (needSelectCheckBox) {
				// 「選択」チェックボックス追加
				addDataSelectCheckBox(list, objectInfo, keyInfo);
			}

			// カラム情報分ループ
			for (Map<String, Object> mp : settingData) {

				String key = (String)mp.getOrDefault("col_cd", "");
				// String name = (String)mp.getOrDefault("display_name", "");
				String name = getCaption(mp, common);
				String fileImageUseflg = (String)mp.getOrDefault("file_image_use_flg", "");
				String linkFlg = (String)mp.getOrDefault("link_flg", "");
				String listDataInputType = StringUtils.defaultString((String)mp.get("list_data_input_type"), DataInputType.LABEL);
				String dataInputType = StringUtils.defaultString((String)mp.get("data_input_type"), DataInputType.LABEL);
				String textDataFormat = StringUtil.defaultString(mp.get("text_data_format"));
				String objInfoType = "";
				int linkflgCnt = 0;
				String linkInfoName = "";
				boolean addObjInfo = false;
				if (FileImageUseflg.USE.equals(fileImageUseflg)) {
					addObjInfo = true;
					objInfoType = "file";
				}
				if (DataInputType.TEXT.equals(listDataInputType)) {
					addObjInfo = true;
					objInfoType = TYPE_TEXT;
				} else if (DataInputType.CHECKBOX.equals(listDataInputType)) {
					addObjInfo = true;
					objInfoType = TYPE_CHECKBOX;
				} else if (DataInputType.RADIO.equals(listDataInputType)) {
					addObjInfo = true;
					objInfoType = TYPE_RADIO;
				} else if (DataInputType.COMBOBOX.equals(listDataInputType)) {
					addObjInfo = true;
					objInfoType = TYPE_COMBOBOX;
				} else if (DataInputType.DATE.equals(listDataInputType)) {
					addObjInfo = true;
					objInfoType = TYPE_DATE;
				}

				Map<String, Object> columnInfo = new HashMap<String, Object>();

				//boolean addLinkInfo = false;
				String colType = "";
				if (LinkFlg.ON.equals(linkFlg)) {
					linkflgCnt++;
					// addLinkInfo = true;
					colType = "link";
					linkInfoName = ("return_link_" + linkflgCnt);
				}

				columnInfo.put("key", key);
				columnInfo.put("name", name);
				if (addObjInfo) {
					columnInfo.put("object", key);
				}
				//if (addLinkInfo) {
				if (!StringUtils.isEmpty(colType)) {
					columnInfo.put("link", linkInfoName);
				}

				// TODO: list_data_input_typeがラベルで、
				//       data_input_typeがチェックボックス、ラジオボタン、コンボボックス、リストボックスの場合、
				//       choice_listを表示する。
				if (DataInputType.LABEL.equals(listDataInputType) &&
					(
						DataInputType.CHECKBOX.equals(dataInputType) ||
						DataInputType.RADIO.equals(dataInputType) ||
						DataInputType.COMBOBOX.equals(dataInputType) ||
						DataInputType.LISTBOX.equals(dataInputType)
					)
				) {
					applyDispMapToColumnList(mp, columnInfo);
				}

				// data_input_typeが21（日付）、22（日時）、26（日時(時分秒)）のものは、
				// 右寄せ表示（表示領域のclassにp-common-table-dateを割り当て）する
				//  text_data_formatが1（半角数字）、または、2（数値）のものは、
				// 右寄せ表示（表示領域のclassにp-common-table-numberを割り当て）する

				StringJoiner sj = new StringJoiner(" ");
				sj.add(key);
				if (DataInputType.DATE.equals(dataInputType) ||
						DataInputType.DATETIME.equals(dataInputType) ||
						DataInputType.DATETIME_HMS.equals(dataInputType)) {
					sj.add("p-common-table-date");
				} else if (TextDataFormat.NUMBER.equals(textDataFormat) ||
						TextDataFormat.NUMERIC.equals(textDataFormat)) {
					sj.add("p-common-table-number");
				}

				columnInfo.put("html_attr", new HashMap<String, Object>(){{
					put("class", sj.toString());
				}});

				//  text_data_formatが1（半角数字）、または、2（数値）のものは、
				// #fmt.numを適用した値を表示する
				if (TextDataFormat.NUMBER.equals(textDataFormat) ||
						TextDataFormat.NUMERIC.equals(textDataFormat)) {
					columnInfo.put("format", "num");
				}

				list.add(columnInfo);

				if (addObjInfo) {
					addDataToObjInfo(key, objInfoType, mp, objectInfo, keyInfo);
				}
				//if (addLinkInfo) {
				Map<String, Object> valMap = new HashMap<String, Object>();
				if ("link".equals(colType)) {
					valMap.put("type","return");
				}
				linkInfo.put(linkInfoName, valMap);

			}

			if (needEditBtn) {
				// 「編集」ボタン追加
				addEditBtn(list, objectInfo, keyInfo);
			}

			if (!list.isEmpty()) {
				columnList.put("list", list);
			}

		}

		ModuleResult result = new ModuleResult();
		// フォームデータのセット
		result.getReturnData().put("column_list", columnList);
		result.getReturnData().put("link_info", linkInfo);
		result.getReturnData().put("object_info", objectInfo);

		return result;

	}

	/**
	 *
	 * 出力モジュールのobject_infoの項目として出力
	 *
	 * @param src
	 * @param columnInfo
	 */
	private void applyDispMapToColumnList(Map<String, Object> src, Map<String, Object> columnInfo) {

		// ラジオボタン、チェックボックスのときには、デフォルト選択値をセット
		String[] choiseItem = getStringArrayFromChoiceList(src);

		if (choiseItem != null) {

			Map<String, Object> mp = new HashMap<String, Object>();

			// 分解した値をリストに設定
			for (int i = 0; i < choiseItem.length; i = i + 2) {
				String val = StringUtils.defaultString(choiseItem[i], "");
				String dispVal = "";
				if (choiseItem.length > (i + 1)) {
					dispVal = choiseItem[i + 1];
				}
				if (!StringUtils.isEmpty(dispVal)) {
					mp.put(val, dispVal);
				}
			}

			columnInfo.put("disp_map", new HashMap<String, Object>(){{
				put("type", "static");
				put("val", mp);
			}});

		}

	}

	/**
	 * 出力モジュールのobject_infoの項目として出力
	 *
	 * @param key
	 * @param type
	 * @param src
	 * @param objectInfo
	 * @param keyInfo
	 */
	private void addDataToObjInfo(String key, String type, Map<String, Object> src, Map<String, Object> objectInfo, List<String> keyInfo) {

		// obj_info.inputs
		Map<String, Object> objInfoInputs = new HashMap<String, Object>();

		objInfoInputs.put("type", type);

		Map<String, Object> html_attr = new HashMap<String, Object>(){{
			put("class", key);
		}};

		if (TYPE_FILE.equals(type)) {

			objInfoInputs.put("file_dir", new HashMap<String, Object>(){{
				//put("type", ParamUtil.TransferTypes.DTO);
				put("type", "row");
				put("val", key + "_file_dir");
			}});

			objInfoInputs.put("file_sub_dir", new HashMap<String, Object>(){{
				put("type", "row");
				put("val", key + "_file_sub_dir");
			}});

			objInfoInputs.put("file_name", new HashMap<String, Object>(){{
				put("type", "row");
				//put("val", key + "_file_name");
				put("val", key);
			}});

			objInfoInputs.put("file_image_disp_width", new HashMap<String, Object>(){{
				String width = "100";
				if (src.get("file_image_disp_width") != null) {
					width = (String)src.get("file_image_disp_width");
				}
				put("type", "static");
				put("val", width);
			}});

			objInfoInputs.put("file_image_use_flg", new HashMap<String, Object>(){{
				String val = "0";
				if (src.get("file_image_use_flg") != null) {
					val = (String)src.get("file_image_use_flg");
				}
				put("type", "static");
				put("val", val);
			}});

		} else if (TYPE_TEXT.equals(type)) {

			objInfoInputs.put(key, new HashMap<String, Object>(){{
				put("type", "param");
				put("val", key);
			}});

			String maxlength = (String)src.get("text_length_max");
			String size = (String)src.get("text_input_size");
			if (!StringUtils.isEmpty(maxlength)) {
				html_attr.put("maxlength", maxlength);
			}
			if (!StringUtils.isEmpty(size)) {
				html_attr.put("size", size);
			}

		} else if (TYPE_CHECKBOX.equals(type) || TYPE_RADIO.equals(type) || TYPE_COMBOBOX.equals(type)){

			objInfoInputs.put(key, new HashMap<String, Object>(){{
				put("type", "param_multi");
				put("val", key);
			}});

			// ラジオボタン、チェックボックスのときには、デフォルト選択値をセット
			String[] choiseItem = getStringArrayFromChoiceList(src);

			if (choiseItem != null) {

				List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();

				// 分解した値をリストに設定
				for (int i = 0; i < choiseItem.length; i = i + 2) {
					Map<String, Object> mp = new HashMap<String, Object>();
					String val = StringUtils.defaultString(choiseItem[i], "");
					String dispVal = "";
					if (choiseItem.length > (i + 1)) {
						dispVal = choiseItem[i + 1];
					}
					if (!StringUtils.isEmpty(dispVal)) {
						mp.put("list_value", val);
						mp.put("list_caption", dispVal);
						list.add(mp);
					}
				}

				objInfoInputs.put("list_type", "static");
				objInfoInputs.put("list", list);

			}

		} else if (TYPE_DATE.equals(type)) {

			objInfoInputs.put(key, new HashMap<String, Object>(){{
				put("type", "param");
				put("val", key);
			}});

		}

		String additionalHtmlAttr = (String)src.getOrDefault("additional_html_attr", "");
		if (!StringUtils.isEmpty(additionalHtmlAttr)) {
			Map<String, Object> mp = JsonUtil.jsonToMap(additionalHtmlAttr);
			for (Map.Entry<String, Object> e : mp.entrySet()) {
				html_attr.put(e.getKey(), e.getValue());
			}
		}
		objInfoInputs.put("html_attr", html_attr);

		// obj_info.params
		Map<String, Object> objInfoParams = new HashMap<String, Object>();
		addParamsToObjInfo(keyInfo, objInfoParams);

		objectInfo.put(key, new HashMap<String, Object>(){{
			put("inputs", objInfoInputs);
			put("params", objInfoParams);
		}});

	}

	/**
	 * 「選択」のチェックボックスを追加
	 *
	 * @param list
	 * @param objectInfo
	 * @param keyInfo
	 *
	 * */
	private void addDataSelectCheckBox(List<Map<String, Object>> list, Map<String, Object> objectInfo, List<String> keyInfo) {

		// カラム情報
		String objectKey = "selected_items";
		addInputObjToColumnList(objectKey, "選択", list);

		// obj_info
		Map<String, Object> obj_info = new HashMap<String, Object>();

		// obj_info.inputs
		obj_info.put("inputs", new HashMap<String, Object>(){{
									put("type", "checkbox");
									put("list_type", "static");
									put("list", new ArrayList<Map<String,Object>>(){{
													add(
														new HashMap<String, Object>() {{
															put("list_value", "1");
															put("list_caption", "");
														}}
													);
												}}
									);
								}}
		);

		// obj_info.params
		obj_info.put("params", makeObjInfoParams(keyInfo));

		objectInfo.put(objectKey, obj_info);

	}

	/**
	 * 「編集」ボタン追加
	 *
	 * @param list
	 * @param objectInfo
	 * @param keyInfo
	 *
	 * */
	private void addEditBtn(List<Map<String, Object>> list, Map<String, Object> objectInfo, List<String> keyInfo) {

		// カラム情報
		String objectKey = "buttons";
		addInputObjToColumnList(objectKey, "", list);

		// obj_info
		Map<String, Object> obj_info = new HashMap<String, Object>();

		// obj_info.inputs
		obj_info.put("inputs", new HashMap<String, Object>(){{
			put("type", "button");
			put("caption", editBtnCaption);
		}});

		// obj_info.params
		Map<String, Object> mp = makeObjInfoParams(keyInfo);
		mp.put("proc_mode", new HashMap<String, Object>(){{
			put("type", "static");
			put("val", "update");
		}});
		if (!StringUtils.isEmpty(menuDiv)) {
			// menu_divが設定されていたとき、詳細画面にmenu_divをパラメータとして渡すようにクエリ文字列に追加する
			mp.put("menu_div", new HashMap<String, Object>(){{
				put("type", "static");
				put("val", menuDiv);
			}});
		}
		obj_info.put("params", mp);
		obj_info.put("action_id", new HashMap<String, Object>(){{
			put("type", "static");
			put("val", detailUrl);
		}});

		objectInfo.put(objectKey, obj_info);

	}

	/**
	 * オブジェクトをcolumnListに追加する
	 *
	 * @param objectKey
	 * @param name
	 * @param list
	 */
	private void addInputObjToColumnList(String objectKey, String name, List<Map<String, Object>> list) {
		list.add(new HashMap<String, Object>(){{
			put("key", objectKey);
			put("name", name);
			put("object", objectKey);
			put("html_attr", new HashMap<String, Object>(){{
				put("class", objectKey);
			}});
		}});
	}

	/**
	 * obj_info.paramsに追加する
	 *
	 */
	private Map<String, Object> makeObjInfoParams(List<String> keyInfo) {
		Map<String, Object> objInfoParams = new HashMap<String, Object>();
		addItemToSettingMap(objInfoParams, "tenant_id", ParamUtil.TransferTypes.PARAM, "tenant_id");
		String type = ParamUtil.TransferTypes.PARAM;
		String val = "edit_table_cd";
		if (!StringUtils.isEmpty(editTableCd)) {
			type = "static";
			val = editTableCd;
		}
		addItemToSettingMap(objInfoParams, "edit_table_cd", type, val);
		addParamsToObjInfo(keyInfo, objInfoParams);
		return objInfoParams;
	}

	/**
	 * obj_infoのparamsプロパティを生成
	 *
	 * @param keyInfo
	 * @param objInfoParams
	 */
	private void addParamsToObjInfo(List<String> keyInfo, Map<String, Object> objInfoParams) {
		if (!CollectionUtils.isEmpty(keyInfo)) {
			for (String key : keyInfo) {
				addItemToSettingMap(objInfoParams, key, "row", key);
			}
		}
	}

	/***
	 *
	 * mapにデータを追加
	 *
	 * @param map
	 * @param key
	 * @param type
	 * @param val
	 */
	private void addItemToSettingMap(Map<String, Object> map, String key, String type, String val) {
		map.put(key, new HashMap<String, Object>(){{
			put("type", type);
			put("val", val);
		}});
	}

	/**
	 * settingDataを取得します。
	 * @return settingData
	 */
	public List<Map<String, Object>> getSettingData() {
		return settingData;
	}

	/**
	 * settingDataを設定します。
	 * @param settingData
	 */
	public void setSettingData(List<Map<String, Object>> settingData) {
		this.settingData = settingData;
	}

	/**
	 * commonを取得します。
	 * @return common
	 */
	public Map<String, Object> getCommon() {
		return common;
	}

	/**
	 * commonを設定します。
	 * @param common
	 */
	public void setCommon(Map<String, Object> common) {
		this.common = common;
	}

	/**
	 * keyColumnsを取得します。
	 * @return keyColumns
	 */
	public List<Map<String, Object>> getKeyColumns() {
		return keyColumns;
	}

	/**
	 * keyColumnsを設定します。
	 * @param keyColumns
	 */
	public void setKeyColumns(List<Map<String, Object>> keyColumns) {
		this.keyColumns = keyColumns;
	}

	/**
	 * needSelectCheckBoxを取得します。
	 * @return needSelectCheckBox
	 */
	public boolean getNeedSelectCheckBox() {
		return needSelectCheckBox;
	}

	/**
	 * needSelectCheckBoxを設定します。
	 * @param needSelectCheckBox
	 */
	public void setNeedSelectCheckBox(boolean needSelectCheckBox) {
		this.needSelectCheckBox = needSelectCheckBox;
	}

	/**
	 * needEditBtnを取得します。
	 * @return needEditBtn
	 */
	public boolean getNeedEditBtn() {
		return needEditBtn;
	}

	/**
	 * needEditBtnを設定します。
	 * @param needEditBtn
	 */
	public void setNeedEditBtn(boolean needEditBtn) {
		this.needEditBtn = needEditBtn;
	}


	/**
	 * editBtnCaptionを取得します。
	 * @return editBtnCaption
	 */
	public String getEditBtnCaption() {
		return editBtnCaption;
	}


	/**
	 * editBtnCaptionを設定します。
	 * @param editBtnCaption
	 */
	public void setEditBtnCaption(String editBtnCaption) {
		this.editBtnCaption = editBtnCaption;
	}


	/**
	 * detailUrlを取得します。
	 * @return detailUrl
	 */
	public String getDetailUrl() {
		return detailUrl;
	}


	/**
	 * detailUrlを設定します。
	 * @param detailUrl
	 */
	public void setDetailUrl(String detailUrl) {
		this.detailUrl = detailUrl;
	}

	/**
	 * editTableCdを取得します。
	 * @return editTableCd
	 */
	public String getEditTableCd() {
		return editTableCd;
	}

	/**
	 * editTableCdを設定します。
	 * @param editTableCd
	 */
	public void setEditTableCd(String editTableCd) {
		this.editTableCd = editTableCd;
	}

	/**
	 * menuDivを取得します。
	 * @return menuDiv
	 */
	public String getMenuDiv() {
		return menuDiv;
	}

	/**
	 * menuDivを設定します。
	 * @param menuDiv
	 */
	public void setMenuDiv(String menuDiv) {
		this.menuDiv = menuDiv;
	}

}
