package jp.ill.photon.module.db;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.ParamUtil;

import org.apache.commons.collections.CollectionUtils;



/**
 * 設定テーブルから、フォワード先を組み立てる
 *
 * @author m_fukukawa
 *
 */
public class SettingDataToForwardParametersModule implements PhotonModule {

	/* モジュールパラメータ */
	@ModuleParam(required=true)
	private List<Map<String, Object>> settingData;

	@ModuleParam(required=true)
	private Map<String, Object> forwardInfo;

	/* クラス内の複数メソッドで使用する変数 */
	protected ActionDto dto;
	protected Map<String, Object> request;

	public ModuleResult execute(ModuleContext context) {

		dto = context.getDto();
		request = context.getDto().getRawParams();

		// フォームデータのセット
		ModuleResult result = new ModuleResult();
		result.getReturnData().put("after", makeAfter());

		return result;

	}

	/***
	 * バリデーションモジュールパラメータの"after"部分作成
	 *
	 * @return
	 */
	@SuppressWarnings("unchecked")
	private Map<String, Object> makeAfter() {

		Map<String, Object> ret = new HashMap<String, Object>();
		// forwardInfoのキー分、afterのキーを追加する
		if (forwardInfo != null) {

			for (Map.Entry<String, Object> e : forwardInfo.entrySet()) {

				Map<String, Object> mp = (Map<String, Object>)e.getValue();
				Map<String, Object> params = (Map<String, Object>)mp.get("params");

				// paramsの値と画面表示していたカラムで"params"を生成
				Map<String, Object> paramsOut = new HashMap<String, Object>();
				if (params != null) {
					for (Map.Entry<String, Object> param : params.entrySet()) {
						// paramsOut.put(param.getKey(), ActionUtil.getActionParamString(request, param.getKey(), ""));
						Map<String, Object> valMap = (Map<String, Object>)param.getValue();
						paramsOut.put(param.getKey(),
								ParamUtil.getParamValueByType(
										(String) valMap.get("transfer_type"),
										valMap.get("transfer_val"), dto));
					}
				}
				if (!CollectionUtils.isEmpty(settingData)) {
					for (Map<String, Object> disp : settingData) {
						String colCd = getKeyName(disp);
						// 新規登録時：入力項目は全項目チェックの対象
						// 更新時：入力項目はキー項目以外がチェックの対象
						paramsOut.put(colCd, request.get(colCd));
					}
				}

				ret.put(e.getKey(), new HashMap<String, Object>(){{
					put("params", paramsOut);
					put("next_path", (String)mp.get("next_path"));
					put("result_type", (String)mp.get("result_type"));
				}});

			}

		}

		return ret;

	}

	/**
	 *
	 * キー名を取得
	 *
	 * @param src カラム定義
	 *
	 * @return キー名
	 *
	 */
	private String getKeyName(Map<String, Object> src) {
		return (String)src.get("col_cd");
	}

	/**
	 * settingDataを取得します。
	 * @return settingData
	 */
	public List<Map<String, Object>> getSettingData() {
		return settingData;
	}

	/**
	 * settingDataを設定します。
	 * @param settingData
	 */
	public void setSettingData(List<Map<String, Object>> settingData) {
		this.settingData = settingData;
	}

	/**
	 * forwardInfoを取得します。
	 * @return forwardInfo
	 */
	public Map<String, Object> getForwardInfo() {
		return forwardInfo;
	}

	/**
	 * forwardInfoを設定します。
	 * @param forwardInfo
	 */
	public void setForwardInfo(Map<String, Object> fowardInfo) {
		this.forwardInfo = fowardInfo;
	}

}
