package jp.ill.photon.module.db;

import java.io.File;
import java.util.Map;
import java.util.StringJoiner;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;

import org.apache.commons.lang3.StringUtils;



/**
 * カラム設定を読んで、ダウンロードするファイルのパスを取得するクラス<br />
 * 実際のダウンロード処理は出力モジュールで行う
 *
 * @author m_fukukawa
 *
 */
public class SettingDataToDownloadFilePathModule  implements PhotonModule {

	/* モジュールパラメータ */
	@ModuleParam(required=true)
	private Map<String, Object> common;

	@ModuleParam(required=true)
	private Map<String, Object> settingData;

	@ModuleParam(required=true)
	private String fileName;

	@ModuleParam(required=false)
	private String subDir;

	@Override
	public ModuleResult execute(ModuleContext context)
			throws PhotonModuleException {

		ModuleResult result = new ModuleResult();

		String outDirName = getFilePath();
		String outFileName = "";

		if (!StringUtils.isEmpty(fileName)) {
			outFileName = fileName;
		}

		result.getReturnData().put("dir_name", outDirName);
		result.getReturnData().put("file_name", outFileName);
		result.setResultCode("success");

		return result;

	}


	/**
	 * カラム設定情報から、ファイルパスを取得
	 */
	@SuppressWarnings("rawtypes")
	private String getFilePath() {

		String retFilePath = "";

		if ((settingData != null && !settingData.isEmpty())) {

			String dirId = (String)settingData.get("file_store_path_system_setting_id");

			String fileDir = "";
			if (!StringUtils.isEmpty(subDir)) {
				fileDir = subDir;
			}

			String fileStorePath = "";
			if (!StringUtils.isEmpty(dirId)) {
				if (common.get("systemsetting") != null &&
						((Map)common.get("systemsetting")).get(dirId) != null
				) {
					fileStorePath = (String)((Map)((Map)common.get("systemsetting")).get(dirId)).get("note");
				}
			}

			// ルートパスを取得
			// return getValueFromSystemSetting(common.get("systemsetting"), dirId, "note") + File.separator + fileDir;
			StringJoiner sj = new StringJoiner(File.separator);
			if (!StringUtils.isEmpty(fileStorePath)) {
				sj.add(fileStorePath);
			}
			if (!StringUtils.isEmpty(fileDir)) {
				sj.add(fileDir);
			}
			retFilePath = sj.toString();

		}

		return retFilePath;

	}


	/**
	 * commonを取得します。
	 * @return common
	 */
	public Map<String, Object> getCommon() {
		return common;
	}


	/**
	 * commonを設定します。
	 * @param common
	 */
	public void setCommon(Map<String, Object> common) {
		this.common = common;
	}


	/**
	 * settingDataを取得します。
	 * @return settingData
	 */
	public Map<String, Object> getSettingData() {
		return settingData;
	}


	/**
	 * settingDataを設定します。
	 * @param settingData
	 */
	public void setSettingData(Map<String, Object> settingData) {
		this.settingData = settingData;
	}


	/**
	 * fileNameを取得します。
	 * @return fileName
	 */
	public String getFileName() {
		return fileName;
	}


	/**
	 * fileNameを設定します。
	 * @param fileName
	 */
	public void setFileName(String fileName) {
		this.fileName = fileName;
	}


	/**
	 * subDirを取得します。
	 * @return subDir
	 */
	public String getSubDir() {
		return subDir;
	}


	/**
	 * subDirを設定します。
	 * @param subDir
	 */
	public void setSubDir(String subDir) {
		this.subDir = subDir;
	}

}
