package jp.ill.photon.module.db;

import java.util.LinkedHashMap;
import java.util.Map;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.annotation.ModuleVersion;
import jp.ill.photon.dao.builder.DomaSQLQueryBuilder;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.ParamUtil;

@ModuleVersion("1.0.0")
public class GeneralDbUpdateModule implements PhotonModule {

	@ModuleParam(required=true)
	private String queryType;

	@ModuleParam(required=true)
	private String queryTemplate;

	@ModuleParam(required=true)
	private Map<String, Object> paramJson;

	public String getQueryType() {
		return queryType;
	}

	public void setQueryType(String queryType) {
		this.queryType = queryType;
	}

	public String getQueryTemplate() {
		return queryTemplate;
	}

	public void setQueryTemplate(String queryTemplate) {
		this.queryTemplate = queryTemplate;
	}

	public Map<String, Object> getParamJson() {
		return paramJson;
	}

	public void setParamJson(Map<String, Object> paramJson) {
		this.paramJson = paramJson;
	}

	@Override
	public ModuleResult execute( ModuleContext context ) {

		Map<String, Object> params = new LinkedHashMap<String, Object>();
		if (paramJson != null) {
			Map<String, String> paramInfo = null;
			for (Map.Entry<String, Object> param : paramJson.entrySet()) {
				paramInfo = (Map) param.getValue();
				params.put(param.getKey(), ParamUtil.getParamValueByType(
						paramInfo.get("type"), paramInfo.get("val"), context.getDto()));
			}
		}

		ModuleResult result = new ModuleResult();
		if (!queryTemplate.isEmpty()) {
			DomaSQLQueryBuilder queryBuilder = new DomaSQLQueryBuilder();
			switch (queryType) {
			case "insert":
				result.getReturnData().put("result",
						queryBuilder.insert(queryTemplate, params, context.getDto()));
				break;
			case "update":
				result.getReturnData().put("result",
						queryBuilder.update(queryTemplate, params, context.getDto()));
				break;
			case "delete":
				result.getReturnData().put("result",
						queryBuilder.delete(queryTemplate, params, context.getDto()));
				break;
			default:
				result.getReturnData().put("result", 0);
				break;
			}
		} else {
			result.getReturnData().put("result", 0);
		}

		return result;
	}

}
